/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.dom;

import adams.gui.core.BasePanel;
import adams.gui.core.BasePopupMenu;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.KeyValuePairTableModel;
import adams.gui.core.MouseUtils;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.core.dom.DOMNode;
import adams.gui.core.dom.DOMTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JMenuItem;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableModel;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMTreeWithPreview
extends BasePanel {
    private static final long serialVersionUID = 7811577045901194135L;
    protected DOMTree m_Tree;
    protected SortableAndSearchableTable m_Table;
    protected KeyValuePairTableModel m_Model;
    protected BaseSplitPane m_SplitPane;

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_SplitPane = new BaseSplitPane(0);
        this.m_SplitPane.setResizeWeight(1.0);
        this.m_SplitPane.setOneTouchExpandable(true);
        this.add((Component)this.m_SplitPane, "Center");
        this.m_Tree = new DOMTree();
        this.m_Tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DOMNode node = (DOMNode)((Object)e.getPath().getLastPathComponent());
                DOMTreeWithPreview.this.updatePreview(node);
            }
        });
        this.m_SplitPane.setTopComponent((Component)new BaseScrollPane((Component)((Object)this.m_Tree)));
        this.m_Model = new KeyValuePairTableModel((Object[][])new String[0][]);
        this.m_Table = new SortableAndSearchableTable((TableModel)this.m_Model);
        this.m_Table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isRightClick((MouseEvent)e)) {
                    DOMTreeWithPreview.this.showPopupMenu(e);
                }
            }
        });
        this.m_Table.setAutoResizeMode(0);
        this.m_Table.setOptimalColumnWidth();
        this.m_SplitPane.setBottomComponent((Component)new BaseScrollPane((Component)this.m_Table));
    }

    public void setDOM(Node value) {
        this.m_Tree.setDOM(value);
    }

    public Node getDOM() {
        return this.m_Tree.getDOM();
    }

    public DOMTree getTree() {
        return this.m_Tree;
    }

    public SortableAndSearchableTable getTable() {
        return this.m_Table;
    }

    public void setPreviewVisible(boolean value) {
        this.m_SplitPane.setRightComponentHidden(!value);
    }

    public boolean isPreviewVisible() {
        return !this.m_SplitPane.isRightComponentHidden();
    }

    public void setSplitterPosition(int value) {
        this.m_SplitPane.setDividerLocation(value);
    }

    public int getSplitterPosition() {
        return this.m_SplitPane.getDividerLocation();
    }

    protected String getText(Node node) {
        StringBuilder result = new StringBuilder();
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i) instanceof Text) {
                if (result.length() > 0) {
                    result.append("\n");
                }
                result.append(((Text)list.item(i)).getWholeText());
                continue;
            }
            if (list.item(i).getNodeType() != 8) continue;
            if (result.length() > 0) {
                result.append("\n");
            }
            result.append(list.item(i).getNodeValue());
        }
        return result.toString();
    }

    protected void updatePreview(DOMNode selNode) {
        KeyValuePairTableModel model = null;
        Node node = (Node)selNode.getValue();
        short type = node.getNodeType();
        switch (type) {
            case 1: {
                if (node.hasAttributes()) {
                    NamedNodeMap map = node.getAttributes();
                    Object[][] data = node.hasChildNodes() ? new String[map.getLength() + 1][2] : new String[map.getLength()][2];
                    for (int i = 0; i < map.getLength(); ++i) {
                        data[i][0] = map.item(i).getNodeName();
                        data[i][1] = map.item(i).getNodeValue();
                    }
                    data[data.length - 1][0] = "Node value";
                    data[data.length - 1][1] = this.getText(node);
                    model = new KeyValuePairTableModel(data);
                    break;
                }
                model = new KeyValuePairTableModel((Object[][])new String[][]{{"Node value", this.getText(node)}});
                break;
            }
            default: {
                model = new KeyValuePairTableModel((Object[][])new String[][]{{"Text", this.getText(node)}});
            }
        }
        this.m_Table.setModel((TableModel)model);
        this.m_Table.setOptimalColumnWidth();
        this.m_Model = model;
    }

    protected void showPopupMenu(MouseEvent e) {
        BasePopupMenu menu = new BasePopupMenu();
        JMenuItem menuitem = new JMenuItem("Copy");
        menuitem.setIcon(GUIHelper.getIcon((String)"copy.gif"));
        menuitem.setEnabled(this.m_Table.getSelectedRowCount() > 0);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DOMTreeWithPreview.this.m_Table.copyToClipboard();
            }
        });
        menu.add(menuitem);
        menu.showAbsolute((Component)this.m_Table, e);
    }
}

