/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io.filecomplete;

import adams.core.io.FileUtils;
import adams.core.io.filecomplete.AbstractFileCompleteCheck;
import java.io.ByteArrayInputStream;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

public class XML
extends AbstractFileCompleteCheck {
    private static final long serialVersionUID = 8742612165238773767L;
    protected boolean m_Validating;
    protected boolean m_NameSpaceAware;
    protected boolean m_XIncludeAware;
    protected boolean m_ExpandEntityReferences;

    public String globalInfo() {
        return "Checks whether the XML can be parsed.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("validating", "validating", (Object)false);
        this.m_OptionManager.add("name-space-aware", "nameSpaceAware", (Object)false);
        this.m_OptionManager.add("x-include-aware", "XIncludeAware", (Object)false);
        this.m_OptionManager.add("expand-entity-references", "expandEntityReferences", (Object)false);
    }

    public void setValidating(boolean value) {
        this.m_Validating = value;
        this.reset();
    }

    public boolean getValidating() {
        return this.m_Validating;
    }

    public String validatingTipText() {
        return "If enabled, the parser will validate the XML.";
    }

    public void setNameSpaceAware(boolean value) {
        this.m_NameSpaceAware = value;
        this.reset();
    }

    public boolean getNameSpaceAware() {
        return this.m_NameSpaceAware;
    }

    public String nameSpaceAwareTipText() {
        return "If enabled, the parser will be namespace aware.";
    }

    public void setXIncludeAware(boolean value) {
        this.m_XIncludeAware = value;
        this.reset();
    }

    public boolean getXIncludeAware() {
        return this.m_XIncludeAware;
    }

    public String XIncludeAwareTipText() {
        return "If enabled, the parser will be X-include aware.";
    }

    public void setExpandEntityReferences(boolean value) {
        this.m_ExpandEntityReferences = value;
        this.reset();
    }

    public boolean getExpandEntityReferences() {
        return this.m_ExpandEntityReferences;
    }

    public String expandEntityReferencesTipText() {
        return "If enabled, the parser will expand entity references.";
    }

    public boolean isComplete(byte[] buffer) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(this.m_Validating);
            factory.setNamespaceAware(this.m_NameSpaceAware);
            factory.setXIncludeAware(this.m_XIncludeAware);
            factory.setExpandEntityReferences(this.m_ExpandEntityReferences);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.parse(new ByteArrayInputStream(buffer));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isComplete(File file) {
        return this.isComplete(FileUtils.loadFromBinaryFile((File)file));
    }
}

