/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseCharset;
import adams.core.io.PrettyPrintingSupporter;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversionToString;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMToString
extends AbstractConversionToString
implements PrettyPrintingSupporter {
    private static final long serialVersionUID = 6744245717394758406L;
    protected BaseCharset m_Encoding;
    protected boolean m_PrettyPrinting;
    protected int m_NumSpaces;

    public String globalInfo() {
        return "Turns a " + Node.class.getName() + " or " + Document.class.getName() + " DOM object into a String.\nIn case of " + Node.class.getName() + " objects, the owner document is converted to String.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("encoding", "encoding", (Object)new BaseCharset());
        this.m_OptionManager.add("pretty-printing", "prettyPrinting", (Object)false);
        this.m_OptionManager.add("num-spaces", "numSpaces", (Object)2, (Number)0, null);
    }

    public void setEncoding(BaseCharset value) {
        this.m_Encoding = value;
        this.reset();
    }

    public BaseCharset getEncoding() {
        return this.m_Encoding;
    }

    public String encodingTipText() {
        return "The type of encoding to use for the string.";
    }

    public void setPrettyPrinting(boolean value) {
        this.m_PrettyPrinting = value;
        this.reset();
    }

    public boolean getPrettyPrinting() {
        return this.m_PrettyPrinting;
    }

    public String prettyPrintingTipText() {
        return "If enabled, the XML is output in pretty-print format.";
    }

    public void setNumSpaces(int value) {
        if (this.getOptionManager().isValid("numSpaces", (Number)value)) {
            this.m_NumSpaces = value;
            this.reset();
        }
    }

    public int getNumSpaces() {
        return this.m_NumSpaces;
    }

    public String numSpacesTipText() {
        return "The number of spaces to use for indentation (in case of pretty-printing).";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"encoding", (Object)this.m_Encoding, (String)"encoding: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"prettyPrinting", (Object)(this.m_PrettyPrinting ? "pretty" : "not-so-pretty"), (String)", ");
        return result;
    }

    public Class accepts() {
        return Node.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doConvert() throws Exception {
        StringWriter swriter;
        Document doc = this.m_Input instanceof Document ? (Document)this.m_Input : ((Node)this.m_Input).getOwnerDocument();
        Document document = doc;
        synchronized (document) {
            if (this.m_PrettyPrinting) {
                doc = (Document)doc.cloneNode(true);
                XPath xPath = XPathFactory.newInstance().newXPath();
                NodeList nodeList = (NodeList)xPath.evaluate("//text()[normalize-space()='']", doc, XPathConstants.NODESET);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    node.getParentNode().removeChild(node);
                }
            }
            TransformerFactory factory = TransformerFactory.newInstance();
            if (this.m_PrettyPrinting) {
                factory.setAttribute("indent-number", this.m_NumSpaces);
            }
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("encoding", this.m_Encoding.charsetValue().toString());
            if (this.m_PrettyPrinting) {
                transformer.setOutputProperty("indent", "yes");
            }
            swriter = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(swriter));
        }
        return swriter.toString();
    }
}

