/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversionFromString;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class XMLToDOM
extends AbstractConversionFromString {
    private static final long serialVersionUID = -7337362020786223426L;
    protected boolean m_Validating;
    protected boolean m_NameSpaceAware;
    protected boolean m_XIncludeAware;
    protected boolean m_ExpandEntityReferences;
    protected boolean m_IgnoringComments;
    protected boolean m_Coalescing;
    protected boolean m_IgnoringWhitespace;

    public String globalInfo() {
        return "Turns an XML string into a " + Document.class.getName() + " DOM object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("validating", "validating", (Object)false);
        this.m_OptionManager.add("name-space-aware", "nameSpaceAware", (Object)false);
        this.m_OptionManager.add("x-include-aware", "XIncludeAware", (Object)false);
        this.m_OptionManager.add("expand-entity-references", "expandEntityReferences", (Object)false);
        this.m_OptionManager.add("ignoring-comments", "ignoringComments", (Object)false);
        this.m_OptionManager.add("coalescing", "coalescing", (Object)false);
        this.m_OptionManager.add("ignoring-whitespace", "ignoringWhitespace", (Object)false);
    }

    public void setValidating(boolean value) {
        this.m_Validating = value;
        this.reset();
    }

    public boolean getValidating() {
        return this.m_Validating;
    }

    public String validatingTipText() {
        return "If enabled, the parser will validate the XML.";
    }

    public void setNameSpaceAware(boolean value) {
        this.m_NameSpaceAware = value;
        this.reset();
    }

    public boolean getNameSpaceAware() {
        return this.m_NameSpaceAware;
    }

    public String nameSpaceAwareTipText() {
        return "If enabled, the parser will be namespace aware.";
    }

    public void setXIncludeAware(boolean value) {
        this.m_XIncludeAware = value;
        this.reset();
    }

    public boolean getXIncludeAware() {
        return this.m_XIncludeAware;
    }

    public String XIncludeAwareTipText() {
        return "If enabled, the parser will be X-include aware.";
    }

    public void setExpandEntityReferences(boolean value) {
        this.m_ExpandEntityReferences = value;
        this.reset();
    }

    public boolean getExpandEntityReferences() {
        return this.m_ExpandEntityReferences;
    }

    public String expandEntityReferencesTipText() {
        return "If enabled, the parser will expand entity references.";
    }

    public void setIgnoringComments(boolean value) {
        this.m_IgnoringComments = value;
        this.reset();
    }

    public boolean getIgnoringComments() {
        return this.m_IgnoringComments;
    }

    public String ignoringCommentsTipText() {
        return "If enabled, the parser will ignore comments.";
    }

    public void setCoalescing(boolean value) {
        this.m_Coalescing = value;
        this.reset();
    }

    public boolean getCoalescing() {
        return this.m_Coalescing;
    }

    public String coalescingTipText() {
        return "If enabled, then parser will convert CDATA nodes to Text nodes and append it to the adjacent (if any) text node.";
    }

    public void setIgnoringWhitespace(boolean value) {
        this.m_IgnoringWhitespace = value;
        this.reset();
    }

    public boolean getIgnoringWhitespace() {
        return this.m_IgnoringWhitespace;
    }

    public String ignoringWhitespaceTipText() {
        return "If enabled, the parser will ignore whitespaces in element content.";
    }

    public Class generates() {
        return Document.class;
    }

    protected Object doConvert() throws Exception {
        Document doc;
        try {
            String input = (String)this.m_Input;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(this.m_Validating);
            factory.setNamespaceAware(this.m_NameSpaceAware);
            factory.setXIncludeAware(this.m_XIncludeAware);
            factory.setExpandEntityReferences(this.m_ExpandEntityReferences);
            factory.setIgnoringComments(this.m_IgnoringComments);
            factory.setIgnoringElementContentWhitespace(this.m_IgnoringWhitespace);
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(new ByteArrayInputStream(input.getBytes()));
        }
        catch (Exception e) {
            throw new Exception("Failed to parse: " + this.m_Input, e);
        }
        return doc;
    }
}

