/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.XPathResult;
import adams.core.base.BaseString;
import adams.core.base.XPathExpression;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPath
extends AbstractTransformer {
    private static final long serialVersionUID = -184602726110144511L;
    protected XPathExpression m_Expression;
    protected XPathResult m_ResultType;
    protected BaseString[] m_NameSpaces;
    protected NamespaceContext m_NameSpaceContext;

    public String globalInfo() {
        return "Applies XPath to the DOM document object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("expression", "expression", (Object)new XPathExpression("/*"));
        this.m_OptionManager.add("result-type", "resultType", (Object)XPathResult.NODESET);
        this.m_OptionManager.add("name-space", "nameSpaces", (Object)new BaseString[0]);
    }

    protected void reset() {
        super.reset();
        this.m_NameSpaceContext = null;
    }

    public void setExpression(XPathExpression value) {
        this.m_Expression = value;
        this.reset();
    }

    public XPathExpression getExpression() {
        return this.m_Expression;
    }

    public String expressionTipText() {
        return "The XPath expression to apply to the input.";
    }

    public void setResultType(XPathResult value) {
        this.m_ResultType = value;
        this.reset();
    }

    public XPathResult getResultType() {
        return this.m_ResultType;
    }

    public String resultTypeTipText() {
        return "The type of result that the XPath expression generates.";
    }

    public void setNameSpaces(BaseString[] value) {
        this.m_NameSpaces = value;
        this.reset();
    }

    public BaseString[] getNameSpaces() {
        return this.m_NameSpaces;
    }

    public String nameSpacesTipText() {
        return "The namespaces to use as context for evaluating the expression; format: 'prefix=URI'.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"expression", (Object)((Object)this.m_Expression), (String)"expr: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"resultType", (Object)this.m_ResultType, (String)", type: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Document.class, NodeList.class, Node.class};
    }

    public Class[] generates() {
        switch (this.m_ResultType) {
            case BOOLEAN: {
                return new Class[]{Boolean.class};
            }
            case STRING: {
                return new Class[]{String.class};
            }
            case NUMBER: {
                return new Class[]{Double.class};
            }
            case NODE: {
                return new Class[]{Node.class};
            }
            case NODESET: {
                return new Class[]{NodeList.class};
            }
        }
        throw new IllegalStateException("Unhandled result type: " + this.m_ResultType);
    }

    protected String doExecute() {
        String result = null;
        try {
            javax.xml.xpath.XPath xpath = XPathFactory.newInstance().newXPath();
            if (this.m_NameSpaces.length > 0) {
                if (this.m_NameSpaceContext == null) {
                    final HashMap<String, String> table = new HashMap<String, String>();
                    final HashMap<String, String> tableReverse = new HashMap<String, String>();
                    for (BaseString s : this.m_NameSpaces) {
                        int pos = s.getValue().indexOf(61);
                        if (pos > -1) {
                            String[] parts = new String[]{s.getValue().substring(0, pos), s.getValue().substring(pos + 1)};
                            table.put(parts[0], parts[1]);
                            tableReverse.put(parts[1], parts[0]);
                            continue;
                        }
                        this.getLogger().severe("Invalid namespace format! Expected 'name=url', found: " + s.getValue());
                    }
                    this.m_NameSpaceContext = new NamespaceContext(){

                        @Override
                        public String getNamespaceURI(String prefix) {
                            return (String)table.get(prefix);
                        }

                        @Override
                        public String getPrefix(String namespaceURI) {
                            return (String)tableReverse.get(namespaceURI);
                        }

                        public Iterator getPrefixes(String namespaceURI) {
                            HashSet set = new HashSet();
                            set.add(tableReverse.get(namespaceURI));
                            return set.iterator();
                        }
                    };
                }
                xpath.setNamespaceContext(this.m_NameSpaceContext);
            }
            Object eval = xpath.evaluate(this.m_Expression.getValue(), this.m_InputToken.getPayload(), this.m_ResultType.getQName());
            this.m_OutputToken = new Token(eval);
        }
        catch (Exception e) {
            result = this.handleException("Failed to apply XPath expression: " + this.m_Expression, e);
        }
        return result;
    }
}

