/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.io.FileUtils;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.BaseButton;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.core.ImageManager;
import adams.gui.core.MenuBarProvider;
import adams.gui.dialog.TextPanel;
import com.github.fracpete.jclipboardhelper.ClipboardHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class XSLTPanel
extends BasePanel
implements MenuBarProvider {
    private static final long serialVersionUID = -5677998941035693457L;
    protected BaseSplitPane m_SplitPane1;
    protected BaseSplitPane m_SplitPane2;
    protected SubPanel m_PanelXML;
    protected SubPanel m_PanelXSL;
    protected SubPanel m_PanelOutput;
    protected JPanel m_PanelButtons;
    protected BaseButton m_ButtonApply;
    protected JCheckBoxMenuItem m_MenuItemValidating;
    protected JCheckBoxMenuItem m_MenuItemNamespaceAware;
    protected JCheckBoxMenuItem m_MenuItemXInludeAware;
    protected JCheckBoxMenuItem m_MenuItemExpandEntityReferences;
    protected JCheckBoxMenuItem m_MenuItemIgnoreComments;
    protected JCheckBoxMenuItem m_MenuItemIgnoreWhitespaces;
    protected JMenuBar m_MenuBar;

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_SplitPane1 = new BaseSplitPane(1);
        this.m_SplitPane1.setResizeWeight(0.33);
        this.add((Component)this.m_SplitPane1, "Center");
        this.m_SplitPane2 = new BaseSplitPane(1);
        this.m_SplitPane2.setResizeWeight(0.5);
        this.m_SplitPane1.setRightComponent((Component)this.m_SplitPane2);
        this.m_PanelXML = new SubPanel();
        this.m_PanelXML.setInfoText("XML");
        this.m_PanelXML.addExtensionFilter(new ExtensionFileFilter("XML files", "xml"));
        this.m_SplitPane1.setLeftComponent((Component)((Object)this.m_PanelXML));
        this.m_PanelXSL = new SubPanel();
        this.m_PanelXSL.setInfoText("XSL");
        this.m_PanelXSL.addExtensionFilter(new ExtensionFileFilter("XSL files", new String[]{"xsl", "xslt"}));
        this.m_SplitPane2.setLeftComponent((Component)((Object)this.m_PanelXSL));
        this.m_PanelOutput = new SubPanel();
        this.m_PanelOutput.setInfoText("Output");
        this.m_PanelOutput.addExtensionFilter(new ExtensionFileFilter("Text files", "txt"));
        this.m_SplitPane2.setRightComponent((Component)((Object)this.m_PanelOutput));
        this.m_PanelButtons = new JPanel(new FlowLayout(2));
        this.add(this.m_PanelButtons, "South");
        this.m_ButtonApply = new BaseButton("Apply", (Icon)ImageManager.getIcon((String)"run.gif"));
        this.m_ButtonApply.addActionListener(e -> this.apply());
        this.m_PanelButtons.add((Component)this.m_ButtonApply);
    }

    public JMenuBar getMenuBar() {
        if (this.m_MenuBar == null) {
            this.m_MenuBar = new JMenuBar();
            JMenu menu = new JMenu("File");
            menu.setMnemonic('F');
            this.m_MenuBar.add(menu);
            JMenuItem menuitem = new JMenuItem("Close", ImageManager.getIcon((String)"exit.png"));
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.addActionListener(e -> this.closeParent());
            menu.add(menuitem);
            menu = new JMenu("Options");
            menu.setMnemonic('O');
            this.m_MenuBar.add(menu);
            menuitem = new JCheckBoxMenuItem("Validating");
            menu.add(menuitem);
            this.m_MenuItemValidating = (JCheckBoxMenuItem)menuitem;
            menuitem = new JCheckBoxMenuItem("Namespace aware");
            menuitem.setSelected(true);
            menu.add(menuitem);
            this.m_MenuItemNamespaceAware = (JCheckBoxMenuItem)menuitem;
            menuitem = new JCheckBoxMenuItem("XInclude aware");
            menu.add(menuitem);
            this.m_MenuItemXInludeAware = (JCheckBoxMenuItem)menuitem;
            menuitem = new JCheckBoxMenuItem("Expand entity references");
            menu.add(menuitem);
            this.m_MenuItemExpandEntityReferences = (JCheckBoxMenuItem)menuitem;
            menuitem = new JCheckBoxMenuItem("Ignoring comments");
            menuitem.setSelected(true);
            menu.add(menuitem);
            this.m_MenuItemIgnoreComments = (JCheckBoxMenuItem)menuitem;
            menuitem = new JCheckBoxMenuItem("Ignoring whitespaces");
            menuitem.setSelected(true);
            menu.add(menuitem);
            this.m_MenuItemIgnoreWhitespaces = (JCheckBoxMenuItem)menuitem;
        }
        return this.m_MenuBar;
    }

    public void apply() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(this.m_MenuItemValidating.isSelected());
            factory.setNamespaceAware(this.m_MenuItemNamespaceAware.isSelected());
            factory.setXIncludeAware(this.m_MenuItemXInludeAware.isSelected());
            factory.setExpandEntityReferences(this.m_MenuItemExpandEntityReferences.isSelected());
            factory.setIgnoringComments(this.m_MenuItemIgnoreComments.isSelected());
            factory.setIgnoringElementContentWhitespace(this.m_MenuItemIgnoreWhitespaces.isSelected());
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(this.m_PanelXML.getContent().getBytes()));
            DOMSource dsource = new DOMSource(doc);
            StreamSource stylesource = new StreamSource(new StringReader(this.m_PanelXSL.getContent()));
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(stylesource);
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            StreamResult sresult = new StreamResult(ostream);
            transformer.transform(dsource, sresult);
            this.m_PanelOutput.setContent(new String(ostream.toByteArray()));
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)GUIHelper.getParentComponent((Component)((Object)this)), (String)"Failed to apply XSL!", (Throwable)e);
        }
    }

    public static class SubPanel
    extends BasePanel {
        private static final long serialVersionUID = 3836566100162935753L;
        protected TextPanel m_PanelText;
        protected JPanel m_PanelButtons;
        protected BaseButton m_ButtonClear;
        protected BaseButton m_ButtonOpen;
        protected BaseButton m_ButtonSave;
        protected BaseButton m_ButtonCopy;
        protected BaseButton m_ButtonPaste;
        protected BaseFileChooser m_FileChooser;

        protected void initialize() {
            super.initialize();
            this.m_FileChooser = new BaseFileChooser();
            this.m_FileChooser.setAcceptAllFileFilterUsed(true);
            this.m_FileChooser.setAutoAppendExtension(true);
        }

        protected void initGUI() {
            super.initGUI();
            this.setLayout(new BorderLayout());
            this.m_PanelText = new TextPanel();
            this.m_PanelText.setCanOpenFiles(true);
            this.add((Component)this.m_PanelText, "Center");
            this.m_PanelButtons = new JPanel(new FlowLayout(0));
            this.add(this.m_PanelButtons, "South");
            this.m_ButtonClear = new BaseButton((Icon)ImageManager.getIcon((String)"new.gif"));
            this.m_ButtonClear.addActionListener(e -> this.clear());
            this.m_PanelButtons.add((Component)this.m_ButtonClear);
            this.m_ButtonOpen = new BaseButton((Icon)ImageManager.getIcon((String)"open.gif"));
            this.m_ButtonOpen.addActionListener(e -> this.open());
            this.m_PanelButtons.add((Component)this.m_ButtonOpen);
            this.m_ButtonSave = new BaseButton((Icon)ImageManager.getIcon((String)"save.gif"));
            this.m_ButtonSave.addActionListener(e -> this.save());
            this.m_PanelButtons.add((Component)this.m_ButtonSave);
            this.m_ButtonCopy = new BaseButton((Icon)ImageManager.getIcon((String)"copy.gif"));
            this.m_ButtonCopy.addActionListener(e -> this.copy());
            this.m_PanelButtons.add((Component)this.m_ButtonCopy);
            this.m_ButtonPaste = new BaseButton((Icon)ImageManager.getIcon((String)"paste.gif"));
            this.m_ButtonPaste.addActionListener(e -> this.paste());
            this.m_PanelButtons.add((Component)this.m_ButtonPaste);
        }

        public void clear() {
            this.m_PanelText.setContent("");
        }

        public void open() {
            int retVal = this.m_FileChooser.showOpenDialog(GUIHelper.getParentComponent((Component)((Object)this)));
            if (retVal != 0) {
                return;
            }
            this.m_PanelText.open(this.m_FileChooser.getSelectedFile());
        }

        public void save() {
            int retVal = this.m_FileChooser.showSaveDialog((Component)((Object)this));
            if (retVal != 0) {
                return;
            }
            String msg = FileUtils.writeToFileMsg((String)this.m_FileChooser.getSelectedFile().getAbsolutePath(), (Object)this.m_PanelText.getContent(), (boolean)false, null);
            if (msg != null) {
                GUIHelper.showErrorMessage((Component)GUIHelper.getParentComponent((Component)((Object)this)), (String)msg);
            }
        }

        public void copy() {
            ClipboardHelper.copyToClipboard((String)this.m_PanelText.getContent());
        }

        public void paste() {
            this.m_PanelText.setContent(ClipboardHelper.pasteStringFromClipboard());
        }

        public void addExtensionFilter(ExtensionFileFilter filter) {
            this.m_FileChooser.addChoosableFileFilter((FileFilter)filter);
        }

        public void setInfoText(String info) {
            this.m_PanelText.setInfoText(info);
        }

        public void setContent(String value) {
            this.m_PanelText.setContent(value);
        }

        public String getContent() {
            return this.m_PanelText.getContent();
        }
    }
}

