/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.gui.core.TextEditorPanel;
import adams.gui.core.dom.DOMTreeWithPreview;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import java.io.File;
import javax.swing.JComponent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class XMLHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = 4859255638148506547L;

    public String globalInfo() {
        return "Displays XML files: " + Utils.arrayToString((Object)this.getExtensions());
    }

    public String[] getExtensions() {
        return new String[]{"xml", "xsl"};
    }

    public PreviewPanel createPreview(File file) {
        PreviewPanel result;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new File(file.getAbsolutePath()));
            DOMTreeWithPreview domPanel = new DOMTreeWithPreview();
            domPanel.setDOM(doc);
            domPanel.getTree().expandAll();
            domPanel.setSplitterPosition(500);
            result = new PreviewPanel((JComponent)((Object)domPanel));
        }
        catch (Exception e) {
            TextEditorPanel textPanel = new TextEditorPanel();
            textPanel.open(file);
            textPanel.setEditable(false);
            result = new PreviewPanel((JComponent)textPanel, (JComponent)textPanel.getTextArea());
        }
        return result;
    }
}

