/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractParameterMapReader;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class YamlParameterMapReader
extends AbstractParameterMapReader {
    private static final long serialVersionUID = -7080929826308953435L;

    public String globalInfo() {
        return "Stores the parameters in YAML format.";
    }

    public String getFormatDescription() {
        return "YAML map";
    }

    public String[] getFormatExtensions() {
        return new String[]{"yaml", "yml"};
    }

    public String getDefaultFormatExtension() {
        return "yaml";
    }

    protected Map<String, Object> doRead(PlaceholderFile input) throws Exception {
        Yaml yaml = new Yaml();
        Map result = (Map)yaml.load(Utils.flatten((List)FileUtils.loadFromFile((File)input), (String)"\n"));
        if (result == null) {
            throw new Exception("Failed to load parameters from: " + input);
        }
        return result;
    }
}

