/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class YamlFileReader
extends AbstractTransformer {
    private static final long serialVersionUID = -184602726110144511L;
    protected DataStructureType m_Type;

    public String globalInfo() {
        return "Reads a YAML file and forwards the generated Map object.\nhttp://yaml.org/";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)DataStructureType.MAP);
    }

    public void setType(DataStructureType value) {
        this.m_Type = value;
        this.reset();
    }

    public DataStructureType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The data structure type to use.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type), (String)"data structure: ");
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        switch (this.m_Type) {
            case LIST: {
                return new Class[]{List.class};
            }
            case MAP: {
                return new Class[]{Map.class};
            }
        }
        throw new IllegalStateException("Unhandled data structure type: " + (Object)((Object)this.m_Type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result = null;
        Object fileObj = this.m_InputToken.getPayload();
        File file = fileObj instanceof File ? (File)fileObj : new PlaceholderFile((String)fileObj);
        FileReader freader = null;
        BufferedReader breader = null;
        try {
            Object obj;
            freader = new FileReader(file.getAbsolutePath());
            breader = new BufferedReader(freader);
            Yaml yaml = new Yaml();
            switch (this.m_Type) {
                case LIST: {
                    obj = yaml.loadAs((Reader)breader, List.class);
                    break;
                }
                case MAP: {
                    obj = yaml.loadAs((Reader)breader, Map.class);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled data structure type: " + (Object)((Object)this.m_Type));
                }
            }
            this.m_OutputToken = new Token(obj);
        }
        catch (Exception e) {
            try {
                result = this.handleException("Failed to read YAML file: " + file, e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(breader);
                FileUtils.closeQuietly((Reader)freader);
                throw throwable;
            }
            FileUtils.closeQuietly((Reader)breader);
            FileUtils.closeQuietly((Reader)freader);
        }
        FileUtils.closeQuietly((Reader)breader);
        FileUtils.closeQuietly((Reader)freader);
        return result;
    }

    public static enum DataStructureType {
        MAP,
        LIST;

    }
}

