/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.YamlFileWriter;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.YamlFileReader;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class YamlFileReaderTest
extends AbstractFlowTest {
    public YamlFileReaderTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("course.yaml");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("course.yaml");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(YamlFileReaderTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            FileSupplier filesupplier = new FileSupplier();
            AbstractArgumentOption argOption = (AbstractArgumentOption)filesupplier.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
            files.add((PlaceholderFile)argOption.valueOf("${TMP}/course.yaml"));
            filesupplier.setFiles(files.toArray(new PlaceholderFile[0]));
            actors.add(filesupplier);
            YamlFileReader yamlfilereader = new YamlFileReader();
            actors.add(yamlfilereader);
            YamlFileWriter yamlfilewriter = new YamlFileWriter();
            argOption = (AbstractArgumentOption)yamlfilewriter.getOptionManager().findByProperty("outputFile");
            yamlfilewriter.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.txt"));
            actors.add(yamlfilewriter);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        }
        catch (Exception e) {
            YamlFileReaderTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        YamlFileReaderTest.runTest((Test)YamlFileReaderTest.suite());
    }
}

