/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.gui.core.TextEditorPanel;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Map;
import javax.swing.JComponent;
import org.yaml.snakeyaml.Yaml;

public class YamlHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = -5643331918040646266L;

    public String globalInfo() {
        return "Displays YAML files: " + Utils.arrayToString((Object)this.getExtensions());
    }

    public String[] getExtensions() {
        return new String[]{"yaml", "yml"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PreviewPanel createPreview(File file) {
        PreviewPanel result;
        FileReader freader = null;
        BufferedReader breader = null;
        try {
            freader = new FileReader(file.getAbsolutePath());
            breader = new BufferedReader(freader);
            Yaml yaml = new Yaml();
            Map map = (Map)yaml.loadAs((Reader)breader, Map.class);
            TextEditorPanel textPanel = new TextEditorPanel();
            textPanel.setContent(yaml.dumpAsMap((Object)map));
            textPanel.setEditable(false);
            result = new PreviewPanel((JComponent)textPanel, (JComponent)textPanel.getTextArea());
        }
        catch (Exception e) {
            try {
                TextEditorPanel textPanel = new TextEditorPanel();
                textPanel.open(file);
                textPanel.setEditable(false);
                result = new PreviewPanel((JComponent)textPanel, (JComponent)textPanel.getTextArea());
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(breader);
                FileUtils.closeQuietly((Reader)freader);
                throw throwable;
            }
            FileUtils.closeQuietly((Reader)breader);
            FileUtils.closeQuietly((Reader)freader);
        }
        FileUtils.closeQuietly((Reader)breader);
        FileUtils.closeQuietly((Reader)freader);
        return result;
    }
}

