/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.adams.djl.dataset;

import ai.djl.basicdataset.tabular.TabularDataset;
import ai.djl.basicdataset.tabular.utils.Feature;
import ai.djl.util.Progress;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import nz.ac.waikato.cms.adams.djl.dataset.ArffAttributeType;
import nz.ac.waikato.cms.adams.djl.dataset.ArffParser;

public class ArffDataset
extends TabularDataset {
    protected URL arffUrl;
    protected String relationName;
    protected List<String> colNames;
    protected List<ArffAttributeType> colTypes;
    protected List<List<String>> data;
    protected List<Map<String, String>> header;
    protected Map<String, Integer> attLookUp;
    protected JsonObject structure;

    protected ArffDataset(ArffBuilder<?> builder) {
        super(builder);
        this.arffUrl = builder.arffUrl;
        this.structure = builder.toJson();
    }

    public String getCell(long rowIndex, String featureName) {
        List<String> record = this.data.get(Math.toIntExact(rowIndex));
        return record.get(this.attLookUp.get(featureName));
    }

    protected long availableSize() {
        return this.data.size();
    }

    protected void parseDataset(Reader r) throws IOException {
        ArffParser parser = new ArffParser();
        parser.parse(r);
        this.relationName = parser.getRelationName();
        this.data = parser.getData();
        this.header = parser.getHeader();
        this.colNames = parser.getColNames();
        this.colTypes = parser.getColTypes();
        this.attLookUp = parser.getAttLookUp();
    }

    public void prepare(Progress progress) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(this.getArffStream(), StandardCharsets.UTF_8);){
            this.parseDataset(reader);
        }
        this.prepareFeaturizers();
    }

    private InputStream getArffStream() throws IOException {
        if (this.arffUrl.getFile().endsWith(".gz")) {
            return new GZIPInputStream(this.arffUrl.openStream());
        }
        return new BufferedInputStream(this.arffUrl.openStream());
    }

    public static ArffBuilder<?> builder() {
        return new ArffBuilder();
    }

    public String getRelationName() {
        return this.relationName;
    }

    public List<String> getColumnNames() {
        if (this.header == null || this.header.isEmpty()) {
            return Collections.emptyList();
        }
        return this.colNames;
    }

    public ArffAttributeType getColumnType(String name) {
        if (this.header == null || this.header.isEmpty()) {
            return null;
        }
        return this.colTypes.get(this.attLookUp.get(name));
    }

    public List<Map<String, String>> getHeader() {
        return this.header;
    }

    public String toInfo() {
        StringBuilder result = new StringBuilder("Relation").append(": ").append(this.getRelationName());
        result.append("\n").append("Features: ").append(this.getFeatureSize());
        for (Feature feature : this.getFeatures()) {
            result.append("\n");
            result.append("- ").append(feature.getName());
            result.append("/");
            result.append((Object)this.getColumnType(feature.getName()));
            result.append("/");
            result.append(feature.getFeaturizer().getClass().getSimpleName());
        }
        if (this.getFeatureSize() > 0) {
            result.append("\n").append("Labels: ").append(this.getLabelSize());
            for (Feature feature : this.getLabels()) {
                result.append("\n");
                result.append("- ").append(feature.getName());
                result.append("/");
                result.append((Object)this.getColumnType(feature.getName()));
                result.append("/");
                result.append(feature.getFeaturizer().getClass().getSimpleName());
            }
        }
        return result.toString();
    }

    public JsonObject toJson() {
        return this.structure;
    }

    public void toJson(Path filename) throws IOException {
        try (FileWriter fw = new FileWriter(filename.toFile());
             BufferedWriter bw = new BufferedWriter(fw);){
            bw.write(this.toJson().toString());
        }
    }

    public static class ArffBuilder<T extends ArffBuilder<T>>
    extends TabularDataset.BaseBuilder<T> {
        protected URL arffUrl;
        protected Set<String> classColumns = new HashSet<String>();
        protected Set<String> ignoredColumns = new HashSet<String>();
        protected ArffParser parser;
        protected boolean classAdded = false;
        protected boolean allFeaturesAdded = false;
        protected Set<String> matchingFeaturesAdded = new HashSet<String>();
        protected boolean stringColumnsAsNominal = false;
        protected boolean dateColumnsAsNumeric = false;
        protected JsonObject structure = new JsonObject();

        protected ArffBuilder() {
            this.structure.add("options", (JsonElement)new JsonObject());
            this.structure.get("options").getAsJsonObject().addProperty("dateColumnsAsNumeric", Boolean.valueOf(false));
            this.structure.get("options").getAsJsonObject().addProperty("stringColumnsAsNominal", Boolean.valueOf(false));
            this.structure.add("features", (JsonElement)new JsonArray());
            this.structure.add("labels", (JsonElement)new JsonArray());
        }

        protected T self() {
            return (T)((Object)this);
        }

        public T optArffFile(Path arffFile) {
            this.parser = null;
            try {
                this.arffUrl = arffFile.toAbsolutePath().toUri().toURL();
                this.structure.addProperty("arffUrl", this.arffUrl.toString());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid file path: " + String.valueOf(arffFile), e);
            }
            return this.self();
        }

        public T optArffUrl(String arffUrl) {
            this.parser = null;
            try {
                this.arffUrl = new URL(arffUrl);
                this.structure.addProperty("arffUrl", arffUrl);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid url: " + arffUrl, e);
            }
            return this.self();
        }

        public T dateColumnsAsNumeric() {
            this.dateColumnsAsNumeric = true;
            this.structure.get("options").getAsJsonObject().addProperty("dateColumnsAsNumeric", Boolean.valueOf(true));
            return this.self();
        }

        public T stringColumnsAsNominal() {
            this.stringColumnsAsNominal = true;
            this.structure.get("options").getAsJsonObject().addProperty("stringColumnsAsNominal", Boolean.valueOf(true));
            return this.self();
        }

        protected ArffParser getParser() {
            if (this.parser == null && this.arffUrl != null) {
                InputStream is = null;
                InputStreamReader ir = null;
                try {
                    is = this.arffUrl.getFile().endsWith(".gz") ? new GZIPInputStream(this.arffUrl.openStream()) : new BufferedInputStream(this.arffUrl.openStream());
                    ir = new InputStreamReader(is, StandardCharsets.UTF_8);
                    this.parser = new ArffParser();
                    this.parser.parseHeader(ir);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (ir != null) {
                    try {
                        ir.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return this.parser;
        }

        public T classIndex(int ... index) {
            for (int i : index) {
                if (i < -1) {
                    i = -1;
                }
                if (i == -1) continue;
                ArffParser parser = this.getParser();
                this.addClassColumn(parser.getColNames().get(i));
            }
            return this.self();
        }

        public T classIsFirst() {
            return this.classIndex(0);
        }

        public T classIsLast() {
            ArffParser parser = this.getParser();
            this.addClassColumn(parser.getColNames().get(parser.getColNames().size() - 1));
            return this.self();
        }

        protected boolean isClassColumn(ArffParser parser, int index) {
            return this.classColumns.contains(parser.getColNames().get(index));
        }

        protected void addColumn(String colName, ArffAttributeType colType, boolean isClassColumn) {
            block16: {
                JsonObject att;
                block15: {
                    if (this.ignoredColumns.contains(colName)) {
                        return;
                    }
                    att = new JsonObject();
                    att.addProperty("name", colName);
                    att.addProperty("type", colType.toString());
                    if (!isClassColumn) break block15;
                    switch (colType) {
                        case NUMERIC: {
                            this.addNumericLabel(colName);
                            this.structure.get("labels").getAsJsonArray().add((JsonElement)att);
                            break block16;
                        }
                        case DATE: {
                            if (this.dateColumnsAsNumeric) {
                                this.addNumericLabel(colName);
                                this.structure.get("labels").getAsJsonArray().add((JsonElement)att);
                            }
                            break block16;
                        }
                        case NOMINAL: {
                            this.addCategoricalLabel(colName);
                            this.structure.get("labels").getAsJsonArray().add((JsonElement)att);
                            break block16;
                        }
                        case STRING: {
                            if (this.stringColumnsAsNominal) {
                                this.addCategoricalLabel(colName);
                                this.structure.get("labels").getAsJsonArray().add((JsonElement)att);
                            }
                            break block16;
                        }
                        default: {
                            throw new IllegalStateException("Unhandled class attribute type: " + String.valueOf((Object)colType));
                        }
                    }
                }
                switch (colType) {
                    case NUMERIC: {
                        this.addNumericFeature(colName);
                        this.structure.get("features").getAsJsonArray().add((JsonElement)att);
                        break;
                    }
                    case DATE: {
                        if (!this.dateColumnsAsNumeric) break;
                        this.addNumericFeature(colName);
                        this.structure.get("features").getAsJsonArray().add((JsonElement)att);
                        break;
                    }
                    case NOMINAL: {
                        this.addCategoricalFeature(colName);
                        this.structure.get("features").getAsJsonArray().add((JsonElement)att);
                        break;
                    }
                    case STRING: {
                        if (!this.stringColumnsAsNominal) break;
                        this.addCategoricalFeature(colName);
                        this.structure.get("features").getAsJsonArray().add((JsonElement)att);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled class attribute type: " + String.valueOf((Object)colType));
                    }
                }
            }
        }

        protected void addColumn(ArffParser parser, int index) {
            String colName = parser.getColNames().get(index);
            ArffAttributeType colType = parser.getColTypes().get(index);
            this.addColumn(colName, colType, this.isClassColumn(parser, index));
        }

        public T addClassColumn(String ... colNames) {
            ArffParser parser = this.getParser();
            for (String colName : colNames) {
                if (this.classColumns.contains(colName)) continue;
                this.classColumns.add(colName);
                int index = parser.getAttLookUp().get(colName);
                this.addColumn(parser, index);
            }
            return this.self();
        }

        public T addIgnoredColumn(String ... colNames) {
            this.ignoredColumns.addAll(Arrays.asList(colNames));
            return this.self();
        }

        public T ignoreMatchingColumns(String ... regexp) {
            ArffParser parser = this.getParser();
            for (String r : regexp) {
                for (String colName : parser.getColNames()) {
                    if (!colName.matches(r)) continue;
                    this.addIgnoredColumn(colName);
                }
            }
            return this.self();
        }

        public T addAllFeatures() {
            if (this.allFeaturesAdded) {
                return this.self();
            }
            this.allFeaturesAdded = true;
            ArffParser parser = this.getParser();
            for (int i = 0; i < parser.getColNames().size(); ++i) {
                if (this.isClassColumn(parser, i)) continue;
                this.addColumn(parser, i);
            }
            return this.self();
        }

        public T addMatchingFeatures(String ... regexp) {
            for (String r : regexp) {
                if (this.matchingFeaturesAdded.contains(r)) continue;
                this.matchingFeaturesAdded.add(r);
                this.parser = this.getParser();
                for (int i = 0; i < this.parser.getColNames().size(); ++i) {
                    if (this.isClassColumn(this.parser, i) || !this.parser.getColNames().get(i).matches(r)) continue;
                    this.addColumn(this.parser, i);
                }
            }
            return this.self();
        }

        public ArffDataset build() {
            return new ArffDataset(this);
        }

        public JsonObject toJson() {
            return this.structure;
        }

        public T fromJson(Path path) throws IOException {
            try (FileReader r = new FileReader(path.toFile());){
                T t;
                try (BufferedReader br = new BufferedReader(r);){
                    JsonObject j = (JsonObject)JsonParser.parseReader((Reader)br);
                    t = this.fromJson(j);
                }
                return t;
            }
        }

        public T fromJson(String json) throws IOException {
            try (StringReader r = new StringReader(json);){
                T t;
                try (BufferedReader br = new BufferedReader(r);){
                    JsonObject j = (JsonObject)JsonParser.parseReader((Reader)br);
                    t = this.fromJson(j);
                }
                return t;
            }
        }

        public T fromJson(JsonObject structure) {
            ArffAttributeType type;
            JsonObject feature;
            int i;
            if (structure.has("options")) {
                JsonObject options = structure.getAsJsonObject("options");
                if (options.has("dateColumnsAsNumeric") && options.get("dateColumnsAsNumeric").getAsBoolean()) {
                    this.dateColumnsAsNumeric();
                }
                if (options.has("stringColumnsAsNominal") && options.get("stringColumnsAsNominal").getAsBoolean()) {
                    this.stringColumnsAsNominal();
                }
            }
            if (structure.has("features")) {
                JsonArray features = structure.getAsJsonArray("features");
                for (i = 0; i < features.size(); ++i) {
                    feature = features.get(i).getAsJsonObject();
                    type = ArffAttributeType.valueOf(feature.get("type").getAsString());
                    this.addColumn(feature.get("name").getAsString(), type, false);
                }
            }
            if (structure.has("labels")) {
                JsonArray labels = structure.getAsJsonArray("labels");
                for (i = 0; i < labels.size(); ++i) {
                    feature = labels.get(i).getAsJsonObject();
                    type = ArffAttributeType.valueOf(feature.get("type").getAsString());
                    this.addColumn(feature.get("name").getAsString(), type, true);
                }
            }
            if (structure.has("arffUrl")) {
                this.optArffUrl(structure.get("arffUrl").getAsString());
            }
            return this.self();
        }
    }
}

