/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.adams.djl.dataset;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nz.ac.waikato.cms.adams.djl.dataset.ArffAttributeType;
import nz.ac.waikato.cms.adams.djl.dataset.ArffUtils;

public class ArffParser {
    protected boolean onlyHeader;
    protected String relationName = "";
    protected List<String> colNames = new ArrayList<String>();
    protected List<ArffAttributeType> colTypes = new ArrayList<ArffAttributeType>();
    protected List<List<String>> data = new ArrayList<List<String>>();
    protected List<Map<String, String>> header = new ArrayList<Map<String, String>>();
    protected Map<String, Integer> attLookUp = new HashMap<String, Integer>();

    protected void doParse(Reader r) throws IOException {
        this.data = new ArrayList<List<String>>();
        this.header = new ArrayList<Map<String, String>>();
        this.colNames = new ArrayList<String>();
        this.colTypes = new ArrayList<ArffAttributeType>();
        this.attLookUp = new HashMap<String, Integer>();
        HashMap<Integer, SimpleDateFormat> formats = new HashMap<Integer, SimpleDateFormat>();
        BufferedReader reader = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        int lineIndex = 0;
        boolean isHeader = true;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                ++lineIndex;
                if ((line = line.trim()).isEmpty() || line.startsWith("%")) continue;
                if (isHeader) {
                    String lower = line.toLowerCase();
                    if (lower.startsWith("@relation")) {
                        this.relationName = ArffUtils.unquote(line.substring("@relation".length()).trim());
                        continue;
                    }
                    if (lower.startsWith("@attribute")) {
                        HashMap<String, String> attInfo = ArffUtils.parseAttribute(line);
                        this.colNames.add((String)attInfo.get("name"));
                        this.colTypes.add(ArffAttributeType.valueOf((String)attInfo.get("type")));
                        this.attLookUp.put((String)attInfo.get("name"), this.attLookUp.size());
                        if (this.colTypes.get(this.colTypes.size() - 1) == ArffAttributeType.DATE) {
                            formats.put(this.colTypes.size() - 1, new SimpleDateFormat((String)attInfo.get("format")));
                        }
                        this.header.add(attInfo);
                        continue;
                    }
                    if (!lower.startsWith("@data")) continue;
                    isHeader = false;
                    if (!this.onlyHeader) continue;
                    return;
                }
                ArrayList<Object> row = new ArrayList<Object>();
                this.data.add(row);
                String[] cells = ArffUtils.split(line, ',', false, '\'', true);
                block9: for (int i = 0; i < cells.length && i < this.header.size(); ++i) {
                    cells[i] = cells[i].trim();
                    if (cells[i].equals("?")) {
                        row.add(null);
                        continue;
                    }
                    cells[i] = ArffUtils.unquote(cells[i]);
                    switch (this.colTypes.get(i)) {
                        case NUMERIC: {
                            Double.parseDouble(cells[i]);
                            row.add(cells[i]);
                            continue block9;
                        }
                        case NOMINAL: 
                        case STRING: {
                            row.add(cells[i]);
                            continue block9;
                        }
                        case DATE: {
                            row.add("" + ((DateFormat)formats.get(i)).parse(cells[i]).getTime());
                            continue block9;
                        }
                        default: {
                            throw new IOException("Unhandled attribute type: " + String.valueOf((Object)this.colTypes.get(i)));
                        }
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException("Failed to read ARFF data from reader (line #" + (lineIndex + 1) + ")!", e);
        }
    }

    public void parseHeader(Reader r) throws IOException {
        this.onlyHeader = true;
        this.doParse(r);
    }

    public void parse(Reader r) throws IOException {
        this.onlyHeader = false;
        this.doParse(r);
    }

    public String getRelationName() {
        return this.relationName;
    }

    public List<Map<String, String>> getHeader() {
        return this.header;
    }

    public List<String> getColNames() {
        return this.colNames;
    }

    public List<ArffAttributeType> getColTypes() {
        return this.colTypes;
    }

    public List<List<String>> getData() {
        return this.data;
    }

    public Map<String, Integer> getAttLookUp() {
        return this.attLookUp;
    }
}

