/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.adams.djl.dataset;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import nz.ac.waikato.cms.adams.djl.dataset.ArffAttributeType;

public class ArffUtils {
    public static String unDoubleQuote(String string) {
        return ArffUtils.unquote(string, "\"");
    }

    public static String unquote(String string) {
        return ArffUtils.unquote(string, "'");
    }

    public static String unquote(String string, String quoteChar) {
        if (string == null || string.length() < 2) {
            return string;
        }
        if (string.startsWith(quoteChar) && string.endsWith(quoteChar) && ((string = string.substring(1, string.length() - 1)).contains("\\n") || string.contains("\\r") || string.contains("\\'") || string.contains("\\\"") || string.contains("\\\\") || string.contains("\\t"))) {
            string = ArffUtils.unbackQuoteChars(string);
        }
        return string;
    }

    public static String unbackQuoteChars(String string) {
        return ArffUtils.unbackQuoteChars(string, new String[]{"\\\\", "\\'", "\\t", "\\n", "\\r", "\\\""}, new char[]{'\\', '\'', '\t', '\n', '\r', '\"'});
    }

    public static String unbackQuoteChars(String string, String[] find, char[] replace) {
        if (string == null) {
            return null;
        }
        int[] pos = new int[find.length];
        String str = string;
        StringBuilder newStr = new StringBuilder();
        while (!str.isEmpty()) {
            int curPos = str.length();
            int index = -1;
            for (int i = 0; i < pos.length; ++i) {
                pos[i] = str.indexOf(find[i]);
                if (pos[i] <= -1 || pos[i] >= curPos) continue;
                index = i;
                curPos = pos[i];
            }
            if (index == -1) {
                newStr.append(str);
                str = "";
                continue;
            }
            newStr.append(str, 0, pos[index]);
            newStr.append(replace[index]);
            str = str.substring(pos[index] + find[index].length());
        }
        return newStr.toString();
    }

    public static String[] split(String s, char delimiter, boolean unquote, char quoteChar, boolean escaped) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean quoted = false;
        boolean backslash = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == quoteChar) {
                if (!backslash) {
                    quoted = !quoted;
                }
                current.append(c);
            } else if (c == delimiter) {
                if (quoted) {
                    current.append(c);
                } else {
                    if (unquote) {
                        if (quoteChar == '\"') {
                            result.add(ArffUtils.unDoubleQuote(current.toString()));
                        } else if (quoteChar == '\'') {
                            result.add(ArffUtils.unquote(current.toString()));
                        } else {
                            result.add(current.toString());
                        }
                    } else {
                        result.add(current.toString());
                    }
                    current.delete(0, current.length());
                }
            } else {
                current.append(c);
            }
            if (!escaped) continue;
            backslash = c == '\\';
        }
        if (current.length() > 0) {
            if (unquote) {
                if (quoteChar == '\"') {
                    result.add(ArffUtils.unDoubleQuote(current.toString()));
                } else if (quoteChar == '\'') {
                    result.add(ArffUtils.unquote(current.toString()));
                } else {
                    result.add(current.toString());
                }
            } else {
                result.add(current.toString());
            }
        }
        return result.toArray(new String[0]);
    }

    public static HashMap<String, String> parseAttribute(String line) throws IOException {
        boolean quoted;
        HashMap<String, String> result = new HashMap<String, String>();
        String current = line.replace("\t", " ");
        if ((current = current.substring("@attribute".length() + 1).trim()).startsWith("'")) {
            quoted = true;
            result.put("name", current.substring(1, current.indexOf(39, 1)).trim());
        } else if (current.startsWith("\"")) {
            quoted = true;
            result.put("name", current.substring(1, current.indexOf(34, 1)).trim());
        } else {
            quoted = false;
            result.put("name", current.substring(0, current.indexOf(32, 1)).trim());
        }
        current = current.substring(((String)result.get("name")).length() + (quoted ? 2 : 0)).trim();
        String lower = current.toLowerCase();
        if (lower.startsWith("numeric") || lower.startsWith("real") || lower.startsWith("integer")) {
            result.put("type", ArffAttributeType.NUMERIC.toString());
        } else if (lower.startsWith("string")) {
            result.put("type", ArffAttributeType.STRING.toString());
        } else if (lower.startsWith("date")) {
            result.put("type", ArffAttributeType.DATE.toString());
        } else if (lower.startsWith("{")) {
            result.put("type", ArffAttributeType.NOMINAL.toString());
        } else {
            throw new IllegalStateException("Unsupported attribute: " + current);
        }
        if (((String)result.get("type")).equals(ArffAttributeType.DATE.toString())) {
            String format = (current = current.substring(5).trim()).startsWith("'") ? ArffUtils.unquote(current) : (current.startsWith("\"") ? ArffUtils.unDoubleQuote(current) : current);
            try {
                new SimpleDateFormat(format);
                result.put("format", format);
            }
            catch (Exception e) {
                throw new IllegalStateException("Invalid date format: " + format);
            }
        }
        return result;
    }
}

