/*
 * Decompiled with CFR 0.152.
 */
package adams.bootstrap;

import com.github.fracpete.requests4j.Requests;
import com.github.fracpete.requests4j.response.BasicResponse;
import com.github.fracpete.resourceextractor4j.Files;
import com.github.fracpete.simpleargparse4j.ArgumentParser;
import com.github.fracpete.simpleargparse4j.ArgumentParserException;
import com.github.fracpete.simpleargparse4j.Namespace;
import com.github.fracpete.simpleargparse4j.Option;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.SystemUtils;

public class Main {
    public static final String USER_SETTINGS_URL = "https://raw.githubusercontent.com/waikato-datamining/adams-website/master/files/resources/settings.xml";
    public static final String ADAMS_BASE_URL = "https://raw.githubusercontent.com/waikato-datamining/adams-base/master/pom.xml";
    public static final String ADAMS_ADDONS_URL = "https://raw.githubusercontent.com/waikato-datamining/adams-addons/master/pom.xml";
    public static final String ADAMS_LTS_URL = "https://raw.githubusercontent.com/waikato-datamining/adams-lts/master/pom.xml";
    public static final String ADAMS_SPECTRAL_BASE_URL = "https://raw.githubusercontent.com/waikato-datamining/adams-spectral-base/master/pom.xml";
    public static final String HOME_DIR_ENV = "INSTANTADAMS_HOME";
    public static final String RESOURCES = "adams/bootstrap";
    public static final String POMTEMPLATE_FILE = "instant-adams.xml";
    public static final String LATEST = "LATEST";
    protected File m_MavenHome;
    protected File m_MavenUserSettings;
    protected File m_ActMavenUserSettings;
    protected File m_JavaHome;
    protected File m_OutputDir;
    protected File m_OutputDirMaven;
    protected File m_PomTemplate;
    protected transient File m_ActPomTemplate;
    protected String m_Name;
    protected boolean m_Clean;
    protected List<String> m_JVM;
    protected String m_Modules;
    protected String m_Version;
    protected transient String m_ActualVersion;
    protected List<File> m_ExternalJars;
    protected boolean m_Sources;
    protected List<File> m_ExternalSources;
    protected List<String> m_Dependencies;
    protected List<File> m_DependencyFiles;
    protected List<String> m_AllDependencies;
    protected String m_MainClass;
    protected boolean m_Debian;
    protected File m_DebianSnippet;
    protected boolean m_Redhat;
    protected File m_RedhatSnippet;
    protected boolean m_ListModules;
    protected Logger m_Logger;
    protected boolean m_HelpRequested;

    public Main() {
        this.initialize();
    }

    protected void initialize() {
        this.m_MavenHome = null;
        this.m_MavenUserSettings = null;
        this.m_ActMavenUserSettings = null;
        this.m_PomTemplate = null;
        this.m_ActPomTemplate = null;
        this.m_JavaHome = null;
        this.m_OutputDir = null;
        this.m_OutputDirMaven = null;
        this.m_JVM = null;
        this.m_Modules = null;
        this.m_ExternalJars = null;
        this.m_Sources = false;
        this.m_ExternalSources = null;
        this.m_AllDependencies = null;
        this.m_Dependencies = null;
        this.m_DependencyFiles = null;
        this.m_MainClass = "adams.gui.Main";
        this.m_Name = "bootstrapp-harness";
        this.m_Clean = false;
        this.m_Debian = false;
        this.m_DebianSnippet = null;
        this.m_Redhat = false;
        this.m_RedhatSnippet = null;
        this.m_ListModules = false;
        this.m_Logger = null;
        this.m_HelpRequested = false;
        this.m_ActualVersion = null;
    }

    protected Logger getLogger() {
        if (this.m_Logger == null) {
            this.m_Logger = Logger.getLogger(this.getClass().getName());
        }
        return this.m_Logger;
    }

    public Main mavenHome(File dir) {
        this.m_MavenHome = dir;
        return this;
    }

    public File getMavenHome() {
        return this.m_MavenHome;
    }

    public Main mavenUserSettings(File dir) {
        this.m_MavenUserSettings = dir;
        return this;
    }

    public File getMavenUserSettings() {
        return this.m_MavenUserSettings;
    }

    public Main javaHome(File dir) {
        this.m_JavaHome = dir;
        return this;
    }

    public File getJavaHome() {
        return this.m_JavaHome;
    }

    public Main outputDir(File dir) {
        this.m_OutputDir = dir;
        return this;
    }

    public File getOutputDir() {
        return this.m_OutputDir;
    }

    public Main pomTemplate(File template) {
        this.m_PomTemplate = template;
        return this;
    }

    public File getPomTemplate() {
        return this.m_PomTemplate;
    }

    public Main name(String name) {
        this.m_Name = name;
        return this;
    }

    public String getName() {
        return this.m_Name;
    }

    protected String checkModules(String[] modules) {
        StringBuilder result = new StringBuilder();
        HashSet<String> set = new HashSet<String>();
        for (String module : modules) {
            if (!module.endsWith("-lts")) continue;
            set.add(module.replaceAll("-lts$", ""));
        }
        for (String module : modules) {
            if ((module = module.trim()).endsWith("-lts") || !set.contains(module)) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(module);
        }
        if (result.length() == 0) {
            return null;
        }
        return "Following modules are present as LTS and non-LTS version: " + result.toString();
    }

    public Main modules(String modules) {
        String msg = this.checkModules(modules.split(","));
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        this.m_Modules = modules;
        return this;
    }

    public Main modules(String ... modules) {
        if (modules != null) {
            String msg = this.checkModules(modules);
            if (msg != null) {
                throw new IllegalArgumentException(msg);
            }
            StringBuilder all = new StringBuilder();
            for (String module : modules) {
                if (all.length() > 0) {
                    all.append(",");
                }
                all.append(module);
            }
            this.m_Modules = all.toString();
        } else {
            this.m_Modules = null;
        }
        return this;
    }

    public Main modules(List<String> modules) {
        if (modules != null) {
            this.modules(modules.toArray(new String[0]));
        } else {
            this.m_Modules = null;
        }
        return this;
    }

    public String getModules() {
        return this.m_Modules;
    }

    public Main version(String version) {
        this.m_Version = version;
        this.m_ActualVersion = null;
        return this;
    }

    public String getVersion() {
        return this.m_Version;
    }

    public Main externalJars(List<File> external) {
        this.m_ExternalJars = external;
        return this;
    }

    public Main externalJars(File ... external) {
        if (external == null) {
            this.m_ExternalJars = null;
        } else {
            this.externalJars(Arrays.asList(external));
        }
        return this;
    }

    public List<File> getExternalJars() {
        return this.m_ExternalJars;
    }

    public Main externalSources(List<File> external) {
        this.m_ExternalSources = external;
        return this;
    }

    public Main externalSources(File ... external) {
        if (external == null) {
            this.m_ExternalSources = null;
        } else {
            this.externalSources(Arrays.asList(external));
        }
        return this;
    }

    public List<File> getExternalSources() {
        return this.m_ExternalSources;
    }

    public Main clean(boolean clean) {
        this.m_Clean = clean;
        return this;
    }

    public boolean getClean() {
        return this.m_Clean;
    }

    public Main sources(boolean sources) {
        this.m_Sources = sources;
        return this;
    }

    public boolean getSources() {
        return this.m_Sources;
    }

    public Main jvm(List<String> options) {
        this.m_JVM = options;
        return this;
    }

    public Main jvm(String ... options) {
        this.m_JVM = options != null ? new ArrayList<String>(Arrays.asList(options)) : null;
        return this;
    }

    public List<String> getJvm() {
        return this.m_JVM;
    }

    public Main dependencies(List<String> dependencies) {
        this.m_Dependencies = dependencies;
        return this;
    }

    public Main dependencies(String ... dependencies) {
        this.m_Dependencies = dependencies != null ? new ArrayList<String>(Arrays.asList(dependencies)) : null;
        return this;
    }

    public List<String> getDependencies() {
        return this.m_Dependencies;
    }

    public Main dependencyFiles(List<File> files) {
        this.m_DependencyFiles = files;
        return this;
    }

    public Main dependencyFiles(File ... files) {
        this.m_DependencyFiles = files != null ? new ArrayList<File>(Arrays.asList(files)) : null;
        return this;
    }

    public List<File> getDependencyFiles() {
        return this.m_DependencyFiles;
    }

    public Main mainClass(String dir) {
        this.m_MainClass = dir;
        return this;
    }

    public String getMainClass() {
        return this.m_MainClass;
    }

    public Main debian(boolean debian) {
        this.m_Debian = debian;
        return this;
    }

    public boolean getDebian() {
        return this.m_Debian;
    }

    public Main debianSnippet(File snippet) {
        this.m_DebianSnippet = snippet;
        return this;
    }

    public File getDebianSnippet() {
        return this.m_DebianSnippet;
    }

    public Main redhat(boolean redhat) {
        this.m_Redhat = redhat;
        return this;
    }

    public boolean getRedhat() {
        return this.m_Redhat;
    }

    public Main redhatSnippet(File snippet) {
        this.m_RedhatSnippet = snippet;
        return this;
    }

    public File getRedhatSnippet() {
        return this.m_RedhatSnippet;
    }

    public Main listModules(boolean listModules) {
        this.m_ListModules = listModules;
        return this;
    }

    public boolean getListModules() {
        return this.m_ListModules;
    }

    protected ArgumentParser getParser() {
        ArgumentParser parser = new ArgumentParser("Allows bootstrapping of ADAMS applications by simply supplying the modules.");
        parser.addOption("-m", "--maven_home").required(false).type(Option.Type.EXISTING_DIR).dest("maven_home").metaVar("DIR").help("The directory with a local Maven installation to use instead of the bundled one.");
        parser.addOption("-u", "--maven_user_settings").required(false).type(Option.Type.EXISTING_FILE).dest("maven_user_settings").metaVar("FILE").help("The file with the maven user settings to use other than $HOME/.m2/settings.xml.");
        parser.addOption("-j", "--java_home").required(false).type(Option.Type.EXISTING_DIR).dest("java_home").metaVar("DIR").help("The Java home to use for the Maven execution.");
        parser.addOption("-p", "--pom_template").required(false).type(Option.Type.EXISTING_FILE).dest("pom_template").metaVar("FILE").help("The alternative template for the pom.xml to use.");
        parser.addOption("-n", "--name").required(false).setDefault("adams").dest("name").help("The name to use for the project in the pom.xml. Also used as library directory and executable name when generating Debian/Redhat packages.");
        parser.addOption("-M", "--module").required(true).dest("modules").help("The comma-separated list of ADAMS modules to use for the application, e.g.: adams-weka,adams-groovy,adams-excel");
        parser.addOption("-V", "--version").required(true).dest("version").help("The version of ADAMS to use, e.g., '20.1.1' or '20.2.0-SNAPSHOT'.\nUse 'LATEST' to use the latest snapshot version available.");
        parser.addOption("-d", "--dependency").required(false).multiple(true).dest("dependencies").metaVar("DEPENDENCY").help("The additional maven dependencies to use for bootstrapping ADAMS (group:artifact:version), e.g.: nz.ac.waikato.cms.weka:kfGroovy:1.0.12");
        parser.addOption("-D", "--dependency-file").required(false).multiple(true).type(Option.Type.EXISTING_FILE).dest("dependency_files").metaVar("FILE").help("The file(s) with additional maven dependencies to use for bootstrapping ADAMS (group:artifact:version), one dependency per line.");
        parser.addOption("-J", "--external-jar").required(false).multiple(true).type(Option.Type.EXISTING_FILE_OR_DIRECTORY).dest("external_jars").metaVar("JAR_OR_DIR").help("The external jar or directory with jar files to also include in the application.");
        parser.addOption("-s", "--sources").type(Option.Type.BOOLEAN).setDefault(false).dest("sources").help("If enabled, source jars of all the Maven artifacts will get downloaded as well and stored in a separated directory.");
        parser.addOption("-S", "--external-source").required(false).multiple(true).type(Option.Type.EXISTING_FILE_OR_DIRECTORY).dest("external_sources").metaVar("JAR_OR_DIR").help("The external source jar or directory with source jar files to also include in the application.");
        parser.addOption("-o", "--output_dir").required(true).type(Option.Type.DIRECTORY).dest("output_dir").metaVar("DIR").help("The directory to output the bootstrapped ADAMS application in.");
        parser.addOption("-C", "--clean").type(Option.Type.BOOLEAN).setDefault(false).dest("clean").help("If enabled, the 'clean' goals gets executed.");
        parser.addOption("-v", "--jvm").required(false).multiple(true).dest("jvm").help("The parameters to pass to the JVM before launching the application in the scripts.");
        parser.addOption("-c", "--main_class").required(false).setDefault("adams.gui.Main").dest("main_class").metaVar("CLASSNAME").help("The main class to launch in the scripts.");
        parser.addOption("--deb").type(Option.Type.BOOLEAN).setDefault(false).dest("debian").help("If enabled, a Debian .deb package is generated. Required tools: fakeroot, dpkg-deb");
        parser.addOption("--deb-snippet").type(Option.Type.EXISTING_FILE).required(false).dest("debian_snippet").metaVar("FILE").help("The custom Maven pom.xml snippet for generating a Debian package.");
        parser.addOption("--rpm").type(Option.Type.BOOLEAN).setDefault(false).dest("redhat").help("If enabled, a Redhat .rpm package is generated.");
        parser.addOption("--rpm-snippet").type(Option.Type.EXISTING_FILE).required(false).dest("rpm_snippet").metaVar("FILE").help("The custom Maven pom.xml snippet for generating a Redhat package.");
        parser.addOption("-l", "--list_modules").type(Option.Type.BOOLEAN).setDefault(false).dest("list_modules").help("If enabled, all currently available ADAMS modules are output (all other options get ignored).");
        return parser;
    }

    protected boolean setOptions(Namespace ns) {
        this.mavenHome(ns.getFile("maven_home"));
        this.mavenUserSettings(ns.getFile("maven_user_settings"));
        this.javaHome(ns.getFile("java_home"));
        this.outputDir(ns.getFile("output_dir"));
        this.clean(ns.getBoolean("clean"));
        this.pomTemplate(ns.getFile("pom_template"));
        this.jvm(ns.getList("jvm"));
        this.name(ns.getString("name"));
        this.modules(ns.getString("modules"));
        this.version(ns.getString("version"));
        this.dependencies(ns.getList("dependencies"));
        this.dependencyFiles(ns.getList("dependency_files"));
        this.externalJars(ns.getList("external_jars"));
        this.sources(ns.getBoolean("sources"));
        this.externalSources(ns.getList("external_sources"));
        this.mainClass(ns.getString("main_class"));
        this.debian(ns.getBoolean("debian"));
        this.debianSnippet(ns.getFile("debian_snippet"));
        this.redhat(ns.getBoolean("redhat"));
        this.redhatSnippet(ns.getFile("redhat_snippet"));
        this.listModules(ns.getBoolean("list_modules"));
        return true;
    }

    public boolean getHelpRequested() {
        return this.m_HelpRequested;
    }

    public boolean setOptions(String[] options) {
        return this.setOptions(options, false);
    }

    public boolean setOptions(String[] options, boolean noErrors) {
        Namespace ns;
        this.m_HelpRequested = false;
        ArgumentParser parser = this.getParser();
        try {
            ns = parser.parseArgs(options, false, noErrors);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            this.m_HelpRequested = parser.getHelpRequested();
            return this.m_HelpRequested;
        }
        return this.setOptions(ns);
    }

    protected String initVersion() {
        if (this.m_ActualVersion == null) {
            if (this.m_Version.equals(LATEST)) {
                try {
                    BasicResponse r = Requests.get((String)ADAMS_BASE_URL).allowRedirects(true).execute();
                    if (r.ok()) {
                        String[] lines;
                        for (String line : lines = r.text().split("\n")) {
                            if (!line.contains("<version>")) continue;
                            line = line.substring(line.indexOf(62) + 1);
                            this.m_ActualVersion = line = line.substring(0, line.indexOf(60));
                            this.getLogger().info("LATEST version resolves to: " + this.m_ActualVersion);
                        }
                    }
                    return "Failed to load URL (status: " + r.statusCode() + ": " + r.statusMessage() + "): " + ADAMS_BASE_URL;
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Failed to extract version from: https://raw.githubusercontent.com/waikato-datamining/adams-base/master/pom.xml", e);
                    return "Failed to extract version from: https://raw.githubusercontent.com/waikato-datamining/adams-base/master/pom.xml";
                }
            } else {
                this.m_ActualVersion = this.m_Version;
            }
        }
        return null;
    }

    protected String initDependencies() {
        if (this.m_Modules.trim().isEmpty()) {
            return "No modules provided!";
        }
        String result = this.initVersion();
        if (result != null) {
            return result;
        }
        this.m_AllDependencies = new ArrayList<String>();
        if (this.m_Modules.contains(",")) {
            for (String module : this.m_Modules.split(",")) {
                this.m_AllDependencies.add("nz.ac.waikato.cms.adams:" + module.trim() + ":" + this.m_ActualVersion);
            }
        } else {
            this.m_AllDependencies.add("nz.ac.waikato.cms.adams:" + this.m_Modules.trim() + ":" + this.m_ActualVersion);
        }
        if (this.m_Dependencies != null) {
            this.m_AllDependencies.addAll(this.m_Dependencies);
        }
        return null;
    }

    public String homeDir() {
        String result;
        if (System.getenv(HOME_DIR_ENV) != null) {
            result = System.getenv(HOME_DIR_ENV);
        } else {
            result = System.getProperty("user.home");
            if (!SystemUtils.IS_OS_WINDOWS) {
                result = result + "/.local/share";
            }
            result = result + "/instant-adams";
        }
        return result;
    }

    protected String initMavenUserSettings() {
        if (this.m_MavenUserSettings != null) {
            this.m_ActMavenUserSettings = this.m_MavenUserSettings;
        } else {
            File settings = new File(this.homeDir() + "/settings.xml");
            if (!settings.exists()) {
                try {
                    settings.getParentFile().mkdirs();
                    BasicResponse r = Requests.get((String)USER_SETTINGS_URL).execute();
                    r.saveBody(settings);
                    this.m_ActMavenUserSettings = settings;
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Failed to download Maven user settings from: https://raw.githubusercontent.com/waikato-datamining/adams-website/master/files/resources/settings.xml", e);
                    return "Failed to download Maven user settings from: https://raw.githubusercontent.com/waikato-datamining/adams-website/master/files/resources/settings.xml";
                }
            } else {
                this.m_ActMavenUserSettings = settings;
            }
        }
        return null;
    }

    protected String initPomTemplate() {
        if (this.m_PomTemplate != null) {
            this.m_ActPomTemplate = this.m_PomTemplate;
        } else {
            try {
                String path = Files.extractTo((String)RESOURCES, (String)POMTEMPLATE_FILE, (String)System.getProperty("java.io.tmpdir"));
                this.m_ActPomTemplate = new File(path);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to extract pom.xml template!", e);
                return "Failed to extract pom.xml template!";
            }
        }
        return null;
    }

    protected List<String> extractModules(String pom) {
        String[] lines;
        ArrayList<String> result = new ArrayList<String>();
        for (String line : lines = pom.split("\n")) {
            if (!line.contains("<module>")) continue;
            line = line.substring(line.indexOf(62) + 1);
            if ((line = line.substring(0, line.indexOf(60))).contains("$")) continue;
            result.add(line);
        }
        Collections.sort(result);
        return result;
    }

    protected String outputModules(String url, String title) {
        try {
            BasicResponse r = Requests.get((String)url).allowRedirects(true).execute();
            if (r.ok()) {
                List<String> modules = this.extractModules(r.text());
                if (modules.size() == 0) {
                    return "Failed to extract any modules from: https://raw.githubusercontent.com/waikato-datamining/adams-base/master/pom.xml";
                }
                System.out.println("\n" + title + ":");
                for (int i = 0; i < modules.size(); ++i) {
                    if (i > 0) {
                        System.out.print(", ");
                    }
                    System.out.print(modules.get(i));
                }
            } else {
                return "Failed to load URL (status: " + r.statusCode() + ": " + r.statusMessage() + "): " + url;
            }
            System.out.println();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to extract modules from: " + url, e);
        }
        return null;
    }

    public String outputModules() {
        System.out.println("\nAvailable modules:");
        String result = this.outputModules(ADAMS_BASE_URL, "adams-base");
        if (result != null) {
            return result;
        }
        result = this.outputModules(ADAMS_ADDONS_URL, "adams-addons");
        if (result != null) {
            return result;
        }
        result = this.outputModules(ADAMS_LTS_URL, "adams-lts");
        if (result != null) {
            return result;
        }
        result = this.outputModules(ADAMS_SPECTRAL_BASE_URL, "adams-spectral-base");
        if (result != null) {
            return result;
        }
        System.out.println("\nNote:\nLTS and non-LTS modules (e.g., 'adams-weka-lts' and 'adams-weka') cannot be mixed.");
        return null;
    }

    protected String doExecute() {
        if (this.m_ListModules) {
            return this.outputModules();
        }
        String result = this.initMavenUserSettings();
        if (result != null) {
            return result;
        }
        result = this.initDependencies();
        if (result != null) {
            return result;
        }
        result = this.initPomTemplate();
        if (result != null) {
            return result;
        }
        com.github.fracpete.bootstrapp.Main main = new com.github.fracpete.bootstrapp.Main().mainClass(this.m_MainClass).scripts(this.m_MainClass != null && !this.m_MainClass.trim().isEmpty()).javaHome(this.m_JavaHome).mavenHome(this.getMavenHome()).mavenUserSettings(this.m_ActMavenUserSettings).name(this.m_Name).dependencies(this.m_AllDependencies).dependencyFiles(this.m_DependencyFiles).externalJars(this.m_ExternalJars).outputDir(this.getOutputDir()).clean(this.m_Clean).springBoot(false).launch(false).sources(this.getSources()).externalSources(this.m_ExternalSources).jvm(this.m_JVM).debian(this.m_Debian).debianSnippet(this.m_DebianSnippet).redhat(this.m_Redhat).redhatSnippet(this.m_RedhatSnippet);
        return main.execute();
    }

    public String execute() {
        String result = this.doExecute();
        if (result != null) {
            this.getLogger().severe(result);
        }
        return result;
    }

    public static void main(String[] args) {
        Main main = new Main();
        main.setOptions(args, true);
        if (main.getListModules()) {
            main.outputModules();
            System.exit(0);
        }
        if (!main.setOptions(args)) {
            System.err.println("Failed to parse options!");
            System.exit(1);
        } else if (main.getHelpRequested()) {
            System.exit(0);
        }
        String result = main.execute();
        if (result != null) {
            System.err.println("Failed to perform bootstrapping:\n" + result);
            System.exit(2);
        }
    }
}

