/*
 *    PlotTab.java
 *    Copyright (C) 2007 University of Waikato, Hamilton, New Zealand 
 *    @author Alberto Verdecia Cabrera (averdeciac@gmail.com)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program. If not, see <http://www.gnu.org/licenses/>.
 *    
 */
package moa.gui.experimentertab;

import moa.gui.LookAndFeel;
import nz.ac.waikato.cms.gui.core.BaseDirectoryChooser;
import org.apache.commons.io.FilenameUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableModel;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

import static moa.gui.experimentertab.ReadFile.readCSV;

/**
 * Generate figures plotting the performance measurements of various learning
 * algorithms over time.
 *
 * @author Alberto Verdecia Cabrera (averdeciac@gmail.com)
 */
public class PlotTab extends javax.swing.JPanel {

    private String path = "";

    private LinkedList<String> measures = new LinkedList();

    private DefaultTableModel algoritmModel;

    private DefaultTableModel streamModel;

    ImageTreePanel imgPanel;

    ImageChart chart[];
    
    ReadFile rf;

    public PlotTab() {
        initComponents();
        initComponents();
        this.algoritmModel = (DefaultTableModel) jTableAlgoritms.getModel();
        this.streamModel = (DefaultTableModel) jTableStreams.getModel();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jScrollPaneAlgorithms = new javax.swing.JScrollPane();
        jTableAlgoritms = new javax.swing.JTable();
        jScrollPane3 = new javax.swing.JScrollPane();
        jTableStreams = new javax.swing.JTable();
        jTextFieldResultPath = new javax.swing.JTextField();
        jButtonInPath = new javax.swing.JButton();
        jLabel3 = new javax.swing.JLabel();
        jButtonDeletAlgorithm = new javax.swing.JButton();
        jButtonDeleteStream = new javax.swing.JButton();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel2 = new javax.swing.JPanel();
        jButtonAcept = new javax.swing.JButton();
        jButtonReset = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        jPanel4 = new javax.swing.JPanel();
        jLabel17 = new javax.swing.JLabel();
        jTextFieldxTitle = new javax.swing.JTextField();
        jLabel18 = new javax.swing.JLabel();
        jLabel19 = new javax.swing.JLabel();
        jTextFieldyTitle = new javax.swing.JTextField();
        jLabel20 = new javax.swing.JLabel();
        jComboBoxXColumn = new javax.swing.JComboBox();
        jComboBoxYColumn = new javax.swing.JComboBox();
        jTextFieldTitle = new javax.swing.JTextField();
        jLabel21 = new javax.swing.JLabel();
        jSpinnerWidth = new javax.swing.JSpinner();
        jSpinnerHeight = new javax.swing.JSpinner();
        jLabel22 = new javax.swing.JLabel();
        jLabel23 = new javax.swing.JLabel();
        jComboBoxGrid = new javax.swing.JComboBox();
        jCheckBoxShape = new javax.swing.JCheckBox();
        jLabel2 = new javax.swing.JLabel();
        jPanel3 = new javax.swing.JPanel();
        jButtonAceptGnuP = new javax.swing.JButton();
        jButtonResetGnuP = new javax.swing.JButton();
        jScrollPaneGnuP = new javax.swing.JScrollPane();
        jPanelGnuP = new javax.swing.JPanel();
        jTextFieldGNUPath = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jButtonGnuoPath = new javax.swing.JButton();
        jComboBoxOutPTypeGnuP = new javax.swing.JComboBox();
        jLabel5 = new javax.swing.JLabel();
        jComboBoxLineStyle = new javax.swing.JComboBox();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jTextFieldxTitleGnuP = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();
        jTextFieldyTitleGnuP = new javax.swing.JTextField();
        jLabel11 = new javax.swing.JLabel();
        jSpinnerLineWidth = new javax.swing.JSpinner();
        jSpinnerPlotInterval = new javax.swing.JSpinner();
        jLabel13 = new javax.swing.JLabel();
        jLabel14 = new javax.swing.JLabel();
        jCheckBoxSmooth = new javax.swing.JCheckBox();
        jLabel15 = new javax.swing.JLabel();
        jCheckBoxDeleteScript = new javax.swing.JCheckBox();
        jLabel16 = new javax.swing.JLabel();
        jComboBoxLegendLocation = new javax.swing.JComboBox();
        jLabel24 = new javax.swing.JLabel();
        jComboBoxLegendType = new javax.swing.JComboBox();
        jLabel25 = new javax.swing.JLabel();
        jTextFieldAdcComand = new javax.swing.JTextField();
        jLabel26 = new javax.swing.JLabel();
        jTextFieldAPOptions = new javax.swing.JTextField();
        jLabel27 = new javax.swing.JLabel();
        jComboBoxXColumnGnuP = new javax.swing.JComboBox();
        jComboBoxYColumnGnuP = new javax.swing.JComboBox();

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Configuration"));

        jScrollPaneAlgorithms.setBorder(javax.swing.BorderFactory.createTitledBorder("Algorithm"));

        jTableAlgoritms.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        jTableAlgoritms.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Algorithm", "Algorithm ID"
            }
        ));
        jScrollPaneAlgorithms.setViewportView(jTableAlgoritms);

        jScrollPane3.setBorder(javax.swing.BorderFactory.createTitledBorder("Stream"));

        jTableStreams.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        jTableStreams.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Stream", "Stream ID"
            }
        ));
        jScrollPane3.setViewportView(jTableStreams);

        jButtonInPath.setText("Browse");
        jButtonInPath.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonInPathActionPerformed(evt);
            }
        });

        jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel3.setText("Result  folder");

        jButtonDeletAlgorithm.setText("Delete Algorithm");
        jButtonDeletAlgorithm.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDeletAlgorithmActionPerformed(evt);
            }
        });

        jButtonDeleteStream.setText("Delete Stream");
        jButtonDeleteStream.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDeleteStreamActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                        .addGap(14, 14, 14)
                        .addComponent(jLabel3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldResultPath)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jButtonInPath))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jButtonDeletAlgorithm)
                            .addComponent(jScrollPaneAlgorithms, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addComponent(jButtonDeleteStream)
                                .addGap(0, 0, Short.MAX_VALUE)))))
                .addGap(16, 16, 16))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addGap(23, 23, 23)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldResultPath, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonInPath)
                    .addComponent(jLabel3))
                .addGap(18, 18, 18)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPaneAlgorithms, javax.swing.GroupLayout.DEFAULT_SIZE, 89, Short.MAX_VALUE)
                    .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonDeleteStream)
                    .addComponent(jButtonDeletAlgorithm)))
        );

        jButtonAcept.setText("Generate Images");
        jButtonAcept.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAceptActionPerformed(evt);
            }
        });

        jButtonReset.setText(" Reset to Default");
        jButtonReset.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonResetActionPerformed(evt);
            }
        });

        jScrollPane1.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        jScrollPane1.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);

        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder(""));

        jLabel17.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel17.setText("xColumn");

        jTextFieldxTitle.setText("Instances processed");

        jLabel18.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel18.setText("xTitle");

        jLabel19.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel19.setText("yColumn");

        jTextFieldyTitle.setText("% of correctly classified");

        jLabel20.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel20.setText("yTitle");

        jLabel21.setText("title");

        jSpinnerWidth.setValue(500);

        jSpinnerHeight.setValue(300);

        jLabel22.setText("width");

        jLabel23.setText("height");

        jComboBoxGrid.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "White", "Default" }));

        jCheckBoxShape.setText("shapes");

        jLabel2.setText("gridColor");

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addGap(67, 67, 67)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(jPanel4Layout.createSequentialGroup()
                        .addGap(3, 3, 3)
                        .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                .addComponent(jLabel17)
                                .addComponent(jLabel21)
                                .addComponent(jLabel18))
                            .addComponent(jLabel19)
                            .addComponent(jLabel20, javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jLabel22, javax.swing.GroupLayout.Alignment.TRAILING))
                        .addGap(18, 18, 18)
                        .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jTextFieldxTitle)
                            .addComponent(jComboBoxXColumn, javax.swing.GroupLayout.Alignment.TRAILING, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jTextFieldTitle, javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jComboBoxYColumn, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jTextFieldyTitle, javax.swing.GroupLayout.DEFAULT_SIZE, 542, Short.MAX_VALUE)
                            .addComponent(jSpinnerWidth)))
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel4Layout.createSequentialGroup()
                        .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jLabel23)
                            .addComponent(jLabel2))
                        .addGap(18, 18, 18)
                        .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel4Layout.createSequentialGroup()
                                .addComponent(jCheckBoxShape, javax.swing.GroupLayout.PREFERRED_SIZE, 91, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(0, 0, Short.MAX_VALUE))
                            .addComponent(jComboBoxGrid, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jSpinnerHeight))))
                .addGap(30, 30, 30))
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldTitle, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel21))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBoxXColumn, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel17))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldxTitle, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel18))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBoxYColumn, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel19))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldyTitle, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel20))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jSpinnerWidth, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel22))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel23)
                    .addComponent(jSpinnerHeight, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBoxGrid, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jCheckBoxShape)
                .addContainerGap(11, Short.MAX_VALUE))
        );

        jScrollPane1.setViewportView(jPanel4);

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGap(135, 135, 135)
                .addComponent(jButtonAcept)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButtonReset)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
            .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 700, Short.MAX_VALUE)
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 247, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonAcept)
                    .addComponent(jButtonReset)))
        );

        jTabbedPane1.addTab("Charts", jPanel2);

        jButtonAceptGnuP.setText("Generate GnuPlot Commands");
        jButtonAceptGnuP.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAceptGnuPActionPerformed(evt);
            }
        });

        jButtonResetGnuP.setText(" Reset to Default");
        jButtonResetGnuP.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonResetGnuPActionPerformed(evt);
            }
        });

        jScrollPaneGnuP.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        jScrollPaneGnuP.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);

        jPanelGnuP.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        jPanelGnuP.setPreferredSize(new java.awt.Dimension(400, 449));

        jTextFieldGNUPath.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextFieldGNUPathActionPerformed(evt);
            }
        });

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel1.setText("gnuplotBinaryPath ");

        jButtonGnuoPath.setText("Browse");
        jButtonGnuoPath.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonGnuoPathActionPerformed(evt);
            }
        });

        jComboBoxOutPTypeGnuP.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "POSTSCRIPT_COLOR", "EPSLATEX", "GIF", "JPEG", "LATEX", "PDFCAIRO", "PNG", "POSTSCRIPT", "CANVAS", "PSLATEX", "PSTEX", "PSTRICKS", "SVG" }));

        jLabel5.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel5.setText("outputType");

        jComboBoxLineStyle.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "LINES", "POINTS", "LINESPOINTS", "IMPULSES", "STEPS", "FSTEPS", "HISTEPS", "DOTS;" }));

        jLabel6.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel6.setText("plotStyle");

        jLabel7.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel7.setText("xColumn");

        jTextFieldxTitleGnuP.setText("Processed instances");

        jLabel8.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel8.setText("xTitle");

        jLabel10.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel10.setText("yColumn");

        jTextFieldyTitleGnuP.setText("Accuracy");

        jLabel11.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel11.setText("yTitle");

        jSpinnerLineWidth.setValue(2);

        jLabel13.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel13.setText("lineWidth");

        jLabel14.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel14.setText("plotInterval");

        jLabel15.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel15.setText("smooth");

        jLabel16.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel16.setText("deleteScripts");

        jComboBoxLegendLocation.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "BOTTOM_CENTER_OUTSIDE", "TOP_LEFT_INSIDE", "TOP_CENTER_INSIDE", "TOP_RIGHT_INSIDE", "LEFT_INSIDE", "CENTER_INSIDE", "RIGHT_INSIDE", "BOTTOM_LEFT_INSIDE", "BOTTOM_CENTER_INSIDE", "BOTTOM_RIGHT_INSIDE", "TOP_LEFT_OUTSIDE", "TOP_CENTER_OUTSIDE", "TOP_RIGHT_OUTSIDE", "LEFT_OUTSIDE", "CENTER_OUTSIDE", "RIGHT_OUTSIDE", "BOTTOM_LEFT_OUTSIDE", "BOTTOM_RIGHT_OUTSIDE" }));
        jComboBoxLegendLocation.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxLegendLocationActionPerformed(evt);
            }
        });

        jLabel24.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel24.setText("legendLocation");

        jComboBoxLegendType.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "NOBOX_HORIZONTAL", "BOX_VERTICAL", "BOX_HORIZONTAL", "NOBOX_VERTICAL", " " }));

        jLabel25.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel25.setText("legendType");

        jLabel26.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel26.setText("additionalCommands");

        jLabel27.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel27.setText("additionalPlotOptions");

        javax.swing.GroupLayout jPanelGnuPLayout = new javax.swing.GroupLayout(jPanelGnuP);
        jPanelGnuP.setLayout(jPanelGnuPLayout);
        jPanelGnuPLayout.setHorizontalGroup(
            jPanelGnuPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelGnuPLayout.createSequentialGroup()
                .addGroup(jPanelGnuPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelGnuPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(jPanelGnuPLayout.createSequentialGroup()
                            .addGap(22, 22, 22)
                            .addGroup(jPanelGnuPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(jLabel5, javax.swing.GroupLayout.Alignment.TRAILING)
                                .addComponent(jLabel6, javax.swing.GroupLayout.Alignment.TRAILING)
                                .addComponent(jLabel7, javax.swing.GroupLayout.Alignment.TRAILING)
                                .addComponent(jLabel8, javax.swing.GroupLayout.Alignment.TRAILING)
                                .addComponent(jLabel10, javax.swing.GroupLayout.Alignment.TRAILING)
                                .addComponent(jLabel11, javax.swing.GroupLayout.Alignment.TRAILING)
                                .addComponent(jLabel1, javax.swing.GroupLayout.Alignment.TRAILING)))
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelGnuPLayout.createSequentialGroup()
                            .addContainerGap()
                            .addComponent(jLabel27)))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelGnuPLayout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jPanelGnuPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel15, javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jLabel13, javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jLabel14, javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jLabel16, javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jLabel24, javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jLabel25, javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jLabel26, javax.swing.GroupLayout.Alignment.TRAILING))))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanelGnuPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jTextFieldAPOptions, javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jTextFieldAdcComand, javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jComboBoxLegendType, javax.swing.GroupLayout.Alignment.TRAILING, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jSpinnerPlotInterval, javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jSpinnerLineWidth, javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jTextFieldyTitleGnuP, javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jTextFieldxTitleGnuP, javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jComboBoxLineStyle, javax.swing.GroupLayout.Alignment.TRAILING, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jComboBoxXColumnGnuP, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jComboBoxYColumnGnuP, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jComboBoxLegendLocation, 0, 542, Short.MAX_VALUE)
                    .addGroup(jPanelGnuPLayout.createSequentialGroup()
                        .addComponent(jTextFieldGNUPath)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonGnuoPath))
                    .addGroup(jPanelGnuPLayout.createSequentialGroup()
                        .addGroup(jPanelGnuPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jCheckBoxDeleteScript)
                            .addComponent(jCheckBoxSmooth))
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addComponent(jComboBoxOutPTypeGnuP, javax.swing.GroupLayout.Alignment.TRAILING, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanelGnuPLayout.setVerticalGroup(
            jPanelGnuPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelGnuPLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelGnuPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldGNUPath, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonGnuoPath)
                    .addComponent(jLabel1))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelGnuPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBoxOutPTypeGnuP, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel5))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelGnuPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jComboBoxLineStyle, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel6))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelGnuPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBoxXColumnGnuP, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel7))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelGnuPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldxTitleGnuP, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel8))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelGnuPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBoxYColumnGnuP, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel10))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelGnuPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldyTitleGnuP, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel11))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelGnuPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jSpinnerLineWidth, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel13))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelGnuPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jSpinnerPlotInterval, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel14))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelGnuPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jCheckBoxSmooth)
                    .addComponent(jLabel15))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelGnuPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jCheckBoxDeleteScript)
                    .addComponent(jLabel16))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelGnuPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBoxLegendLocation, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel24))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelGnuPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBoxLegendType, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel25))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelGnuPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldAdcComand, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel26))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelGnuPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldAPOptions, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel27))
                .addGap(186, 186, 186))
        );

        jScrollPaneGnuP.setViewportView(jPanelGnuP);

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addGap(128, 128, 128)
                .addComponent(jButtonAceptGnuP)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButtonResetGnuP)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
            .addComponent(jScrollPaneGnuP, javax.swing.GroupLayout.DEFAULT_SIZE, 700, Short.MAX_VALUE)
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPaneGnuP, javax.swing.GroupLayout.PREFERRED_SIZE, 247, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonAceptGnuP)
                    .addComponent(jButtonResetGnuP)))
        );

        jTabbedPane1.addTab("GnuPlot", jPanel3);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jTabbedPane1, javax.swing.GroupLayout.Alignment.TRAILING))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jTabbedPane1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(7, 7, 7))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonInPathActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonInPathActionPerformed
        path = getDirectory("open", JFileChooser.DIRECTORIES_ONLY);
        if (!path.equals("")) {
            reset();
            resetP();
            this.jTextFieldResultPath.setText(path);
             rf = new ReadFile(path);
            String str = rf.processFiles();
            if (str.equals("")) {

                int algSize = rf.getAlgShortNames().size();
                int streamSize = rf.getStream().size();
                this.measures = rf.getMeasures();
                for (int i = 0; i < algSize; i++) {
                    this.algoritmModel.addRow(new Object[]{rf.getAlgNames().get(i), rf.getAlgShortNames().get(i)});
                }
                for (int i = 0; i < streamSize; i++) {
                    this.streamModel.addRow(new Object[]{rf.getStream().get(i), rf.getStream().get(i)});
                }

                String measuresNames[] = measures.getFirst().split(",");
                for (String measuresName : measuresNames) {
                    jComboBoxXColumn.addItem(measuresName);
                    jComboBoxYColumn.addItem(measuresName);
                    jComboBoxXColumnGnuP.addItem(measuresName);
                    jComboBoxYColumnGnuP.addItem(measuresName);
                    if (measuresName.equals("learning evaluation instances") == true) {
                        jComboBoxXColumn.setSelectedItem(measuresName);
                        jComboBoxXColumnGnuP.setSelectedItem(measuresName);
                    }
                    if (measuresName.equals("classifications correct (percent)") == true
                            || measuresName.equals("[avg] classifications correct (percent)") == true) {
                        jComboBoxYColumn.setSelectedItem(measuresName);
                        jComboBoxYColumnGnuP.setSelectedItem(measuresName);
                    }

                }
            } else {

                JOptionPane.showMessageDialog(this, str,
                        "Error", JOptionPane.ERROR_MESSAGE);
            }
        }
    }//GEN-LAST:event_jButtonInPathActionPerformed

    private void jButtonDeletAlgorithmActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDeletAlgorithmActionPerformed
         if (this.jTableAlgoritms.getSelectedRow() != -1) {
           
            this.algoritmModel.removeRow(this.jTableAlgoritms.getSelectedRow());
             String algorithms[] = new String[algoritmModel.getRowCount()];
            for (int i = 0; i < algoritmModel.getRowCount(); i++) {
                algorithms[i] = algoritmModel.getValueAt(i, 0).toString();
            }
           if (streamModel.getValueAt(0, 0).toString() != null) {
               String s = streamModel.getValueAt(0, 0).toString();
               rf.updateMeasures(algorithms, s);
            this.measures = rf.getMeasures();
            String measuresNames[] = measures.getFirst().split(",");
            jComboBoxXColumn.removeAllItems();
            jComboBoxYColumn.removeAllItems();
            jComboBoxXColumnGnuP.removeAllItems();
            jComboBoxYColumnGnuP.removeAllItems();
            for (String measuresName : measuresNames) {
                jComboBoxXColumn.addItem(measuresName);
                jComboBoxYColumn.addItem(measuresName);
                jComboBoxXColumnGnuP.addItem(measuresName);
                jComboBoxYColumnGnuP.addItem(measuresName);
                if (measuresName.equals("learning evaluation instances") == true) {
                    jComboBoxXColumn.setSelectedItem(measuresName);
                    jComboBoxXColumnGnuP.setSelectedItem(measuresName);
                }
                if (measuresName.equals("classifications correct (percent)") == true || measuresName.equals("[avg] classifications correct (percent)")) {
                    jComboBoxYColumn.setSelectedItem(measuresName);
                    jComboBoxYColumnGnuP.setSelectedItem(measuresName);
                }

            }
           }
        }
    }//GEN-LAST:event_jButtonDeletAlgorithmActionPerformed

    private void jButtonDeleteStreamActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDeleteStreamActionPerformed
        this.streamModel.removeRow(this.jTableStreams.getSelectedRow());
    }//GEN-LAST:event_jButtonDeleteStreamActionPerformed

    private void jButtonAceptActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAceptActionPerformed

        int algCount = this.jTableAlgoritms.getRowCount();
        int streamCount = this.jTableStreams.getRowCount();
        chart = new ImageChart[streamCount];

        for (int i = 0; i < streamCount; i++) {
            String streamName = this.jTableStreams.getModel().getValueAt(i, 0).toString();
            String streamID = this.jTableStreams.getModel().getValueAt(i, 1).toString();
            XYSeriesCollection dataset = new XYSeriesCollection();
            for (int j = 0; j < algCount; j++) {
                try {
                    String algName = this.jTableAlgoritms.getModel().getValueAt(j, 0).toString();
                    String algID = this.jTableAlgoritms.getModel().getValueAt(j, 1).toString();
                    String algPath = FilenameUtils.separatorsToSystem(
                            this.path + "\\" + streamName + "\\" + algName);
                    File inputFile = new File(algPath);
                    if (!inputFile.exists()) {
                        JOptionPane.showMessageDialog(this, "File not found: "
                                + inputFile.getAbsolutePath(),
                                "Error", JOptionPane.ERROR_MESSAGE);
                        return;
                    }
                    /*Preparing the graph*/
                    ArrayList<String[]> data = readCSV(algPath);
                    XYSeries series = new XYSeries(algID);
                    int x = ReadFile.getMeasureIndex(algPath,this.jComboBoxXColumn.getSelectedItem().toString());
                    int y = ReadFile.getMeasureIndex(algPath,this.jComboBoxYColumn.getSelectedItem().toString());
                    
                    for (String[] s : data) {
                        series.add(Double.parseDouble(s[x]), Double.parseDouble(s[y]));
                    }

                    dataset.addSeries(series);

                } catch (FileNotFoundException ex) {
                    Logger.getLogger(PlotTab.class.getName()).log(Level.SEVERE, null, ex);
                } catch (IOException ex) {
                    Logger.getLogger(PlotTab.class.getName()).log(Level.SEVERE, null, ex);
                }
            }//end for 
            /*Create chart*/
            JFreeChart imgChart = ChartFactory.createXYLineChart(
                    this.jTextFieldTitle.getText(), // Title
                    this.jTextFieldxTitle.getText(), // x-axis Label
                    this.jTextFieldyTitle.getText(), // y-axis Label
                    dataset, // Dataset
                    PlotOrientation.VERTICAL, // Plot Orientation
                    true, // Show Legend
                    true, // Use tooltips
                    false // Configure chart to generate URLs?
            );
            final XYPlot plot = imgChart.getXYPlot();
            switch (this.jComboBoxGrid.getSelectedItem().toString()) {
                case "White":
                    plot.setBackgroundPaint(Color.white);
                    break;
                case "Default":
                    plot.setBackgroundPaint(Color.lightGray);
            }
            if (this.jCheckBoxShape.isSelected()) {
                final XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
                renderer.setSeriesLinesVisible(0, true);
                renderer.setSeriesShapesVisible(1, false);
                for (int k = 0; k < algCount; k++) {
                    renderer.setSeriesPaint(k, Color.black);
                }
                plot.setRenderer(renderer);
            }

            this.chart[i] = new ImageChart(streamID, imgChart,
                    (int) this.jSpinnerWidth.getValue(), (int) this.jSpinnerHeight.getValue());

        }
        this.imgPanel = new ImageTreePanel(chart);
        new ImageViewer(imgPanel, path);

    }//GEN-LAST:event_jButtonAceptActionPerformed

    private void jButtonResetActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonResetActionPerformed
        reset();
    }//GEN-LAST:event_jButtonResetActionPerformed

    private void jButtonAceptGnuPActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAceptGnuPActionPerformed

        if (!this.jTextFieldResultPath.getText().equals("")) {
            String outPath = getDirectory("open", JFileChooser.DIRECTORIES_ONLY);
            if(!outPath.equals("")){
                
            File resultFile = new File(this.jTextFieldResultPath.getText());
            String resultDirectory = resultFile.getAbsolutePath();
            String gnuPlotPath = this.jTextFieldGNUPath.getText();
            String gnuplotScriptPath = null;
            File gnuplotDir = new File(gnuPlotPath);
            if (!gnuplotDir.exists()) {
                JOptionPane.showMessageDialog(this, "Gnuplot directory not found: " + gnuPlotPath, "Error", JOptionPane.ERROR_MESSAGE);
                return;
            }
            String algShortName[] = new String[this.jTableAlgoritms.getRowCount()];
            String algName[] = new String[this.jTableAlgoritms.getRowCount()];
            for (int i = 0; i < this.jTableStreams.getRowCount(); i++) {
                String streamName = this.jTableStreams.getModel().getValueAt(i, 0).toString();
                String streamShortName = this.jTableStreams.getModel().getValueAt(i, 1).toString();
                for (int j = 0; j < this.jTableAlgoritms.getRowCount(); j++) {
                    algName[j] = this.jTableAlgoritms.getModel().getValueAt(j, 0).toString();
                    algShortName[j] = this.jTableAlgoritms.getModel().getValueAt(j, 1).toString();
                    File inputFile = new File(FilenameUtils.separatorsToSystem(
                            this.path + "\\" + streamName + "\\" + algName[j]));

                    if (!inputFile.exists()) {
                        JOptionPane.showMessageDialog(this, "File not found: "
                                + inputFile.getAbsolutePath(),
                                "Error", JOptionPane.ERROR_MESSAGE);
                        return;
                    }

                }

                gnuplotScriptPath = resultDirectory + File.separator
                        + resultFile.getName() + ".plt";
                String script = createScript(streamName, algName, algShortName, outPath);
                File scriptFile = writeScriptToFile(gnuplotScriptPath, script);
                String gnuplotCommand = gnuPlotPath + File.separator + "gnuplot \""
                        + gnuplotScriptPath + "\"";
                String line, gnuplotOutput = "";
                try {
                    Process p = Runtime.getRuntime().exec(gnuplotCommand);

                    BufferedReader err = new BufferedReader(new InputStreamReader(p
                            .getErrorStream()));
                    while ((line = err.readLine()) != null) {
                        gnuplotOutput += line + System.getProperty("line.separator");
                    }
                    err.close();
                } catch (IOException ex) {
                    JOptionPane.showMessageDialog(this, "Error while executing gnuplot script",
                            "Error", JOptionPane.ERROR_MESSAGE);
                    throw new RuntimeException("Error while executing gnuplot script:"
                            + scriptFile, ex);

                }
                if (this.jCheckBoxDeleteScript.isSelected()) {
                    scriptFile.delete();
                }
            }

            //Completed
            JOptionPane.showMessageDialog(this, "Figures created at " + (new File(resultFile.getAbsolutePath())).getParent(),
                    "", JOptionPane.INFORMATION_MESSAGE);
        }
        } else {
            JOptionPane.showMessageDialog(this, "Plot output file option not set!",
                    "Error", JOptionPane.ERROR_MESSAGE);
        }

    }//GEN-LAST:event_jButtonAceptGnuPActionPerformed

    private void jButtonResetGnuPActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonResetGnuPActionPerformed
        resetP();
    }//GEN-LAST:event_jButtonResetGnuPActionPerformed

    private void jButtonGnuoPathActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonGnuoPathActionPerformed
        this.jTextFieldGNUPath.setText(getDirectory("open", JFileChooser.DIRECTORIES_ONLY));
    }//GEN-LAST:event_jButtonGnuoPathActionPerformed

    private void jComboBoxLegendLocationActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxLegendLocationActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jComboBoxLegendLocationActionPerformed

    private void jTextFieldGNUPathActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextFieldGNUPathActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jTextFieldGNUPathActionPerformed

    /**
     * Allows to read the results file and update the corresponding fields.
     *
     * @param path
     */
    public void readData(String path) {
        reset();
        resetP();
        this.jTextFieldResultPath.setText(path);
        this.path = path;
        rf = new ReadFile(path);
        String str = rf.processFiles();
        if (str.equals("")) {

            int algSize = rf.getAlgShortNames().size();
            int streamSize = rf.getStream().size();
            this.measures = rf.getMeasures();
            for (int i = 0; i < algSize; i++) {
                this.algoritmModel.addRow(new Object[]{rf.getAlgNames().get(i), rf.getAlgShortNames().get(i)});
            }
            for (int i = 0; i < streamSize; i++) {
                this.streamModel.addRow(new Object[]{rf.getStream().get(i), rf.getStream().get(i)});
            }
            String measuresNames[] = measures.getFirst().split(",");
            for (String measuresName : measuresNames) {
                jComboBoxXColumn.addItem(measuresName);
                jComboBoxYColumn.addItem(measuresName);
                jComboBoxXColumnGnuP.addItem(measuresName);
                jComboBoxYColumnGnuP.addItem(measuresName);
                if (measuresName.equals("learning evaluation instances") == true) {
                    jComboBoxXColumn.setSelectedItem(measuresName);
                    jComboBoxXColumnGnuP.setSelectedItem(measuresName);
                }
                if (measuresName.equals("classifications correct (percent)") == true || measuresName.equals("[avg] classifications correct (percent)")) {
                    jComboBoxYColumn.setSelectedItem(measuresName);
                    jComboBoxYColumnGnuP.setSelectedItem(measuresName);
                }

            }
        } else {

            JOptionPane.showMessageDialog(this, str,
                    "Error", JOptionPane.ERROR_MESSAGE);
        }

    }

    private String getDirectory(String type, int filter) {
        BaseDirectoryChooser gnuPlotDir = new BaseDirectoryChooser();
        gnuPlotDir.setFileSelectionMode(filter);
        int selection = -1;
        if (type.equals("open")) 
            selection = gnuPlotDir.showOpenDialog(this);
        if (selection == JFileChooser.APPROVE_OPTION) {

            try {
                return gnuPlotDir.getSelectedFile().getAbsolutePath();

            } catch (Exception exp) {
            }

        }
        return "";
    }

    /**
     * Clean the tables
     */
    public void cleanTables() {
        try {
            DefaultTableModel algModel = (DefaultTableModel) jTableAlgoritms.getModel();
            DefaultTableModel strModel = (DefaultTableModel) jTableStreams.getModel();
            int rows = jTableAlgoritms.getRowCount();
            int srow = jTableStreams.getRowCount();
            for (int i = 0; i < rows; i++) {
                algModel.removeRow(0);
            }
            for (int i = 0; i < srow; i++) {
                strModel.removeRow(0);
            }

        } catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error cleaning the table.");
        }
    }

    private void reset() {
        cleanTables();
        this.jTextFieldResultPath.setText("");

        this.jTextFieldxTitle.setText("Instances processed");

        this.jTextFieldyTitle.setText("% of correctly classified");

        //Combobox
        this.jComboBoxXColumn.removeAllItems();
        this.jComboBoxYColumn.removeAllItems();
        //spinner
        this.jSpinnerWidth.setValue(500);
        this.jSpinnerHeight.setValue(300);

        this.jCheckBoxShape.setSelected(false);
        this.jComboBoxGrid.setSelectedItem("White");

    }

    private void resetP() {
        cleanTables();
        this.jTextFieldGNUPath.setText("");
        this.jTextFieldResultPath.setText("");
        this.jTextFieldAPOptions.setText("");
        this.jTextFieldAdcComand.setText("");
        this.jTextFieldxTitleGnuP.setText("Instances processed");
        this.jTextFieldyTitleGnuP.setText("% of correctly classified");
        //Combobox
        this.jComboBoxLegendLocation.setSelectedIndex(0);

        this.jComboBoxLegendType.setSelectedIndex(0);
        this.jComboBoxLineStyle.setSelectedIndex(0);
        this.jComboBoxOutPTypeGnuP.setSelectedIndex(0);
        this.jComboBoxXColumnGnuP.removeAllItems();
        this.jComboBoxYColumnGnuP.removeAllItems();
        //spinner
        this.jSpinnerLineWidth.setValue(2);
        this.jSpinnerPlotInterval.setValue(0);

    }

    private String createScript(String streamName, String algName[], String algShortName[], String outPath) {
        String newLine = System.getProperty("line.separator");
        int sourceFileIdx = 0;

        String imgName;
        boolean eps = false;
        switch (this.jComboBoxOutPTypeGnuP.getSelectedItem().toString()) {
            case "GIF":
                imgName = outPath + File.separator + streamName + "GP" + ".gif";
                break;
            case "JPEG":
                imgName = outPath + File.separator + streamName + "GP" + ".JPEG";
                break;
            case "LATEX":
                imgName = outPath + File.separator + streamName + "GP" + ".tex";
                break;
            case "PDFCAIRO":
                imgName = outPath + File.separator + streamName + "GP" + ".pdf";
                break;
            case "PNG":
                imgName = outPath + File.separator + streamName + "GP" + ".PNG";
                break;
            case "PSTEX":
                imgName = outPath + File.separator + streamName + "GP" + ".tex";
                break;
            case "PSTRICKS":
                imgName = outPath + File.separator + streamName + "GP" + ".tex";
                break;
            case "PSLATEX":
                imgName = outPath + File.separator + streamName + "GP" + ".tex";
                break;
            case "SVG":
                imgName = outPath + File.separator + streamName + "GP" + ".SVG";
                break;
            default:
                imgName = outPath + File.separator + streamName + "GP" + ".eps";
                eps = true;

        }
        // terminal options;
        String script;
        if (eps) {
            script = "set term "
                    + terminalOptions(Terminal.valueOf(this.jComboBoxOutPTypeGnuP.getSelectedItem().toString())) + " eps " + newLine;
        } else {
            script = "set term "
                    + terminalOptions(Terminal.valueOf(this.jComboBoxOutPTypeGnuP.getSelectedItem().toString())) + newLine;
        }
        script += "set loadpath '" + FilenameUtils.separatorsToSystem(path + File.separator + streamName) + "'" + newLine;
        script += "set output '" + imgName + "'" + newLine;
        script += "set datafile separator ','" + newLine;
        //script += "set grid" + newLine;
        script += "set style line 1 pt 8" + newLine;
        script += "set style line 2 lt rgb '#00C000'" + newLine;
        script += "set style line 5 lt rgb '#FFD800'" + newLine;
        script += "set style line 6 lt rgb '#4E0000'" + newLine;
//        script += "set format x '%.0s %c" + getAxisUnit(this.jTextFieldxUnit.getText())
//                + "'" + newLine;
//        script += "set format y '%.1f" + getAxisUnit(this.jTextFieldyUnit.getText())
//                + "'" + newLine;
        script += "set ylabel '" + this.jTextFieldyTitleGnuP.getText() + "'" + newLine;
        script += "set xlabel '" + this.jTextFieldxTitleGnuP.getText() + "'" + newLine;
        if (!this.jComboBoxLegendType.getSelectedItem().toString().equals(LegendType.NONE)) {
            script += "set key "
                    + this.jComboBoxLegendType.getSelectedItem().toString().toLowerCase().replace(
                            '_', ' ')
                    + " "
                    + this.jComboBoxLegendLocation.getSelectedItem().toString().toLowerCase()
                    .replace('_', ' ') + newLine;
        }

        // additional commands
        script += this.jTextFieldAdcComand.getText();

        // plot command
        script += "plot " + this.jTextFieldAPOptions.getText() + " ";

        // plot for each input file
        for (int i = 0; i < algName.length; i++) {

            if (sourceFileIdx > 0) {
                script += ", ";
            }
            sourceFileIdx++;
            script += "'" + algName[i] + "' using "
                    + (this.jComboBoxXColumnGnuP.getSelectedIndex() + 1) + ":" + (this.jComboBoxYColumnGnuP.getSelectedIndex() + 1);

            if (this.jCheckBoxSmooth.isSelected()) {
                script += ":(1.0) smooth bezier";
            }

            script += " with " + this.jComboBoxLineStyle.getSelectedItem().toString().toLowerCase()
                    + " ls " + sourceFileIdx + " lw "
                    + this.jSpinnerLineWidth.getValue().toString();
            if (this.jComboBoxLineStyle.getSelectedItem().toString().equals(
                    PlotStyle.LINESPOINTS.toString())
                    && Integer.parseInt(this.jSpinnerPlotInterval.getValue().toString()) > 0) {
                script += " pointinterval " + this.jSpinnerPlotInterval.getValue().toString();
            }
            script += " title '" + algShortName[i] + "'";
        }
        script += newLine;
        return script;
    }

    private File writeScriptToFile(String gnuplotScriptPath, String script) {
        File scriptFile = new File(gnuplotScriptPath);
        BufferedWriter writer;
        try {
            writer = new BufferedWriter(new FileWriter(scriptFile));
            writer.write(script);
            writer.close();
        } catch (IOException ex) {
            throw new RuntimeException(
                    "Unable to create or write to script file: " + scriptFile,
                    ex);
        }
        return scriptFile;
    }

    private String terminalOptions(Terminal term) {
        String options;

        switch (term) {
            case POSTSCRIPT:
                options = "postscript enhanced";
                break;
            case POSTSCRIPT_COLOR:
                options = "postscript color enhanced";
                break;
            default:
                options = term.toString().toLowerCase();
                break;
        }
        return options;
    }

    /**
     * Lgend type
     */
    public enum LegendType {

        NONE, BOX_VERTICAL, BOX_HORIZONTAL, NOBOX_VERTICAL, NOBOX_HORIZONTAL;
    }

    /**
     * Plot style
     */
    public enum PlotStyle {

        LINES, POINTS, LINESPOINTS, IMPULSES, STEPS, FSTEPS, HISTEPS, DOTS;

    }

    /**
     * Terminal
     */
    public enum Terminal {

        CANVAS, EPSLATEX, GIF, JPEG, LATEX, PDFCAIRO, PNG, POSTSCRIPT, POSTSCRIPT_COLOR, PSLATEX, PSTEX, PSTRICKS, SVG;

    }

    private static void createAndShowGUI() {

        // Create and set up the window.
        JFrame frame = new JFrame("Test");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        // Create and set up the content pane.
        JPanel panel = new PlotTab();
        panel.setOpaque(true); // content panes must be opaque
        frame.setContentPane(panel);

        // Display the window.
        frame.pack();
        //frame.setSize(400, 400);
        frame.setVisible(true);
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        try {
            LookAndFeel.install();
            javax.swing.SwingUtilities.invokeLater(new Runnable() {

                @Override
                public void run() {
                    createAndShowGUI();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonAcept;
    private javax.swing.JButton jButtonAceptGnuP;
    private javax.swing.JButton jButtonDeletAlgorithm;
    private javax.swing.JButton jButtonDeleteStream;
    private javax.swing.JButton jButtonGnuoPath;
    private javax.swing.JButton jButtonInPath;
    private javax.swing.JButton jButtonReset;
    private javax.swing.JButton jButtonResetGnuP;
    private javax.swing.JCheckBox jCheckBoxDeleteScript;
    private javax.swing.JCheckBox jCheckBoxShape;
    private javax.swing.JCheckBox jCheckBoxSmooth;
    private javax.swing.JComboBox jComboBoxGrid;
    private javax.swing.JComboBox jComboBoxLegendLocation;
    private javax.swing.JComboBox jComboBoxLegendType;
    private javax.swing.JComboBox jComboBoxLineStyle;
    private javax.swing.JComboBox jComboBoxOutPTypeGnuP;
    private javax.swing.JComboBox jComboBoxXColumn;
    private javax.swing.JComboBox jComboBoxXColumnGnuP;
    private javax.swing.JComboBox jComboBoxYColumn;
    private javax.swing.JComboBox jComboBoxYColumnGnuP;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JLabel jLabel19;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel20;
    private javax.swing.JLabel jLabel21;
    private javax.swing.JLabel jLabel22;
    private javax.swing.JLabel jLabel23;
    private javax.swing.JLabel jLabel24;
    private javax.swing.JLabel jLabel25;
    private javax.swing.JLabel jLabel26;
    private javax.swing.JLabel jLabel27;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanelGnuP;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JScrollPane jScrollPaneAlgorithms;
    private javax.swing.JScrollPane jScrollPaneGnuP;
    private javax.swing.JSpinner jSpinnerHeight;
    private javax.swing.JSpinner jSpinnerLineWidth;
    private javax.swing.JSpinner jSpinnerPlotInterval;
    private javax.swing.JSpinner jSpinnerWidth;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JTable jTableAlgoritms;
    private javax.swing.JTable jTableStreams;
    private javax.swing.JTextField jTextFieldAPOptions;
    private javax.swing.JTextField jTextFieldAdcComand;
    private javax.swing.JTextField jTextFieldGNUPath;
    private javax.swing.JTextField jTextFieldResultPath;
    private javax.swing.JTextField jTextFieldTitle;
    private javax.swing.JTextField jTextFieldxTitle;
    private javax.swing.JTextField jTextFieldxTitleGnuP;
    private javax.swing.JTextField jTextFieldyTitle;
    private javax.swing.JTextField jTextFieldyTitleGnuP;
    // End of variables declaration//GEN-END:variables
}
