/*
 *    OutlierTabPanel.java
 *    Copyright (C) 2010 RWTH Aachen University, Germany
 *    @author Jansen (moa@cs.rwth-aachen.de)
 *
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 *    
 *    
 */

package moa.gui.outliertab;

import moa.gui.AbstractTabPanel;

public class OutlierTabPanel extends AbstractTabPanel{

    /** Creates new form ClusterTab */
    public OutlierTabPanel() {
        initComponents();
        outlierVisualTab.setOutlierSetupTab(outlierSetupTab);
        outlierSetupTab.addButtonActionListener(outlierVisualTab);
        outlierSetupTab.setOutlierTab(this);
    }

    void toggle() {
        outlierVisualTab.toggleVisualizer(false);
    }

    void stop() {
        outlierVisualTab.stopVisualizer();
    }

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jTabbedPane1 = new javax.swing.JTabbedPane();
        outlierSetupTab = new moa.gui.outliertab.OutlierSetupTab();
        outlierVisualTab = new moa.gui.outliertab.OutlierVisualTab();

        setLayout(new java.awt.BorderLayout());

        jTabbedPane1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jTabbedPane1MouseClicked(evt);
            }
        });
        jTabbedPane1.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jTabbedPane1FocusGained(evt);
            }
        });
        jTabbedPane1.addTab("Setup", outlierSetupTab);
        jTabbedPane1.addTab("Visualization", outlierVisualTab);

        add(jTabbedPane1, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents

    private void jTabbedPane1FocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jTabbedPane1FocusGained
        
    }//GEN-LAST:event_jTabbedPane1FocusGained

    private void jTabbedPane1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTabbedPane1MouseClicked
        
    }//GEN-LAST:event_jTabbedPane1MouseClicked



    // Variables declaration - do not modify//GEN-BEGIN:variables
    private moa.gui.outliertab.OutlierSetupTab outlierSetupTab;
    private moa.gui.outliertab.OutlierVisualTab outlierVisualTab;
    private javax.swing.JTabbedPane jTabbedPane1;
    // End of variables declaration//GEN-END:variables

    //returns the string to display as title of the tab
    public String getTabTitle() {
            return "Outliers";
    }

    //a short description (can be used as tool tip) of the tab, or contributor, etc.
    public String getDescription(){
            return "MOA Outliers";
    }


}
