/*
 * Decompiled with CFR 0.152.
 */
package com.github.javacliparser.gui;

import com.github.javacliparser.Option;
import com.github.javacliparser.gui.OptionEditComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import moa.gui.ClassOptionSelectionPanel;
import moa.options.ClassOption;

public class ClassOptionEditComponent
extends JPanel
implements OptionEditComponent {
    private static final long serialVersionUID = 1L;
    protected ClassOption editedOption;
    protected JTextField textField = new JTextField();
    protected JButton editButton = new JButton("Edit");
    protected boolean midUpdate = false;
    protected HashSet<ChangeListener> changeListeners = new HashSet();

    public ClassOptionEditComponent(Option opt) {
        ClassOption option;
        this.editedOption = option = (ClassOption)opt;
        this.textField.setEditable(false);
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!ClassOptionEditComponent.this.midUpdate) {
                    ClassOptionEditComponent.this.notifyChangeListeners();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ClassOptionEditComponent.this.notifyChangeListeners();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ClassOptionEditComponent.this.notifyChangeListeners();
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.textField, "Center");
        this.add((Component)this.editButton, "East");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ClassOptionEditComponent.this.editObject();
            }
        });
        this.setEditState(this.editedOption.getValueAsCLIString());
    }

    @Override
    public void applyState() {
        this.editedOption.setValueViaCLIString(this.textField.getText());
    }

    @Override
    public Option getEditedOption() {
        return this.editedOption;
    }

    @Override
    public void setEditState(String cliString) {
        if (cliString.length() > 0) {
            this.midUpdate = true;
        }
        this.textField.setText(cliString);
        this.midUpdate = false;
    }

    public void editObject() {
        this.setEditState(ClassOptionSelectionPanel.showSelectClassDialog(this, "Editing option: " + this.editedOption.getName(), this.editedOption.getRequiredType(), this.textField.getText(), this.editedOption.getNullString()));
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    protected void notifyChangeListeners() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.changeListeners) {
            l.stateChanged(e);
        }
    }
}

