/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.meta;

import com.yahoo.labs.samoa.instances.InstancesHeader;
import com.yahoo.labs.samoa.instances.MultiLabelInstance;
import com.yahoo.labs.samoa.instances.MultiLabelPrediction;
import com.yahoo.labs.samoa.instances.Prediction;
import moa.classifiers.AbstractMultiLabelLearner;
import moa.classifiers.MultiLabelClassifier;
import moa.classifiers.MultiTargetRegressor;
import moa.core.Measurement;
import moa.options.ClassOption;

public class MLCviaMTR
extends AbstractMultiLabelLearner
implements MultiLabelClassifier {
    protected InstancesHeader header;
    protected MultiTargetRegressor learner;
    public ClassOption regressorOption = new ClassOption("regressor", 'l', "Multi-target regressor to use for MLC .", MultiTargetRegressor.class, "multilabel.trees.ISOUPTree");

    private void makeHeader() {
        if (this.header == null) {
            this.header = this.getModelContext();
        }
    }

    @Override
    public boolean isRandomizable() {
        return true;
    }

    @Override
    public void trainOnInstanceImpl(MultiLabelInstance instance) {
        this.learner.trainOnInstance(instance);
    }

    @Override
    public Prediction getPredictionForInstance(MultiLabelInstance inst) {
        int n = this.header.numOutputAttributes();
        Prediction p = this.learner.getPredictionForInstance(inst);
        MultiLabelPrediction y = new MultiLabelPrediction(n);
        for (int i = 0; i < n; ++i) {
            y.setVotes(i, new double[]{1.0 - p.getVote(i, 1), p.getVote(i, 1)});
        }
        return y;
    }

    @Override
    public void resetLearningImpl() {
        this.learner = (MultiTargetRegressor)((MultiTargetRegressor)this.getPreparedClassOption(this.regressorOption)).copy();
        this.learner.resetLearning();
    }

    @Override
    public void setModelContext(InstancesHeader ih) {
        super.setModelContext(ih);
        this.makeHeader();
        this.learner.setModelContext(ih);
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return this.learner.getModelMeasurements();
    }

    @Override
    public void setRandomSeed(int i) {
        super.setRandomSeed(i);
        this.learner.setRandomSeed(i);
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }
}

