/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.meta.imbalanced;

import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.SamoaToWekaInstanceConverter;
import com.yahoo.labs.samoa.instances.WekaToSamoaInstanceConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.Classifier;
import moa.classifiers.MultiClassClassifier;
import moa.classifiers.core.driftdetection.ADWIN;
import moa.core.Measurement;
import moa.core.TimingUtils;
import moa.options.ClassOption;
import weka.core.Attribute;
import weka.core.Instances;

public class RebalanceStream
extends AbstractClassifier
implements MultiClassClassifier {
    private static final long serialVersionUID = 1L;
    public ClassOption baseLearnerOption = new ClassOption("baseLearner", 'l', "Classifier to train.", Classifier.class, "meta.TemporallyAugmentedClassifier");
    public IntOption minInstanceLimitBatchOption = new IntOption("minInstanceLimitBatch", 'c', "Minimum number of instances in the batch in order to rebalance it  (-1 = no limit).", -1, -1, Integer.MAX_VALUE);
    public IntOption maxInstanceLimitBatchOption = new IntOption("maxInstanceLimitBatch", 'g', "Maximum number of instances in the batch in order to rebalance it  (-1 = no limit).", -1, -1, Integer.MAX_VALUE);
    public IntOption minInstanceLimitResetBatchOption = new IntOption("minInstanceLimitResetBatch", 'h', "Minimum number of instances in the Resetbatch in order to rebalance it  (-1 = no limit).", -1, -1, Integer.MAX_VALUE);
    public IntOption maxInstanceLimitResetBatchOption = new IntOption("maxInstanceLimitResetBatch", 'm', "Maximum number of instances in the Resetbatch in order to rebalance it  (-1 = no limit).", -1, -1, Integer.MAX_VALUE);
    protected Classifier learner;
    protected Classifier learnerResetBal;
    protected Classifier learnerReset;
    protected Classifier learnerBal;
    protected ADWIN adwin = new ADWIN();
    protected int nAttributes;
    protected int minInstanceLimitBatch;
    protected int maxInstanceLimitBatch;
    protected int minInstanceLimitResetBatch;
    protected int maxInstanceLimitResetBatch;
    protected int[][] confusionMatrixLearner = new int[2][2];
    protected double accLearner = 0.0;
    protected double kStatLearner = 0.0;
    protected int[][] confusionMatrixResetBal = new int[2][2];
    protected double accResetBal = 0.0;
    protected double kStatResetBal = 0.0;
    protected int[][] confusionMatrixReset = new int[2][2];
    protected double accReset = 0.0;
    protected double kStatReset = 0.0;
    protected int[][] confusionMatrixBal = new int[2][2];
    protected double accBal = 0.0;
    protected double kStatBal = 0.0;
    protected ArrayList<Instance> batch = new ArrayList();
    protected ArrayList<Instance> batchMinority = new ArrayList();
    protected ArrayList<Instance> batchMajority = new ArrayList();
    protected ArrayList<Instance> resetBatch = new ArrayList();
    protected ArrayList<Instance> resetBatchMinority = new ArrayList();
    protected ArrayList<Instance> resetBatchMajority = new ArrayList();
    boolean warning = false;
    SamoaToWekaInstanceConverter samoaToWeka = new SamoaToWekaInstanceConverter();
    WekaToSamoaInstanceConverter wekaToSamoa = new WekaToSamoaInstanceConverter();
    protected double modelInUse = 0.0;
    protected int nMinorityTotal;
    protected int nMajorityTotal;
    protected int nGeneratedMinorityTotal;
    protected int nGeneratedMajorityTotal;
    protected HashMap<Instance, Integer> instanceGenerated = new HashMap();
    protected ArrayList<Integer> alreadyUsed = new ArrayList();
    protected int effectiveNearestNeighbors;
    protected Instances minorityInstances;
    protected Map vdmMap = new HashMap();
    protected int[] indexValues;

    @Override
    public String getPurposeString() {
        return "RebalanceStream algorithm for rebalancing a stream and training a model with it";
    }

    @Override
    public void resetLearningImpl() {
        this.learner = (Classifier)this.getPreparedClassOption(this.baseLearnerOption);
        this.learnerResetBal = (Classifier)this.getPreparedClassOption(this.baseLearnerOption);
        this.learnerReset = (Classifier)this.getPreparedClassOption(this.baseLearnerOption);
        this.learnerBal = (Classifier)this.getPreparedClassOption(this.baseLearnerOption);
        this.adwin.resetChange();
        this.nAttributes = -1;
        this.learner.resetLearning();
        this.clean(this.confusionMatrixLearner, this.accLearner, this.kStatLearner);
        this.modelInUse = 0.0;
        this.nMinorityTotal = 0;
        this.nMajorityTotal = 0;
        this.nGeneratedMinorityTotal = 0;
        this.nGeneratedMajorityTotal = 0;
        this.minInstanceLimitBatch = this.minInstanceLimitBatchOption.getValue();
        this.maxInstanceLimitBatch = this.maxInstanceLimitBatchOption.getValue();
        this.minInstanceLimitResetBatch = this.minInstanceLimitResetBatchOption.getValue();
        this.maxInstanceLimitResetBatch = this.maxInstanceLimitResetBatchOption.getValue();
        if (this.minInstanceLimitBatch != -1 && this.maxInstanceLimitBatch != -1 && this.minInstanceLimitBatch > this.maxInstanceLimitBatch) {
            System.out.println("The minimum number of instances in the batch cannot be greater than the maximum number allowed");
            return;
        }
        if (this.minInstanceLimitResetBatch != -1 && this.maxInstanceLimitResetBatch != -1 && this.minInstanceLimitResetBatch > this.maxInstanceLimitResetBatch) {
            System.out.println("The minimum number of instances in the resetBatch cannot be greater than the maximum number allowed");
            return;
        }
        this.effectiveNearestNeighbors = -1;
        this.alreadyUsed.clear();
        this.minorityInstances = null;
        this.vdmMap.clear();
        this.instanceGenerated.clear();
        this.indexValues = null;
        this.classifierRandom = new Random(this.randomSeed);
        this.resetAfterDrift();
    }

    @Override
    public void trainOnInstanceImpl(Instance instance) {
        if (this.nAttributes == -1) {
            this.nAttributes = instance.numAttributes();
            this.indexValues = new int[this.nAttributes];
            for (int i = 0; i < this.nAttributes; ++i) {
                this.indexValues[i] = i;
            }
        }
        this.learner.trainOnInstance(instance);
        this.fillBatches(instance);
        this.adwin.setInput(instance.classValue());
        try {
            this.checkADWINWidth(instance);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private void fillBatches(Instance instance) {
        this.batch.add(instance);
        if (instance.classValue() == 1.0) {
            this.batchMajority.add(instance);
            ++this.nMajorityTotal;
        } else {
            this.batchMinority.add(instance);
            ++this.nMinorityTotal;
        }
        if (this.warning) {
            this.resetBatch.add(instance);
            if (instance.classValue() == 1.0) {
                this.resetBatchMajority.add(instance);
            } else {
                this.resetBatchMinority.add(instance);
            }
        }
    }

    private void checkADWINWidth(Instance instance) throws Exception {
        if (this.adwin.getWarning() && !this.warning) {
            this.resetBatch.add(instance);
            if (instance.classValue() == 1.0) {
                this.resetBatchMajority.add(instance);
            } else {
                this.resetBatchMinority.add(instance);
            }
            this.warning = true;
        }
        if (this.adwin.getChange()) {
            boolean minBatchSizeCheck = this.checkMinConstraints(this.batch.size(), this.minInstanceLimitBatch);
            boolean minResetBatchSizeCheck = this.checkMinConstraints(this.resetBatch.size(), this.minInstanceLimitResetBatch);
            if (minBatchSizeCheck && minResetBatchSizeCheck) {
                this.trainsParallelModels();
            }
            int newWidth = this.adwin.getWidth();
            int windowSize = this.batch.size();
            int diff = windowSize - newWidth;
            for (int i = 0; i < diff; ++i) {
                Instance instanceRemoved = this.batch.remove(0);
                if (instanceRemoved.classValue() == 1.0) {
                    this.batchMajority.remove(instanceRemoved);
                    --this.nMajorityTotal;
                    if (this.instanceGenerated.get(instanceRemoved) == null) continue;
                    this.nGeneratedMajorityTotal -= this.instanceGenerated.get(instanceRemoved).intValue();
                    this.instanceGenerated.remove(instanceRemoved);
                    continue;
                }
                this.batchMinority.remove(instanceRemoved);
                --this.nMinorityTotal;
                if (this.instanceGenerated.get(instanceRemoved) == null) continue;
                this.nGeneratedMinorityTotal -= this.instanceGenerated.get(instanceRemoved).intValue();
                this.instanceGenerated.remove(instanceRemoved);
            }
        } else {
            boolean maxBatchSizeCheck = this.checkMaxConstraints(this.batch.size(), this.maxInstanceLimitBatch);
            boolean maxResetBatchCheck = this.checkMaxConstraints(this.resetBatch.size(), this.maxInstanceLimitResetBatch);
            if (maxBatchSizeCheck || maxResetBatchCheck) {
                this.trainsParallelModels();
            }
        }
    }

    private boolean checkMaxConstraints(int size, int maxSize) {
        return maxSize != -1 && size >= maxSize;
    }

    private boolean checkMinConstraints(int size, int minSize) {
        return minSize == -1 && size > 0 || minSize != -1 && size >= minSize;
    }

    private void trainsParallelModels() throws Exception {
        long evaluateStartTime = TimingUtils.getNanoCPUTimeOfCurrentThread();
        this.accLearner = this.calculateAccuracy(this.confusionMatrixLearner);
        this.kStatLearner = this.calculateKStatistic(this.confusionMatrixLearner, this.accLearner);
        double ratio = this.calculateRatio(this.nMajorityTotal, this.nMinorityTotal, this.nGeneratedMajorityTotal, this.nGeneratedMinorityTotal);
        boolean rebalance = false;
        if (this.nMinorityTotal > 1 && this.nMajorityTotal > 1) {
            this.learnerBal.prepareForUse();
            while (0.5 > ratio) {
                Instance newInstance;
                rebalance = true;
                if (this.nMinorityTotal + this.nGeneratedMinorityTotal < this.nMajorityTotal + this.nGeneratedMajorityTotal) {
                    newInstance = this.generateNewInstance(this.batchMinority, true);
                    ++this.nGeneratedMinorityTotal;
                } else {
                    newInstance = this.generateNewInstance(this.batchMajority, true);
                    ++this.nGeneratedMajorityTotal;
                }
                this.fillConfusionMatrix(newInstance, this.confusionMatrixBal, this.learnerBal);
                this.learnerBal.trainOnInstance(newInstance);
                ratio = this.calculateRatio(this.nMajorityTotal, this.nMinorityTotal, this.nGeneratedMajorityTotal, this.nGeneratedMinorityTotal);
            }
        }
        if (rebalance) {
            this.accBal = this.calculateAccuracy(this.confusionMatrixBal);
            this.kStatBal = this.calculateKStatistic(this.confusionMatrixBal, this.accBal);
        } else {
            this.kStatBal = -1.0;
        }
        this.alreadyUsed.clear();
        this.effectiveNearestNeighbors = -1;
        this.minorityInstances.clear();
        this.vdmMap.clear();
        Instances resetBatchBal = this.createRandomInstances();
        resetBatchBal = this.fillNewBatch(this.resetBatch);
        resetBatchBal.setClassIndex(resetBatchBal.numAttributes() - 1);
        this.learnerReset.prepareForUse();
        for (int r = 0; r < resetBatchBal.numInstances(); ++r) {
            Instance trainInstBal = this.wekaToSamoa.samoaInstance(resetBatchBal.instance(r));
            this.fillConfusionMatrix(trainInstBal, this.confusionMatrixReset, this.learnerReset);
            this.learnerReset.trainOnInstance(trainInstBal);
        }
        this.accReset = this.calculateAccuracy(this.confusionMatrixReset);
        this.kStatReset = this.calculateKStatistic(this.confusionMatrixReset, this.accReset);
        int minGenerated = 0;
        int maxGenerated = 0;
        ratio = this.calculateRatio(this.resetBatchMajority.size(), this.resetBatchMinority.size(), maxGenerated, minGenerated);
        rebalance = false;
        if (this.resetBatchMinority.size() > 1 && this.resetBatchMajority.size() > 1) {
            this.learnerResetBal.prepareForUse();
            while (0.5 > ratio) {
                Instance newInstance;
                if (this.resetBatchMinority.size() + minGenerated < this.resetBatchMajority.size() + maxGenerated) {
                    newInstance = this.generateNewInstance(this.resetBatchMinority, false);
                    ++minGenerated;
                } else {
                    newInstance = this.generateNewInstance(this.resetBatchMajority, false);
                    ++maxGenerated;
                }
                this.fillConfusionMatrix(newInstance, this.confusionMatrixResetBal, this.learnerResetBal);
                this.learnerResetBal.trainOnInstance(newInstance);
                ratio = this.calculateRatio(this.resetBatchMajority.size(), this.resetBatchMinority.size(), maxGenerated, minGenerated);
            }
        }
        if (rebalance) {
            this.accResetBal = this.calculateAccuracy(this.confusionMatrixResetBal);
            this.kStatResetBal = this.calculateKStatistic(this.confusionMatrixResetBal, this.accResetBal);
        } else {
            this.kStatResetBal = -1.0;
        }
        this.alreadyUsed.clear();
        this.effectiveNearestNeighbors = -1;
        this.minorityInstances.clear();
        this.vdmMap.clear();
        int maxPos = this.findMaxKStatistic();
        this.swipeModelInUse(maxPos);
        this.resetAfterDrift();
    }

    private Instance generateNewInstance(ArrayList<Instance> minoritySamples, boolean newInstanceBatch) {
        Attribute attr;
        Enumeration attrEnum;
        if (this.effectiveNearestNeighbors == -1) {
            this.setParameters(minoritySamples);
        }
        Instance[] nnArray = new Instance[1];
        try {
            nnArray = new Instance[this.effectiveNearestNeighbors];
        }
        catch (Exception exception) {
            // empty catch block
        }
        int pos = 0;
        try {
            pos = this.classifierRandom.nextInt(this.minorityInstances.numInstances());
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (this.alreadyUsed.contains(pos)) {
            pos = this.classifierRandom.nextInt(this.minorityInstances.numInstances());
        }
        this.alreadyUsed.add(pos);
        if (this.alreadyUsed.size() == minoritySamples.size()) {
            this.alreadyUsed.clear();
        }
        Instance instanceI = this.wekaToSamoa.samoaInstance(this.minorityInstances.instance(pos));
        LinkedList<Object[]> distanceToInstance = new LinkedList<Object[]>();
        for (int j = 0; j < this.minorityInstances.numInstances(); ++j) {
            Instance instanceJ = this.wekaToSamoa.samoaInstance(this.minorityInstances.instance(j));
            if (pos == j) continue;
            double distance = 0.0;
            attrEnum = this.minorityInstances.enumerateAttributes();
            while (attrEnum.hasMoreElements()) {
                attr = (Attribute)attrEnum.nextElement();
                if (attr.equals((Object)this.minorityInstances.classAttribute())) continue;
                double iVal = this.samoaToWeka.wekaInstance(instanceI).value(attr);
                double jVal = this.samoaToWeka.wekaInstance(instanceJ).value(attr);
                if (attr.isNumeric()) {
                    distance += Math.pow(iVal - jVal, 2.0);
                    continue;
                }
                distance += ((double[][])this.vdmMap.get(attr))[(int)iVal][(int)jVal];
            }
            distance = Math.pow(distance, 0.5);
            distanceToInstance.add(new Object[]{distance, instanceJ});
        }
        Collections.sort(distanceToInstance, new Comparator(){

            public int compare(Object o1, Object o2) {
                double distance1 = (Double)((Object[])o1)[0];
                double distance2 = (Double)((Object[])o2)[0];
                return Double.compare(distance1, distance2);
            }
        });
        Iterator entryIterator = distanceToInstance.iterator();
        for (int j = 0; entryIterator.hasNext() && j < this.effectiveNearestNeighbors; ++j) {
            nnArray[j] = (Instance)((Object[])entryIterator.next())[1];
        }
        double[] values = new double[this.minorityInstances.numAttributes()];
        int nn = this.classifierRandom.nextInt(this.effectiveNearestNeighbors);
        attrEnum = this.minorityInstances.enumerateAttributes();
        while (attrEnum.hasMoreElements()) {
            int iVal;
            attr = (Attribute)attrEnum.nextElement();
            if (attr.equals((Object)this.minorityInstances.classAttribute())) continue;
            if (attr.isNumeric()) {
                double dif = this.samoaToWeka.wekaInstance(nnArray[nn]).value(attr) - this.samoaToWeka.wekaInstance(instanceI).value(attr);
                double gap = this.classifierRandom.nextDouble();
                values[attr.index()] = this.samoaToWeka.wekaInstance(instanceI).value(attr) + gap * dif;
                continue;
            }
            if (attr.isDate()) {
                double dif = this.samoaToWeka.wekaInstance(nnArray[nn]).value(attr) - this.samoaToWeka.wekaInstance(instanceI).value(attr);
                double gap = this.classifierRandom.nextDouble();
                values[attr.index()] = (long)(this.samoaToWeka.wekaInstance(instanceI).value(attr) + gap * dif);
                continue;
            }
            int[] valueCounts = new int[attr.numValues()];
            int n = iVal = (int)this.samoaToWeka.wekaInstance(instanceI).value(attr);
            valueCounts[n] = valueCounts[n] + 1;
            for (int nnEx = 0; nnEx < this.effectiveNearestNeighbors; ++nnEx) {
                int val;
                int n2 = val = (int)this.samoaToWeka.wekaInstance(nnArray[nnEx]).value(attr);
                valueCounts[n2] = valueCounts[n2] + 1;
            }
            int maxIndex = 0;
            int max = Integer.MIN_VALUE;
            for (int index = 0; index < attr.numValues(); ++index) {
                if (valueCounts[index] <= max) continue;
                max = valueCounts[index];
                maxIndex = index;
            }
            values[attr.index()] = maxIndex;
        }
        values[this.minorityInstances.classIndex()] = instanceI.classValue();
        Instance synthetic = instanceI.copy();
        synthetic.addSparseValues(this.indexValues, values, this.nAttributes);
        if (newInstanceBatch) {
            if (this.instanceGenerated.get(instanceI) != null) {
                this.instanceGenerated.replace(instanceI, this.instanceGenerated.get(instanceI) + 1);
            } else {
                this.instanceGenerated.put(instanceI, 1);
            }
        }
        return synthetic;
    }

    private void setParameters(ArrayList<Instance> minoritySamples) {
        this.effectiveNearestNeighbors = 5 >= minoritySamples.size() ? minoritySamples.size() - 1 : 5;
        this.minorityInstances = this.fillNewBatch(minoritySamples);
        this.minorityInstances.setClassIndex(this.minorityInstances.numAttributes() - 1);
        Enumeration attrEnum = this.minorityInstances.enumerateAttributes();
        while (attrEnum.hasMoreElements()) {
            Attribute attr = (Attribute)attrEnum.nextElement();
            if (attr.equals((Object)this.minorityInstances.classAttribute()) || !attr.isNominal() && !attr.isString()) continue;
            double[][] vdm = new double[attr.numValues()][attr.numValues()];
            this.vdmMap.put(attr, vdm);
            int[] featureValueCounts = new int[attr.numValues()];
            int[][] featureValueCountsByClass = new int[this.minorityInstances.classAttribute().numValues()][attr.numValues()];
            Enumeration instanceEnum = this.minorityInstances.enumerateInstances();
            while (instanceEnum.hasMoreElements()) {
                Instance instance = (Instance)instanceEnum.nextElement();
                int value = (int)this.samoaToWeka.wekaInstance(instance).value(attr);
                int classValue = (int)instance.classValue();
                int n = value;
                featureValueCounts[n] = featureValueCounts[n] + 1;
                int[] nArray = featureValueCountsByClass[classValue];
                int n2 = value;
                nArray[n2] = nArray[n2] + 1;
            }
            for (int valueIndex1 = 0; valueIndex1 < attr.numValues(); ++valueIndex1) {
                for (int valueIndex2 = 0; valueIndex2 < attr.numValues(); ++valueIndex2) {
                    double sum = 0.0;
                    for (int classValueIndex = 0; classValueIndex < this.minorityInstances.numClasses(); ++classValueIndex) {
                        double c1i = featureValueCountsByClass[classValueIndex][valueIndex1];
                        double c2i = featureValueCountsByClass[classValueIndex][valueIndex2];
                        double c1 = featureValueCounts[valueIndex1];
                        double c2 = featureValueCounts[valueIndex2];
                        double term1 = c1i / c1;
                        double term2 = c2i / c2;
                        sum += Math.abs(term1 - term2);
                    }
                    vdm[valueIndex1][valueIndex2] = sum;
                }
            }
        }
    }

    private double calculateRatio(int nMajority, int nMinority, int nMajorityGenerated, int nMinorityGenerated) {
        double ratio = 0.0;
        ratio = nMinority + nMinorityGenerated <= nMajority + nMajorityGenerated ? ((double)nMinority + (double)nMinorityGenerated) / ((double)nMinority + (double)nMinorityGenerated + (double)nMajority + (double)nMajorityGenerated) : ((double)nMajority + (double)nMajorityGenerated) / ((double)nMinority + (double)nMinorityGenerated + (double)nMajority + (double)nMajorityGenerated);
        return ratio;
    }

    private Instances createRandomInstances() {
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        ArrayList<String> label = new ArrayList<String>();
        for (int i = 1; i <= this.nAttributes - 1; ++i) {
            atts.add(new Attribute("att" + i));
            if (i >= 3) continue;
            label.add(Integer.toString(i - 1));
        }
        atts.add(new Attribute("label", label));
        Instances data = new Instances("BatchBalance", atts, 0);
        return data;
    }

    private void clean(int[][] confusionMatrix, double accuracy, double kStatistic) {
        for (int r = 0; r < 2; ++r) {
            for (int c = 0; c < 2; ++c) {
                confusionMatrix[r][c] = 0;
            }
        }
        accuracy = 0.0;
        kStatistic = 0.0;
    }

    private void resetAfterDrift() {
        this.learnerBal.resetLearning();
        this.learnerReset.resetLearning();
        this.learnerResetBal.resetLearning();
        this.clean(this.confusionMatrixResetBal, this.accResetBal, this.kStatResetBal);
        this.clean(this.confusionMatrixReset, this.accReset, this.kStatReset);
        this.clean(this.confusionMatrixBal, this.accBal, this.kStatBal);
        this.resetBatch.clear();
        this.resetBatchMinority.clear();
        this.resetBatchMajority.clear();
        this.warning = false;
    }

    private double calculateAccuracy(int[][] confusionMatrix) {
        int numberSamplesCorrect = confusionMatrix[0][0] + confusionMatrix[1][1];
        int numberSamples = confusionMatrix[0][0] + confusionMatrix[1][1] + confusionMatrix[0][1] + confusionMatrix[1][0];
        double accuracy = (double)numberSamplesCorrect / (double)numberSamples;
        return accuracy;
    }

    private double calculateKStatistic(int[][] confusionMatrix, double accuracy) {
        int numberSamples = confusionMatrix[0][0] + confusionMatrix[1][1] + confusionMatrix[0][1] + confusionMatrix[1][0];
        double p0 = ((double)confusionMatrix[0][0] + (double)confusionMatrix[0][1]) / (double)numberSamples * (((double)confusionMatrix[0][0] + (double)confusionMatrix[1][0]) / (double)numberSamples);
        double p1 = ((double)confusionMatrix[1][0] + (double)confusionMatrix[1][1]) / (double)numberSamples * (((double)confusionMatrix[0][1] + (double)confusionMatrix[1][1]) / (double)numberSamples);
        double pc = p0 + p1;
        double kStatistic = (accuracy - pc) / (1.0 - pc);
        return kStatistic;
    }

    private Instances fillNewBatch(ArrayList<Instance> batch) {
        Instances newBatch = this.createRandomInstances();
        for (int l = 0; l < batch.size(); ++l) {
            newBatch.add(this.samoaToWeka.wekaInstance(batch.get(l)));
        }
        return newBatch;
    }

    private int findMaxKStatistic() {
        ArrayList<Double> compare = new ArrayList<Double>();
        compare.add(0, this.kStatLearner);
        compare.add(1, this.kStatBal);
        compare.add(2, this.kStatReset);
        compare.add(3, this.kStatResetBal);
        double max = (Double)compare.get(0);
        int maxPos = 0;
        for (int pos = 0; pos < compare.size(); ++pos) {
            if (!((Double)compare.get(pos) > max)) continue;
            max = (Double)compare.get(pos);
            maxPos = pos;
        }
        return maxPos;
    }

    private void swipeModelInUse(int maxPos) {
        if (maxPos == 0) {
            this.modelInUse = maxPos;
        } else if (maxPos == 1) {
            this.modelInUse = maxPos;
            this.copyInLearner(this.learnerBal, this.confusionMatrixBal);
        } else if (maxPos == 2) {
            this.modelInUse = maxPos;
            this.copyInLearner(this.learnerReset, this.confusionMatrixReset);
        } else {
            this.modelInUse = maxPos;
            this.copyInLearner(this.learnerResetBal, this.confusionMatrixResetBal);
        }
    }

    private void copyInLearner(Classifier learnerSelected, int[][] confusionMatrixSelected) {
        this.learner = learnerSelected.copy();
        for (int r = 0; r < 2; ++r) {
            for (int c = 0; c < 2; ++c) {
                this.confusionMatrixLearner[r][c] = confusionMatrixSelected[r][c];
            }
        }
    }

    @Override
    public double[] getVotesForInstance(Instance instance) {
        double[] prediction = this.learner.getVotesForInstance(instance);
        this.fillConfusionMatrix(instance, this.confusionMatrixLearner, this.learner);
        return prediction;
    }

    private void fillConfusionMatrix(Instance instance, int[][] confusionMatrix, Classifier learner) {
        if (learner.correctlyClassifies(instance) && instance.classValue() == 0.0) {
            int[] nArray = confusionMatrix[0];
            nArray[0] = nArray[0] + 1;
        } else if (learner.correctlyClassifies(instance) && instance.classValue() == 1.0) {
            int[] nArray = confusionMatrix[1];
            nArray[1] = nArray[1] + 1;
        } else if (!learner.correctlyClassifies(instance) && instance.classValue() == 0.0) {
            int[] nArray = confusionMatrix[0];
            nArray[1] = nArray[1] + 1;
        } else if (!learner.correctlyClassifies(instance) && instance.classValue() == 1.0) {
            int[] nArray = confusionMatrix[1];
            nArray[0] = nArray[0] + 1;
        }
    }

    @Override
    public boolean isRandomizable() {
        if (this.learner != null) {
            return this.learner.isRandomizable();
        }
        return false;
    }

    @Override
    public void getModelDescription(StringBuilder arg0, int arg1) {
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    @Override
    public String toString() {
        return "RebalanceStream strategy trains in parallel four models and each one of them uses a different batch of data";
    }
}

