/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.multilabel;

import com.yahoo.labs.samoa.instances.MultiLabelInstance;
import com.yahoo.labs.samoa.instances.MultiLabelPrediction;
import com.yahoo.labs.samoa.instances.Prediction;
import com.yahoo.labs.samoa.instances.SamoaToWekaInstanceConverter;
import java.io.Serializable;
import moa.classifiers.AbstractMultiLabelLearner;
import moa.classifiers.MultiLabelLearner;
import moa.classifiers.MultiTargetRegressor;
import moa.core.Measurement;
import moa.options.WEKAClassOption;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.UpdateableClassifier;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class MEKAClassifier
extends AbstractMultiLabelLearner
implements MultiLabelLearner,
MultiTargetRegressor,
Serializable {
    private static final long serialVersionUID = 1L;
    protected SamoaToWekaInstanceConverter instanceConverter;
    public WEKAClassOption baseLearnerOption = new WEKAClassOption("baseLearner", 'l', "Classifier to train.", Classifier.class, "meka.classifiers.multilabel.incremental.BRUpdateable");
    protected Classifier classifier;
    protected Instances instancesBuffer;
    protected boolean isClassificationEnabled;
    private int L = 0;

    @Override
    public String getPurposeString() {
        return "Classifier from Meka";
    }

    @Override
    public void resetLearningImpl() {
        try {
            String[] options = Utils.splitOptions((String)this.baseLearnerOption.getValueAsCLIString());
            this.createWekaClassifier(options);
        }
        catch (Exception e) {
            System.err.println("[ERROR] Creating a new classifier: " + e.getMessage());
        }
        this.isClassificationEnabled = false;
        this.instanceConverter = new SamoaToWekaInstanceConverter();
    }

    @Override
    public void trainOnInstanceImpl(MultiLabelInstance samoaInstance) {
        this.L = samoaInstance.numberOutputTargets();
        Instance x = this.instanceConverter.wekaInstance(samoaInstance);
        x.dataset().setClassIndex(this.L);
        if (!this.isClassificationEnabled) {
            this.instancesBuffer = new Instances(x.dataset());
            try {
                this.instancesBuffer.setClassIndex(this.L);
                this.classifier.buildClassifier(this.instancesBuffer);
            }
            catch (Exception e) {
                System.err.println("[ERROR] Failed to build classifier, L=" + this.L);
                e.printStackTrace();
            }
            this.isClassificationEnabled = true;
        } else {
            try {
                ((UpdateableClassifier)this.classifier).updateClassifier(x);
            }
            catch (Exception e) {
                System.err.println("[ERROR] Failed to update classifier");
                e.printStackTrace();
            }
        }
    }

    @Override
    public double[] getVotesForInstance(com.yahoo.labs.samoa.instances.Instance samoaInstance) {
        Instance inst = this.instanceConverter.wekaInstance(samoaInstance);
        double[] votes = new double[this.L];
        try {
            votes = this.classifier.distributionForInstance(inst);
        }
        catch (Exception e) {
            System.err.println("[WARNING] Failed to get votes from multi-label classifier (not trained yet?).");
        }
        return votes;
    }

    @Override
    public Prediction getPredictionForInstance(MultiLabelInstance samoaInstance) {
        MultiLabelPrediction prediction = new MultiLabelPrediction(this.L);
        if (this.isClassificationEnabled) {
            double[] votes = this.getVotesForInstance(samoaInstance);
            for (int j = 0; j < this.L; ++j) {
                prediction.setVotes(j, new double[]{1.0 - votes[j], votes[j]});
            }
        }
        return prediction;
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        if (this.classifier != null) {
            out.append(this.classifier.toString());
        }
    }

    public void createWekaClassifier(String[] options) throws Exception {
        String classifierName = options[0];
        String[] newoptions = (String[])options.clone();
        newoptions[0] = "";
        this.classifier = AbstractClassifier.forName((String)classifierName, (String[])newoptions);
        if (!(this.classifier instanceof UpdateableClassifier)) {
            System.err.println("[ERROR] You must use an Updateable Classifier");
            throw new Exception("Only Updateable MEKA classifiers can be used.");
        }
    }
}

