/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.multilabel.core.splitcriteria;

import moa.classifiers.multilabel.core.splitcriteria.WeightedICVarianceReduction;
import moa.core.DoubleVector;

public class PCTWeightedICVarianceReduction
extends WeightedICVarianceReduction {
    private static final long serialVersionUID = 1L;
    public DoubleVector inputWeights;
    public double targetInputTradeoff;

    public PCTWeightedICVarianceReduction(DoubleVector targetWeights, DoubleVector inputWeights, double targetInputTradeoff) {
        super(targetWeights);
        this.inputWeights = inputWeights;
        this.targetInputTradeoff = targetInputTradeoff;
    }

    public double getMeritOfSplit(DoubleVector[] preSplitTargetDist, DoubleVector[][] postSplitTargetDists, DoubleVector[] preSplitInputDist, DoubleVector[][] postSplitInputDists) {
        int i;
        double targetError = 0.0;
        double inputError = 0.0;
        int numTargets = preSplitTargetDist.length;
        int numInputs = preSplitInputDist.length;
        for (i = 0; i < numTargets; ++i) {
            if (postSplitTargetDists[i][0].getValue(0) == 0.0 || postSplitTargetDists[i][1].getValue(0) == 0.0) {
                return Double.NaN;
            }
            targetError += this.weights.getValue(i) * this.getMeritOfSplitForAttribute(preSplitTargetDist[i], postSplitTargetDists[i]);
        }
        for (i = 0; i < numInputs; ++i) {
            inputError += this.inputWeights.getValue(i) * this.getMeritOfSplitForAttribute(preSplitInputDist[i], postSplitInputDists[i]);
        }
        return this.targetInputTradeoff * targetError / this.weights.sumOfValues() + (1.0 - this.targetInputTradeoff) * inputError / this.inputWeights.sumOfValues();
    }

    protected double getMeritOfSplitForAttribute(DoubleVector preSplitDist, DoubleVector[] postSplitDists) {
        double merit = 0.0;
        int count = 0;
        for (int i = 0; i < postSplitDists.length; ++i) {
            if (!(postSplitDists[i].getValue(0) >= 0.05 * preSplitDist.getValue(0))) continue;
            ++count;
        }
        if (count == postSplitDists.length) {
            double varPreSplit = this.computeVariance(preSplitDist);
            double sumVarPostSplit = 0.0;
            double weightTotal = 0.0;
            for (int i = 0; i < postSplitDists.length; ++i) {
                weightTotal += postSplitDists[i].getValue(0);
            }
            double[] variances = this.getBranchSplitVarianceOutput(postSplitDists);
            for (int i = 0; i < variances.length; ++i) {
                if (!(postSplitDists[i].getValue(0) > 0.0)) continue;
                sumVarPostSplit += postSplitDists[i].getValue(0) / weightTotal * variances[i];
            }
            merit = varPreSplit > 0.0 ? 1.0 - sumVarPostSplit / varPreSplit : 0.0;
        }
        return merit;
    }

    public double getMeritOfSplit(DoubleVector[] preSplitTargetDist, DoubleVector[] preSplitInputDist, DoubleVector[][] postSplitTargetDists, DoubleVector[][] postSplitInputDists) {
        double error = 0.0;
        int numOutputs = preSplitTargetDist.length;
        for (int i = 0; i < numOutputs; ++i) {
            error += this.weights.getValue(i) * this.getMeritOfSplitForOutput(preSplitTargetDist, postSplitTargetDists, i);
        }
        return error / this.weights.sumOfValues();
    }
}

