/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.multilabel.core.splitcriteria;

import moa.classifiers.multilabel.core.splitcriteria.ICVarianceReduction;
import moa.core.DoubleVector;
import moa.core.ObjectRepository;
import moa.tasks.TaskMonitor;

public class WeightedICVarianceReduction
extends ICVarianceReduction {
    private static final long serialVersionUID = 1L;
    public DoubleVector weights;

    public WeightedICVarianceReduction(DoubleVector targetWeights) {
        this.weights = targetWeights;
    }

    @Override
    public double getMeritOfSplit(DoubleVector[] preSplitDist, DoubleVector[][] postSplitDists) {
        double error = 0.0;
        int numOutputs = preSplitDist.length;
        for (int i = 0; i < numOutputs; ++i) {
            error += this.weights.getValue(i) * this.getMeritOfSplitForOutput(preSplitDist, postSplitDists, i);
        }
        return error / this.weights.sumOfValues();
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }
}

