/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.multilabel.trees;

import com.github.javacliparser.FileOption;
import com.github.javacliparser.FlagOption;
import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.InstanceImpl;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import com.yahoo.labs.samoa.instances.MultiLabelInstance;
import com.yahoo.labs.samoa.instances.MultiLabelPrediction;
import com.yahoo.labs.samoa.instances.Prediction;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import moa.classifiers.AbstractMultiLabelLearner;
import moa.classifiers.MultiTargetLearnerSemiSupervised;
import moa.classifiers.MultiTargetRegressor;
import moa.classifiers.multilabel.core.splitcriteria.PCTWeightedICVarianceReduction;
import moa.classifiers.multilabel.core.splitcriteria.WeightedICVarianceReduction;
import moa.classifiers.rules.core.Predicate;
import moa.classifiers.rules.multilabel.attributeclassobservers.AttributeStatisticsObserver;
import moa.classifiers.rules.multilabel.attributeclassobservers.MultiLabelBSTree;
import moa.classifiers.rules.multilabel.attributeclassobservers.MultiLabelBSTreePCT;
import moa.classifiers.rules.multilabel.attributeclassobservers.MultiLabelNominalAttributeObserver;
import moa.classifiers.rules.multilabel.attributeclassobservers.NominalStatisticsObserver;
import moa.classifiers.rules.multilabel.attributeclassobservers.NumericStatisticsObserver;
import moa.classifiers.rules.multilabel.core.AttributeExpansionSuggestion;
import moa.classifiers.rules.multilabel.core.splitcriteria.MultiLabelSplitCriterion;
import moa.core.AutoExpandVector;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.core.SizeOf;
import moa.core.StringUtils;

public class ISOUPTree
extends AbstractMultiLabelLearner
implements MultiTargetRegressor,
MultiTargetLearnerSemiSupervised {
    private static final long serialVersionUID = 1L;
    public Node treeRoot;
    protected double learningWeight = 0.0;
    public DoubleVector examplesSeen = new DoubleVector();
    public DoubleVector sumOfValues = new DoubleVector();
    public DoubleVector sumOfSquares = new DoubleVector();
    public DoubleVector weightOfInputs = new DoubleVector();
    public DoubleVector sumOfAttrValues = new DoubleVector();
    public DoubleVector sumOfAttrSquares = new DoubleVector();
    private int numInputAttributes;
    private int numOutputAttributes;
    public int maxID = 0;
    private BufferedWriter writer;
    public DoubleVector targetWeights;
    public IntOption gracePeriodOption = new IntOption("gracePeriod", 'g', "The number of instances a leaf should observe between split attempts.", 200, 0, Integer.MAX_VALUE);
    public FloatOption splitConfidenceOption = new FloatOption("splitConfidence", 'c', "The allowable error in split decision, values closer to 0 will take longer to decide.", 1.0E-7, 0.0, 1.0);
    public FloatOption tieThresholdOption = new FloatOption("tieThreshold", 't', "Threshold below which a split will be forced to break ties.", 0.05, 0.0, 1.0);
    public FloatOption PageHinckleyAlphaOption = new FloatOption("PageHinckleyAlpha", 'a', "The alpha value to use in the Page Hinckley change detection tests.", 0.005, 0.0, 1.0);
    public IntOption PageHinckleyThresholdOption = new IntOption("PageHinckleyThreshold", 'h', "The threshold value to be used in the Page Hinckley change detection tests.", 50, 0, Integer.MAX_VALUE);
    public FloatOption alternateTreeFadingFactorOption = new FloatOption("alternateTreeFadingFactor", 'f', "The fading factor to use when deciding if an alternate tree should replace an original.", 0.995, 0.0, 1.0);
    public IntOption alternateTreeTMinOption = new IntOption("alternateTreeTMin", 'y', "The Tmin value to use when deciding if an alternate tree should replace an original.", 150, 0, Integer.MAX_VALUE);
    public IntOption alternateTreeTimeOption = new IntOption("alternateTreeTime", 'u', "The 'time' (in terms of number of instances) value to use when deciding if an alternate tree should be discarded.", 1500, 0, Integer.MAX_VALUE);
    public FlagOption regressionTreeOption = new FlagOption("regressionTree", 's', "Build a regression tree instead of a model tree.");
    public FloatOption learningRatioOption = new FloatOption("learningRatio", 'l', "Learning ratio to use for training the Perceptrons in the leaves.", 0.02);
    public FloatOption learningRateDecayFactorOption = new FloatOption("learningRatioDecayFactor", 'd', "Learning rate decay factor (not used when learning rate is constant).", 0.001);
    public FlagOption learningRatioConstOption = new FlagOption("learningRatioConst", 'o', "Keep learning rate constant instead of decaying (if kept constant learning ratio is suggested to be 0.001).");
    public FlagOption runAsPCTOption = new FlagOption("runAsPCT", 'p', "Run as a predictive clustering tree, i.e., use input attributes in heuristic calculation.");
    public FlagOption doNotNormalizeOption = new FlagOption("doNotNormalize", 'n', "Don't normalize.");
    public FileOption weightFile = new FileOption("targetWeightFile", 'w', "File with the weights of the targets.", null, null, false);

    public List<Integer> newInputIndexes() {
        Vector<Integer> indexes = new Vector<Integer>();
        for (int i = 0; i < this.numInputAttributes; ++i) {
            indexes.add(i, i);
        }
        return indexes;
    }

    @Override
    public String getPurposeString() {
        return "Implementation of the iSOUP-Tree algorithm as described by Osojnik et al.";
    }

    @Override
    public void resetLearningImpl() {
        this.treeRoot = null;
        if (this.getModelContext() != null) {
            this.checkRoot();
        }
        this.learningWeight = 0.0;
        this.examplesSeen = new DoubleVector();
        this.sumOfValues = new DoubleVector();
        this.sumOfSquares = new DoubleVector();
        this.weightOfInputs = new DoubleVector();
        this.sumOfAttrValues = new DoubleVector();
        this.sumOfAttrSquares = new DoubleVector();
    }

    @Override
    public void setModelContext(InstancesHeader ih) {
        super.setModelContext(ih);
        this.numInputAttributes = this.getModelContext().numInputAttributes();
        this.numOutputAttributes = this.getModelContext().numOutputAttributes();
        this.loadWeights();
        this.checkRoot();
    }

    public void loadWeights() {
        this.targetWeights = new DoubleVector();
        try {
            List<String> lines = Files.readAllLines(Paths.get(this.weightFile.getValue(), new String[0]), Charset.defaultCharset());
            for (int i = 0; i < lines.size(); ++i) {
                this.targetWeights.setValue(i, Double.valueOf(lines.get(i)));
            }
        }
        catch (Exception e) {
            for (int i = 0; i < this.numOutputAttributes; ++i) {
                this.targetWeights.setValue(i, 1.0);
            }
        }
    }

    @Override
    public boolean isRandomizable() {
        return true;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        if (this.treeRoot != null) {
            this.treeRoot.describeSubtree(out, indent);
        }
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return new Measurement[0];
    }

    public long calcByteSize() {
        long size = SizeOf.sizeOf(this);
        if (this.treeRoot != null) {
            size += this.treeRoot.calcByteSize();
        }
        size += SizeOf.sizeOf(this.examplesSeen) + SizeOf.sizeOf(this.weightOfInputs);
        size += SizeOf.sizeOf(this.sumOfValues) + SizeOf.sizeOf(this.sumOfSquares);
        size += SizeOf.sizeOf(this.sumOfAttrValues) + SizeOf.sizeOf(this.sumOfAttrSquares);
        return size += SizeOf.sizeOf(this.targetWeights);
    }

    @Override
    public Prediction getPredictionForInstance(MultiLabelInstance inst) {
        this.checkRoot();
        double[] predictionVector = this.treeRoot.getPrediction(inst);
        MultiLabelPrediction prediction = new MultiLabelPrediction(this.getModelContext().numOutputAttributes());
        for (int i = 0; i < this.getModelContext().numOutputAttributes(); ++i) {
            prediction.setVote(i, 1, predictionVector[i]);
        }
        return prediction;
    }

    @Override
    public Prediction getTrainingPrediction() {
        return null;
    }

    public double[] normalizedInputVector(Instance inst) {
        double[] normalizedInput = new double[this.numInputAttributes + 1];
        if (this.normalize()) {
            for (int j = 0; j < this.numInputAttributes; ++j) {
                Attribute attr = inst.inputAttribute(j);
                double value = inst.valueInputAttribute(j);
                double mean = this.sumOfAttrValues.getValue(j) / this.weightOfInputs.getValue(j);
                double sd = this.computeSD(this.sumOfAttrSquares.getValue(j), this.sumOfAttrValues.getValue(j), this.weightOfInputs.getValue(j));
                if (this.weightOfInputs.getValue(j) > 1.0 && sd > 1.0E-5) {
                    if (attr.isNumeric()) {
                        normalizedInput[j] = (value - mean) / sd;
                        continue;
                    }
                    normalizedInput[j] = value;
                    continue;
                }
                normalizedInput[j] = 0.0;
            }
            normalizedInput[this.numInputAttributes] = 1.0;
        } else {
            for (int j = 0; j < this.numInputAttributes; ++j) {
                normalizedInput[j] = inst.valueInputAttribute(j);
            }
            normalizedInput[this.numInputAttributes] = 1.0;
        }
        return normalizedInput;
    }

    public double[] normalizedTargetVector(Instance instance) {
        InstanceWrapper inst = new InstanceWrapper((InstanceImpl)instance);
        double[] out = new double[this.numOutputAttributes];
        if (this.normalize()) {
            for (int i = 0; i < this.numOutputAttributes; ++i) {
                double value;
                double d = value = inst.isOutputMissing(i) ? Double.NaN : inst.valueOutputAttribute(i);
                if (!Double.isNaN(value)) {
                    double sd = this.computeSD(this.sumOfSquares.getValue(i), this.sumOfValues.getValue(i), this.examplesSeen.getValue(i));
                    double average = this.sumOfValues.getValue(i) / this.examplesSeen.getValue(i);
                    if (sd > 0.0 && this.examplesSeen.getValue(i) > 1.0) {
                        out[i] = (value - average) / sd;
                        continue;
                    }
                    out[i] = 0.0;
                    continue;
                }
                out[i] = value;
            }
        } else {
            for (int i = 0; i < this.numOutputAttributes; ++i) {
                out[i] = inst.isOutputMissing(i) ? Double.NaN : inst.valueOutputAttribute(i);
            }
        }
        return out;
    }

    public double[] normalizeTargetVector(double[] pred) {
        if (pred != null && this.normalize()) {
            double[] out = new double[pred.length];
            for (int i = 0; i < pred.length; ++i) {
                double value = pred[i];
                double sd = this.computeSD(this.sumOfSquares.getValue(i), this.sumOfValues.getValue(i), this.examplesSeen.getValue(i));
                double average = this.sumOfValues.getValue(i) / this.examplesSeen.getValue(i);
                out[i] = sd > 0.0 && this.examplesSeen.getValue(i) > 1.0 ? (value - average) / sd : 0.0;
            }
            return out;
        }
        return pred;
    }

    public double normalizeTargetValue(Instance inst, int i) {
        if (this.normalize()) {
            if (this.examplesSeen.getValue(i) > 1.0) {
                double value = inst.valueOutputAttribute(i);
                double sd = this.computeSD(this.sumOfSquares.getValue(i), this.sumOfValues.getValue(i), this.examplesSeen.getValue(i));
                double average = this.sumOfValues.getValue(i) / this.examplesSeen.getValue(i);
                if (sd > 0.0) {
                    return (value - average) / sd;
                }
                return 0.0;
            }
            return 0.0;
        }
        return inst.valueOutputAttribute(i);
    }

    public double normalizeTargetValue(double value, int i) {
        if (this.normalize()) {
            if (this.examplesSeen.getValue(i) > 1.0) {
                double sd = this.computeSD(this.sumOfSquares.getValue(i), this.sumOfValues.getValue(i), this.examplesSeen.getValue(i));
                double average = this.sumOfValues.getValue(i) / this.examplesSeen.getValue(i);
                if (sd > 0.0) {
                    return (value - average) / sd;
                }
                return 0.0;
            }
            return 0.0;
        }
        return value;
    }

    public double[] getNormalizedError(Instance inst, double[] prediction) {
        double[] normalPrediction = this.normalizeTargetVector(prediction);
        double[] normalValue = this.normalizedTargetVector(inst);
        double[] out = new double[this.numOutputAttributes];
        if (normalPrediction != null) {
            for (int i = 0; i < this.numOutputAttributes; ++i) {
                out[i] = Math.abs(normalValue[i] - normalPrediction[i]);
            }
        }
        return out;
    }

    @Override
    public void trainOnInstanceImpl(MultiLabelInstance instance) {
        InstanceWrapper inst = new InstanceWrapper((InstanceImpl)instance);
        if (inst.weight() > 0.0) {
            double iVal;
            int i;
            double[] prediction = this.treeRoot.getPrediction(inst);
            double[] normalError = null;
            this.processInstance(inst, this.treeRoot, prediction, normalError, true, false);
            double weight = inst.weight();
            this.learningWeight += weight;
            for (i = 0; i < this.numOutputAttributes; ++i) {
                if (inst.isOutputMissing(i)) continue;
                iVal = inst.valueOutputAttribute(i);
                this.examplesSeen.addToValue(i, weight);
                this.sumOfValues.addToValue(i, weight * iVal);
                this.sumOfSquares.addToValue(i, weight * iVal * iVal);
            }
            for (i = 0; i < this.numInputAttributes; ++i) {
                if (inst.isInputMissing(i)) continue;
                iVal = inst.valueInputAttribute(i);
                this.weightOfInputs.addToValue(i, weight);
                this.sumOfAttrValues.addToValue(i, weight * iVal);
                this.sumOfAttrSquares.addToValue(i, weight * iVal * iVal);
            }
        }
    }

    public void processInstance(Instance inst, Node node, double[] prediction, double[] normalError, boolean growthAllowed, boolean inAlternate) {
        Node currentNode = node;
        while (true) {
            if (currentNode instanceof LeafNode) break;
            currentNode = ((SplitNode)currentNode).getChild(((SplitNode)currentNode).instanceChildIndex(inst));
        }
        ((LeafNode)currentNode).learnFromInstance(inst, prediction, growthAllowed);
    }

    protected NumericStatisticsObserver newNumericClassObserver() {
        try {
            if (this.runAsPCTOption.isSet()) {
                return new MultiLabelBSTreePCT();
            }
            return new MultiLabelBSTree();
        }
        catch (Exception e) {
            return null;
        }
    }

    public NominalStatisticsObserver newNominalClassObserver() {
        return new MultiLabelNominalAttributeObserver();
    }

    protected SplitNode newSplitNode(Predicate predicate) {
        ++this.maxID;
        return new SplitNode(predicate, this);
    }

    protected LeafNode newLeafNode() {
        ++this.maxID;
        return new LeafNode(this);
    }

    public MultitargetPerceptron newLeafModel() {
        return new MultitargetPerceptron(this);
    }

    protected void checkRoot() {
        if (this.treeRoot == null) {
            this.treeRoot = this.newLeafNode();
        }
    }

    public static double computeHoeffdingBound(double range, double confidence, double n) {
        return Math.sqrt(range * range * Math.log(1.0 / confidence) / (2.0 * n));
    }

    public boolean buildingModelTree() {
        return !this.regressionTreeOption.isSet();
    }

    public boolean normalize() {
        return !this.doNotNormalizeOption.isSet();
    }

    protected void attemptToSplit(LeafNode node, InnerNode parent, int parentIndex) {
        WeightedICVarianceReduction splitCriterion = null;
        if (!this.runAsPCTOption.isSet()) {
            splitCriterion = new WeightedICVarianceReduction(this.targetWeights);
        } else {
            DoubleVector inputWeights = new DoubleVector();
            for (int i = 0; i < this.numInputAttributes; ++i) {
                inputWeights.setValue(i, 1.0);
            }
            splitCriterion = new PCTWeightedICVarianceReduction(this.targetWeights, inputWeights, 0.5);
        }
        Object[] bestSplitSuggestions = node.getBestSplitSuggestions(splitCriterion);
        boolean shouldSplit = false;
        if (bestSplitSuggestions.length < 2) {
            shouldSplit = bestSplitSuggestions.length > 0;
        } else {
            Arrays.sort(bestSplitSuggestions);
            double numExamples = node.learningWeight;
            double hoeffdingBound = ISOUPTree.computeHoeffdingBound(1.0, this.splitConfidenceOption.getValue(), numExamples);
            Object bestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 1];
            Object secondBestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 2];
            boolean bl = shouldSplit = ((AttributeExpansionSuggestion)secondBestSuggestion).merit / ((AttributeExpansionSuggestion)bestSuggestion).merit < 1.0 - hoeffdingBound || hoeffdingBound < this.tieThresholdOption.getValue();
        }
        if (shouldSplit) {
            Object splitDecision = bestSplitSuggestions[bestSplitSuggestions.length - 1];
            SplitNode newSplit = this.newSplitNode(((AttributeExpansionSuggestion)splitDecision).predicate);
            newSplit.ID = node.ID;
            newSplit.copyStatistics(node);
            newSplit.changeDetection = node.changeDetection;
            this.log(Integer.toString(node.ID) + ',' + this.examplesSeen.toString());
            for (int i = 0; i < 2; ++i) {
                LeafNode newChild = this.newLeafNode();
                if (this.buildingModelTree()) {
                    newChild.learningModel = new MultitargetPerceptron(this, node.learningModel);
                    newChild.errorM = (DoubleVector)node.errorM.copy();
                    newChild.errorP = (DoubleVector)node.errorP.copy();
                } else {
                    for (int j = 0; j < this.getModelContext().numOutputAttributes(); ++j) {
                        newChild.examplesSeen.setValue(j, ((AttributeExpansionSuggestion)splitDecision).getResultingNodeStatistics()[j][i].getValue(0));
                        newChild.sumOfValues.setValue(j, ((AttributeExpansionSuggestion)splitDecision).getResultingNodeStatistics()[j][i].getValue(1));
                        newChild.sumOfSquares.setValue(j, ((AttributeExpansionSuggestion)splitDecision).getResultingNodeStatistics()[j][i].getValue(2));
                    }
                }
                newChild.changeDetection = node.changeDetection;
                newChild.setParent(newSplit);
                newSplit.setChild(i, newChild);
            }
            if (parent == null && node.originalNode == null) {
                this.treeRoot = newSplit;
            } else if (parent == null && node.originalNode != null) {
                node.originalNode.alternateTree = newSplit;
            } else {
                parent.setChild(parentIndex, newSplit);
                newSplit.setParent(parent);
            }
        }
    }

    public double computeSD(double squaredVal, double val, double size) {
        if (size > 1.0) {
            return Math.sqrt((squaredVal - val * val / size) / size);
        }
        return 0.0;
    }

    public static double scalarProduct(DoubleVector u, DoubleVector v) {
        double ret = 0.0;
        for (int i = 0; i < Math.max(u.numValues(), v.numValues()); ++i) {
            ret += u.getValue(i) * v.getValue(i);
        }
        return ret;
    }

    public void initWriter(String filename) {
        try {
            this.writer = new BufferedWriter(new FileWriter(filename));
            this.writer.write("");
            this.writer.close();
            this.writer = new BufferedWriter(new FileWriter(filename, true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void closeWriter() {
        try {
            this.writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.writer = null;
    }

    public void log(String s) {
        if (this.writer != null) {
            try {
                this.writer.write(s + "\n");
                this.writer.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class MultitargetPerceptron
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected ISOUPTree tree;
        public double[][] weights;
        protected int instancesSeen = 0;

        public MultitargetPerceptron(ISOUPTree tree, MultitargetPerceptron original) {
            this.tree = tree;
            this.weights = new double[original.weights.length][original.weights[0].length];
            for (int i = 0; i < original.weights.length; ++i) {
                for (int j = 0; j < original.weights[0].length; ++j) {
                    this.weights[i][j] = original.weights[i][j];
                }
            }
        }

        public MultitargetPerceptron(ISOUPTree tree) {
            this.tree = tree;
            this.initializeWeights();
        }

        public long calcByteSize() {
            return SizeOf.sizeOf(this);
        }

        public String getPurposeString() {
            return "A multi-target perceptron";
        }

        public void initializeWeights() {
            this.instancesSeen = 0;
            int numTargets = this.tree.numOutputAttributes;
            int numInputs = this.tree.numInputAttributes;
            this.weights = new double[numTargets][numInputs + 1];
            for (int i = 0; i < numTargets; ++i) {
                for (int j = 0; j < numInputs + 1; ++j) {
                    this.weights[i][j] = 2.0 * this.tree.classifierRandom.nextDouble() - 1.0;
                }
            }
            this.normalizeWeights();
        }

        public void updatePerceptron(Instance inst) {
            this.instancesSeen = (int)((double)this.instancesSeen + inst.weight());
            double learningRatio = 0.0;
            learningRatio = this.tree.learningRatioConstOption.isSet() ? this.tree.learningRatioOption.getValue() : this.tree.learningRatioOption.getValue() / (1.0 + (double)this.instancesSeen * this.tree.learningRateDecayFactorOption.getValue());
            for (int i = 0; i < (int)inst.weight(); ++i) {
                this.updateWeights(inst, learningRatio);
            }
        }

        public void updateWeights(Instance inst, double learningRatio) {
            if ((double)this.instancesSeen > 1.0) {
                double[] normalizedInput = this.tree.normalizedInputVector(inst);
                double[] normalizedPrediction = this.prediction(normalizedInput);
                double[] normalizedTarget = this.tree.normalizedTargetVector(inst);
                for (int i = 0; i < this.tree.numOutputAttributes; ++i) {
                    if (Double.isNaN(normalizedTarget[i])) continue;
                    double delta = normalizedTarget[i] - normalizedPrediction[i];
                    for (int j = 0; j < normalizedInput.length; ++j) {
                        double[] dArray = this.weights[i];
                        int n = j;
                        dArray[n] = dArray[n] + delta * learningRatio * normalizedInput[j];
                    }
                }
                this.normalizeWeights();
            }
        }

        public void normalizeWeights() {
            for (int j = 0; j < this.weights.length; ++j) {
                int i;
                double sum = 0.0;
                for (i = 0; i < this.weights[j].length; ++i) {
                    sum += Math.abs(this.weights[j][i]);
                }
                i = 0;
                while (i < this.weights[j].length) {
                    double[] dArray = this.weights[j];
                    int n = i++;
                    dArray[n] = dArray[n] / sum;
                }
            }
        }

        public double[] prediction(double[] instanceValues) {
            double[] out = new double[this.tree.numOutputAttributes];
            for (int i = 0; i < this.tree.numOutputAttributes; ++i) {
                out[i] = 0.0;
                for (int j = 0; j < instanceValues.length; ++j) {
                    int n = i;
                    out[n] = out[n] + this.weights[i][j] * instanceValues[j];
                }
            }
            return out;
        }

        private double[] prediction(Instance inst) {
            double[] normalizedInput = this.tree.normalizedInputVector(inst);
            double[] normalizedPrediction = this.prediction(normalizedInput);
            return this.denormalizePrediction(normalizedPrediction);
        }

        private double[] denormalizePrediction(double[] normalizedPrediction) {
            double[] out = new double[normalizedPrediction.length];
            if (this.tree.normalize()) {
                for (int i = 0; i < this.tree.numOutputAttributes; ++i) {
                    double mean = this.tree.sumOfValues.getValue(i) / this.tree.examplesSeen.getValue(i);
                    double sd = ISOUPTree.this.computeSD(this.tree.sumOfSquares.getValue(i), this.tree.sumOfValues.getValue(i), this.tree.examplesSeen.getValue(i));
                    out[i] = ISOUPTree.this.examplesSeen.getValue(i) > 1.0 ? normalizedPrediction[i] * sd + mean : 0.0;
                }
                return out;
            }
            return normalizedPrediction;
        }

        public void getModelDescription(StringBuilder out, int indent) {
            if (ISOUPTree.this.getModelContext() != null) {
                for (int i = 0; i < this.tree.numOutputAttributes; ++i) {
                    StringUtils.appendIndented(out, indent, " [" + this.tree.getModelContext().outputAttribute(i).name() + "] =");
                    for (int j = 0; j < this.tree.numInputAttributes; ++j) {
                        if (!ISOUPTree.this.getModelContext().inputAttribute(j).isNumeric()) continue;
                        out.append(j == 0 && this.weights[i][j] >= 0.0 ? " " : (this.weights[i][j] < 0.0 ? " - " : " + "));
                        out.append(String.format("%.4f", Math.abs(this.weights[i][j])));
                        out.append(" * ");
                        out.append(ISOUPTree.this.getModelContext().inputAttribute(j).name());
                    }
                    out.append((this.weights[i][this.tree.numInputAttributes] < 0.0 ? " - " : " + ") + String.format("%.4f", Math.abs(this.weights[i][this.tree.numInputAttributes])));
                }
                StringUtils.appendNewline(out);
            }
        }
    }

    public static class SplitNode
    extends InnerNode {
        private static final long serialVersionUID = 1L;
        public Predicate predicate;

        public SplitNode(Predicate predicate, ISOUPTree tree) {
            super(tree);
            this.predicate = predicate;
            this.ID = tree.maxID;
        }

        @Override
        public long calcByteSize() {
            return super.calcByteSize() + SizeOf.sizeOf(this.predicate);
        }

        public int instanceChildIndex(Instance inst) {
            return this.predicate.evaluate(inst) ? 0 : 1;
        }

        @Override
        public void describeSubtree(StringBuilder out, int indent) {
            for (int branch = 0; branch < this.children.size(); ++branch) {
                Node child = this.getChild(branch);
                if (child == null) continue;
                if (branch == 0) {
                    StringUtils.appendIndented(out, indent, "if ");
                    this.predicate.getDescription(out, 0, this.tree.getModelContext().getInstanceInformation());
                } else {
                    StringUtils.appendIndented(out, indent, "else");
                }
                out.append(": ");
                StringUtils.appendNewline(out);
                child.describeSubtree(out, indent + 2);
            }
        }

        @Override
        public double[] getPrediction(Instance inst) {
            return ((Node)this.children.get(this.predicate.evaluate(inst) ? 0 : 1)).getPrediction(inst);
        }
    }

    public static abstract class InnerNode
    extends Node {
        private static final long serialVersionUID = 1L;
        protected AutoExpandVector<Node> children = new AutoExpandVector();
        protected DoubleVector sumOfAbsErrors = new DoubleVector();
        protected DoubleVector PHsums = new DoubleVector();
        protected DoubleVector PHmins = new DoubleVector();
        protected double lossExamplesSeen;
        protected double lossFadedSumOriginal;
        protected double lossFadedSumAlternate;
        protected double lossNumQiTests;
        protected double lossSumQi;
        protected double previousWeight = 0.0;

        public InnerNode(ISOUPTree tree) {
            super(tree);
        }

        @Override
        public long calcByteSize() {
            long size = super.calcByteSize();
            size += SizeOf.sizeOf(this.PHsums) + SizeOf.sizeOf(this.PHmins) + SizeOf.sizeOf(this.sumOfAbsErrors);
            for (Node child : this.children) {
                size += child.calcByteSize();
            }
            return size;
        }

        public int numChildren() {
            return this.children.size();
        }

        public Node getChild(int i) {
            return this.children.get(i);
        }

        @Override
        public int getChildIndex(Node child) {
            return this.children.indexOf(child);
        }

        @Override
        public void setChild(int i, Node child) {
            this.children.set(i, child);
        }

        @Override
        public void disableChangeDetection() {
            this.changeDetection = false;
            for (Node child : this.children) {
                child.disableChangeDetection();
            }
        }

        @Override
        public void restartChangeDetection() {
            if (this.alternateTree == null) {
                this.changeDetection = true;
                this.PHsums = new DoubleVector();
                this.PHmins = new DoubleVector();
                for (int i = 0; i < this.tree.numOutputAttributes; ++i) {
                    this.PHmins.setValue(i, Double.MAX_VALUE);
                }
                for (Node child : this.children) {
                    child.restartChangeDetection();
                }
            }
        }

        public boolean PageHinckleyTest(double error, double threshold, int targetIndex) {
            this.PHsums.addToValue(targetIndex, error);
            if (this.PHsums.getValue(targetIndex) < this.PHmins.getValue(targetIndex)) {
                this.PHmins.setValue(targetIndex, this.PHsums.getValue(targetIndex));
            }
            return this.PHsums.getValue(targetIndex) - this.PHmins.getValue(targetIndex) > threshold;
        }

        public void initializeAlternateTree(ISOUPTree tree) {
            this.alternateTree = tree.newLeafNode();
            this.alternateTree.originalNode = this;
            this.lossExamplesSeen = 0.0;
            this.lossFadedSumOriginal = 0.0;
            this.lossFadedSumAlternate = 0.0;
            this.lossNumQiTests = 0.0;
            this.lossSumQi = 0.0;
            this.previousWeight = 0.0;
            this.disableChangeDetection();
        }
    }

    public static class LeafNode
    extends Node {
        private static final long serialVersionUID = 1L;
        public MultitargetPerceptron learningModel;
        public double learningWeight = 0.0;
        public DoubleVector errorP = new DoubleVector();
        public DoubleVector errorM = new DoubleVector();
        public List<Integer> inputIndexes = null;
        protected double examplesSeenAtLastSplitEvaluation = 0.0;
        protected AutoExpandVector<AttributeStatisticsObserver> attributeObservers = new AutoExpandVector();

        public LeafNode(ISOUPTree tree) {
            super(tree);
            if (tree.buildingModelTree()) {
                this.learningModel = tree.newLeafModel();
            }
            this.initializeInputIndexes();
            this.learningWeight = 0.0;
            this.examplesSeen = new DoubleVector();
            this.sumOfValues = new DoubleVector();
            this.sumOfSquares = new DoubleVector();
            if (tree.runAsPCTOption.isSet()) {
                this.weightOfInputs = new DoubleVector();
                this.sumOfInputValues = new DoubleVector();
                this.sumOfInputSquares = new DoubleVector();
            }
        }

        @Override
        public long calcByteSize() {
            long size = super.calcByteSize();
            if (this.tree.buildingModelTree()) {
                size += this.learningModel.calcByteSize();
                size += SizeOf.sizeOf(this.errorP);
                size += SizeOf.sizeOf(this.errorM);
            }
            size += SizeOf.sizeOf(this.inputIndexes);
            return size += SizeOf.fullSizeOf(this.attributeObservers);
        }

        public void initializeInputIndexes() {
            this.inputIndexes = this.tree.newInputIndexes();
        }

        public void learnFromInstance(Instance instance, double[] prediction, boolean growthAllowed) {
            InstanceWrapper inst = new InstanceWrapper((InstanceImpl)instance);
            double weight = inst.weight();
            double[] predictionP = this.tree.buildingModelTree() ? this.getPredictionModel(inst) : null;
            double[] predictionM = this.getPredictionTargetMean(inst);
            DoubleVector[] observations = new DoubleVector[this.tree.numOutputAttributes];
            DoubleVector[] inputObservations = null;
            this.learningWeight += weight;
            if (this.tree.buildingModelTree() && !inst.missingOutputs()) {
                this.learningModel.updatePerceptron(inst);
            }
            for (int i = 0; i < this.tree.numOutputAttributes; ++i) {
                if (inst.isOutputMissing(i)) continue;
                double outVal = inst.valueOutputAttribute(i);
                this.examplesSeen.addToValue(i, weight);
                this.sumOfValues.addToValue(i, weight * outVal);
                this.sumOfSquares.addToValue(i, weight * outVal * outVal);
                if (this.tree.buildingModelTree()) {
                    this.errorP.setValue(i, this.errorP.getValue(i) * 0.95 + Math.abs(predictionP[i] - outVal));
                    this.errorM.setValue(i, this.errorM.getValue(i) * 0.95 + Math.abs(predictionM[i] - outVal));
                }
                observations[i] = new DoubleVector(new double[]{weight, weight * outVal, weight * outVal * outVal});
            }
            if (this.tree.runAsPCTOption.isSet()) {
                inputObservations = new DoubleVector[this.tree.numInputAttributes];
                for (int i : this.inputIndexes) {
                    if (inst.isInputMissing(i)) continue;
                    double inVal = inst.valueInputAttribute(i);
                    this.weightOfInputs.addToValue(i, weight);
                    this.sumOfInputValues.addToValue(i, weight * inVal);
                    this.sumOfInputSquares.addToValue(i, weight * inVal * inVal);
                    inputObservations[i] = new DoubleVector(new double[]{weight, weight * inVal, weight * inVal * inVal});
                }
            }
            for (int i : this.inputIndexes) {
                AttributeStatisticsObserver obs = this.attributeObservers.get(i);
                if (obs == null) {
                    if (inst.inputAttribute(i).isNumeric()) {
                        obs = this.tree.newNumericClassObserver();
                        this.attributeObservers.set(i, obs);
                    } else if (inst.inputAttribute(i).isNominal()) {
                        obs = this.tree.newNominalClassObserver();
                        this.attributeObservers.set(i, obs);
                    }
                }
                if (!this.tree.runAsPCTOption.isSet() || !inst.inputAttribute(i).isNumeric()) {
                    obs.observeAttribute(inst.valueInputAttribute(i), observations);
                    continue;
                }
                ((MultiLabelBSTreePCT)obs).observeAttribute(inst.valueInputAttribute(i), observations, inputObservations);
            }
            if (growthAllowed) {
                this.checkForSplit();
            }
        }

        public AttributeExpansionSuggestion[] getBestSplitSuggestions(MultiLabelSplitCriterion criterion) {
            LinkedList<AttributeExpansionSuggestion> bestSuggestions = new LinkedList<AttributeExpansionSuggestion>();
            for (int i : this.inputIndexes) {
                int j;
                AttributeStatisticsObserver obs = this.attributeObservers.get(i);
                if (obs == null) continue;
                DoubleVector[] preSplitStatistics = new DoubleVector[this.tree.numOutputAttributes];
                DoubleVector[] preSplitInputStatistics = null;
                for (j = 0; j < this.tree.numOutputAttributes; ++j) {
                    preSplitStatistics[j] = new DoubleVector();
                    preSplitStatistics[j].setValue(0, this.examplesSeen.getValue(j));
                    preSplitStatistics[j].setValue(1, this.sumOfValues.getValue(j));
                    preSplitStatistics[j].setValue(2, this.sumOfSquares.getValue(j));
                }
                if (this.tree.runAsPCTOption.isSet() && this.tree.modelContext.inputAttribute(i).isNumeric()) {
                    preSplitInputStatistics = new DoubleVector[this.tree.numInputAttributes];
                    for (j = 0; j < this.tree.numInputAttributes; ++j) {
                        preSplitInputStatistics[j] = new DoubleVector();
                        preSplitInputStatistics[j].setValue(0, this.weightOfInputs.getValue(j));
                        preSplitInputStatistics[j].setValue(1, this.sumOfInputValues.getValue(j));
                        preSplitInputStatistics[j].setValue(2, this.sumOfInputSquares.getValue(j));
                    }
                }
                AttributeExpansionSuggestion bestSuggestion = null;
                bestSuggestion = this.tree.runAsPCTOption.isSet() && this.tree.modelContext.inputAttribute(i).isNumeric() ? ((MultiLabelBSTreePCT)obs).getBestEvaluatedSplitSuggestion(criterion, preSplitStatistics, preSplitInputStatistics, i) : obs.getBestEvaluatedSplitSuggestion(criterion, preSplitStatistics, i);
                if (bestSuggestion == null) continue;
                bestSuggestions.add(bestSuggestion);
            }
            return bestSuggestions.toArray(new AttributeExpansionSuggestion[bestSuggestions.size()]);
        }

        public double[] getPredictionModel(Instance inst) {
            return this.learningModel.prediction(inst);
        }

        public double[] getPredictionTargetMean(Instance inst) {
            double[] pred = new double[this.tree.numOutputAttributes];
            for (int i = 0; i < this.tree.numOutputAttributes; ++i) {
                pred[i] = this.examplesSeen.getValue(i) > 0.0 ? this.sumOfValues.getValue(i) / this.examplesSeen.getValue(i) : 0.0;
            }
            return pred;
        }

        @Override
        public double[] getPrediction(Instance inst) {
            if (this.tree.buildingModelTree()) {
                double[] predictionP = this.getPredictionModel(inst);
                double[] predictionM = this.getPredictionTargetMean(inst);
                double[] prediction = new double[predictionP.length];
                for (int i = 0; i < predictionP.length; ++i) {
                    prediction[i] = this.errorP.getValue(i) < this.errorM.getValue(i) ? predictionP[i] : predictionM[i];
                }
                return prediction;
            }
            return this.getPredictionTargetMean(inst);
        }

        public void checkForSplit() {
            if (this.learningWeight - this.examplesSeenAtLastSplitEvaluation >= (double)this.tree.gracePeriodOption.getValue()) {
                int index = this.parent != null ? this.parent.getChildIndex(this) : 0;
                this.tree.attemptToSplit(this, this.parent, index);
                this.examplesSeenAtLastSplitEvaluation = this.learningWeight;
            }
        }

        @Override
        public void describeSubtree(StringBuilder out, int indent) {
            StringUtils.appendIndented(out, indent, "Leaf ");
            StringUtils.appendNewline(out);
            if (this.tree.buildingModelTree()) {
                this.learningModel.getModelDescription(out, indent + 2);
            } else {
                out.append("Leaf node");
                StringUtils.appendNewline(out);
            }
        }
    }

    public static abstract class Node
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected double weightSeenAtLastSplitEvaluation;
        public int ID;
        protected ISOUPTree tree;
        protected InnerNode parent;
        protected Node alternateTree;
        protected Node originalNode;
        protected boolean changeDetection = true;
        public DoubleVector examplesSeen = new DoubleVector();
        public DoubleVector sumOfValues = new DoubleVector();
        public DoubleVector sumOfSquares = new DoubleVector();
        public DoubleVector weightOfInputs;
        public DoubleVector sumOfInputValues;
        public DoubleVector sumOfInputSquares;

        public Node(ISOUPTree tree) {
            this.tree = tree;
            this.ID = tree.maxID;
        }

        public void copyStatistics(Node node) {
            this.examplesSeen = (DoubleVector)node.examplesSeen.copy();
            this.sumOfValues = (DoubleVector)node.sumOfValues.copy();
            this.sumOfSquares = (DoubleVector)node.sumOfSquares.copy();
            if (this.tree.runAsPCTOption.isSet()) {
                this.weightOfInputs = (DoubleVector)node.weightOfInputs.copy();
                this.sumOfInputValues = (DoubleVector)node.sumOfInputValues.copy();
                this.sumOfInputSquares = (DoubleVector)node.sumOfInputSquares.copy();
            }
        }

        public long calcByteSize() {
            long size = SizeOf.sizeOf(this) + SizeOf.sizeOf(this.sumOfSquares) + SizeOf.sizeOf(this.sumOfValues) + SizeOf.sizeOf(this.examplesSeen);
            if (this.tree.runAsPCTOption.isSet()) {
                size += SizeOf.sizeOf(this.sumOfInputSquares) + SizeOf.sizeOf(this.sumOfInputValues) + SizeOf.sizeOf(this.weightOfInputs);
            }
            return size;
        }

        public void setParent(InnerNode parent) {
            this.parent = parent;
        }

        public Node getParent() {
            return this.parent;
        }

        public void disableChangeDetection() {
            this.changeDetection = false;
        }

        public void restartChangeDetection() {
            this.changeDetection = true;
        }

        public void getDescription(StringBuilder sb, int i) {
        }

        public abstract double[] getPrediction(Instance var1);

        public void describeSubtree(StringBuilder out, int indent) {
            StringUtils.appendIndented(out, indent, "Leaf");
        }

        public int getLevel() {
            Node target = this;
            int level = 0;
            while (target.getParent() != null) {
                if (target.skipInLevelCount()) {
                    target = target.getParent();
                    continue;
                }
                ++level;
                target = target.getParent();
            }
            if (target.originalNode == null) {
                return level;
            }
            return level + this.originalNode.getLevel();
        }

        public void setChild(int parentBranch, Node node) {
        }

        public int getChildIndex(Node child) {
            return -1;
        }

        public int getNumSubtrees() {
            return 1;
        }

        protected boolean skipInLevelCount() {
            return false;
        }
    }

    private static class InstanceWrapper
    extends InstanceImpl {
        public InstanceWrapper(InstanceImpl inst) {
            super(inst);
        }

        public boolean isInputMissing(int index) {
            return this.instanceData.isMissing(this.instanceHeader.getInstanceInformation().inputAttributeIndex(index));
        }

        public boolean isOutputMissing(int index) {
            return this.instanceData.isMissing(this.instanceHeader.getInstanceInformation().outputAttributeIndex(index));
        }

        public boolean missingOutputs() {
            if (this.instanceHeader.numOutputAttributes() == 1) {
                return this.classIsMissing();
            }
            for (int i = 0; i < this.instanceHeader.numOutputAttributes(); ++i) {
                if (!this.isOutputMissing(i)) continue;
                return true;
            }
            return false;
        }
    }
}

