/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.multilabel.trees;

import com.github.javacliparser.MultiChoiceOption;
import java.util.List;
import java.util.Vector;
import moa.classifiers.multilabel.trees.ISOUPTree;
import moa.core.DoubleVector;

public class ISOUPTreeRF
extends ISOUPTree {
    private static final long serialVersionUID = 1L;
    public MultiChoiceOption subspaceSizeOption = new MultiChoiceOption("randomForestFunAttr", 'z', "The function of the number of input attribtues to use in the random forest construction.", new String[]{"sqrt", "log", "percent"}, new String[]{"Square root", "Logarithm", "10% percent"}, 0);
    public Integer subspaceSize = null;

    public int numRFAttrs() {
        if (this.subspaceSize == null) {
            switch (this.subspaceSizeOption.getChosenLabel()) {
                case "sqrt": {
                    this.subspaceSize = 1 + (int)Math.ceil(Math.sqrt(this.getModelContext().numInputAttributes()));
                }
                case "log": {
                    this.subspaceSize = 1 + (int)Math.ceil(Math.log(this.getModelContext().numInputAttributes()));
                }
                case "percent": {
                    this.subspaceSize = (int)Math.ceil(0.1 * (double)this.getModelContext().numInputAttributes());
                }
            }
        }
        return this.subspaceSize;
    }

    @Override
    public List<Integer> newInputIndexes() {
        int i;
        Vector<Integer> indexes = new Vector<Integer>();
        int numAttrs = this.getModelContext().numInputAttributes();
        for (i = 0; i < numAttrs; ++i) {
            indexes.add(i, i);
        }
        for (i = 0; i < this.numRFAttrs(); ++i) {
            int swap = i + this.classifierRandom.nextInt(numAttrs - i);
            int temp = (Integer)indexes.get(i);
            indexes.set(i, (Integer)indexes.get(swap));
            indexes.set(swap, temp);
        }
        return indexes.subList(0, this.numRFAttrs());
    }

    public DoubleVector getFeatureScores() {
        return this.getNodeFeatureScore(this.treeRoot);
    }

    public DoubleVector getNodeFeatureScore(ISOUPTree.Node node) {
        if (node instanceof ISOUPTree.SplitNode) {
            DoubleVector scores = new DoubleVector(new double[this.getModelContext().numInputAttributes()]);
            for (ISOUPTree.Node child : ((ISOUPTree.SplitNode)node).children) {
                scores.addValues(this.getNodeFeatureScore(child));
            }
            scores.setValue(((ISOUPTree.SplitNode)node).predicate.getAttributeIndex(), Math.pow(0.5, node.getLevel()));
            return scores;
        }
        return new DoubleVector();
    }
}

