/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.multilabel.attributeclassobservers;

import com.github.javacliparser.IntOption;
import java.io.Serializable;
import moa.classifiers.multilabel.core.splitcriteria.PCTWeightedICVarianceReduction;
import moa.classifiers.rules.core.NumericRulePredicate;
import moa.classifiers.rules.core.Utils;
import moa.classifiers.rules.multilabel.attributeclassobservers.NumericStatisticsObserver;
import moa.classifiers.rules.multilabel.core.AttributeExpansionSuggestion;
import moa.classifiers.rules.multilabel.core.splitcriteria.MultiLabelSplitCriterion;
import moa.core.DoubleVector;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.tasks.TaskMonitor;

public class MultiLabelBSTreePCT
extends AbstractOptionHandler
implements NumericStatisticsObserver {
    public IntOption maxNodesOption = new IntOption("maxNodesOption", 'z', "Maximum number of nodes", 2000, 0, Integer.MAX_VALUE);
    protected int maxNodes;
    protected int numNodes;
    private static final long serialVersionUID = 1L;
    protected Node root = null;
    protected DoubleVector[] leftTargetStatistics;
    protected DoubleVector[] rightTargetStatistics;
    protected DoubleVector[] leftInputStatistics;
    protected DoubleVector[] rightInputStatistics;

    public static double roundToSignificantFigures(double num, int n) {
        double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
        int power = n - (int)d;
        double magnitude = Math.pow(10.0, power);
        long shifted = (long)(num * magnitude);
        return (double)shifted / magnitude;
    }

    @Override
    public void observeAttribute(double inputAttributeValue, DoubleVector[] statistics) {
        throw new UnsupportedOperationException("This is an attribute observer used for PCTs and needs both input and output statistics.");
    }

    public void observeAttribute(double inputAttributeValue, DoubleVector[] targetStatistics, DoubleVector[] inputStatistics) {
        if (!Double.isNaN(inputAttributeValue)) {
            if (this.root == null) {
                this.root = new Node(inputAttributeValue, targetStatistics, inputStatistics);
                this.maxNodes = this.maxNodesOption.getValue();
            } else {
                this.root.observeAttribute(inputAttributeValue, targetStatistics, inputStatistics);
            }
        }
    }

    @Override
    public AttributeExpansionSuggestion getBestEvaluatedSplitSuggestion(MultiLabelSplitCriterion criterion, DoubleVector[] preSplitStatistics, int inputAttributeIndex) {
        throw new UnsupportedOperationException("This is an attribute observer used for PCTs and needs both input and output statistics.");
    }

    public AttributeExpansionSuggestion getBestEvaluatedSplitSuggestion(MultiLabelSplitCriterion criterion, DoubleVector[] preSplitTargetStatistics, DoubleVector[] preSplitInputStatistics, int inputAttributeIndex) {
        int i;
        int numOutputs = preSplitTargetStatistics.length;
        int numInputs = preSplitInputStatistics.length;
        this.leftTargetStatistics = new DoubleVector[numOutputs];
        this.rightTargetStatistics = new DoubleVector[numOutputs];
        this.leftInputStatistics = new DoubleVector[numInputs];
        this.rightInputStatistics = new DoubleVector[numInputs];
        for (i = 0; i < numOutputs; ++i) {
            this.leftTargetStatistics[i] = new DoubleVector(new double[preSplitTargetStatistics[i].numValues()]);
            this.rightTargetStatistics[i] = new DoubleVector(preSplitTargetStatistics[i]);
        }
        for (i = 0; i < numInputs; ++i) {
            this.leftInputStatistics[i] = new DoubleVector(new double[preSplitInputStatistics[i].numValues()]);
            this.rightInputStatistics[i] = new DoubleVector(preSplitInputStatistics[i]);
        }
        return this.searchForBestSplitOption(this.root, null, criterion, preSplitTargetStatistics, preSplitInputStatistics, inputAttributeIndex);
    }

    protected AttributeExpansionSuggestion searchForBestSplitOption(Node currentNode, AttributeExpansionSuggestion currentBestOption, MultiLabelSplitCriterion criterion, DoubleVector[] preSplitTargetStatistics, DoubleVector[] preSplitInputStatistics, int inputAttributeIndex) {
        int i;
        int i2;
        int i3;
        if (currentNode == null) {
            return currentBestOption;
        }
        if (currentNode.left != null) {
            currentBestOption = this.searchForBestSplitOption(currentNode.left, currentBestOption, criterion, preSplitTargetStatistics, preSplitInputStatistics, inputAttributeIndex);
        }
        for (i3 = 0; i3 < this.leftTargetStatistics.length; ++i3) {
            this.leftTargetStatistics[i3].addValues(currentNode.targetStatistics[i3]);
            this.rightTargetStatistics[i3].subtractValues(currentNode.targetStatistics[i3]);
        }
        for (i3 = 0; i3 < this.leftInputStatistics.length; ++i3) {
            this.leftInputStatistics[i3].addValues(currentNode.inputStatistics[i3]);
            this.rightInputStatistics[i3].subtractValues(currentNode.inputStatistics[i3]);
        }
        DoubleVector[][] postSplitTargetDists = new DoubleVector[this.leftTargetStatistics.length][2];
        DoubleVector[][] postSplitInputDists = new DoubleVector[this.leftInputStatistics.length][2];
        for (i2 = 0; i2 < this.leftTargetStatistics.length; ++i2) {
            postSplitTargetDists[i2] = new DoubleVector[2];
            postSplitTargetDists[i2][0] = this.leftTargetStatistics[i2];
            postSplitTargetDists[i2][1] = this.rightTargetStatistics[i2];
        }
        for (i2 = 0; i2 < this.leftInputStatistics.length; ++i2) {
            postSplitInputDists[i2] = new DoubleVector[2];
            postSplitInputDists[i2][0] = this.leftInputStatistics[i2];
            postSplitInputDists[i2][1] = this.rightInputStatistics[i2];
        }
        double merit = ((PCTWeightedICVarianceReduction)criterion).getMeritOfSplit(preSplitTargetStatistics, postSplitTargetDists, preSplitInputStatistics, postSplitInputDists);
        if (!Double.isNaN(merit) && (currentBestOption == null || merit > currentBestOption.merit)) {
            currentBestOption = new AttributeExpansionSuggestion(new NumericRulePredicate(inputAttributeIndex, currentNode.cutPoint, true), Utils.copy(postSplitTargetDists), merit);
        }
        if (currentNode.right != null) {
            currentBestOption = this.searchForBestSplitOption(currentNode.right, currentBestOption, criterion, preSplitTargetStatistics, preSplitInputStatistics, inputAttributeIndex);
        }
        for (i = 0; i < this.leftTargetStatistics.length; ++i) {
            this.leftTargetStatistics[i].subtractValues(currentNode.targetStatistics[i]);
            this.rightTargetStatistics[i].addValues(currentNode.targetStatistics[i]);
        }
        for (i = 0; i < this.leftInputStatistics.length; ++i) {
            this.leftInputStatistics[i].subtractValues(currentNode.inputStatistics[i]);
            this.rightInputStatistics[i].addValues(currentNode.inputStatistics[i]);
        }
        return currentBestOption;
    }

    @Override
    public String getPurposeString() {
        return "Stores statistics for all output and input attributes for a giver input attribute.";
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }

    protected class Node
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private double cutPoint;
        private DoubleVector[] targetStatistics;
        private DoubleVector[] inputStatistics;
        private Node left;
        private Node right;

        public Node(double inputAttributeValue, DoubleVector[] targetStatistics, DoubleVector[] inputStatistics) {
            int i;
            this.cutPoint = inputAttributeValue;
            int numOutputAttributes = targetStatistics.length;
            int numInputAttributes = inputStatistics.length;
            this.targetStatistics = new DoubleVector[numOutputAttributes];
            this.inputStatistics = new DoubleVector[numInputAttributes];
            for (i = 0; i < numOutputAttributes; ++i) {
                this.targetStatistics[i] = targetStatistics[i] != null ? new DoubleVector(targetStatistics[i]) : new DoubleVector();
            }
            for (i = 0; i < numInputAttributes; ++i) {
                this.inputStatistics[i] = new DoubleVector(inputStatistics[i]);
            }
        }

        public void observeAttribute(double inputAttributeValue, DoubleVector[] targetStatistics, DoubleVector[] inputStatistics) {
            if (inputAttributeValue == this.cutPoint) {
                int i;
                for (i = 0; i < targetStatistics.length; ++i) {
                    if (targetStatistics[i] == null) continue;
                    this.targetStatistics[i].addValues(targetStatistics[i]);
                }
                for (i = 0; i < inputStatistics.length; ++i) {
                    this.inputStatistics[i].addValues(inputStatistics[i]);
                }
            } else if (inputAttributeValue < this.cutPoint) {
                if (this.left == null) {
                    if (MultiLabelBSTreePCT.this.numNodes < MultiLabelBSTreePCT.this.maxNodes) {
                        this.left = new Node(inputAttributeValue, targetStatistics, inputStatistics);
                        ++MultiLabelBSTreePCT.this.numNodes;
                    }
                } else {
                    this.left.observeAttribute(inputAttributeValue, targetStatistics, inputStatistics);
                }
            } else if (this.right == null) {
                if (MultiLabelBSTreePCT.this.numNodes < MultiLabelBSTreePCT.this.maxNodes) {
                    this.right = new Node(inputAttributeValue, targetStatistics, inputStatistics);
                    ++MultiLabelBSTreePCT.this.numNodes;
                }
            } else {
                this.right.observeAttribute(inputAttributeValue, targetStatistics, inputStatistics);
            }
        }
    }
}

