/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.dstream;

import com.github.javacliparser.FloatOption;
import com.yahoo.labs.samoa.instances.Instance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import moa.cluster.CFCluster;
import moa.cluster.Clustering;
import moa.clusterers.AbstractClusterer;
import moa.clusterers.dstream.CharacteristicVector;
import moa.clusterers.dstream.DensityGrid;
import moa.clusterers.dstream.GridCluster;
import moa.core.Measurement;

public class Dstream
extends AbstractClusterer {
    private static final long serialVersionUID = 8759754409276716725L;
    private static final int NO_CLASS = -1;
    private static final int SPARSE = 0;
    private static final int TRANSITIONAL = 1;
    private static final int DENSE = 2;
    public FloatOption decayFactorOption = new FloatOption("decayFactor", 'd', "The decay factor, lambda, in (0,1)", 0.998, 0.001, 0.999);
    public FloatOption cmOption = new FloatOption("Cm", 'm', "Controls the threshold for dense grids, > 1", 3.0, 1.001, Double.MAX_VALUE);
    public FloatOption clOption = new FloatOption("Cl", 'l', "Controls the threshold for sparse grids, in (0,1)", 0.8, 0.001, 0.999);
    public FloatOption betaOption = new FloatOption("Beta", 'b', "Adjusts the window of protection for renaming previously deleted grids as sporadic, > 0", 0.3, 0.001, Double.MAX_VALUE);
    private int currTime;
    private int gap;
    private double decayFactor;
    private double cm;
    private double cl;
    private double beta;
    private double dm;
    private double dl;
    private int d;
    private int N;
    private boolean initialized;
    private HashMap<DensityGrid, CharacteristicVector> grid_list;
    private HashMap<DensityGrid, Integer> deleted_grids;
    private ArrayList<GridCluster> cluster_list;
    private ArrayList<GridCluster> newClusterList;
    private int[] minVals;
    private int[] maxVals;

    @Override
    public boolean isRandomizable() {
        return false;
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        return null;
    }

    @Override
    public Clustering getClusteringResult() {
        Clustering c = new Clustering();
        for (GridCluster gc : this.cluster_list) {
            c.add(gc);
        }
        return c;
    }

    @Override
    public void resetLearningImpl() {
        this.setCurrTime(0);
        this.decayFactor = this.decayFactorOption.getValue();
        this.cm = this.cmOption.getValue();
        this.cl = this.clOption.getValue();
        this.beta = this.betaOption.getValue();
        this.initialized = false;
        this.grid_list = new HashMap();
        this.deleted_grids = new HashMap();
        this.cluster_list = new ArrayList();
        this.gap = 1;
        this.dm = -1.0;
        this.dl = -1.0;
        this.d = -1;
        this.N = -1;
        this.minVals = null;
        this.maxVals = null;
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        DensityGrid dg;
        int i;
        boolean recalculateN = false;
        if (!this.initialized) {
            this.d = inst.numAttributes();
            this.minVals = new int[this.d];
            this.maxVals = new int[this.d];
            for (i = 0; i < this.d; ++i) {
                if (!inst.attribute(i).isNumeric()) continue;
                this.maxVals[i] = (int)inst.value(i);
                this.minVals[i] = (int)inst.value(i);
            }
            recalculateN = true;
            this.initialized = true;
        }
        int[] g = new int[this.d];
        for (i = 0; i < this.d; ++i) {
            if (inst.attribute(i).isNumeric()) {
                g[i] = (int)inst.value(i);
                if (g[i] > this.maxVals[i]) {
                    this.maxVals[i] = g[i];
                    recalculateN = true;
                    continue;
                }
                if (g[i] >= this.minVals[i]) continue;
                this.minVals[i] = g[i];
                recalculateN = true;
                continue;
            }
            g[i] = (int)inst.value(i);
        }
        if (recalculateN) {
            int n = 1;
            for (int i2 = 0; i2 < this.d; ++i2) {
                if (inst.attribute(i2).isNominal()) {
                    n *= inst.attribute(i2).numValues();
                    continue;
                }
                n *= 3 + this.maxVals[i2] - this.minVals[i2];
            }
            this.N = n;
            this.dl = this.cl / ((double)this.N * (1.0 - this.decayFactor));
            this.dm = this.cm / ((double)this.N * (1.0 - this.decayFactor));
            double optionA = this.cl / this.cm;
            double optionB = ((double)this.N - this.cm) / ((double)this.N - this.cl);
            this.gap = (int)Math.floor(Math.log(Math.max(optionA, optionB)) / Math.log(this.getDecayFactor()));
            if (this.gap == 0) {
                this.gap = 1;
            }
        }
        if (!this.grid_list.containsKey(dg = new DensityGrid(g))) {
            CharacteristicVector cv;
            if (this.deleted_grids.containsKey(dg)) {
                cv = new CharacteristicVector(this.getCurrTime(), this.deleted_grids.get(dg), 1.0, -1, false, this.getDL(), this.getDM());
                this.deleted_grids.remove(dg);
            } else {
                cv = new CharacteristicVector(this.getCurrTime(), -1, 1.0, -1, false, this.getDL(), this.getDM());
            }
            this.grid_list.put(dg, cv);
        } else {
            CharacteristicVector cv = this.grid_list.get(dg);
            cv.densityWithNew(this.getCurrTime(), this.getDecayFactor());
            cv.setUpdateTime(this.getCurrTime());
            this.grid_list.put(dg, cv);
        }
        if (this.getCurrTime() != 0 && this.getCurrTime() % this.gap == 0) {
            if (this.getCurrTime() == this.gap) {
                this.initialClustering();
            } else {
                this.removeSporadic();
                this.adjustClustering();
            }
        }
        this.incCurrTime();
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void initialClustering() {
        boolean changesMade;
        this.updateGridListDensity();
        Iterator<Map.Entry<DensityGrid, CharacteristicVector>> glIter = this.grid_list.entrySet().iterator();
        HashMap<DensityGrid, CharacteristicVector> newGL = new HashMap<DensityGrid, CharacteristicVector>();
        while (glIter.hasNext()) {
            Map.Entry<DensityGrid, CharacteristicVector> grid = glIter.next();
            DensityGrid dg = grid.getKey();
            CharacteristicVector cvOfG = grid.getValue();
            if (cvOfG.getAttribute() == 2) {
                int gridClass = this.cluster_list.size();
                cvOfG.setLabel(gridClass);
                GridCluster gc = new GridCluster(dg, new ArrayList<CFCluster>(), gridClass);
                gc.addGrid(dg);
                this.cluster_list.add(gc);
            } else {
                cvOfG.setLabel(-1);
            }
            newGL.put(dg, cvOfG);
        }
        this.grid_list = newGL;
        while (changesMade = this.adjustLabels()) {
        }
    }

    private boolean adjustLabels() {
        for (GridCluster c : this.cluster_list) {
            for (Map.Entry<DensityGrid, Boolean> grid : c.getGrids().entrySet()) {
                DensityGrid dg = grid.getKey();
                Boolean inside = grid.getValue();
                if (inside.booleanValue()) continue;
                for (DensityGrid dgprime : dg.getNeighbours()) {
                    int class2;
                    if (!this.grid_list.containsKey(dgprime)) continue;
                    CharacteristicVector cv1 = this.grid_list.get(dg);
                    CharacteristicVector cv2 = this.grid_list.get(dgprime);
                    int class1 = cv1.getLabel();
                    if (class1 == (class2 = cv2.getLabel())) continue;
                    if (class2 != -1) {
                        if (this.cluster_list.get(class1).getWeight() < this.cluster_list.get(class2).getWeight()) {
                            this.mergeClusters(class1, class2);
                        } else {
                            this.mergeClusters(class2, class1);
                        }
                        return true;
                    }
                    if (!cv2.isTransitional(this.dm, this.dl)) continue;
                    cv2.setLabel(class1);
                    c.addGrid(dgprime);
                    this.cluster_list.set(class1, c);
                    this.grid_list.put(dg, cv2);
                    return true;
                }
            }
        }
        return false;
    }

    private void adjustClustering() {
        this.updateGridListDensity();
        boolean changesMade = false;
        while (changesMade = this.inspectChangedGrids()) {
        }
    }

    private boolean inspectChangedGrids() {
        HashMap<DensityGrid, CharacteristicVector> glNew = new HashMap<DensityGrid, CharacteristicVector>();
        Iterator<Map.Entry<DensityGrid, CharacteristicVector>> gridIter = this.grid_list.entrySet().iterator();
        while (gridIter.hasNext() && glNew.isEmpty()) {
            Map.Entry<DensityGrid, CharacteristicVector> grid = gridIter.next();
            DensityGrid dg = grid.getKey();
            CharacteristicVector cv = grid.getValue();
            int dgClass = cv.getLabel();
            if (!cv.isAttChanged() || dg.isVisited()) continue;
            dg.setVisited(true);
            glNew.put(dg, cv);
            if (cv.getAttribute() == 0) {
                glNew.putAll(this.adjustForSparseGrid(dg, cv, dgClass));
                continue;
            }
            if (cv.getAttribute() == 2) {
                glNew.putAll(this.adjustForDenseGrid(dg, cv, dgClass));
                continue;
            }
            glNew.putAll(this.adjustForTransitionalGrid(dg, cv, dgClass));
        }
        if (!glNew.isEmpty()) {
            this.grid_list.putAll(glNew);
            this.cleanClusters();
            return true;
        }
        return false;
    }

    private HashMap<DensityGrid, CharacteristicVector> adjustForSparseGrid(DensityGrid dg, CharacteristicVector cv, int dgClass) {
        HashMap<DensityGrid, CharacteristicVector> glNew = new HashMap<DensityGrid, CharacteristicVector>();
        if (dgClass != -1) {
            GridCluster gc = this.cluster_list.get(dgClass);
            gc.removeGrid(dg);
            cv.setLabel(-1);
            glNew.put(dg, cv);
            this.cluster_list.set(dgClass, gc);
            if (gc.getWeight() > 0.0 && !gc.isConnected()) {
                glNew.putAll(this.recluster(gc));
            }
        }
        return glNew;
    }

    private HashMap<DensityGrid, CharacteristicVector> recluster(GridCluster gc) {
        boolean changesMade;
        HashMap<DensityGrid, CharacteristicVector> glNew = new HashMap<DensityGrid, CharacteristicVector>();
        Iterator<Map.Entry<DensityGrid, Boolean>> gcIter = gc.getGrids().entrySet().iterator();
        this.newClusterList = new ArrayList();
        while (gcIter.hasNext()) {
            Map.Entry<DensityGrid, Boolean> grid = gcIter.next();
            DensityGrid dg = grid.getKey();
            CharacteristicVector cvOfG = this.grid_list.get(dg);
            if (cvOfG.getAttribute() == 2) {
                int gridClass = this.newClusterList.size();
                cvOfG.setLabel(gridClass);
                GridCluster newClus = new GridCluster(dg, new ArrayList<CFCluster>(), gridClass);
                newClus.addGrid(dg);
                this.newClusterList.add(newClus);
            } else {
                cvOfG.setLabel(-1);
            }
            glNew.put(dg, cvOfG);
        }
        do {
            changesMade = false;
            HashMap<DensityGrid, CharacteristicVector> glAdjusted = this.adjustNewLabels(glNew);
            if (glAdjusted.isEmpty()) continue;
            glNew.putAll(glAdjusted);
            changesMade = true;
        } while (changesMade);
        gc.getGrids().clear();
        this.cluster_list.set(gc.getClusterLabel(), gc);
        this.cluster_list.addAll(this.newClusterList);
        return glNew;
    }

    private HashMap<DensityGrid, CharacteristicVector> adjustNewLabels(HashMap<DensityGrid, CharacteristicVector> glNew) {
        Iterator<GridCluster> newClusIter = this.newClusterList.iterator();
        HashMap<DensityGrid, CharacteristicVector> glAdjusted = new HashMap<DensityGrid, CharacteristicVector>();
        while (newClusIter.hasNext()) {
            GridCluster c = newClusIter.next();
            for (Map.Entry<DensityGrid, Boolean> grid : c.getGrids().entrySet()) {
                DensityGrid dg = grid.getKey();
                Boolean inside = grid.getValue();
                if (inside.booleanValue()) continue;
                for (DensityGrid dgprime : dg.getNeighbours()) {
                    int class2;
                    if (!glNew.containsKey(dgprime)) continue;
                    CharacteristicVector cv1 = glNew.get(dg);
                    CharacteristicVector cv2 = glNew.get(dgprime);
                    int class1 = cv1.getLabel();
                    if (class1 == (class2 = cv2.getLabel())) continue;
                    GridCluster c1 = this.newClusterList.get(class1);
                    if (class2 != -1) {
                        GridCluster c2 = this.newClusterList.get(class2);
                        if (c1.getWeight() < c2.getWeight()) {
                            glAdjusted.putAll(this.mergeNewClusters(glNew, class1, class2));
                        } else {
                            glAdjusted.putAll(this.mergeNewClusters(glNew, class2, class1));
                        }
                        return glAdjusted;
                    }
                    if (!cv2.isTransitional(this.dm, this.dl)) continue;
                    cv2.setLabel(class1);
                    c1.addGrid(dgprime);
                    this.newClusterList.set(class1, c1);
                    glAdjusted.put(dgprime, cv2);
                    return glAdjusted;
                }
            }
        }
        return glAdjusted;
    }

    private HashMap<DensityGrid, CharacteristicVector> mergeNewClusters(HashMap<DensityGrid, CharacteristicVector> glNew, int smallClus, int bigClus) {
        for (Map.Entry<DensityGrid, CharacteristicVector> grid : glNew.entrySet()) {
            DensityGrid dg = grid.getKey();
            CharacteristicVector cv = grid.getValue();
            if (cv.getLabel() != smallClus) continue;
            cv.setLabel(bigClus);
            glNew.put(dg, cv);
        }
        GridCluster bGC = this.newClusterList.get(bigClus);
        bGC.absorbCluster(this.newClusterList.get(smallClus));
        this.newClusterList.set(bigClus, bGC);
        this.newClusterList.remove(smallClus);
        glNew = this.cleanNewClusters(glNew);
        return glNew;
    }

    private HashMap<DensityGrid, CharacteristicVector> adjustForDenseGrid(DensityGrid dg, CharacteristicVector cv, int dgClass) {
        GridCluster ch;
        DensityGrid hChosen = new DensityGrid(dg);
        double hChosenSize = -1.0;
        int hClass = -1;
        int hChosenClass = -1;
        Iterator<DensityGrid> dgNeighbourhood = dg.getNeighbours().iterator();
        HashMap<DensityGrid, CharacteristicVector> glNew = new HashMap<DensityGrid, CharacteristicVector>();
        while (dgNeighbourhood.hasNext()) {
            DensityGrid dgH = dgNeighbourhood.next();
            if (!this.grid_list.containsKey(dgH) || (hClass = this.grid_list.get(dgH).getLabel()) == -1 || !((ch = this.cluster_list.get(hClass)).getWeight() > hChosenSize)) continue;
            hChosenSize = ch.getWeight();
            hChosenClass = hClass;
            hChosen = new DensityGrid(dgH);
        }
        if (hChosenClass != -1 && hChosenClass != dgClass) {
            ch = this.cluster_list.get(hChosenClass);
            if (this.grid_list.get(hChosen).getAttribute() == 2) {
                if (dgClass == -1) {
                    cv.setLabel(hChosenClass);
                    glNew.put(dg, cv);
                    ch.addGrid(dg);
                    this.cluster_list.set(hChosenClass, ch);
                } else {
                    double gSize = this.cluster_list.get(dgClass).getWeight();
                    if (gSize <= hChosenSize) {
                        this.mergeClusters(dgClass, hChosenClass);
                    } else {
                        this.mergeClusters(hChosenClass, dgClass);
                    }
                }
            } else if (this.grid_list.get(hChosen).getAttribute() == 1) {
                GridCluster c;
                double gSize;
                if (dgClass == -1 && !ch.isInside(hChosen, dg).booleanValue()) {
                    cv.setLabel(hChosenClass);
                    glNew.put(dg, cv);
                    ch.addGrid(dg);
                    this.cluster_list.set(hChosenClass, ch);
                } else if (dgClass != -1 && (gSize = (c = this.cluster_list.get(dgClass)).getWeight()) >= hChosenSize) {
                    ch.removeGrid(hChosen);
                    c.addGrid(hChosen);
                    CharacteristicVector cvhChosen = this.grid_list.get(hChosen);
                    cvhChosen.setLabel(dgClass);
                    glNew.put(hChosen, cvhChosen);
                    this.cluster_list.set(hChosenClass, ch);
                    this.cluster_list.set(dgClass, c);
                }
            }
        } else if (dgClass == -1) {
            int newClass = this.cluster_list.size();
            GridCluster c = new GridCluster(dg, new ArrayList<CFCluster>(), newClass);
            c.addGrid(dg);
            this.cluster_list.add(c);
            cv.setLabel(newClass);
            glNew.put(dg, cv);
            for (DensityGrid dghprime : dg.getNeighbours()) {
                CharacteristicVector cvhprime;
                if (!this.grid_list.containsKey(dghprime) || c.getGrids().containsKey(dghprime) || (cvhprime = this.grid_list.get(dghprime)).getAttribute() != 1) continue;
                c.addGrid(dghprime);
                cvhprime.setLabel(newClass);
                glNew.put(dghprime, cvhprime);
            }
            this.cluster_list.set(newClass, c);
        }
        return glNew;
    }

    private HashMap<DensityGrid, CharacteristicVector> adjustForTransitionalGrid(DensityGrid dg, CharacteristicVector cv, int dgClass) {
        GridCluster ch;
        double hChosenSize = 0.0;
        int hClass = -1;
        int hChosenClass = -1;
        Iterator<DensityGrid> dgNeighbourhood = dg.getNeighbours().iterator();
        HashMap<DensityGrid, CharacteristicVector> glNew = new HashMap<DensityGrid, CharacteristicVector>();
        while (dgNeighbourhood.hasNext()) {
            DensityGrid dgH = dgNeighbourhood.next();
            if (!this.grid_list.containsKey(dgH) || (hClass = this.grid_list.get(dgH).getLabel()) == -1 || !((ch = this.cluster_list.get(hClass)).getWeight() > hChosenSize) || ch.isInside(dg, dg).booleanValue()) continue;
            hChosenSize = ch.getWeight();
            hChosenClass = hClass;
        }
        if (hChosenClass != -1 && hChosenClass != dgClass) {
            ch = this.cluster_list.get(hChosenClass);
            ch.addGrid(dg);
            this.cluster_list.set(hChosenClass, ch);
            if (dgClass != -1) {
                GridCluster c = this.cluster_list.get(dgClass);
                c.removeGrid(dg);
                this.cluster_list.set(dgClass, c);
            }
            cv.setLabel(hChosenClass);
            glNew.put(dg, cv);
        }
        return glNew;
    }

    private void cleanClusters() {
        Iterator<GridCluster> clusIter = this.cluster_list.iterator();
        ArrayList<GridCluster> toRem = new ArrayList<GridCluster>();
        while (clusIter.hasNext()) {
            GridCluster c = clusIter.next();
            if (c.getWeight() != 0.0) continue;
            toRem.add(c);
        }
        if (!toRem.isEmpty()) {
            clusIter = toRem.iterator();
            while (clusIter.hasNext()) {
                this.cluster_list.remove(clusIter.next());
            }
        }
        for (GridCluster c : this.cluster_list) {
            int index = this.cluster_list.indexOf(c);
            c.setClusterLabel(index);
            this.cluster_list.set(index, c);
            Iterator<Map.Entry<DensityGrid, Boolean>> gridsOfClus = c.getGrids().entrySet().iterator();
            while (gridsOfClus.hasNext()) {
                DensityGrid dg = gridsOfClus.next().getKey();
                CharacteristicVector cv = this.grid_list.get(dg);
                if (cv == null) {
                    System.out.println("Warning, cv is null for " + dg.toString() + " from cluster " + index + ".");
                    this.printGridList();
                    this.printGridClusters();
                }
                cv.setLabel(index);
                this.grid_list.put(dg, cv);
            }
        }
    }

    private HashMap<DensityGrid, CharacteristicVector> cleanNewClusters(HashMap<DensityGrid, CharacteristicVector> glNew) {
        Iterator<GridCluster> clusIter = this.newClusterList.iterator();
        ArrayList<GridCluster> toRem = new ArrayList<GridCluster>();
        while (clusIter.hasNext()) {
            GridCluster c = clusIter.next();
            if (c.getWeight() != 0.0) continue;
            toRem.add(c);
        }
        if (!toRem.isEmpty()) {
            clusIter = toRem.iterator();
            while (clusIter.hasNext()) {
                this.newClusterList.remove(clusIter.next());
            }
        }
        for (GridCluster c : this.newClusterList) {
            int index = this.newClusterList.indexOf(c);
            c.setClusterLabel(index);
            Iterator<Map.Entry<DensityGrid, Boolean>> gridsOfClus = c.getGrids().entrySet().iterator();
            while (gridsOfClus.hasNext()) {
                DensityGrid dg = gridsOfClus.next().getKey();
                CharacteristicVector cv = glNew.get(dg);
                cv.setLabel(index);
                glNew.put(dg, cv);
            }
        }
        return glNew;
    }

    private void removeSporadic() {
        Iterator<Map.Entry<DensityGrid, CharacteristicVector>> glIter = this.grid_list.entrySet().iterator();
        HashMap<DensityGrid, CharacteristicVector> newGL = new HashMap<DensityGrid, CharacteristicVector>();
        ArrayList<DensityGrid> remGL = new ArrayList<DensityGrid>();
        while (glIter.hasNext()) {
            Map.Entry<DensityGrid, CharacteristicVector> grid = glIter.next();
            DensityGrid dg = grid.getKey();
            CharacteristicVector cv = grid.getValue();
            if (cv.isSporadic()) {
                if (this.getCurrTime() - cv.getUpdateTime() >= this.gap) {
                    int dgClass = cv.getLabel();
                    if (dgClass != -1) {
                        this.cluster_list.get(dgClass).removeGrid(dg);
                    }
                    remGL.add(dg);
                    continue;
                }
                cv.setSporadic(this.checkIfSporadic(cv));
                newGL.put(dg, cv);
                continue;
            }
            cv.setSporadic(this.checkIfSporadic(cv));
            newGL.put(dg, cv);
        }
        this.grid_list.putAll(newGL);
        for (DensityGrid sporadicDG : remGL) {
            this.deleted_grids.put(sporadicDG, new Integer(this.getCurrTime()));
            this.grid_list.remove(sporadicDG);
        }
    }

    private boolean checkIfSporadic(CharacteristicVector cv) {
        return cv.getCurrGridDensity(this.getCurrTime(), this.getDecayFactor()) < this.densityThresholdFunction(cv.getDensityTimeStamp(), this.cl, this.getDecayFactor(), this.N) && (cv.getRemoveTime() == -1 || (double)this.getCurrTime() >= (1.0 + this.beta) * (double)cv.getRemoveTime());
    }

    private double densityThresholdFunction(int tg, double cl, double decayFactor, int N) {
        return cl * (1.0 - Math.pow(decayFactor, (double)(this.getCurrTime() - tg) + 1.0)) / ((double)N * (1.0 - decayFactor));
    }

    private void mergeClusters(int smallClus, int bigClus) {
        for (Map.Entry<DensityGrid, CharacteristicVector> grid : this.grid_list.entrySet()) {
            DensityGrid dg = grid.getKey();
            CharacteristicVector cv = grid.getValue();
            if (cv.getLabel() != smallClus) continue;
            cv.setLabel(bigClus);
            this.grid_list.put(dg, cv);
        }
        GridCluster bGC = this.cluster_list.get(bigClus);
        bGC.absorbCluster(this.cluster_list.get(smallClus));
        this.cluster_list.set(bigClus, bGC);
        this.cluster_list.remove(smallClus);
        this.cleanClusters();
    }

    private void updateGridListDensity() {
        for (Map.Entry<DensityGrid, CharacteristicVector> grid : this.grid_list.entrySet()) {
            DensityGrid dg = grid.getKey();
            CharacteristicVector cvOfG = grid.getValue();
            dg.setVisited(false);
            cvOfG.updateGridDensity(this.getCurrTime(), this.getDecayFactor(), this.getDL(), this.getDM());
            this.grid_list.put(dg, cvOfG);
        }
    }

    public int getCurrTime() {
        return this.currTime;
    }

    private void setCurrTime(int t) {
        this.currTime = t;
    }

    private void incCurrTime() {
        ++this.currTime;
    }

    public double getDecayFactor() {
        return this.decayFactor;
    }

    public double getDM() {
        return this.dm;
    }

    public double getDL() {
        return this.dl;
    }

    public void printInst(Instance inst) {
        for (int i = 0; i < inst.numAttributes(); ++i) {
            System.out.print(inst.value(i) + " ");
        }
    }

    public void printDStreamState() {
        System.out.println("State of D-Stream algorithm");
        System.out.println("Time Gap: " + this.gap + ", Decay Factor: " + this.decayFactor);
        System.out.println("C_m: " + this.cm + ", C_l: " + this.cl);
        System.out.println("D_m: " + this.dm + ", D_l: " + this.dl);
        System.out.println("Beta: " + this.beta);
    }

    public void printGridList() {
        System.out.println("Grid List. Size " + this.grid_list.size() + ".");
        for (Map.Entry<DensityGrid, CharacteristicVector> grid : this.grid_list.entrySet()) {
            DensityGrid dg = grid.getKey();
            CharacteristicVector cv = grid.getValue();
            if (cv.getAttribute() == 0) continue;
            double dtf = this.densityThresholdFunction(cv.getUpdateTime(), this.cl, this.getDecayFactor(), this.N);
            System.out.println(dg.toString() + " " + cv.toString() + " // Density Threshold Function = " + dtf);
        }
    }

    public void printGridClusters() {
        System.out.println("List of Clusters. Total " + this.cluster_list.size() + ".");
        for (GridCluster gc : this.cluster_list) {
            System.out.println(gc.getClusterLabel() + ": " + gc.getWeight() + " {" + gc.toString() + "}");
        }
    }

    @Override
    public void adjustParameters() {
        this.decayFactor = this.decayFactorOption.getValue();
        this.cm = this.cmOption.getValue();
        this.cl = this.clOption.getValue();
        this.beta = this.betaOption.getValue();
    }
}

