/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.meta;

import com.github.javacliparser.Option;
import com.github.javacliparser.Options;
import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.Instances;
import java.util.Arrays;
import moa.cluster.Cluster;
import moa.cluster.Clustering;
import moa.cluster.SphereCluster;
import moa.clusterers.AbstractClusterer;
import moa.clusterers.Clusterer;
import moa.clusterers.meta.AlgorithmConfiguration;
import moa.clusterers.meta.BooleanParameter;
import moa.clusterers.meta.CategoricalParameter;
import moa.clusterers.meta.IParameter;
import moa.clusterers.meta.IntegerParameter;
import moa.clusterers.meta.NumericalParameter;
import moa.clusterers.meta.OrdinalParameter;
import moa.clusterers.meta.ParameterConfiguration;
import moa.core.AutoExpandVector;
import moa.options.ClassOption;

public class Algorithm {
    public String algorithm;
    public IParameter[] parameters;
    public AbstractClusterer clusterer;
    public Attribute[] attributes;
    public double prediction;
    public double performanceMeasure;
    public boolean preventRemoval;
    public boolean isDefault;

    public Algorithm(Algorithm x, double lambda, double reset, boolean keepCurrentModel, boolean reinitialiseWithClusters, int verbose) {
        this.algorithm = x.algorithm;
        this.attributes = x.attributes;
        this.parameters = new IParameter[x.parameters.length];
        this.preventRemoval = x.preventRemoval;
        this.isDefault = false;
        for (int i = 0; i < x.parameters.length; ++i) {
            this.parameters[i] = x.parameters[i].copy();
            this.parameters[i].sampleNewConfig(lambda, reset, verbose);
        }
        if (keepCurrentModel) {
            try {
                this.clusterer = (AbstractClusterer)x.clusterer.copy();
            }
            catch (RuntimeException e) {
                if (verbose >= 2) {
                    System.out.println("Copy failed for " + x.clusterer.getCLICreationString(Clusterer.class) + "! Reinitialise instead.");
                }
                this.clusterer = x.clusterer;
                keepCurrentModel = false;
            }
        } else {
            this.clusterer = x.clusterer;
        }
        this.adjustAlgorithm(keepCurrentModel, reinitialiseWithClusters, verbose);
    }

    public Algorithm(AlgorithmConfiguration x) {
        this.algorithm = x.algorithm;
        this.parameters = new IParameter[x.parameters.length];
        this.preventRemoval = false;
        this.isDefault = true;
        this.attributes = new Attribute[x.parameters.length];
        for (int i = 0; i < x.parameters.length; ++i) {
            IParameter param;
            ParameterConfiguration paramConfig = x.parameters[i];
            if (paramConfig.type.equals("numeric") || paramConfig.type.equals("float") || paramConfig.type.equals("real")) {
                this.parameters[i] = param = new NumericalParameter(paramConfig);
                this.attributes[i] = new Attribute(((NumericalParameter)param).getParameter());
                continue;
            }
            if (paramConfig.type.equals("integer")) {
                this.parameters[i] = param = new IntegerParameter(paramConfig);
                this.attributes[i] = new Attribute(((IntegerParameter)param).getParameter());
                continue;
            }
            if (paramConfig.type.equals("nominal") || paramConfig.type.equals("categorical") || paramConfig.type.equals("factor")) {
                this.parameters[i] = param = new CategoricalParameter(paramConfig);
                this.attributes[i] = new Attribute(((CategoricalParameter)param).getParameter(), Arrays.asList(((CategoricalParameter)param).getRange()));
                continue;
            }
            if (paramConfig.type.equals("boolean") || paramConfig.type.equals("flag")) {
                this.parameters[i] = param = new BooleanParameter(paramConfig);
                this.attributes[i] = new Attribute(((BooleanParameter)param).getParameter(), Arrays.asList(((BooleanParameter)param).getRange()));
                continue;
            }
            if (paramConfig.type.equals("ordinal")) {
                this.parameters[i] = param = new OrdinalParameter(paramConfig);
                this.attributes[i] = new Attribute(((OrdinalParameter)param).getParameter());
                continue;
            }
            throw new RuntimeException("Unknown parameter type: '" + paramConfig.type + "'. Available options are 'numeric', 'integer', 'nominal', 'boolean' or 'ordinal'");
        }
        this.init();
    }

    public void init() {
        StringBuilder commandLine = new StringBuilder();
        commandLine.append(this.algorithm);
        for (IParameter param : this.parameters) {
            commandLine.append(" ");
            commandLine.append(param.getCLIString());
        }
        ClassOption opt = new ClassOption("", ' ', "", Clusterer.class, commandLine.toString());
        this.clusterer = (AbstractClusterer)opt.materializeObject(null, null);
        this.clusterer.prepareForUse();
    }

    public void adjustAlgorithm(boolean keepCurrentModel, boolean reinitialiseWithClusters, int verbose) {
        if (keepCurrentModel) {
            StringBuilder commandLine = new StringBuilder();
            for (IParameter param : this.parameters) {
                commandLine.append(param.getCLIString());
            }
            Options opts = this.clusterer.getOptions();
            for (IParameter param : this.parameters) {
                Option opt = opts.getOption(param.getParameter().charAt(0));
                opt.setValueViaCLIString(param.getCLIValueString());
            }
            try {
                this.clusterer.adjustParameters();
                if (verbose >= 2) {
                    System.out.println("Changed: " + this.clusterer.getCLICreationString(Clusterer.class));
                }
            }
            catch (UnsupportedOperationException e) {
                if (verbose >= 2) {
                    System.out.println("Cannot change parameters of " + this.algorithm + " on the fly, reset instead.");
                }
                this.adjustAlgorithm(false, reinitialiseWithClusters, verbose);
            }
        } else {
            AutoExpandVector<Cluster> clusters = null;
            if (reinitialiseWithClusters) {
                Clustering result = this.clusterer.getMicroClusteringResult();
                if (result == null) {
                    result = this.clusterer.getClusteringResult();
                }
                if (result == null) {
                    reinitialiseWithClusters = false;
                } else {
                    clusters = result.getClusteringCopy();
                }
            }
            this.init();
            if (verbose >= 2) {
                System.out.println("Initialise: " + this.clusterer.getCLICreationString(Clusterer.class));
            }
            if (reinitialiseWithClusters) {
                if (verbose >= 2) {
                    System.out.println("Train with existing clusters.");
                }
                for (Cluster cluster : clusters) {
                    SphereCluster c = (SphereCluster)cluster;
                    DenseInstance inst = new DenseInstance(c.getWeight(), c.getCenter());
                    inst.setDataset(new Instances(null, this.attributes, 0));
                    this.clusterer.trainOnInstance(inst);
                }
            }
        }
    }

    public double[] getParamVector(int padding) {
        double[] params = new double[this.parameters.length + padding];
        int pos = 0;
        for (IParameter param : this.parameters) {
            params[pos++] = param.getValue();
        }
        return params;
    }
}

