/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.meta;

import com.yahoo.labs.samoa.instances.Attribute;
import java.util.ArrayList;
import java.util.HashMap;
import moa.clusterers.meta.EnsembleClustererAbstract;
import moa.clusterers.meta.IParameter;
import moa.clusterers.meta.ParameterConfiguration;

public class BooleanParameter
implements IParameter {
    private String parameter;
    private int numericValue;
    private String value;
    private String[] range = new String[]{"false", "true"};
    private Attribute attribute;
    private ArrayList<Double> probabilities;
    private boolean optimise;

    public BooleanParameter(BooleanParameter x) {
        this.parameter = x.parameter;
        this.numericValue = x.numericValue;
        this.value = x.value;
        this.attribute = x.attribute;
        this.optimise = x.optimise;
        if (this.optimise) {
            this.range = (String[])x.range.clone();
            this.probabilities = new ArrayList<Double>(x.probabilities);
        }
    }

    public BooleanParameter(ParameterConfiguration x) {
        int i;
        this.parameter = x.parameter;
        this.value = String.valueOf(x.value);
        for (i = 0; i < this.range.length; ++i) {
            if (!this.range[i].equals(this.value)) continue;
            this.numericValue = i;
        }
        this.attribute = new Attribute(x.parameter);
        this.optimise = x.optimise;
        if (this.optimise) {
            this.probabilities = new ArrayList(2);
            for (i = 0; i < 2; ++i) {
                this.probabilities.add(0.5);
            }
        }
    }

    @Override
    public BooleanParameter copy() {
        return new BooleanParameter(this);
    }

    @Override
    public String getCLIString() {
        if (this.numericValue == 1) {
            return "-" + this.parameter;
        }
        return "";
    }

    @Override
    public String getCLIValueString() {
        if (this.numericValue == 1) {
            return "";
        }
        return null;
    }

    @Override
    public double getValue() {
        return this.numericValue;
    }

    @Override
    public String getParameter() {
        return this.parameter;
    }

    public String[] getRange() {
        return this.range;
    }

    @Override
    public void sampleNewConfig(double lambda, double reset, int verbose) {
        int i;
        if (!this.optimise) {
            return;
        }
        if (Math.random() < reset) {
            for (int i2 = 0; i2 < this.probabilities.size(); ++i2) {
                this.probabilities.set(i2, 1.0 / (double)this.probabilities.size());
            }
        }
        HashMap<Integer, Double> map = new HashMap<Integer, Double>();
        for (int i3 = 0; i3 < this.probabilities.size(); ++i3) {
            map.put(i3, this.probabilities.get(i3));
        }
        this.numericValue = EnsembleClustererAbstract.sampleProportionally(map, true);
        String newValue = this.range[this.numericValue];
        if (verbose >= 3) {
            System.out.print("Sample new configuration for boolean parameter -" + this.parameter + " with probabilities");
            for (int i4 = 0; i4 < this.probabilities.size(); ++i4) {
                System.out.print(" " + this.probabilities.get(i4));
            }
            System.out.println("\t=>\t -" + this.parameter + " " + newValue);
        }
        this.value = newValue;
        this.probabilities.set(this.numericValue, this.probabilities.get(this.numericValue) * (2.0 - Math.pow(2.0, -1.0 * lambda)));
        double sum = 0.0;
        for (i = 0; i < this.probabilities.size(); ++i) {
            sum += this.probabilities.get(i).doubleValue();
        }
        for (i = 0; i < this.probabilities.size(); ++i) {
            this.probabilities.set(i, this.probabilities.get(i) / sum);
        }
    }
}

