/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.meta;

import com.yahoo.labs.samoa.instances.Attribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import moa.clusterers.meta.EnsembleClustererAbstract;
import moa.clusterers.meta.IParameter;
import moa.clusterers.meta.ParameterConfiguration;

public class CategoricalParameter
implements IParameter {
    private String parameter;
    private int numericValue;
    private String value;
    private String[] range;
    private Attribute attribute;
    private ArrayList<Double> probabilities;
    private boolean optimise;

    public CategoricalParameter(CategoricalParameter x) {
        this.parameter = x.parameter;
        this.numericValue = x.numericValue;
        this.value = x.value;
        this.attribute = x.attribute;
        this.optimise = x.optimise;
        if (this.optimise) {
            this.range = (String[])x.range.clone();
            this.probabilities = new ArrayList<Double>(x.probabilities);
        }
    }

    public CategoricalParameter(ParameterConfiguration x) {
        this.parameter = x.parameter;
        this.value = String.valueOf(x.value);
        this.attribute = new Attribute(x.parameter, Arrays.asList(this.range));
        this.optimise = x.optimise;
        if (this.optimise) {
            int i;
            this.range = new String[x.range.length];
            for (i = 0; i < x.range.length; ++i) {
                this.range[i] = String.valueOf(x.range[i]);
                if (!this.range[i].equals(this.value)) continue;
                this.numericValue = i;
            }
            this.probabilities = new ArrayList(x.range.length);
            for (i = 0; i < x.range.length; ++i) {
                this.probabilities.add(1.0 / (double)x.range.length);
            }
        }
    }

    @Override
    public CategoricalParameter copy() {
        return new CategoricalParameter(this);
    }

    @Override
    public String getCLIString() {
        return "-" + this.parameter + " " + this.value;
    }

    @Override
    public String getCLIValueString() {
        return "" + this.value;
    }

    @Override
    public double getValue() {
        return this.numericValue;
    }

    @Override
    public String getParameter() {
        return this.parameter;
    }

    public String[] getRange() {
        return this.range;
    }

    @Override
    public void sampleNewConfig(double lambda, double reset, int verbose) {
        int i;
        if (!this.optimise) {
            return;
        }
        if (Math.random() < reset) {
            for (int i2 = 0; i2 < this.probabilities.size(); ++i2) {
                this.probabilities.set(i2, 1.0 / (double)this.probabilities.size());
            }
        }
        HashMap<Integer, Double> map = new HashMap<Integer, Double>();
        for (int i3 = 0; i3 < this.probabilities.size(); ++i3) {
            map.put(i3, this.probabilities.get(i3));
        }
        this.numericValue = EnsembleClustererAbstract.sampleProportionally(map, true);
        String newValue = this.range[this.numericValue];
        if (verbose >= 3) {
            System.out.print("Sample new configuration for nominal parameter -" + this.parameter + "with probabilities");
            for (int i4 = 0; i4 < this.probabilities.size(); ++i4) {
                System.out.print(" " + this.probabilities.get(i4));
            }
            System.out.println("\t=>\t -" + this.parameter + " " + newValue);
        }
        this.value = newValue;
        this.probabilities.set(this.numericValue, this.probabilities.get(this.numericValue) * (2.0 - Math.pow(2.0, -1.0 * lambda)));
        double sum = 0.0;
        for (i = 0; i < this.probabilities.size(); ++i) {
            sum += this.probabilities.get(i).doubleValue();
        }
        for (i = 0; i < this.probabilities.size(); ++i) {
            this.probabilities.set(i, this.probabilities.get(i) / sum);
        }
    }
}

