/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.meta;

import com.github.javacliparser.FileOption;
import com.google.gson.Gson;
import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.Instances;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import moa.classifiers.meta.AdaptiveRandomForestRegressor;
import moa.cluster.Clustering;
import moa.clusterers.AbstractClusterer;
import moa.clusterers.Clusterer;
import moa.clusterers.meta.Algorithm;
import moa.clusterers.meta.ConfStream;
import moa.clusterers.meta.GeneralConfiguration;
import moa.core.Measurement;
import moa.core.ObjectRepository;
import moa.evaluation.MeasureCollection;
import moa.gui.visualization.DataPoint;
import moa.options.ClassOption;
import moa.streams.clustering.RandomRBFGeneratorEvents;
import moa.tasks.TaskMonitor;

public abstract class EnsembleClustererAbstract
extends AbstractClusterer {
    private static final long serialVersionUID = 1L;
    int iteration;
    int instancesSeen;
    int iter;
    public int bestModel;
    public ArrayList<Algorithm> ensemble;
    public ArrayList<Algorithm> candidateEnsemble;
    public ArrayList<DataPoint> windowPoints;
    HashMap<String, AdaptiveRandomForestRegressor> ARFregs = new HashMap();
    GeneralConfiguration settings;
    ArrayList<Double> performanceMeasures;
    int verbose = 0;
    protected ExecutorService executor;
    int numberOfCores;
    public FileOption fileOption = new FileOption("ConfigurationFile", 'f', "Configuration file in json format.", "settings.json", ".json", false);

    public void init() {
        this.fileOption.getFile();
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        return null;
    }

    @Override
    public Clustering getClusteringResult() {
        return null;
    }

    @Override
    public void resetLearningImpl() {
        this.instancesSeen = 0;
        this.bestModel = 0;
        this.iter = 0;
        this.windowPoints = new ArrayList(this.settings.windowSize);
        for (AdaptiveRandomForestRegressor ARFreg : this.ARFregs.values()) {
            ARFreg.resetLearning();
        }
        for (int i = 0; i < this.ensemble.size(); ++i) {
            this.ensemble.get(i).init();
        }
        this.numberOfCores = this.settings.numberOfCores == -1 ? Runtime.getRuntime().availableProcessors() : this.settings.numberOfCores;
        this.executor = Executors.newFixedThreadPool(this.numberOfCores);
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        if (inst.classIndex() < inst.numAttributes()) {
            inst.deleteAttributeAt(inst.classIndex());
        }
        DataPoint point = new DataPoint(inst, this.instancesSeen);
        this.windowPoints.add(point);
        ++this.instancesSeen;
        if (this.numberOfCores == 1) {
            int i;
            for (i = 0; i < this.ensemble.size(); ++i) {
                this.ensemble.get((int)i).clusterer.trainOnInstance(inst);
            }
            if (this.settings.useTestEnsemble && this.candidateEnsemble.size() > 0) {
                for (i = 0; i < this.candidateEnsemble.size(); ++i) {
                    this.candidateEnsemble.get((int)i).clusterer.trainOnInstance(inst);
                }
            }
        } else {
            EnsembleRunnable trainer;
            int i;
            ArrayList<EnsembleRunnable> trainers = new ArrayList<EnsembleRunnable>();
            for (i = 0; i < this.ensemble.size(); ++i) {
                trainer = new EnsembleRunnable(this.ensemble.get((int)i).clusterer, inst);
                trainers.add(trainer);
            }
            if (this.settings.useTestEnsemble && this.candidateEnsemble.size() > 0) {
                for (i = 0; i < this.candidateEnsemble.size(); ++i) {
                    trainer = new EnsembleRunnable(this.candidateEnsemble.get((int)i).clusterer, inst);
                    trainers.add(trainer);
                }
            }
            try {
                this.executor.invokeAll(trainers);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Could not call invokeAll() on training threads.");
            }
        }
        if (this.instancesSeen % this.settings.windowSize == 0) {
            if (this.verbose >= 1) {
                System.out.println(" ");
                System.out.println("-------------- Processed " + this.instancesSeen + " Instances --------------");
            }
            this.updateConfiguration();
        }
    }

    protected void updateConfiguration() {
        if (this.verbose >= 2) {
            System.out.println(" ");
            System.out.println("---- Evaluate performance of current ensemble:");
        }
        this.evaluatePerformance();
        if (this.settings.useTestEnsemble) {
            this.promoteCandidatesIntoEnsemble();
        }
        if (this.verbose >= 1) {
            System.out.println("Clusterer " + this.bestModel + " (" + this.ensemble.get((int)this.bestModel).clusterer.getCLICreationString(Clusterer.class) + ") is the active clusterer with performance: " + this.performanceMeasures.get(this.bestModel));
        }
        this.generateNewConfigurations();
        this.windowPoints.clear();
        ++this.iter;
    }

    protected void evaluatePerformance() {
        HashMap<String, Double> bestPerformanceValMap = new HashMap<String, Double>();
        HashMap<String, Integer> bestPerformanceIdxMap = new HashMap<String, Integer>();
        HashMap<String, Integer> algorithmCount = new HashMap<String, Integer>();
        this.performanceMeasures = new ArrayList(this.ensemble.size());
        double bestPerformance = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.ensemble.size(); ++i) {
            String algorithm;
            this.predictPerformance(this.ensemble.get(i));
            double performance = this.computePerformanceMeasure(this.ensemble.get(i));
            this.performanceMeasures.add(performance);
            if (performance > bestPerformance) {
                this.bestModel = i;
                bestPerformance = performance;
            }
            if (this.verbose >= 1) {
                System.out.println(i + ") " + this.ensemble.get((int)i).clusterer.getCLICreationString(Clusterer.class) + "\t => \t performance: " + performance);
            }
            if (!bestPerformanceIdxMap.containsKey(algorithm = this.ensemble.get((int)i).algorithm) || performance > bestPerformanceValMap.get(algorithm)) {
                bestPerformanceValMap.put(algorithm, performance);
                bestPerformanceIdxMap.put(algorithm, i);
            }
            algorithmCount.put(algorithm, algorithmCount.getOrDefault(algorithm, 0) + 1);
            this.trainRegressor(this.ensemble.get(i), performance);
        }
        this.updateRemovalFlags(bestPerformanceValMap, bestPerformanceIdxMap, algorithmCount);
    }

    protected double computePerformanceMeasure(Algorithm algorithm) {
        double performance;
        ClassOption opt = new ClassOption("", ' ', "", MeasureCollection.class, this.settings.performanceMeasure);
        MeasureCollection performanceMeasure = (MeasureCollection)opt.materializeObject(null, null);
        Clustering result = null;
        if (!this.settings.evaluateMacro) {
            result = algorithm.clusterer.getMicroClusteringResult();
        }
        if (this.settings.evaluateMacro || result == null) {
            if (this.verbose >= 2) {
                System.out.println("Micro-Cluster not available for " + algorithm.clusterer.getCLICreationString(Clusterer.class) + ". Try Macro-Clusters instead.");
            }
            result = algorithm.clusterer.getClusteringResult();
        }
        if (result == null) {
            throw new RuntimeException("Neither micro- nor macro clusters available for " + algorithm.clusterer.getCLICreationString(Clusterer.class));
        }
        if (result.size() == 0 || result.size() == 1) {
            performance = -1.0;
        } else {
            try {
                performanceMeasure.evaluateClusteringPerformance(result, null, this.windowPoints);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not compute clustering performance.");
            }
            performance = performanceMeasure.getLastValue(0);
            if (Double.isNaN(performance)) {
                performance = -1.0;
            }
        }
        algorithm.performanceMeasure = performance;
        return performance;
    }

    protected void promoteCandidatesIntoEnsemble() {
        for (int i = 0; i < this.candidateEnsemble.size(); ++i) {
            Algorithm newAlgorithm = this.candidateEnsemble.get(i);
            this.predictPerformance(newAlgorithm);
            double performance = this.computePerformanceMeasure(newAlgorithm);
            if (this.verbose >= 1) {
                System.out.println("Test " + i + ") " + newAlgorithm.clusterer.getCLICreationString(Clusterer.class) + "\t => \t Performance: " + performance);
            }
            if (this.ensemble.size() < this.settings.ensembleSize) {
                if (this.verbose >= 1) {
                    System.out.println("Promote " + newAlgorithm.clusterer.getCLICreationString(Clusterer.class) + " from test ensemble to the ensemble as new configuration");
                }
                this.performanceMeasures.add(newAlgorithm.performanceMeasure);
                this.ensemble.add(newAlgorithm);
                continue;
            }
            if (!(performance > EnsembleClustererAbstract.getWorstSolution(this.performanceMeasures))) continue;
            HashMap<Integer, Double> replace = this.getReplaceMap(this.performanceMeasures);
            if (replace.size() == 0) {
                return;
            }
            int replaceIdx = EnsembleClustererAbstract.sampleProportionally(replace, !this.settings.performanceMeasureMaximisation);
            if (this.verbose >= 1) {
                System.out.println("Promote " + newAlgorithm.clusterer.getCLICreationString(Clusterer.class) + " from test ensemble to the ensemble by replacing " + replaceIdx);
            }
            this.performanceMeasures.set(replaceIdx, newAlgorithm.performanceMeasure);
            this.ensemble.set(replaceIdx, newAlgorithm);
        }
    }

    protected void trainRegressor(Algorithm algortihm, double performance) {
        double[] params = algortihm.getParamVector(1);
        params[params.length - 1] = performance;
        DenseInstance inst = new DenseInstance(1.0, params);
        Instances dataset = new Instances(null, algortihm.attributes, 0);
        dataset.setClassIndex(dataset.numAttributes());
        inst.setDataset(dataset);
        this.ARFregs.get(algortihm.algorithm).trainOnInstanceImpl(inst);
    }

    protected void updateRemovalFlags(HashMap<String, Double> bestPerformanceValMap, HashMap<String, Integer> bestPerformanceIdxMap, HashMap<String, Integer> algorithmCount) {
        for (Algorithm algorithm : this.ensemble) {
            algorithm.preventRemoval = false;
        }
        if (this.settings.keepGlobalIncumbent) {
            this.ensemble.get((int)this.bestModel).preventRemoval = true;
        }
        if (this.settings.keepAlgorithmIncumbents) {
            Iterator<Object> iterator = bestPerformanceIdxMap.values().iterator();
            while (iterator.hasNext()) {
                int idx = (Integer)iterator.next();
                this.ensemble.get((int)idx).preventRemoval = true;
            }
        }
        if (this.settings.keepInitialConfigurations) {
            for (Algorithm algorithm : this.ensemble) {
                if (!algorithm.isDefault) continue;
                algorithm.preventRemoval = true;
            }
        }
        if (this.settings.preventAlgorithmDeath) {
            for (Algorithm algorithm : this.ensemble) {
                if (algorithmCount.get(algorithm.algorithm) != 1) continue;
                algorithm.preventRemoval = true;
            }
        }
    }

    protected void generateNewConfigurations() {
        if (this.settings.useTestEnsemble) {
            this.candidateEnsemble.clear();
        }
        for (int z = 0; z < this.settings.newConfigurations; ++z) {
            if (this.verbose == 2) {
                System.out.println(" ");
                System.out.println("---- Sample new configuration " + z + ":");
            }
            int parentIdx = this.sampleParent(this.performanceMeasures);
            Algorithm newAlgorithm = this.sampleNewConfiguration(this.performanceMeasures, parentIdx);
            if (this.settings.useTestEnsemble) {
                if (this.verbose >= 1) {
                    System.out.println("Based on " + parentIdx + " add " + newAlgorithm.clusterer.getCLICreationString(Clusterer.class) + " to test ensemble");
                }
                this.candidateEnsemble.add(newAlgorithm);
                continue;
            }
            double prediction = this.predictPerformance(newAlgorithm);
            if (this.verbose >= 1) {
                System.out.println("Based on " + parentIdx + " predict: " + newAlgorithm.clusterer.getCLICreationString(Clusterer.class) + "\t => \t Performance: " + prediction);
            }
            if (Double.isNaN(prediction)) {
                return;
            }
            if (this.ensemble.size() < this.settings.ensembleSize) {
                if (this.verbose >= 1) {
                    System.out.println("Add configuration as new algorithm.");
                }
                this.ensemble.add(newAlgorithm);
                this.performanceMeasures.add(prediction);
                continue;
            }
            if (!(prediction > EnsembleClustererAbstract.getWorstSolution(this.performanceMeasures))) continue;
            HashMap<Integer, Double> replace = this.getReplaceMap(this.performanceMeasures);
            if (replace.size() == 0) {
                return;
            }
            int replaceIdx = EnsembleClustererAbstract.sampleProportionally(replace, !this.settings.performanceMeasureMaximisation);
            if (this.verbose >= 1) {
                System.out.println("Replace algorithm: " + replaceIdx);
            }
            this.performanceMeasures.set(replaceIdx, prediction);
            this.ensemble.set(replaceIdx, newAlgorithm);
        }
    }

    protected int sampleParent(ArrayList<Double> silhs) {
        HashMap<Integer, Double> parents = new HashMap<Integer, Double>();
        for (int i = 0; i < silhs.size(); ++i) {
            parents.put(i, silhs.get(i));
        }
        int parentIdx = EnsembleClustererAbstract.sampleProportionally(parents, this.settings.performanceMeasureMaximisation);
        return parentIdx;
    }

    protected Algorithm sampleNewConfiguration(ArrayList<Double> silhs, int parentIdx) {
        if (this.verbose >= 2) {
            System.out.println("Selected Configuration " + parentIdx + " as parent: " + this.ensemble.get((int)parentIdx).clusterer.getCLICreationString(Clusterer.class));
        }
        Algorithm newAlgorithm = new Algorithm(this.ensemble.get(parentIdx), this.settings.lambda, this.settings.resetProbability, this.settings.keepCurrentModel, this.settings.reinitialiseWithClusters, this.verbose);
        return newAlgorithm;
    }

    protected double predictPerformance(Algorithm newAlgorithm) {
        double prediction;
        double[] params = newAlgorithm.getParamVector(0);
        DenseInstance newInst = new DenseInstance(1.0, params);
        Instances newDataset = new Instances(null, newAlgorithm.attributes, 0);
        newDataset.setClassIndex(newDataset.numAttributes());
        newInst.setDataset(newDataset);
        newAlgorithm.prediction = prediction = this.ARFregs.get(newAlgorithm.algorithm).getVotesForInstance(newInst)[0];
        return prediction;
    }

    HashMap<Integer, Double> getReplaceMap(ArrayList<Double> silhs) {
        int i;
        HashMap<Integer, Double> replace = new HashMap<Integer, Double>();
        double worst = EnsembleClustererAbstract.getWorstSolution(silhs);
        if (worst <= -1.0) {
            for (i = 0; i < this.ensemble.size(); ++i) {
                if (!(silhs.get(i) <= -1.0) || this.ensemble.get((int)i).preventRemoval) continue;
                replace.put(i, silhs.get(i));
            }
        }
        if (replace.size() == 0) {
            for (i = 0; i < this.ensemble.size(); ++i) {
                if (this.ensemble.get((int)i).preventRemoval) continue;
                replace.put(i, silhs.get(i));
            }
        }
        return replace;
    }

    static double getWorstSolution(ArrayList<Double> values) {
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < values.size(); ++i) {
            if (!(values.get(i) < min)) continue;
            min = values.get(i);
        }
        return min;
    }

    static int sampleProportionally(HashMap<Integer, Double> values, boolean maximisation) {
        if (!maximisation) {
            HashMap<Integer, Double> vals = new HashMap<Integer, Double>(values.size());
            for (int i : values.keySet()) {
                vals.put(i, -1.0 * values.get(i));
            }
            return EnsembleClustererAbstract.rouletteWheelSelection(vals);
        }
        return EnsembleClustererAbstract.rouletteWheelSelection(values);
    }

    static int rouletteWheelSelection(HashMap<Integer, Double> values) {
        double minVal = Double.POSITIVE_INFINITY;
        for (Double value : values.values()) {
            if (!(value < minVal)) continue;
            minVal = value;
        }
        double shift = Math.abs(minVal) - minVal;
        double completeWeight = 0.0;
        for (Double value : values.values()) {
            completeWeight += value + shift;
        }
        double r = Math.random() * completeWeight;
        double countWeight = 0.0;
        for (int j : values.keySet()) {
            if (!((countWeight += values.get(j) + shift) >= r)) continue;
            return j;
        }
        throw new RuntimeException("Sampling failed");
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }

    @Override
    public void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        try {
            int i;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.fileOption.getValue()));
            Gson gson = new Gson();
            this.settings = (GeneralConfiguration)gson.fromJson((Reader)bufferedReader, GeneralConfiguration.class);
            this.instancesSeen = 0;
            this.bestModel = 0;
            this.iter = 0;
            this.windowPoints = new ArrayList(this.settings.windowSize);
            this.ensemble = new ArrayList(this.settings.ensembleSize);
            for (i = 0; i < this.settings.algorithms.length; ++i) {
                this.ensemble.add(new Algorithm(this.settings.algorithms[i]));
            }
            if (this.settings.useTestEnsemble) {
                this.candidateEnsemble = new ArrayList(this.settings.newConfigurations);
            }
            for (i = 0; i < this.settings.algorithms.length; ++i) {
                AdaptiveRandomForestRegressor ARFreg = new AdaptiveRandomForestRegressor();
                ARFreg.prepareForUse();
                this.ARFregs.put(this.settings.algorithms[i].algorithm, ARFreg);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        super.prepareForUseImpl(monitor, repository);
    }

    public static void main(String[] args) throws Exception {
        RandomRBFGeneratorEvents stream = new RandomRBFGeneratorEvents();
        stream.prepareForUse();
        ConfStream confStream = new ConfStream();
        confStream.fileOption.setValue(System.getProperty("user.dir") + "/moa/src/main/java/moa/clusterers/meta/settings.json");
        confStream.prepareForUse();
        for (int i = 1; i < 5000; ++i) {
            Instance inst = stream.nextInstance().getData();
            confStream.trainOnInstanceImpl(inst);
        }
        Clustering micro = confStream.getMicroClusteringResult();
    }

    protected class EnsembleRunnable
    implements Runnable,
    Callable<Integer> {
        private final AbstractClusterer clusterer;
        private final Instance instance;

        public EnsembleRunnable(AbstractClusterer clusterer, Instance instance) {
            this.clusterer = clusterer;
            this.instance = instance;
        }

        @Override
        public void run() {
            this.clusterer.trainOnInstance(this.instance);
        }

        @Override
        public Integer call() throws Exception {
            this.run();
            return 0;
        }
    }
}

