/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.meta;

import com.yahoo.labs.samoa.instances.Attribute;
import moa.clusterers.meta.IParameter;
import moa.clusterers.meta.ParameterConfiguration;
import moa.clusterers.meta.TruncatedNormal;

public class IntegerParameter
implements IParameter {
    private String parameter;
    private int value;
    private int[] range;
    private double std;
    private Attribute attribute;
    private boolean optimise;

    public IntegerParameter(IntegerParameter x) {
        this.parameter = x.parameter;
        this.value = x.value;
        this.attribute = x.attribute;
        this.optimise = x.optimise;
        if (this.optimise) {
            this.range = (int[])x.range.clone();
            this.std = x.std;
        }
    }

    public IntegerParameter(ParameterConfiguration x) {
        this.parameter = x.parameter;
        this.value = (int)((Double)x.value).doubleValue();
        this.attribute = new Attribute(x.parameter);
        this.optimise = x.optimise;
        if (this.optimise) {
            this.range = new int[x.range.length];
            for (int i = 0; i < x.range.length; ++i) {
                this.range[i] = (int)((Double)x.range[i]).doubleValue();
            }
            this.std = (this.range[1] - this.range[0]) / 2;
        }
    }

    @Override
    public IntegerParameter copy() {
        return new IntegerParameter(this);
    }

    @Override
    public String getCLIString() {
        return "-" + this.parameter + " " + this.value;
    }

    @Override
    public String getCLIValueString() {
        return "" + this.value;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    @Override
    public String getParameter() {
        return this.parameter;
    }

    @Override
    public void sampleNewConfig(double lambda, double reset, int verbose) {
        if (!this.optimise) {
            return;
        }
        if (Math.random() < reset) {
            this.std = (this.range[1] - this.range[0]) / 2;
        }
        TruncatedNormal trncnormal = new TruncatedNormal(this.value, this.std, this.range[0], this.range[1]);
        int newValue = (int)Math.round(trncnormal.sample());
        if (verbose >= 3) {
            System.out.println("Sample new configuration for integer parameter -" + this.parameter + " with mean: " + this.value + ", std: " + this.std + ", lb: " + this.range[0] + ", ub: " + this.range[1] + "\t=>\t -" + this.parameter + " " + newValue);
        }
        this.value = newValue;
        this.std *= Math.pow(2.0, -1.0 * lambda);
    }
}

