/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.meta;

import com.yahoo.labs.samoa.instances.Attribute;
import moa.clusterers.meta.IParameter;
import moa.clusterers.meta.ParameterConfiguration;
import moa.clusterers.meta.TruncatedNormal;

public class NumericalParameter
implements IParameter {
    private String parameter;
    private double value;
    private double[] range;
    private double std;
    private Attribute attribute;
    private boolean optimise;

    public NumericalParameter(NumericalParameter x) {
        this.parameter = x.parameter;
        this.value = x.value;
        this.attribute = new Attribute(x.parameter);
        this.optimise = x.optimise;
        if (this.optimise) {
            this.range = (double[])x.range.clone();
            this.std = x.std;
        }
    }

    public NumericalParameter(ParameterConfiguration x) {
        this.parameter = x.parameter;
        this.value = (Double)x.value;
        this.attribute = new Attribute(x.parameter);
        this.optimise = x.optimise;
        if (this.optimise) {
            this.range = new double[x.range.length];
            for (int i = 0; i < x.range.length; ++i) {
                this.range[i] = (Double)x.range[i];
            }
            this.std = (this.range[1] - this.range[0]) / 2.0;
        }
    }

    @Override
    public NumericalParameter copy() {
        return new NumericalParameter(this);
    }

    @Override
    public String getCLIString() {
        return "-" + this.parameter + " " + this.value;
    }

    @Override
    public String getCLIValueString() {
        return "" + this.value;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public String getParameter() {
        return this.parameter;
    }

    @Override
    public void sampleNewConfig(double lambda, double reset, int verbose) {
        if (!this.optimise) {
            return;
        }
        if (Math.random() < reset) {
            this.std = (this.range[1] - this.range[0]) / 2.0;
        }
        TruncatedNormal trncnormal = new TruncatedNormal(this.value, this.std, this.range[0], this.range[1]);
        double newValue = trncnormal.sample();
        if (verbose >= 3) {
            System.out.println("Sample new configuration for numerical parameter -" + this.parameter + " with mean: " + this.value + ", std: " + this.std + ", lb: " + this.range[0] + ", ub: " + this.range[1] + "\t=>\t -" + this.parameter + " " + newValue);
        }
        this.value = newValue;
        this.std *= Math.pow(2.0, -1.0 * lambda);
    }
}

