/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.meta;

import com.yahoo.labs.samoa.instances.Attribute;
import moa.clusterers.meta.IParameter;
import moa.clusterers.meta.ParameterConfiguration;
import moa.clusterers.meta.TruncatedNormal;

public class OrdinalParameter
implements IParameter {
    private String parameter;
    private String value;
    private int numericValue;
    private String[] range;
    private double std;
    private Attribute attribute;
    private boolean optimise;

    public OrdinalParameter(OrdinalParameter x) {
        this.parameter = x.parameter;
        this.value = x.value;
        this.numericValue = x.numericValue;
        this.attribute = x.attribute;
        this.optimise = x.optimise;
        if (this.optimise) {
            this.range = (String[])x.range.clone();
            this.std = x.std;
        }
    }

    public OrdinalParameter(ParameterConfiguration x) {
        this.parameter = x.parameter;
        this.value = String.valueOf(x.value);
        this.attribute = new Attribute(x.parameter);
        this.optimise = x.optimise;
        if (this.optimise) {
            this.range = new String[x.range.length];
            for (int i = 0; i < x.range.length; ++i) {
                this.range[i] = String.valueOf(x.range[i]);
                if (!this.range[i].equals(this.value)) continue;
                this.numericValue = i;
            }
            this.std = (this.range.length - 0) / 2;
        }
    }

    @Override
    public OrdinalParameter copy() {
        return new OrdinalParameter(this);
    }

    @Override
    public String getCLIString() {
        return "-" + this.parameter + " " + this.value;
    }

    @Override
    public String getCLIValueString() {
        return "" + this.value;
    }

    @Override
    public double getValue() {
        return this.numericValue;
    }

    @Override
    public String getParameter() {
        return this.parameter;
    }

    @Override
    public void sampleNewConfig(double lambda, double reset, int verbose) {
        if (!this.optimise) {
            return;
        }
        if (Math.random() < reset) {
            double upper = this.range.length - 1;
            this.std = upper / 2.0;
        }
        TruncatedNormal trncnormal = new TruncatedNormal(this.numericValue, this.std, 0.0, this.range.length - 1);
        int newValue = (int)Math.round(trncnormal.sample());
        if (verbose >= 3) {
            System.out.println("Sample new configuration for ordinal parameter -" + this.parameter + " with mean: " + this.numericValue + ", std: " + this.std + ", lb: " + 0 + ", ub: " + (this.range.length - 1) + "\t=>\t -" + this.parameter + " " + this.range[newValue] + " (" + newValue + ")");
        }
        this.numericValue = newValue;
        this.value = this.range[this.numericValue];
        this.std *= Math.pow(2.0, -1.0 * lambda);
    }
}

