/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.meta;

import java.util.Random;
import umontreal.iro.lecuyer.probdist.NormalDist;

public class TruncatedNormal {
    double mean;
    double sd;
    double lb;
    double ub;
    double cdf_a;
    double Z;

    TruncatedNormal(double mean, double sd, double lb, double ub) {
        this.mean = mean;
        this.sd = sd;
        this.lb = lb;
        this.ub = ub;
        this.cdf_a = NormalDist.cdf01((double)((lb - mean) / sd));
        double cdf_b = NormalDist.cdf01((double)((ub - mean) / sd));
        this.Z = cdf_b - this.cdf_a;
    }

    public double sample() {
        Random random = new Random();
        double val = random.nextDouble() * this.Z + this.cdf_a;
        return this.mean + this.sd * NormalDist.inverseF01((double)val);
    }

    public static void main(String[] args) {
        TruncatedNormal trncnorm = new TruncatedNormal(0.0, 10.0, -5.0, 5.0);
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        double sum = 0.0;
        for (int i = 0; i < 100000; ++i) {
            double val = trncnorm.sample();
            sum += val;
            if (val > max) {
                max = val;
            }
            if (val < min) {
                min = val;
            }
            System.out.println(val);
        }
        System.out.println("Min: " + min);
        System.out.println("Max: " + max);
        System.out.println("Mean: " + sum / 100000.0);
    }
}

