/*
 * Decompiled with CFR 0.152.
 */
package moa.core;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nz.ac.waikato.cms.locator.ClassCache;
import nz.ac.waikato.cms.locator.ClassTraversal;
import nz.ac.waikato.cms.locator.FixedClassListTraversal;

public class AutoClassDiscovery {
    protected static final Map<String, String[]> cachedClassNames = new HashMap<String, String[]>();
    protected static ClassCache m_Cache;
    public static final String CLASS_LIST = "moa.classes";

    protected static synchronized void initCache() {
        if (m_Cache == null && (m_Cache = new ClassCache()).getClassnames("moa.classifiers.trees").isEmpty()) {
            InputStream inputStream = null;
            try {
                inputStream = m_Cache.getClass().getClassLoader().getResourceAsStream(CLASS_LIST);
                m_Cache = new ClassCache((ClassTraversal)new FixedClassListTraversal(inputStream));
            }
            catch (Exception e) {
                System.err.println("Failed to initialize class cache from fixed list (moa.classes)!");
                e.printStackTrace();
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static List<String> getAllClassNames() {
        ArrayList<String> result = new ArrayList<String>();
        Iterator pkgs = m_Cache.packages();
        while (pkgs.hasNext()) {
            String pkg = (String)pkgs.next();
            if (!pkg.startsWith("moa")) continue;
            Set classnames = m_Cache.getClassnames(pkg);
            result.addAll(classnames);
        }
        return result;
    }

    public static synchronized String[] findClassNames(String packageNameToSearch) {
        Object[] cached = cachedClassNames.get(packageNameToSearch);
        if (cached == null) {
            HashSet classNames = new HashSet();
            AutoClassDiscovery.initCache();
            Iterator iter = m_Cache.packages();
            while (iter.hasNext()) {
                String pkg = (String)iter.next();
                if (!pkg.equals(packageNameToSearch) && !pkg.startsWith(packageNameToSearch + ".")) continue;
                classNames.addAll(m_Cache.getClassnames(pkg));
            }
            cached = classNames.toArray(new String[classNames.size()]);
            Arrays.sort(cached);
            cachedClassNames.put(packageNameToSearch, (String[])cached);
        }
        return cached;
    }

    public static Class[] findClassesOfType(String packageNameToSearch, Class<?> typeDesired) {
        String[] classNames;
        ArrayList classesFound = new ArrayList();
        for (String className : classNames = AutoClassDiscovery.findClassNames(packageNameToSearch)) {
            if (!AutoClassDiscovery.isPublicConcreteClassOfType(className, typeDesired)) continue;
            try {
                classesFound.add(Class.forName(className));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return classesFound.toArray(new Class[classesFound.size()]);
    }

    public static boolean isPublicConcreteClassOfType(String className, Class<?> typeDesired) {
        Class<?> testClass = null;
        try {
            testClass = Class.forName(className);
        }
        catch (Exception e) {
            return false;
        }
        int classModifiers = testClass.getModifiers();
        return Modifier.isPublic(classModifiers) && !Modifier.isAbstract(classModifiers) && typeDesired.isAssignableFrom(testClass) && AutoClassDiscovery.hasEmptyConstructor(testClass);
    }

    public static boolean hasEmptyConstructor(Class<?> type) {
        try {
            type.getConstructor(new Class[0]);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        AutoClassDiscovery.initCache();
        List<String> allClassnames = AutoClassDiscovery.getAllClassNames();
        PrintStream out = System.out;
        if (args.length > 0) {
            out = new PrintStream(new File(args[0]));
        }
        Collections.sort(allClassnames);
        for (String clsname : allClassnames) {
            out.println(clsname);
        }
        out.flush();
        if (args.length > 0) {
            out.close();
        }
    }
}

