/*
 * Decompiled with CFR 0.152.
 */
package moa.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import moa.DoTask;
import moa.core.WekaUtils;
import moa.gui.AbstractTabPanel;
import moa.gui.GUIDefaults;
import moa.gui.LookAndFeel;
import nz.ac.waikato.cms.gui.core.BaseFlatSplitButton;
import nz.ac.waikato.cms.gui.core.GUIHelper;
import nz.ac.waikato.cms.gui.core.MultiPagePane;

public class GUI
extends JPanel {
    private static final long serialVersionUID = 1L;
    private MultiPagePane pagePane;

    public GUI() {
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.pagePane = new MultiPagePane();
        this.pagePane.setMaxPageCloseUndo(GUIDefaults.getMaxTabUndo());
        this.add((Component)this.pagePane, "Center");
        BaseFlatSplitButton buttonAdd = new BaseFlatSplitButton((Icon)GUIHelper.getIcon((String)"add.gif"));
        buttonAdd.setFont(this.getFont().deriveFont(0));
        this.pagePane.getButtonPanel().add((Component)buttonAdd);
        HashSet<String> defaultTabs = new HashSet<String>(Arrays.asList(GUIDefaults.getDefaultTabs()));
        String[] tabs = GUIDefaults.getTabs();
        boolean first = true;
        for (int i = 0; i < tabs.length; ++i) {
            try {
                String[] optionsStr = tabs[i].split(":");
                final String classname = optionsStr[0];
                AbstractTabPanel tabPanel = (AbstractTabPanel)Class.forName(classname).newInstance();
                if (defaultTabs.size() == 0 || defaultTabs.contains(classname)) {
                    this.pagePane.addPage(tabPanel.getTabTitle(), (Component)tabPanel);
                }
                AbstractAction action = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            AbstractTabPanel tab = (AbstractTabPanel)Class.forName(classname).newInstance();
                            GUI.this.pagePane.addPage(tab.getTabTitle(), (Component)tab);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                action.putValue("Name", tabPanel.getTabTitle());
                if (first) {
                    buttonAdd.setAction((Action)action);
                    first = false;
                    continue;
                }
                buttonAdd.add((Action)action);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.pagePane.setSelectedIndex(0);
    }

    public static void main(String[] args) {
        try {
            if (!DoTask.isJavaVersionOK() || !WekaUtils.isWekaVersionOK()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JFrame frame = new JFrame("MOA Graphical User Interface");
                    frame.setDefaultCloseOperation(3);
                    LookAndFeel.install();
                    GUI gui = new GUI();
                    frame.getContentPane().setLayout(new BorderLayout());
                    frame.getContentPane().add(gui);
                    frame.setSize(GUIDefaults.getFrameWidth(), GUIDefaults.getFrameHeight());
                    frame.setLocationRelativeTo(null);
                    frame.setVisible(true);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

