/*
 * Decompiled with CFR 0.152.
 */
package moa.gui;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;
import moa.gui.GUIDefaults;

public class LookAndFeel {
    public static final String KEY_LOOKANDFEEL = "LookAndFeel";
    public static final String WINDOWS_LNF = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    public static final String CROSSPLATFORM_LNF = "javax.swing.plaf.metal.MetalLookAndFeel";
    public static final String VALUE_SYSTEM = "system";
    public static final String VALUE_CROSSPLATFORM = "crossplatform";
    protected static Logger LOGGER = Logger.getLogger(LookAndFeel.class.getName());

    protected static boolean installJavaLookAndFeel(String lnf) {
        boolean result = true;
        switch (lnf) {
            case "": {
                LOGGER.info("Using built-in strategy for setting Look'n'Feel...");
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Throwable t) {
                    try {
                        UIManager.setLookAndFeel(WINDOWS_LNF);
                    }
                    catch (Throwable th) {
                        result = false;
                    }
                }
                break;
            }
            case "system": {
                LOGGER.info("Using system Look'n'Feel...");
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Throwable t) {
                    result = false;
                }
                break;
            }
            case "crossplatform": {
                LOGGER.info("Using cross-platform Look'n'Feel...");
                try {
                    UIManager.setLookAndFeel(CROSSPLATFORM_LNF);
                }
                catch (Throwable t) {
                    result = false;
                }
                break;
            }
            default: {
                LOGGER.info("Using Look'n'Feel class: " + lnf);
                try {
                    UIManager.setLookAndFeel(lnf);
                    break;
                }
                catch (Throwable t) {
                    LOGGER.severe("Failed to instantiate Look'n'Feel class: " + lnf);
                    result = false;
                }
            }
        }
        return result;
    }

    protected static boolean attemptInstallJavaLookAndFeel(String lnf) {
        boolean result = LookAndFeel.installJavaLookAndFeel(lnf);
        if (!result) {
            LOGGER.info("Falling back on cross-platform Look'n'Feel...");
            result = LookAndFeel.installJavaLookAndFeel(CROSSPLATFORM_LNF);
            if (!result) {
                LOGGER.severe("Failed to set cross-platform Look'n'Feel (javax.swing.plaf.metal.MetalLookAndFeel), which should always succeed!");
            }
        }
        return result;
    }

    public static void install() {
        String lnf = GUIDefaults.get(KEY_LOOKANDFEEL, "").trim();
        boolean success = LookAndFeel.attemptInstallJavaLookAndFeel(lnf);
        LOGGER.info("Setting Java Look'n'Feel: " + success);
    }

    static {
        LOGGER.setLevel(Level.INFO);
    }
}

