/*
 * Decompiled with CFR 0.152.
 */
package moa.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import moa.capabilities.Capability;
import moa.capabilities.CapabilityRequirement;
import moa.core.StringUtils;
import moa.gui.ClassOptionSelectionPanel;
import moa.gui.FileExtensionFilter;
import moa.gui.GUIUtils;
import moa.gui.LookAndFeel;
import moa.gui.PreviewPanel;
import moa.options.ClassOption;
import moa.options.OptionHandler;
import moa.tasks.ClassificationMainTask;
import moa.tasks.EvaluatePrequential;
import moa.tasks.MainTask;
import moa.tasks.Task;
import moa.tasks.TaskThread;
import nz.ac.waikato.cms.gui.core.BaseFileChooser;

public class TaskManagerPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int MILLISECS_BETWEEN_REFRESH = 600;
    public static String exportFileExtension = "log";
    protected MainTask currentTask = new EvaluatePrequential();
    protected List<TaskThread> taskList = new ArrayList<TaskThread>();
    protected JButton configureTaskButton = new JButton("Configure");
    protected JTextField taskDescField = new JTextField();
    protected JButton runTaskButton = new JButton("Run");
    protected JComboBox<String> viewModeList = new JComboBox<String>(new String[]{Capability.VIEW_LITE.toString(), Capability.VIEW_STANDARD.toString()});
    protected TaskTableModel taskTableModel;
    protected JTable taskTable;
    protected JButton pauseTaskButton = new JButton("Pause");
    protected JButton resumeTaskButton = new JButton("Resume");
    protected JButton cancelTaskButton = new JButton("Cancel");
    protected JButton deleteTaskButton = new JButton("Delete");
    protected PreviewPanel previewPanel;
    private Preferences prefs = Preferences.userRoot().node(this.getClass().getName());
    private final String PREF_NAME = "currentTask";
    private final String PREF_VIEW_MODE = "viewModeOption";

    public TaskManagerPanel() {
        this.currentTask = new EvaluatePrequential();
        String taskText = this.currentTask.getCLICreationString(MainTask.class);
        String propertyValue = this.prefs.get("currentTask", taskText);
        this.setTaskString(propertyValue, false);
        this.taskDescField.setEditable(false);
        final JTextField comp = this.taskDescField;
        this.taskDescField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 1 && (evt.getButton() == 3 || evt.getButton() == 1 && evt.isAltDown() && evt.isShiftDown())) {
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem item = new JMenuItem("Copy configuration to clipboard");
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TaskManagerPanel.this.copyClipBoardConfiguration();
                        }
                    });
                    menu.add(item);
                    item = new JMenuItem("Save selected tasks to file");
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            TaskManagerPanel.this.saveLogSelectedTasks();
                        }
                    });
                    menu.add(item);
                    item = new JMenuItem("Enter configuration...");
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            String newTaskString = JOptionPane.showInputDialog("Insert command line");
                            if (newTaskString != null) {
                                TaskManagerPanel.this.setTaskString(newTaskString);
                            }
                        }
                    });
                    menu.add(item);
                    menu.show(comp, evt.getX(), evt.getY());
                }
            }
        });
        JPanel configPanel = new JPanel();
        configPanel.setLayout(new BorderLayout());
        configPanel.add((Component)this.configureTaskButton, "West");
        configPanel.add((Component)this.taskDescField, "Center");
        JPanel runViewPanel = new JPanel();
        runViewPanel.setLayout(new BorderLayout());
        runViewPanel.add((Component)this.runTaskButton, "West");
        this.viewModeList.setPrototypeDisplayValue(Capability.VIEW_EXPERIMENTAL.toString() + "        ");
        runViewPanel.add(this.viewModeList, "East");
        configPanel.add((Component)runViewPanel, "East");
        this.viewModeList.setSelectedIndex(this.prefs.getInt("viewModeOption", 0));
        this.taskTableModel = new TaskTableModel();
        this.taskTable = new JTable(this.taskTableModel);
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        this.taskTable.getColumnModel().getColumn(1).setCellRenderer(centerRenderer);
        this.taskTable.getColumnModel().getColumn(2).setCellRenderer(centerRenderer);
        this.taskTable.getColumnModel().getColumn(4).setCellRenderer(new ProgressCellRenderer());
        JPanel controlPanel = new JPanel();
        controlPanel.add(this.pauseTaskButton);
        controlPanel.add(this.resumeTaskButton);
        controlPanel.add(this.cancelTaskButton);
        controlPanel.add(this.deleteTaskButton);
        this.setLayout(new BorderLayout());
        this.add((Component)configPanel, "North");
        this.add((Component)new JScrollPane(this.taskTable), "Center");
        this.add((Component)controlPanel, "South");
        this.taskTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                TaskManagerPanel.this.taskSelectionChanged();
            }
        });
        this.configureTaskButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CapabilityRequirement capReq = TaskManagerPanel.this.forViewSelection();
                ClassOptionSelectionPanel.setRequiredCapabilities(capReq);
                String newTaskString = ClassOptionSelectionPanel.showSelectClassDialog(TaskManagerPanel.this, "Configure task", ClassificationMainTask.class, TaskManagerPanel.this.currentTask.getCLICreationString(ClassificationMainTask.class), null);
                TaskManagerPanel.this.setTaskString(newTaskString);
                ClassOptionSelectionPanel.setRequiredCapabilities(null);
            }
        });
        this.viewModeList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TaskManagerPanel.this.storeSelectedViewMode();
            }
        });
        this.runTaskButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TaskManagerPanel.this.runTask((Task)((Object)TaskManagerPanel.this.currentTask.copy()));
            }
        });
        this.pauseTaskButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TaskManagerPanel.this.pauseSelectedTasks();
            }
        });
        this.resumeTaskButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TaskManagerPanel.this.resumeSelectedTasks();
            }
        });
        this.cancelTaskButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TaskManagerPanel.this.cancelSelectedTasks();
            }
        });
        this.deleteTaskButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TaskManagerPanel.this.deleteSelectedTasks();
            }
        });
        Timer updateListTimer = new Timer(600, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskManagerPanel.this.taskTable.repaint();
            }
        });
        updateListTimer.start();
        this.setPreferredSize(new Dimension(0, 200));
    }

    public void setPreviewPanel(PreviewPanel previewPanel) {
        this.previewPanel = previewPanel;
    }

    public void setTaskString(String cliString) {
        this.setTaskString(cliString, true);
    }

    public void setTaskString(String cliString, boolean storePreference) {
        try {
            this.currentTask = (MainTask)ClassOption.cliStringToObject(cliString, MainTask.class, null);
            String taskText = this.currentTask.getCLICreationString(MainTask.class);
            this.taskDescField.setText(taskText);
            if (storePreference) {
                this.prefs.put("currentTask", taskText);
            }
        }
        catch (Exception ex) {
            GUIUtils.showExceptionDialog(this, "Problem with task", ex);
        }
    }

    public void runTask(Task task) {
        TaskThread thread = new TaskThread(task);
        this.taskList.add(0, thread);
        this.taskTableModel.fireTableDataChanged();
        this.taskTable.setRowSelectionInterval(0, 0);
        thread.start();
    }

    public void taskSelectionChanged() {
        TaskThread[] selectedTasks = this.getSelectedTasks();
        if (selectedTasks.length == 1) {
            this.setTaskString(((OptionHandler)((Object)selectedTasks[0].getTask())).getCLICreationString(MainTask.class));
            if (this.previewPanel != null) {
                this.previewPanel.setTaskThreadToPreview(selectedTasks[0]);
            }
        } else {
            this.previewPanel.setTaskThreadToPreview(null);
        }
    }

    public TaskThread[] getSelectedTasks() {
        int[] selectedRows = this.taskTable.getSelectedRows();
        TaskThread[] selectedTasks = new TaskThread[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            selectedTasks[i] = this.taskList.get(selectedRows[i]);
        }
        return selectedTasks;
    }

    public void storeSelectedViewMode() {
        int selectedIndexMode = this.viewModeList.getSelectedIndex();
        this.prefs.putInt("viewModeOption", selectedIndexMode);
    }

    public void pauseSelectedTasks() {
        TaskThread[] selectedTasks;
        for (TaskThread thread : selectedTasks = this.getSelectedTasks()) {
            thread.pauseTask();
        }
    }

    public void resumeSelectedTasks() {
        TaskThread[] selectedTasks;
        for (TaskThread thread : selectedTasks = this.getSelectedTasks()) {
            thread.resumeTask();
        }
    }

    public void cancelSelectedTasks() {
        TaskThread[] selectedTasks;
        for (TaskThread thread : selectedTasks = this.getSelectedTasks()) {
            thread.cancelTask();
        }
    }

    public void deleteSelectedTasks() {
        TaskThread[] selectedTasks;
        for (TaskThread thread : selectedTasks = this.getSelectedTasks()) {
            thread.cancelTask();
            this.taskList.remove(thread);
        }
        this.taskTableModel.fireTableDataChanged();
    }

    public void copyClipBoardConfiguration() {
        StringSelection selection = new StringSelection(this.taskDescField.getText().trim());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, selection);
    }

    public void saveLogSelectedTasks() {
        TaskThread[] selectedTasks;
        String tasksLog = "";
        for (TaskThread thread : selectedTasks = this.getSelectedTasks()) {
            tasksLog = tasksLog + ((OptionHandler)((Object)thread.getTask())).getCLICreationString(MainTask.class) + "\n";
        }
        BaseFileChooser fileChooser = new BaseFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.addChoosableFileFilter((FileFilter)new FileExtensionFilter(exportFileExtension));
        if (fileChooser.showSaveDialog((Component)this) == 0) {
            File chosenFile = fileChooser.getSelectedFile();
            String fileName = chosenFile.getPath();
            if (!chosenFile.exists() && !fileName.endsWith(exportFileExtension)) {
                fileName = fileName + "." + exportFileExtension;
            }
            try {
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                out.write(tasksLog);
                out.close();
            }
            catch (IOException ioe) {
                GUIUtils.showExceptionDialog(this, "Problem saving file " + fileName, ioe);
            }
        }
    }

    private CapabilityRequirement forViewSelection() {
        return CapabilityRequirement.has(Capability.forShortName((String)this.viewModeList.getSelectedItem()));
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Test");
        frame.setDefaultCloseOperation(3);
        TaskManagerPanel panel = new TaskManagerPanel();
        panel.setOpaque(true);
        frame.setContentPane(panel);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            LookAndFeel.install();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TaskManagerPanel.createAndShowGUI();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected class TaskTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        protected TaskTableModel() {
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "command";
                }
                case 1: {
                    return "status";
                }
                case 2: {
                    return "time elapsed";
                }
                case 3: {
                    return "current activity";
                }
                case 4: {
                    return "% complete";
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return TaskManagerPanel.this.taskList.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            TaskThread thread = TaskManagerPanel.this.taskList.get(row);
            switch (col) {
                case 0: {
                    return ((OptionHandler)((Object)thread.getTask())).getCLICreationString(MainTask.class);
                }
                case 1: {
                    return thread.getCurrentStatusString();
                }
                case 2: {
                    return StringUtils.secondsToDHMSString(thread.getCPUSecondsElapsed());
                }
                case 3: {
                    return thread.getCurrentActivityString();
                }
                case 4: {
                    return new Double(thread.getCurrentActivityFracComplete());
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    public class ProgressCellRenderer
    extends JProgressBar
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public ProgressCellRenderer() {
            super(0, 0, 10000);
            this.setBorderPainted(false);
            this.setStringPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            double frac = -1.0;
            if (value instanceof Double) {
                frac = (Double)value;
            }
            if (frac >= 0.0) {
                this.setIndeterminate(false);
                this.setValue((int)(frac * 10000.0));
                this.setString(StringUtils.doubleToString(frac * 100.0, 2, 2));
            } else {
                this.setValue(0);
            }
            return this;
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }
}

