/*
 * Decompiled with CFR 0.152.
 */
package moa.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Scanner;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import moa.evaluation.MeasureCollection;
import moa.evaluation.preview.Preview;
import moa.gui.FileExtensionFilter;
import moa.gui.GUIUtils;
import moa.gui.PreviewPanel;
import moa.gui.PreviewTableModel;
import moa.gui.clustertab.ClusteringVisualEvalPanel;
import moa.gui.conceptdrift.CDTaskManagerPanel;
import moa.gui.visualization.GraphCanvas;
import moa.gui.visualization.StreamPanel;
import moa.streams.clustering.ClusterEvent;
import moa.tasks.ConceptDriftMainTask;
import moa.tasks.FailedTaskReport;
import nz.ac.waikato.cms.gui.core.BaseFileChooser;
import nz.ac.waikato.cms.gui.core.DetachablePanel;
import nz.ac.waikato.cms.gui.core.ExtensionFileFilter;
import nz.ac.waikato.cms.gui.core.GUIHelper;
import weka.gui.visualize.PNGWriter;

public class TaskTextViewerPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static String exportFileExtension = "txt";
    private PreviewTableModel previewTableModel;
    private JTable previewTable;
    private JTextArea previewText;
    private JScrollPane scrollPaneTable;
    private JScrollPane scrollPaneText;
    protected JButton exportButton;
    private JPanel topWrapper;
    private JSplitPane jSplitPane1;
    protected CDTaskManagerPanel taskManagerPanel;
    protected PreviewPanel.TypePanel typePanel;
    public GridBagConstraints gridBagConstraints;
    protected MeasureCollection[] acc1 = new MeasureCollection[1];
    protected MeasureCollection[] acc2 = new MeasureCollection[1];
    protected String secondLine = "";
    private JButton buttonRun;
    private JButton buttonScreenshot;
    private JButton buttonStop;
    private JButton buttonZoomInX;
    private JButton buttonZoomInY;
    private JButton buttonZoomOutX;
    private JButton buttonZoomOutY;
    private JButton buttonDetach;
    private JButton buttonSaveAs;
    private DetachablePanel detachablePanel;
    private JCheckBox checkboxDrawClustering;
    private JCheckBox checkboxDrawGT;
    private JCheckBox checkboxDrawMicro;
    private JCheckBox checkboxDrawPoints;
    private ClusteringVisualEvalPanel clusteringVisualEvalPanel1;
    private JComboBox comboX;
    private JComboBox comboY;
    private GraphCanvas graphCanvas;
    private BaseFileChooser fileChooserGraph;
    private JPanel graphPanel;
    private JPanel graphPanelControlBottom;
    private JPanel graphPanelControlTop;
    private JScrollPane graphScrollPanel;
    private JLabel jLabel1;
    private JLabel labelEvents;
    private JLabel labelNumPause;
    private JLabel labelX;
    private JLabel labelY;
    private JLabel label_processed_points;
    private JLabel label_processed_points_value;
    private JTextField numPauseAfterPoints;
    private JPanel panelControl;
    private JPanel panelEvalOutput;
    private JPanel panelVisualWrapper;
    private JScrollPane scrollPane0;
    private JScrollPane scrollPane1;
    private JSlider speedSlider;
    private JSplitPane splitVisual;
    private StreamPanel streamPanel0;
    private StreamPanel streamPanel1;

    public void initVisualEvalPanel() {
        this.acc1[0] = this.getNewMeasureCollection();
        this.acc2[0] = this.getNewMeasureCollection();
        if (this.clusteringVisualEvalPanel1 != null) {
            this.panelEvalOutput.remove(this.clusteringVisualEvalPanel1);
        }
        this.clusteringVisualEvalPanel1 = new ClusteringVisualEvalPanel();
        this.clusteringVisualEvalPanel1.setMeasures(this.acc1, this.acc2, this);
        this.graphCanvas.setGraph(this.acc1[0], this.acc2[0], 0, 1000);
        this.graphCanvas.forceAddEvents();
        this.clusteringVisualEvalPanel1.setMinimumSize(new Dimension(280, 118));
        this.clusteringVisualEvalPanel1.setPreferredSize(new Dimension(290, 115));
        this.panelEvalOutput.add((Component)this.clusteringVisualEvalPanel1, this.gridBagConstraints);
    }

    public TaskTextViewerPanel() {
        this(PreviewPanel.TypePanel.CLASSIFICATION, null);
    }

    public TaskTextViewerPanel(PreviewPanel.TypePanel typePanel, CDTaskManagerPanel taskManagerPanel) {
        this.typePanel = typePanel;
        this.taskManagerPanel = taskManagerPanel;
        this.topWrapper = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jSplitPane1 = new JSplitPane(0);
        this.jSplitPane1.setDividerLocation(200);
        this.topWrapper = new JPanel();
        this.topWrapper.setLayout(new BorderLayout());
        this.previewTableModel = new PreviewTableModel();
        this.previewTable = new JTable(this.previewTableModel);
        this.previewTable.setFont(new Font("Monospaced", 0, 12));
        this.previewTable.setAutoResizeMode(0);
        this.previewText = new JTextArea();
        this.previewText.setEditable(false);
        this.previewText.setFont(new Font("Monospaced", 0, 12));
        this.scrollPaneTable = new JScrollPane(this.previewTable, 20, 30);
        this.scrollPaneText = new JScrollPane(this.previewText, 20, 30);
        this.scrollPaneText.setVisible(false);
        this.topWrapper.add((Component)this.scrollPaneTable, "Center");
        this.exportButton = new JButton("Export as .txt file...");
        this.exportButton.setEnabled(false);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2));
        buttonPanel.add(this.exportButton);
        this.topWrapper.add((Component)buttonPanel, "South");
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseFileChooser fileChooser = new BaseFileChooser();
                fileChooser.setAcceptAllFileFilterUsed(true);
                fileChooser.addChoosableFileFilter((FileFilter)new FileExtensionFilter(exportFileExtension));
                if (fileChooser.showSaveDialog((Component)TaskTextViewerPanel.this) == 0) {
                    File chosenFile = fileChooser.getSelectedFile();
                    String fileName = chosenFile.getPath();
                    if (!chosenFile.exists() && !fileName.endsWith(exportFileExtension)) {
                        fileName = fileName + "." + exportFileExtension;
                    }
                    try {
                        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                        String text = "";
                        text = TaskTextViewerPanel.this.scrollPaneTable.isVisible() ? TaskTextViewerPanel.this.previewTableModel.toString() : TaskTextViewerPanel.this.previewText.getText();
                        out.write(text);
                        out.close();
                    }
                    catch (IOException ioe) {
                        GUIUtils.showExceptionDialog(TaskTextViewerPanel.this.exportButton, "Problem saving file " + fileName, ioe);
                    }
                }
            }
        });
        this.panelEvalOutput = new JPanel();
        this.graphPanel = new JPanel();
        this.graphPanelControlTop = new JPanel();
        this.buttonZoomInY = new JButton();
        this.buttonZoomOutY = new JButton();
        this.buttonDetach = new JButton();
        this.buttonSaveAs = new JButton();
        this.labelEvents = new JLabel();
        this.graphScrollPanel = new JScrollPane();
        this.graphCanvas = new GraphCanvas();
        this.graphPanelControlBottom = new JPanel();
        this.buttonZoomInX = new JButton();
        this.buttonZoomOutX = new JButton();
        this.setLayout(new GridBagLayout());
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setLeftComponent(this.topWrapper);
        this.panelEvalOutput.setBorder(BorderFactory.createTitledBorder("Evaluation"));
        this.panelEvalOutput.setLayout(new GridBagLayout());
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.anchor = 17;
        this.gridBagConstraints.weighty = 1.0;
        this.initVisualEvalPanel();
        this.graphPanel.setBorder(BorderFactory.createTitledBorder("Plot"));
        this.graphPanel.setPreferredSize(new Dimension(530, 115));
        this.graphPanel.setLayout(new GridBagLayout());
        this.detachablePanel = new DetachablePanel();
        this.detachablePanel.setFrameTitle("Plot");
        this.detachablePanel.getContentPanel().add((Component)this.graphPanel);
        this.graphPanelControlTop.setLayout(new GridBagLayout());
        this.buttonZoomInY.setIcon(GUIHelper.getIcon((String)"zoom_in.png"));
        this.buttonZoomInY.setText("Y");
        this.buttonZoomInY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskTextViewerPanel.this.buttonZoomInYActionPerformed(evt);
            }
        });
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.graphPanelControlTop.add((Component)this.buttonZoomInY, this.gridBagConstraints);
        this.buttonZoomOutY.setIcon(GUIHelper.getIcon((String)"zoom_out.png"));
        this.buttonZoomOutY.setText("Y");
        this.buttonZoomOutY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskTextViewerPanel.this.buttonZoomOutYActionPerformed(evt);
            }
        });
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.graphPanelControlTop.add((Component)this.buttonZoomOutY, this.gridBagConstraints);
        this.labelEvents.setHorizontalAlignment(0);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.fill = 2;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.graphPanelControlTop.add((Component)this.labelEvents, this.gridBagConstraints);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.fill = 2;
        this.gridBagConstraints.anchor = 17;
        this.gridBagConstraints.weightx = 1.0;
        this.graphPanel.add((Component)this.graphPanelControlTop, this.gridBagConstraints);
        GroupLayout graphCanvasLayout = new GroupLayout(this.graphCanvas);
        this.graphCanvas.setLayout(graphCanvasLayout);
        graphCanvasLayout.setHorizontalGroup(graphCanvasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 515, Short.MAX_VALUE));
        graphCanvasLayout.setVerticalGroup(graphCanvasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 128, Short.MAX_VALUE));
        this.graphScrollPanel.setViewportView(this.graphCanvas);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 1;
        this.gridBagConstraints.gridwidth = 2;
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 1.0;
        this.gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.graphPanel.add((Component)this.graphScrollPanel, this.gridBagConstraints);
        this.buttonZoomInX.setIcon(GUIHelper.getIcon((String)"zoom_in.png"));
        this.buttonZoomInX.setText("X");
        this.buttonZoomInX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskTextViewerPanel.this.buttonZoomInXActionPerformed(evt);
            }
        });
        this.graphPanelControlBottom.add(this.buttonZoomInX);
        this.buttonZoomOutX.setIcon(GUIHelper.getIcon((String)"zoom_out.png"));
        this.buttonZoomOutX.setText("X");
        this.buttonZoomOutX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskTextViewerPanel.this.buttonZoomOutXActionPerformed(evt);
            }
        });
        this.graphPanelControlBottom.add(this.buttonZoomOutX);
        this.buttonDetach.setIcon(GUIHelper.getIcon((String)"maximize.png"));
        this.buttonDetach.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (TaskTextViewerPanel.this.detachablePanel.isDetached()) {
                    TaskTextViewerPanel.this.detachablePanel.reattach();
                    TaskTextViewerPanel.this.buttonDetach.setIcon(GUIHelper.getIcon((String)"maximize.png"));
                } else {
                    TaskTextViewerPanel.this.detachablePanel.detach();
                    TaskTextViewerPanel.this.buttonDetach.setIcon(GUIHelper.getIcon((String)"minimize.png"));
                }
            }
        });
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.graphPanelControlBottom.add((Component)this.buttonDetach, this.gridBagConstraints);
        this.buttonSaveAs.setIcon(GUIHelper.getIcon((String)"save.gif"));
        this.buttonSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int retVal;
                if (TaskTextViewerPanel.this.fileChooserGraph == null) {
                    TaskTextViewerPanel.this.fileChooserGraph = new BaseFileChooser();
                    TaskTextViewerPanel.this.fileChooserGraph.setAcceptAllFileFilterUsed(false);
                    ExtensionFileFilter filter = new ExtensionFileFilter("PNG image", "png");
                    TaskTextViewerPanel.this.fileChooserGraph.addChoosableFileFilter((FileFilter)filter);
                }
                if ((retVal = TaskTextViewerPanel.this.fileChooserGraph.showSaveDialog((Component)TaskTextViewerPanel.this.getParent())) != 0) {
                    return;
                }
                File png = TaskTextViewerPanel.this.fileChooserGraph.getSelectedFile();
                PNGWriter writer = new PNGWriter((JComponent)TaskTextViewerPanel.this.graphCanvas);
                writer.setFile(png);
                try {
                    writer.toOutput();
                }
                catch (Exception e) {
                    GUIHelper.showErrorMessage((Component)TaskTextViewerPanel.this.getParent(), (String)("Failed to save graph to: " + png), (Throwable)e);
                }
            }
        });
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.graphPanelControlBottom.add((Component)this.buttonSaveAs, this.gridBagConstraints);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 1;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.anchor = 13;
        this.graphPanel.add((Component)this.graphPanelControlBottom, this.gridBagConstraints);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.anchor = 17;
        this.gridBagConstraints.weightx = 2.0;
        this.gridBagConstraints.weighty = 1.0;
        this.panelEvalOutput.add((Component)this.detachablePanel, this.gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.panelEvalOutput);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSplitPane1, this.gridBagConstraints);
    }

    public void setText(Preview preview) {
        Point p = this.scrollPaneTable.getViewport().getViewPosition();
        this.previewTableModel.setPreview(preview);
        SwingUtilities.invokeLater(new Runnable(){
            boolean structureChanged;
            {
                this.structureChanged = TaskTextViewerPanel.this.previewTableModel.structureChanged();
            }

            @Override
            public void run() {
                if (!TaskTextViewerPanel.this.scrollPaneTable.isVisible()) {
                    TaskTextViewerPanel.this.topWrapper.remove(TaskTextViewerPanel.this.scrollPaneText);
                    TaskTextViewerPanel.this.scrollPaneText.setVisible(false);
                    TaskTextViewerPanel.this.topWrapper.add((Component)TaskTextViewerPanel.this.scrollPaneTable, "Center");
                    TaskTextViewerPanel.this.scrollPaneTable.setVisible(true);
                    TaskTextViewerPanel.this.topWrapper.validate();
                }
                if (this.structureChanged) {
                    TaskTextViewerPanel.this.previewTableModel.fireTableStructureChanged();
                    TaskTextViewerPanel.this.rescaleTableColumns();
                } else {
                    TaskTextViewerPanel.this.previewTableModel.fireTableDataChanged();
                }
                TaskTextViewerPanel.this.previewTable.repaint();
            }
        });
        this.scrollPaneTable.getViewport().setViewPosition(p);
        this.exportButton.setEnabled(preview != null);
    }

    public void setText(Object object) {
        if (object instanceof Preview) {
            this.setText((Preview)object);
            return;
        }
        if (object instanceof FailedTaskReport) {
            this.setText((FailedTaskReport)object);
            return;
        }
        Point p = this.scrollPaneText.getViewport().getViewPosition();
        final String string = object == null ? null : object.toString();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!TaskTextViewerPanel.this.scrollPaneText.isVisible()) {
                    TaskTextViewerPanel.this.topWrapper.remove(TaskTextViewerPanel.this.scrollPaneTable);
                    TaskTextViewerPanel.this.scrollPaneTable.setVisible(false);
                    TaskTextViewerPanel.this.topWrapper.add((Component)TaskTextViewerPanel.this.scrollPaneText, "Center");
                    TaskTextViewerPanel.this.scrollPaneText.setVisible(true);
                    TaskTextViewerPanel.this.topWrapper.validate();
                }
                TaskTextViewerPanel.this.previewText.setText(string);
                TaskTextViewerPanel.this.previewText.repaint();
            }
        });
        this.scrollPaneText.getViewport().setViewPosition(p);
        this.exportButton.setEnabled(object != null);
    }

    public void setText(FailedTaskReport failedTaskReport) {
        String failedTaskReportString = failedTaskReport == null ? "Failed Task Report is null" : failedTaskReport.toString();
        this.setText(failedTaskReportString);
    }

    private void rescaleTableColumns() {
        TableColumnModel columnModel = this.previewTable.getColumnModel();
        for (int columnIdx = 0; columnIdx < columnModel.getColumnCount(); ++columnIdx) {
            TableColumn column = columnModel.getColumn(columnIdx);
            TableCellRenderer renderer = column.getHeaderRenderer();
            if (renderer == null) {
                renderer = this.previewTable.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(this.previewTable, column.getHeaderValue(), false, false, 0, columnIdx);
            int width = comp.getPreferredSize().width;
            column.setPreferredWidth(width);
        }
    }

    protected double round(double d) {
        return Math.rint(d * 100.0) / 100.0;
    }

    protected MeasureCollection getNewMeasureCollection() {
        return this.typePanel.getMeasureCollection();
    }

    public void setGraph(String preview) {
        double processFrequency = 1000.0;
        if (preview != null && !preview.equals("")) {
            MeasureCollection oldAccuracy = this.acc1[0];
            this.acc1[0] = this.getNewMeasureCollection();
            Scanner scanner = new Scanner(preview);
            String firstLine = scanner.nextLine();
            boolean isSecondLine = true;
            boolean isPrequential = firstLine.startsWith("learning evaluation instances,evaluation time");
            boolean isHoldOut = firstLine.startsWith("evaluation instances,to");
            int accuracyColumn = 6;
            int kappaColumn = 4;
            int RamColumn = 2;
            int timeColumn = 1;
            int memoryColumn = 9;
            int kappaTempColumn = 5;
            if (this.taskManagerPanel instanceof CDTaskManagerPanel) {
                accuracyColumn = 6;
                kappaColumn = 4;
                RamColumn = 2;
                timeColumn = 1;
                memoryColumn = 9;
            } else if (isPrequential || isHoldOut) {
                accuracyColumn = 4;
                kappaColumn = 5;
                RamColumn = 2;
                timeColumn = 1;
                memoryColumn = 7;
                kappaTempColumn = 5;
                String[] tokensFirstLine = firstLine.split(",");
                int i = 0;
                for (String s : tokensFirstLine) {
                    if (s.equals("classifications correct (percent)") || s.equals("[avg] classifications correct (percent)")) {
                        accuracyColumn = i;
                    } else if (s.equals("Kappa Statistic (percent)") || s.equals("[avg] Kappa Statistic (percent)")) {
                        kappaColumn = i;
                    } else if (s.equals("Kappa Temporal Statistic (percent)") || s.equals("[avg] Kappa Temporal Statistic (percent)")) {
                        kappaTempColumn = i;
                    } else if (s.equals("model cost (RAM-Hours)")) {
                        RamColumn = i;
                    } else if (s.equals("evaluation time (cpu seconds)") || s.equals("total train time")) {
                        timeColumn = i;
                    } else if (s.equals("model serialized size (bytes)")) {
                        memoryColumn = i;
                    }
                    ++i;
                }
            }
            if (isPrequential || isHoldOut || this.taskManagerPanel instanceof CDTaskManagerPanel) {
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    String[] tokens = line.split(",");
                    this.acc1[0].addValue(0, this.round(this.parseDouble(tokens[accuracyColumn])));
                    this.acc1[0].addValue(1, this.round(this.parseDouble(tokens[kappaColumn])));
                    this.acc1[0].addValue(2, this.round(this.parseDouble(tokens[kappaTempColumn])));
                    if (!isHoldOut) {
                        this.acc1[0].addValue(3, Math.abs(this.parseDouble(tokens[RamColumn])));
                    }
                    this.acc1[0].addValue(4, this.round(this.parseDouble(tokens[timeColumn])));
                    this.acc1[0].addValue(5, this.round(this.parseDouble(tokens[memoryColumn]) / 1048576.0));
                    if (!isSecondLine) continue;
                    processFrequency = Math.abs(this.parseDouble(tokens[0]));
                    isSecondLine = false;
                    if (this.acc1[0].getValue(0, 0) == oldAccuracy.getValue(0, 0)) continue;
                    this.secondLine = line;
                    if (processFrequency != (double)this.graphCanvas.getProcessFrequency()) continue;
                    this.acc2[0] = oldAccuracy;
                }
            } else {
                this.acc2[0] = this.getNewMeasureCollection();
            }
            scanner.close();
        } else {
            this.acc1[0] = this.getNewMeasureCollection();
            this.acc2[0] = this.getNewMeasureCollection();
        }
        if (this.taskManagerPanel instanceof CDTaskManagerPanel) {
            ConceptDriftMainTask cdTask = this.taskManagerPanel.getSelectedCurrenTask();
            ArrayList<ClusterEvent> clusterEvents = cdTask.getEventsList();
            this.graphCanvas.setClusterEventsList(clusterEvents);
        }
        this.graphCanvas.setGraph(this.acc1[0], this.acc2[0], this.graphCanvas.getMeasureSelected(), (int)processFrequency);
        this.graphCanvas.updateCanvas(true);
        this.graphCanvas.forceAddEvents();
        this.clusteringVisualEvalPanel1.update();
    }

    private double parseDouble(String s) {
        double ret = 0.0;
        if (!s.equals("?")) {
            ret = Double.parseDouble(s);
        }
        return ret;
    }

    private void scrollPane0MouseWheelMoved(MouseWheelEvent evt) {
        this.streamPanel0.setZoom(evt.getX(), evt.getY(), -1 * evt.getWheelRotation(), this.scrollPane0);
    }

    private void buttonZoomInXActionPerformed(ActionEvent evt) {
        this.graphCanvas.scaleXResolution(false);
    }

    private void buttonZoomOutYActionPerformed(ActionEvent evt) {
        this.graphCanvas.setSize(new Dimension(this.graphCanvas.getWidth(), (int)((double)this.graphCanvas.getHeight() * 0.8)));
        this.graphCanvas.setPreferredSize(new Dimension(this.graphCanvas.getWidth(), (int)((double)this.graphCanvas.getHeight() * 0.8)));
        this.graphCanvas.updateCanvas(true);
    }

    private void buttonZoomOutXActionPerformed(ActionEvent evt) {
        this.graphCanvas.scaleXResolution(true);
    }

    private void buttonZoomInYActionPerformed(ActionEvent evt) {
        this.graphCanvas.setSize(new Dimension(this.graphCanvas.getWidth(), (int)((double)this.graphCanvas.getHeight() * 1.2)));
        this.graphCanvas.setPreferredSize(new Dimension(this.graphCanvas.getWidth(), (int)((double)this.graphCanvas.getHeight() * 1.2)));
        this.graphCanvas.updateCanvas(true);
    }

    private void buttonRunActionPerformed(ActionEvent evt) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int selected;
        int counter = selected = Integer.parseInt(e.getActionCommand());
        int m_select = 0;
        int m_select_offset = 0;
        boolean found = false;
        for (int i = 0; i < this.acc1.length; ++i) {
            for (int j = 0; j < this.acc1[i].getNumMeasures(); ++j) {
                if (!this.acc1[i].isEnabled(j) || --counter >= 0) continue;
                m_select = i;
                m_select_offset = j;
                found = true;
                break;
            }
            if (found) break;
        }
        this.graphCanvas.setGraph(this.acc1[m_select], this.acc2[m_select], m_select_offset, this.graphCanvas.getProcessFrequency());
        this.graphCanvas.forceAddEvents();
    }
}

