/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.experimentertab;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import moa.gui.LookAndFeel;
import moa.gui.experimentertab.ImageChart;
import moa.gui.experimentertab.ImageTreePanel;
import moa.gui.experimentertab.ImageViewer;
import moa.gui.experimentertab.ReadFile;
import nz.ac.waikato.cms.gui.core.BaseDirectoryChooser;
import org.apache.commons.io.FilenameUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class PlotTab
extends JPanel {
    private String path = "";
    private LinkedList<String> measures = new LinkedList();
    private DefaultTableModel algoritmModel;
    private DefaultTableModel streamModel;
    ImageTreePanel imgPanel;
    ImageChart[] chart;
    ReadFile rf;
    private JButton jButtonAcept;
    private JButton jButtonAceptGnuP;
    private JButton jButtonDeletAlgorithm;
    private JButton jButtonDeleteStream;
    private JButton jButtonGnuoPath;
    private JButton jButtonInPath;
    private JButton jButtonReset;
    private JButton jButtonResetGnuP;
    private JCheckBox jCheckBoxDeleteScript;
    private JCheckBox jCheckBoxShape;
    private JCheckBox jCheckBoxSmooth;
    private JComboBox jComboBoxGrid;
    private JComboBox jComboBoxLegendLocation;
    private JComboBox jComboBoxLegendType;
    private JComboBox jComboBoxLineStyle;
    private JComboBox jComboBoxOutPTypeGnuP;
    private JComboBox jComboBoxXColumn;
    private JComboBox jComboBoxXColumnGnuP;
    private JComboBox jComboBoxYColumn;
    private JComboBox jComboBoxYColumnGnuP;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanelGnuP;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPaneAlgorithms;
    private JScrollPane jScrollPaneGnuP;
    private JSpinner jSpinnerHeight;
    private JSpinner jSpinnerLineWidth;
    private JSpinner jSpinnerPlotInterval;
    private JSpinner jSpinnerWidth;
    private JTabbedPane jTabbedPane1;
    private JTable jTableAlgoritms;
    private JTable jTableStreams;
    private JTextField jTextFieldAPOptions;
    private JTextField jTextFieldAdcComand;
    private JTextField jTextFieldGNUPath;
    private JTextField jTextFieldResultPath;
    private JTextField jTextFieldTitle;
    private JTextField jTextFieldxTitle;
    private JTextField jTextFieldxTitleGnuP;
    private JTextField jTextFieldyTitle;
    private JTextField jTextFieldyTitleGnuP;

    public PlotTab() {
        this.initComponents();
        this.initComponents();
        this.algoritmModel = (DefaultTableModel)this.jTableAlgoritms.getModel();
        this.streamModel = (DefaultTableModel)this.jTableStreams.getModel();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPaneAlgorithms = new JScrollPane();
        this.jTableAlgoritms = new JTable();
        this.jScrollPane3 = new JScrollPane();
        this.jTableStreams = new JTable();
        this.jTextFieldResultPath = new JTextField();
        this.jButtonInPath = new JButton();
        this.jLabel3 = new JLabel();
        this.jButtonDeletAlgorithm = new JButton();
        this.jButtonDeleteStream = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jButtonAcept = new JButton();
        this.jButtonReset = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel4 = new JPanel();
        this.jLabel17 = new JLabel();
        this.jTextFieldxTitle = new JTextField();
        this.jLabel18 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jTextFieldyTitle = new JTextField();
        this.jLabel20 = new JLabel();
        this.jComboBoxXColumn = new JComboBox();
        this.jComboBoxYColumn = new JComboBox();
        this.jTextFieldTitle = new JTextField();
        this.jLabel21 = new JLabel();
        this.jSpinnerWidth = new JSpinner();
        this.jSpinnerHeight = new JSpinner();
        this.jLabel22 = new JLabel();
        this.jLabel23 = new JLabel();
        this.jComboBoxGrid = new JComboBox();
        this.jCheckBoxShape = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jButtonAceptGnuP = new JButton();
        this.jButtonResetGnuP = new JButton();
        this.jScrollPaneGnuP = new JScrollPane();
        this.jPanelGnuP = new JPanel();
        this.jTextFieldGNUPath = new JTextField();
        this.jLabel1 = new JLabel();
        this.jButtonGnuoPath = new JButton();
        this.jComboBoxOutPTypeGnuP = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jComboBoxLineStyle = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jTextFieldxTitleGnuP = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jTextFieldyTitleGnuP = new JTextField();
        this.jLabel11 = new JLabel();
        this.jSpinnerLineWidth = new JSpinner();
        this.jSpinnerPlotInterval = new JSpinner();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jCheckBoxSmooth = new JCheckBox();
        this.jLabel15 = new JLabel();
        this.jCheckBoxDeleteScript = new JCheckBox();
        this.jLabel16 = new JLabel();
        this.jComboBoxLegendLocation = new JComboBox();
        this.jLabel24 = new JLabel();
        this.jComboBoxLegendType = new JComboBox();
        this.jLabel25 = new JLabel();
        this.jTextFieldAdcComand = new JTextField();
        this.jLabel26 = new JLabel();
        this.jTextFieldAPOptions = new JTextField();
        this.jLabel27 = new JLabel();
        this.jComboBoxXColumnGnuP = new JComboBox();
        this.jComboBoxYColumnGnuP = new JComboBox();
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Configuration"));
        this.jScrollPaneAlgorithms.setBorder(BorderFactory.createTitledBorder("Algorithm"));
        this.jTableAlgoritms.setBorder(BorderFactory.createTitledBorder(""));
        this.jTableAlgoritms.setModel(new DefaultTableModel(new Object[0][], new String[]{"Algorithm", "Algorithm ID"}));
        this.jScrollPaneAlgorithms.setViewportView(this.jTableAlgoritms);
        this.jScrollPane3.setBorder(BorderFactory.createTitledBorder("Stream"));
        this.jTableStreams.setBorder(BorderFactory.createTitledBorder(""));
        this.jTableStreams.setModel(new DefaultTableModel(new Object[0][], new String[]{"Stream", "Stream ID"}));
        this.jScrollPane3.setViewportView(this.jTableStreams);
        this.jButtonInPath.setText("Browse");
        this.jButtonInPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlotTab.this.jButtonInPathActionPerformed(evt);
            }
        });
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Result  folder");
        this.jButtonDeletAlgorithm.setText("Delete Algorithm");
        this.jButtonDeletAlgorithm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlotTab.this.jButtonDeletAlgorithmActionPerformed(evt);
            }
        });
        this.jButtonDeleteStream.setText("Delete Stream");
        this.jButtonDeleteStream.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlotTab.this.jButtonDeleteStreamActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldResultPath).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonInPath)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonDeletAlgorithm).addComponent(this.jScrollPaneAlgorithms, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -2, 0, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonDeleteStream).addGap(0, 0, Short.MAX_VALUE))))).addGap(16, 16, 16)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(23, 23, 23).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldResultPath, -2, 23, -2).addComponent(this.jButtonInPath).addComponent(this.jLabel3)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneAlgorithms, -1, 89, Short.MAX_VALUE).addComponent(this.jScrollPane3, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonDeleteStream).addComponent(this.jButtonDeletAlgorithm))));
        this.jButtonAcept.setText("Generate Images");
        this.jButtonAcept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlotTab.this.jButtonAceptActionPerformed(evt);
            }
        });
        this.jButtonReset.setText(" Reset to Default");
        this.jButtonReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlotTab.this.jButtonResetActionPerformed(evt);
            }
        });
        this.jScrollPane1.setBorder(BorderFactory.createTitledBorder(""));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(""));
        this.jLabel17.setHorizontalAlignment(4);
        this.jLabel17.setText("xColumn");
        this.jTextFieldxTitle.setText("Instances processed");
        this.jLabel18.setHorizontalAlignment(4);
        this.jLabel18.setText("xTitle");
        this.jLabel19.setHorizontalAlignment(4);
        this.jLabel19.setText("yColumn");
        this.jTextFieldyTitle.setText("% of correctly classified");
        this.jLabel20.setHorizontalAlignment(4);
        this.jLabel20.setText("yTitle");
        this.jLabel21.setText("title");
        this.jSpinnerWidth.setValue(500);
        this.jSpinnerHeight.setValue(300);
        this.jLabel22.setText("width");
        this.jLabel23.setText("height");
        this.jComboBoxGrid.setModel(new DefaultComboBoxModel<String>(new String[]{"White", "Default"}));
        this.jCheckBoxShape.setText("shapes");
        this.jLabel2.setText("gridColor");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(67, 67, 67).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel4Layout.createSequentialGroup().addGap(3, 3, 3).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel17).addComponent(this.jLabel21).addComponent(this.jLabel18)).addComponent(this.jLabel19).addComponent(this.jLabel20, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel22, GroupLayout.Alignment.TRAILING)).addGap(18, 18, 18).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldxTitle).addComponent(this.jComboBoxXColumn, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.jTextFieldTitle, GroupLayout.Alignment.TRAILING).addComponent(this.jComboBoxYColumn, 0, -1, Short.MAX_VALUE).addComponent(this.jTextFieldyTitle, -1, 542, Short.MAX_VALUE).addComponent(this.jSpinnerWidth))).addGroup(GroupLayout.Alignment.LEADING, jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel23).addComponent(this.jLabel2)).addGap(18, 18, 18).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jCheckBoxShape, -2, 91, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jComboBoxGrid, 0, -1, Short.MAX_VALUE).addComponent(this.jSpinnerHeight)))).addGap(30, 30, 30)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldTitle, -2, -1, -2).addComponent(this.jLabel21)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxXColumn, -2, -1, -2).addComponent(this.jLabel17)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldxTitle, -2, -1, -2).addComponent(this.jLabel18)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxYColumn, -2, -1, -2).addComponent(this.jLabel19)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldyTitle, -2, -1, -2).addComponent(this.jLabel20)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSpinnerWidth, -2, -1, -2).addComponent(this.jLabel22)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel23).addComponent(this.jSpinnerHeight, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxGrid, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxShape).addContainerGap(11, Short.MAX_VALUE)));
        this.jScrollPane1.setViewportView(this.jPanel4);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(135, 135, 135).addComponent(this.jButtonAcept).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonReset).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 700, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 247, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonAcept).addComponent(this.jButtonReset))));
        this.jTabbedPane1.addTab("Charts", this.jPanel2);
        this.jButtonAceptGnuP.setText("Generate GnuPlot Commands");
        this.jButtonAceptGnuP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlotTab.this.jButtonAceptGnuPActionPerformed(evt);
            }
        });
        this.jButtonResetGnuP.setText(" Reset to Default");
        this.jButtonResetGnuP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlotTab.this.jButtonResetGnuPActionPerformed(evt);
            }
        });
        this.jScrollPaneGnuP.setBorder(BorderFactory.createTitledBorder(""));
        this.jScrollPaneGnuP.setHorizontalScrollBarPolicy(31);
        this.jPanelGnuP.setBorder(BorderFactory.createTitledBorder(""));
        this.jPanelGnuP.setPreferredSize(new Dimension(400, 449));
        this.jTextFieldGNUPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlotTab.this.jTextFieldGNUPathActionPerformed(evt);
            }
        });
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("gnuplotBinaryPath ");
        this.jButtonGnuoPath.setText("Browse");
        this.jButtonGnuoPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlotTab.this.jButtonGnuoPathActionPerformed(evt);
            }
        });
        this.jComboBoxOutPTypeGnuP.setModel(new DefaultComboBoxModel<String>(new String[]{"POSTSCRIPT_COLOR", "EPSLATEX", "GIF", "JPEG", "LATEX", "PDFCAIRO", "PNG", "POSTSCRIPT", "CANVAS", "PSLATEX", "PSTEX", "PSTRICKS", "SVG"}));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText("outputType");
        this.jComboBoxLineStyle.setModel(new DefaultComboBoxModel<String>(new String[]{"LINES", "POINTS", "LINESPOINTS", "IMPULSES", "STEPS", "FSTEPS", "HISTEPS", "DOTS;"}));
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText("plotStyle");
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText("xColumn");
        this.jTextFieldxTitleGnuP.setText("Processed instances");
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setText("xTitle");
        this.jLabel10.setHorizontalAlignment(4);
        this.jLabel10.setText("yColumn");
        this.jTextFieldyTitleGnuP.setText("Accuracy");
        this.jLabel11.setHorizontalAlignment(4);
        this.jLabel11.setText("yTitle");
        this.jSpinnerLineWidth.setValue(2);
        this.jLabel13.setHorizontalAlignment(4);
        this.jLabel13.setText("lineWidth");
        this.jLabel14.setHorizontalAlignment(4);
        this.jLabel14.setText("plotInterval");
        this.jLabel15.setHorizontalAlignment(4);
        this.jLabel15.setText("smooth");
        this.jLabel16.setHorizontalAlignment(4);
        this.jLabel16.setText("deleteScripts");
        this.jComboBoxLegendLocation.setModel(new DefaultComboBoxModel<String>(new String[]{"BOTTOM_CENTER_OUTSIDE", "TOP_LEFT_INSIDE", "TOP_CENTER_INSIDE", "TOP_RIGHT_INSIDE", "LEFT_INSIDE", "CENTER_INSIDE", "RIGHT_INSIDE", "BOTTOM_LEFT_INSIDE", "BOTTOM_CENTER_INSIDE", "BOTTOM_RIGHT_INSIDE", "TOP_LEFT_OUTSIDE", "TOP_CENTER_OUTSIDE", "TOP_RIGHT_OUTSIDE", "LEFT_OUTSIDE", "CENTER_OUTSIDE", "RIGHT_OUTSIDE", "BOTTOM_LEFT_OUTSIDE", "BOTTOM_RIGHT_OUTSIDE"}));
        this.jComboBoxLegendLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlotTab.this.jComboBoxLegendLocationActionPerformed(evt);
            }
        });
        this.jLabel24.setHorizontalAlignment(4);
        this.jLabel24.setText("legendLocation");
        this.jComboBoxLegendType.setModel(new DefaultComboBoxModel<String>(new String[]{"NOBOX_HORIZONTAL", "BOX_VERTICAL", "BOX_HORIZONTAL", "NOBOX_VERTICAL", " "}));
        this.jLabel25.setHorizontalAlignment(4);
        this.jLabel25.setText("legendType");
        this.jLabel26.setHorizontalAlignment(4);
        this.jLabel26.setText("additionalCommands");
        this.jLabel27.setHorizontalAlignment(4);
        this.jLabel27.setText("additionalPlotOptions");
        GroupLayout jPanelGnuPLayout = new GroupLayout(this.jPanelGnuP);
        this.jPanelGnuP.setLayout(jPanelGnuPLayout);
        jPanelGnuPLayout.setHorizontalGroup(jPanelGnuPLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelGnuPLayout.createSequentialGroup().addGroup(jPanelGnuPLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelGnuPLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelGnuPLayout.createSequentialGroup().addGap(22, 22, 22).addGroup(jPanelGnuPLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel6, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel7, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel8, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel10, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel11, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING))).addGroup(GroupLayout.Alignment.TRAILING, jPanelGnuPLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel27))).addGroup(GroupLayout.Alignment.TRAILING, jPanelGnuPLayout.createSequentialGroup().addContainerGap().addGroup(jPanelGnuPLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel15, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel13, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel14, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel16, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel24, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel25, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel26, GroupLayout.Alignment.TRAILING)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelGnuPLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldAPOptions, GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldAdcComand, GroupLayout.Alignment.TRAILING).addComponent(this.jComboBoxLegendType, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.jSpinnerPlotInterval, GroupLayout.Alignment.TRAILING).addComponent(this.jSpinnerLineWidth, GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldyTitleGnuP, GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldxTitleGnuP, GroupLayout.Alignment.TRAILING).addComponent(this.jComboBoxLineStyle, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxXColumnGnuP, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxYColumnGnuP, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxLegendLocation, 0, 542, Short.MAX_VALUE).addGroup(jPanelGnuPLayout.createSequentialGroup().addComponent(this.jTextFieldGNUPath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonGnuoPath)).addGroup(jPanelGnuPLayout.createSequentialGroup().addGroup(jPanelGnuPLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxDeleteScript).addComponent(this.jCheckBoxSmooth)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jComboBoxOutPTypeGnuP, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanelGnuPLayout.setVerticalGroup(jPanelGnuPLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelGnuPLayout.createSequentialGroup().addContainerGap().addGroup(jPanelGnuPLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldGNUPath, -2, -1, -2).addComponent(this.jButtonGnuoPath).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelGnuPLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxOutPTypeGnuP, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelGnuPLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxLineStyle, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelGnuPLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxXColumnGnuP, -2, -1, -2).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelGnuPLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldxTitleGnuP, -2, -1, -2).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelGnuPLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxYColumnGnuP, -2, -1, -2).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelGnuPLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldyTitleGnuP, -2, -1, -2).addComponent(this.jLabel11)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelGnuPLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerLineWidth, -2, -1, -2).addComponent(this.jLabel13)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelGnuPLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerPlotInterval, -2, -1, -2).addComponent(this.jLabel14)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelGnuPLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxSmooth).addComponent(this.jLabel15)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelGnuPLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxDeleteScript).addComponent(this.jLabel16)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelGnuPLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxLegendLocation, -2, -1, -2).addComponent(this.jLabel24)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelGnuPLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxLegendType, -2, -1, -2).addComponent(this.jLabel25)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelGnuPLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldAdcComand, -2, -1, -2).addComponent(this.jLabel26)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelGnuPLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldAPOptions, -2, -1, -2).addComponent(this.jLabel27)).addGap(186, 186, 186)));
        this.jScrollPaneGnuP.setViewportView(this.jPanelGnuP);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(128, 128, 128).addComponent(this.jButtonAceptGnuP).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonResetGnuP).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.jScrollPaneGnuP, -1, 700, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneGnuP, -2, 247, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonAceptGnuP).addComponent(this.jButtonResetGnuP))));
        this.jTabbedPane1.addTab("GnuPlot", this.jPanel3);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jTabbedPane1, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTabbedPane1, -2, -1, -2).addGap(7, 7, 7)));
    }

    private void jButtonInPathActionPerformed(ActionEvent evt) {
        this.path = this.getDirectory("open", 1);
        if (!this.path.equals("")) {
            this.reset();
            this.resetP();
            this.jTextFieldResultPath.setText(this.path);
            this.rf = new ReadFile(this.path);
            String str = this.rf.processFiles();
            if (str.equals("")) {
                String[] measuresNames;
                int i;
                int algSize = this.rf.getAlgShortNames().size();
                int streamSize = this.rf.getStream().size();
                this.measures = this.rf.getMeasures();
                for (i = 0; i < algSize; ++i) {
                    this.algoritmModel.addRow(new Object[]{this.rf.getAlgNames().get(i), this.rf.getAlgShortNames().get(i)});
                }
                for (i = 0; i < streamSize; ++i) {
                    this.streamModel.addRow(new Object[]{this.rf.getStream().get(i), this.rf.getStream().get(i)});
                }
                for (String measuresName : measuresNames = this.measures.getFirst().split(",")) {
                    this.jComboBoxXColumn.addItem(measuresName);
                    this.jComboBoxYColumn.addItem(measuresName);
                    this.jComboBoxXColumnGnuP.addItem(measuresName);
                    this.jComboBoxYColumnGnuP.addItem(measuresName);
                    if (measuresName.equals("learning evaluation instances")) {
                        this.jComboBoxXColumn.setSelectedItem(measuresName);
                        this.jComboBoxXColumnGnuP.setSelectedItem(measuresName);
                    }
                    if (!measuresName.equals("classifications correct (percent)") && !measuresName.equals("[avg] classifications correct (percent)")) continue;
                    this.jComboBoxYColumn.setSelectedItem(measuresName);
                    this.jComboBoxYColumnGnuP.setSelectedItem(measuresName);
                }
            } else {
                JOptionPane.showMessageDialog(this, str, "Error", 0);
            }
        }
    }

    private void jButtonDeletAlgorithmActionPerformed(ActionEvent evt) {
        if (this.jTableAlgoritms.getSelectedRow() != -1) {
            this.algoritmModel.removeRow(this.jTableAlgoritms.getSelectedRow());
            String[] algorithms = new String[this.algoritmModel.getRowCount()];
            for (int i = 0; i < this.algoritmModel.getRowCount(); ++i) {
                algorithms[i] = this.algoritmModel.getValueAt(i, 0).toString();
            }
            if (this.streamModel.getValueAt(0, 0).toString() != null) {
                String s = this.streamModel.getValueAt(0, 0).toString();
                this.rf.updateMeasures(algorithms, s);
                this.measures = this.rf.getMeasures();
                String[] measuresNames = this.measures.getFirst().split(",");
                this.jComboBoxXColumn.removeAllItems();
                this.jComboBoxYColumn.removeAllItems();
                this.jComboBoxXColumnGnuP.removeAllItems();
                this.jComboBoxYColumnGnuP.removeAllItems();
                for (String measuresName : measuresNames) {
                    this.jComboBoxXColumn.addItem(measuresName);
                    this.jComboBoxYColumn.addItem(measuresName);
                    this.jComboBoxXColumnGnuP.addItem(measuresName);
                    this.jComboBoxYColumnGnuP.addItem(measuresName);
                    if (measuresName.equals("learning evaluation instances")) {
                        this.jComboBoxXColumn.setSelectedItem(measuresName);
                        this.jComboBoxXColumnGnuP.setSelectedItem(measuresName);
                    }
                    if (!measuresName.equals("classifications correct (percent)") && !measuresName.equals("[avg] classifications correct (percent)")) continue;
                    this.jComboBoxYColumn.setSelectedItem(measuresName);
                    this.jComboBoxYColumnGnuP.setSelectedItem(measuresName);
                }
            }
        }
    }

    private void jButtonDeleteStreamActionPerformed(ActionEvent evt) {
        this.streamModel.removeRow(this.jTableStreams.getSelectedRow());
    }

    private void jButtonAceptActionPerformed(ActionEvent evt) {
        int algCount = this.jTableAlgoritms.getRowCount();
        int streamCount = this.jTableStreams.getRowCount();
        this.chart = new ImageChart[streamCount];
        for (int i = 0; i < streamCount; ++i) {
            String streamName = this.jTableStreams.getModel().getValueAt(i, 0).toString();
            String streamID = this.jTableStreams.getModel().getValueAt(i, 1).toString();
            XYSeriesCollection dataset = new XYSeriesCollection();
            for (int j = 0; j < algCount; ++j) {
                try {
                    String algName = this.jTableAlgoritms.getModel().getValueAt(j, 0).toString();
                    String algID = this.jTableAlgoritms.getModel().getValueAt(j, 1).toString();
                    String algPath = FilenameUtils.separatorsToSystem((String)(this.path + "\\" + streamName + "\\" + algName));
                    File inputFile = new File(algPath);
                    if (!inputFile.exists()) {
                        JOptionPane.showMessageDialog(this, "File not found: " + inputFile.getAbsolutePath(), "Error", 0);
                        return;
                    }
                    ArrayList<String[]> data = ReadFile.readCSV(algPath);
                    XYSeries series = new XYSeries((Comparable)((Object)algID));
                    int x = ReadFile.getMeasureIndex(algPath, this.jComboBoxXColumn.getSelectedItem().toString());
                    int y = ReadFile.getMeasureIndex(algPath, this.jComboBoxYColumn.getSelectedItem().toString());
                    for (String[] s : data) {
                        series.add(Double.parseDouble(s[x]), Double.parseDouble(s[y]));
                    }
                    dataset.addSeries(series);
                    continue;
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(PlotTab.class.getName()).log(Level.SEVERE, null, ex);
                    continue;
                }
                catch (IOException ex) {
                    Logger.getLogger(PlotTab.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            JFreeChart imgChart = ChartFactory.createXYLineChart((String)this.jTextFieldTitle.getText(), (String)this.jTextFieldxTitle.getText(), (String)this.jTextFieldyTitle.getText(), (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            XYPlot plot = imgChart.getXYPlot();
            switch (this.jComboBoxGrid.getSelectedItem().toString()) {
                case "White": {
                    plot.setBackgroundPaint((Paint)Color.white);
                    break;
                }
                case "Default": {
                    plot.setBackgroundPaint((Paint)Color.lightGray);
                }
            }
            if (this.jCheckBoxShape.isSelected()) {
                XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
                renderer.setSeriesLinesVisible(0, true);
                renderer.setSeriesShapesVisible(1, false);
                for (int k = 0; k < algCount; ++k) {
                    renderer.setSeriesPaint(k, (Paint)Color.black);
                }
                plot.setRenderer((XYItemRenderer)renderer);
            }
            this.chart[i] = new ImageChart(streamID, imgChart, (Integer)this.jSpinnerWidth.getValue(), (Integer)this.jSpinnerHeight.getValue());
        }
        this.imgPanel = new ImageTreePanel(this.chart);
        new ImageViewer(this.imgPanel, this.path);
    }

    private void jButtonResetActionPerformed(ActionEvent evt) {
        this.reset();
    }

    private void jButtonAceptGnuPActionPerformed(ActionEvent evt) {
        if (!this.jTextFieldResultPath.getText().equals("")) {
            String outPath = this.getDirectory("open", 1);
            if (!outPath.equals("")) {
                File resultFile = new File(this.jTextFieldResultPath.getText());
                String resultDirectory = resultFile.getAbsolutePath();
                String gnuPlotPath = this.jTextFieldGNUPath.getText();
                String gnuplotScriptPath = null;
                File gnuplotDir = new File(gnuPlotPath);
                if (!gnuplotDir.exists()) {
                    JOptionPane.showMessageDialog(this, "Gnuplot directory not found: " + gnuPlotPath, "Error", 0);
                    return;
                }
                String[] algShortName = new String[this.jTableAlgoritms.getRowCount()];
                String[] algName = new String[this.jTableAlgoritms.getRowCount()];
                for (int i = 0; i < this.jTableStreams.getRowCount(); ++i) {
                    String streamName = this.jTableStreams.getModel().getValueAt(i, 0).toString();
                    String streamShortName = this.jTableStreams.getModel().getValueAt(i, 1).toString();
                    for (int j = 0; j < this.jTableAlgoritms.getRowCount(); ++j) {
                        algName[j] = this.jTableAlgoritms.getModel().getValueAt(j, 0).toString();
                        algShortName[j] = this.jTableAlgoritms.getModel().getValueAt(j, 1).toString();
                        File inputFile = new File(FilenameUtils.separatorsToSystem((String)(this.path + "\\" + streamName + "\\" + algName[j])));
                        if (inputFile.exists()) continue;
                        JOptionPane.showMessageDialog(this, "File not found: " + inputFile.getAbsolutePath(), "Error", 0);
                        return;
                    }
                    gnuplotScriptPath = resultDirectory + File.separator + resultFile.getName() + ".plt";
                    String script = this.createScript(streamName, algName, algShortName, outPath);
                    File scriptFile = this.writeScriptToFile(gnuplotScriptPath, script);
                    String gnuplotCommand = gnuPlotPath + File.separator + "gnuplot \"" + gnuplotScriptPath + "\"";
                    String gnuplotOutput = "";
                    try {
                        String line;
                        Process p = Runtime.getRuntime().exec(gnuplotCommand);
                        BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                        while ((line = err.readLine()) != null) {
                            gnuplotOutput = gnuplotOutput + line + System.getProperty("line.separator");
                        }
                        err.close();
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(this, "Error while executing gnuplot script", "Error", 0);
                        throw new RuntimeException("Error while executing gnuplot script:" + scriptFile, ex);
                    }
                    if (!this.jCheckBoxDeleteScript.isSelected()) continue;
                    scriptFile.delete();
                }
                JOptionPane.showMessageDialog(this, "Figures created at " + new File(resultFile.getAbsolutePath()).getParent(), "", 1);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Plot output file option not set!", "Error", 0);
        }
    }

    private void jButtonResetGnuPActionPerformed(ActionEvent evt) {
        this.resetP();
    }

    private void jButtonGnuoPathActionPerformed(ActionEvent evt) {
        this.jTextFieldGNUPath.setText(this.getDirectory("open", 1));
    }

    private void jComboBoxLegendLocationActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldGNUPathActionPerformed(ActionEvent evt) {
    }

    public void readData(String path) {
        this.reset();
        this.resetP();
        this.jTextFieldResultPath.setText(path);
        this.path = path;
        this.rf = new ReadFile(path);
        String str = this.rf.processFiles();
        if (str.equals("")) {
            String[] measuresNames;
            int i;
            int algSize = this.rf.getAlgShortNames().size();
            int streamSize = this.rf.getStream().size();
            this.measures = this.rf.getMeasures();
            for (i = 0; i < algSize; ++i) {
                this.algoritmModel.addRow(new Object[]{this.rf.getAlgNames().get(i), this.rf.getAlgShortNames().get(i)});
            }
            for (i = 0; i < streamSize; ++i) {
                this.streamModel.addRow(new Object[]{this.rf.getStream().get(i), this.rf.getStream().get(i)});
            }
            for (String measuresName : measuresNames = this.measures.getFirst().split(",")) {
                this.jComboBoxXColumn.addItem(measuresName);
                this.jComboBoxYColumn.addItem(measuresName);
                this.jComboBoxXColumnGnuP.addItem(measuresName);
                this.jComboBoxYColumnGnuP.addItem(measuresName);
                if (measuresName.equals("learning evaluation instances")) {
                    this.jComboBoxXColumn.setSelectedItem(measuresName);
                    this.jComboBoxXColumnGnuP.setSelectedItem(measuresName);
                }
                if (!measuresName.equals("classifications correct (percent)") && !measuresName.equals("[avg] classifications correct (percent)")) continue;
                this.jComboBoxYColumn.setSelectedItem(measuresName);
                this.jComboBoxYColumnGnuP.setSelectedItem(measuresName);
            }
        } else {
            JOptionPane.showMessageDialog(this, str, "Error", 0);
        }
    }

    private String getDirectory(String type, int filter) {
        BaseDirectoryChooser gnuPlotDir = new BaseDirectoryChooser();
        gnuPlotDir.setFileSelectionMode(filter);
        int selection = -1;
        if (type.equals("open")) {
            selection = gnuPlotDir.showOpenDialog((Component)this);
        }
        if (selection == 0) {
            try {
                return gnuPlotDir.getSelectedFile().getAbsolutePath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public void cleanTables() {
        try {
            int i;
            DefaultTableModel algModel = (DefaultTableModel)this.jTableAlgoritms.getModel();
            DefaultTableModel strModel = (DefaultTableModel)this.jTableStreams.getModel();
            int rows = this.jTableAlgoritms.getRowCount();
            int srow = this.jTableStreams.getRowCount();
            for (i = 0; i < rows; ++i) {
                algModel.removeRow(0);
            }
            for (i = 0; i < srow; ++i) {
                strModel.removeRow(0);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error cleaning the table.");
        }
    }

    private void reset() {
        this.cleanTables();
        this.jTextFieldResultPath.setText("");
        this.jTextFieldxTitle.setText("Instances processed");
        this.jTextFieldyTitle.setText("% of correctly classified");
        this.jComboBoxXColumn.removeAllItems();
        this.jComboBoxYColumn.removeAllItems();
        this.jSpinnerWidth.setValue(500);
        this.jSpinnerHeight.setValue(300);
        this.jCheckBoxShape.setSelected(false);
        this.jComboBoxGrid.setSelectedItem("White");
    }

    private void resetP() {
        this.cleanTables();
        this.jTextFieldGNUPath.setText("");
        this.jTextFieldResultPath.setText("");
        this.jTextFieldAPOptions.setText("");
        this.jTextFieldAdcComand.setText("");
        this.jTextFieldxTitleGnuP.setText("Instances processed");
        this.jTextFieldyTitleGnuP.setText("% of correctly classified");
        this.jComboBoxLegendLocation.setSelectedIndex(0);
        this.jComboBoxLegendType.setSelectedIndex(0);
        this.jComboBoxLineStyle.setSelectedIndex(0);
        this.jComboBoxOutPTypeGnuP.setSelectedIndex(0);
        this.jComboBoxXColumnGnuP.removeAllItems();
        this.jComboBoxYColumnGnuP.removeAllItems();
        this.jSpinnerLineWidth.setValue(2);
        this.jSpinnerPlotInterval.setValue(0);
    }

    private String createScript(String streamName, String[] algName, String[] algShortName, String outPath) {
        String imgName;
        String newLine = System.getProperty("line.separator");
        int sourceFileIdx = 0;
        boolean eps = false;
        switch (this.jComboBoxOutPTypeGnuP.getSelectedItem().toString()) {
            case "GIF": {
                imgName = outPath + File.separator + streamName + "GP.gif";
                break;
            }
            case "JPEG": {
                imgName = outPath + File.separator + streamName + "GP.JPEG";
                break;
            }
            case "LATEX": {
                imgName = outPath + File.separator + streamName + "GP.tex";
                break;
            }
            case "PDFCAIRO": {
                imgName = outPath + File.separator + streamName + "GP.pdf";
                break;
            }
            case "PNG": {
                imgName = outPath + File.separator + streamName + "GP.PNG";
                break;
            }
            case "PSTEX": {
                imgName = outPath + File.separator + streamName + "GP.tex";
                break;
            }
            case "PSTRICKS": {
                imgName = outPath + File.separator + streamName + "GP.tex";
                break;
            }
            case "PSLATEX": {
                imgName = outPath + File.separator + streamName + "GP.tex";
                break;
            }
            case "SVG": {
                imgName = outPath + File.separator + streamName + "GP.SVG";
                break;
            }
            default: {
                imgName = outPath + File.separator + streamName + "GP.eps";
                eps = true;
            }
        }
        String script = eps ? "set term " + this.terminalOptions(Terminal.valueOf(this.jComboBoxOutPTypeGnuP.getSelectedItem().toString())) + " eps " + newLine : "set term " + this.terminalOptions(Terminal.valueOf(this.jComboBoxOutPTypeGnuP.getSelectedItem().toString())) + newLine;
        script = script + "set loadpath '" + FilenameUtils.separatorsToSystem((String)(this.path + File.separator + streamName)) + "'" + newLine;
        script = script + "set output '" + imgName + "'" + newLine;
        script = script + "set datafile separator ','" + newLine;
        script = script + "set style line 1 pt 8" + newLine;
        script = script + "set style line 2 lt rgb '#00C000'" + newLine;
        script = script + "set style line 5 lt rgb '#FFD800'" + newLine;
        script = script + "set style line 6 lt rgb '#4E0000'" + newLine;
        script = script + "set ylabel '" + this.jTextFieldyTitleGnuP.getText() + "'" + newLine;
        script = script + "set xlabel '" + this.jTextFieldxTitleGnuP.getText() + "'" + newLine;
        if (!this.jComboBoxLegendType.getSelectedItem().toString().equals((Object)LegendType.NONE)) {
            script = script + "set key " + this.jComboBoxLegendType.getSelectedItem().toString().toLowerCase().replace('_', ' ') + " " + this.jComboBoxLegendLocation.getSelectedItem().toString().toLowerCase().replace('_', ' ') + newLine;
        }
        script = script + this.jTextFieldAdcComand.getText();
        script = script + "plot " + this.jTextFieldAPOptions.getText() + " ";
        for (int i = 0; i < algName.length; ++i) {
            if (sourceFileIdx > 0) {
                script = script + ", ";
            }
            ++sourceFileIdx;
            script = script + "'" + algName[i] + "' using " + (this.jComboBoxXColumnGnuP.getSelectedIndex() + 1) + ":" + (this.jComboBoxYColumnGnuP.getSelectedIndex() + 1);
            if (this.jCheckBoxSmooth.isSelected()) {
                script = script + ":(1.0) smooth bezier";
            }
            script = script + " with " + this.jComboBoxLineStyle.getSelectedItem().toString().toLowerCase() + " ls " + sourceFileIdx + " lw " + this.jSpinnerLineWidth.getValue().toString();
            if (this.jComboBoxLineStyle.getSelectedItem().toString().equals(PlotStyle.LINESPOINTS.toString()) && Integer.parseInt(this.jSpinnerPlotInterval.getValue().toString()) > 0) {
                script = script + " pointinterval " + this.jSpinnerPlotInterval.getValue().toString();
            }
            script = script + " title '" + algShortName[i] + "'";
        }
        script = script + newLine;
        return script;
    }

    private File writeScriptToFile(String gnuplotScriptPath, String script) {
        File scriptFile = new File(gnuplotScriptPath);
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(scriptFile));
            writer.write(script);
            writer.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to create or write to script file: " + scriptFile, ex);
        }
        return scriptFile;
    }

    private String terminalOptions(Terminal term) {
        String options;
        switch (term) {
            case POSTSCRIPT: {
                options = "postscript enhanced";
                break;
            }
            case POSTSCRIPT_COLOR: {
                options = "postscript color enhanced";
                break;
            }
            default: {
                options = term.toString().toLowerCase();
            }
        }
        return options;
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Test");
        frame.setDefaultCloseOperation(3);
        PlotTab panel = new PlotTab();
        panel.setOpaque(true);
        frame.setContentPane(panel);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            LookAndFeel.install();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PlotTab.createAndShowGUI();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum Terminal {
        CANVAS,
        EPSLATEX,
        GIF,
        JPEG,
        LATEX,
        PDFCAIRO,
        PNG,
        POSTSCRIPT,
        POSTSCRIPT_COLOR,
        PSLATEX,
        PSTEX,
        PSTRICKS,
        SVG;

    }

    public static enum PlotStyle {
        LINES,
        POINTS,
        LINESPOINTS,
        IMPULSES,
        STEPS,
        FSTEPS,
        HISTEPS,
        DOTS;

    }

    public static enum LegendType {
        NONE,
        BOX_VERTICAL,
        BOX_HORIZONTAL,
        NOBOX_VERTICAL,
        NOBOX_HORIZONTAL;

    }
}

