/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.experimentertab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import moa.gui.LookAndFeel;
import moa.gui.experimentertab.Measure;
import moa.gui.experimentertab.ReadFile;
import moa.gui.experimentertab.Stream;
import moa.gui.experimentertab.Summary;
import moa.gui.experimentertab.SummaryTable;
import moa.gui.experimentertab.SummaryViewer;
import nz.ac.waikato.cms.gui.core.BaseDirectoryChooser;
import org.apache.commons.io.FilenameUtils;

public class SummaryTab
extends JPanel {
    private JButton jButtonResults;
    private JButton jButtonDelAlgoritm;
    private JButton jButtonDelStream;
    private JButton jButtonDelMeasure;
    private JButton jButtonDleteRow;
    private JButton jButtonSummarize;
    private JButton jButtonAddMeasure;
    private JButton jButtonShowSummary;
    private JPanel jPanelConfig;
    private JScrollPane jScrollPaneAlgorithms;
    private JScrollPane jScrollPaneStreams;
    private JScrollPane jScrollPaneMeasure;
    private JTable jTableAlgoritms;
    private JTable jTableStreams;
    private JTable jTableMeasures;
    private JTextField jTextFieldResultsPath;
    private JComboBox jComboBoxMeasure;
    private JComboBox option;
    private JLabel jLabelResults;
    private JLabel jLabelMeasure;
    private DefaultTableModel algoritmModel;
    private DefaultTableModel streamModel;
    private DefaultTableModel measureModel;
    public LinkedList<String> measures;
    private ArrayList<String> algotithmID;
    private LinkedList<String> algorithmNames;
    private LinkedList<String> streamNames;
    Summary summary;
    ReadFile rf;

    public SummaryTab() {
        this.initComponents();
        this.measures = new LinkedList();
        this.algotithmID = new ArrayList();
        this.algorithmNames = new LinkedList();
        this.streamNames = new LinkedList();
        this.algoritmModel = (DefaultTableModel)this.jTableAlgoritms.getModel();
        this.streamModel = (DefaultTableModel)this.jTableStreams.getModel();
        this.measureModel = (DefaultTableModel)this.jTableMeasures.getModel();
        TableColumn col = this.jTableMeasures.getColumnModel().getColumn(2);
        String[] op = new String[]{"Mean", "Last Value"};
        this.option = new JComboBox<String>(op);
        this.option.setSelectedIndex(0);
        col.setCellEditor(new DefaultCellEditor(this.option));
        TableColumn col1 = this.jTableMeasures.getColumnModel().getColumn(0);
    }

    private void initComponents() {
        this.jPanelConfig = new JPanel();
        this.jScrollPaneAlgorithms = new JScrollPane();
        this.jTableAlgoritms = new JTable();
        this.jScrollPaneStreams = new JScrollPane();
        this.jTableStreams = new JTable();
        this.jTextFieldResultsPath = new JTextField();
        this.jButtonResults = new JButton();
        this.jButtonAddMeasure = new JButton();
        this.jButtonShowSummary = new JButton();
        this.jScrollPaneMeasure = new JScrollPane();
        this.jTableMeasures = new JTable();
        this.jButtonDelAlgoritm = new JButton();
        this.jButtonDelStream = new JButton();
        this.jButtonDleteRow = new JButton();
        this.jButtonSummarize = new JButton();
        this.jButtonDelMeasure = new JButton();
        this.jLabelResults = new JLabel();
        this.jLabelMeasure = new JLabel();
        this.jComboBoxMeasure = new JComboBox();
        this.jPanelConfig.setBorder(BorderFactory.createTitledBorder(null, "Configure", 0, 0, new Font("Tahoma", 0, 12)));
        this.jScrollPaneAlgorithms.setBorder(BorderFactory.createTitledBorder("Algorithms"));
        this.jTableAlgoritms.setModel(new DefaultTableModel(new Object[0][], new String[]{"Algorithm", "Algorithm ID"}));
        this.jTableAlgoritms.setEditingColumn(1);
        this.jScrollPaneAlgorithms.setViewportView(this.jTableAlgoritms);
        this.jScrollPaneStreams.setBorder(BorderFactory.createTitledBorder("Streams"));
        this.jTableStreams.setModel(new DefaultTableModel(new Object[0][], new String[]{"Stream", "Stream ID"}));
        this.jScrollPaneStreams.setViewportView(this.jTableStreams);
        this.jTextFieldResultsPath.setEditable(true);
        this.jLabelResults.setHorizontalAlignment(4);
        this.jLabelResults.setLabelFor(this.jTextFieldResultsPath);
        this.jLabelResults.setText("Result folder");
        this.jButtonResults.setText("Browse");
        this.jButtonResults.addActionListener(this::jButtonResultsActionPerformed);
        this.jButtonAddMeasure.setText("Add Measure");
        this.jButtonAddMeasure.setToolTipText("Add Measure");
        this.jButtonAddMeasure.addActionListener(evt -> {});
        this.jTableMeasures.setModel(new DefaultTableModel(new Object[0][], new String[]{"Measure", "Measure ID", "Option"}));
        this.jScrollPaneMeasure.setBorder(BorderFactory.createTitledBorder("Performance measures"));
        this.jScrollPaneMeasure.setViewportView(this.jTableMeasures);
        this.jButtonDelAlgoritm.setText("Delete Algorithm");
        this.jButtonDelAlgoritm.addActionListener(this::jButtonDelAlgoritmActionPerformed);
        this.jButtonDelStream.setText("Delete Stream");
        this.jButtonDelStream.addActionListener(this::jButtonDelStreamActionPerformed);
        this.jButtonDelMeasure.setText("Delete Measure");
        this.jButtonDelMeasure.addActionListener(this::jButtonDelMeasureActionPerformed);
        this.jButtonSummarize.setText("Export Summary");
        this.jButtonSummarize.setEnabled(false);
        this.jButtonSummarize.addActionListener(this::jButtonSummaryActionPerformed);
        this.jButtonShowSummary.setText("Show Summary");
        this.jButtonShowSummary.setEnabled(true);
        this.jButtonShowSummary.addActionListener(this::jButtonShowSummaryActionPerformed);
        this.jLabelMeasure.setText("Measures");
        this.jComboBoxMeasure.setModel(new DefaultComboBoxModel<String>(new String[]{"--Slect--"}));
        this.jButtonAddMeasure.addActionListener(this::jButtonAddMeasureActionPerformed);
        JPanel jPanel1 = new JPanel();
        jPanel1.setBorder(BorderFactory.createTitledBorder("Configuration"));
        JLabel jLabelDirectory = new JLabel("Result folder");
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(14, 14, 14).addComponent(jLabelDirectory).addGap(18, 18, 18).addComponent(this.jTextFieldResultsPath).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonResults)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonDelAlgoritm).addComponent(this.jScrollPaneAlgorithms, -1, 341, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneStreams, -1, 332, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonDelStream).addGap(0, 0, Short.MAX_VALUE))))).addGap(16, 16, 16)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(23, 23, 23).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldResultsPath, -2, 23, -2).addComponent(this.jButtonResults).addComponent(jLabelDirectory)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneAlgorithms, -1, 305, Short.MAX_VALUE).addComponent(this.jScrollPaneStreams, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonDelStream).addComponent(this.jButtonDelAlgoritm))));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 741, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap())));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 443, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap())));
        JPanel panelMeasure = new JPanel();
        panelMeasure.setLayout(new BorderLayout());
        panelMeasure.add((Component)this.jLabelMeasure, "West");
        panelMeasure.add((Component)this.jComboBoxMeasure, "Center");
        panelMeasure.add((Component)this.jButtonAddMeasure, "East");
        JPanel panelMeasuresTable = new JPanel();
        JPanel panelTaskTableBtn = new JPanel();
        panelTaskTableBtn.add(this.jButtonShowSummary);
        panelTaskTableBtn.add(this.jButtonDelMeasure);
        panelMeasuresTable.setLayout(new BorderLayout());
        panelMeasuresTable.add((Component)panelMeasure, "North");
        panelMeasuresTable.add((Component)this.jScrollPaneMeasure, "Center");
        panelMeasuresTable.add((Component)panelTaskTableBtn, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel1, "North");
        this.add((Component)panelMeasuresTable, "Center");
    }

    private void jButtonDelAlgoritmActionPerformed(ActionEvent evt) {
        if (this.jTableAlgoritms.getSelectedRow() != -1) {
            this.algoritmModel.removeRow(this.jTableAlgoritms.getSelectedRow());
            String[] algorithms = new String[this.algoritmModel.getRowCount()];
            for (int i = 0; i < this.algoritmModel.getRowCount(); ++i) {
                algorithms[i] = this.algoritmModel.getValueAt(i, 0).toString();
            }
            if (this.streamModel.getValueAt(0, 0).toString() != null) {
                this.rf.updateMeasures(algorithms, this.streamModel.getValueAt(0, 0).toString());
                this.measures = this.rf.getMeasures();
                String[] measuresNames = this.measures.getFirst().split(",");
                this.jComboBoxMeasure.removeAllItems();
                for (String measuresName : measuresNames) {
                    this.jComboBoxMeasure.addItem(measuresName);
                }
            }
        }
    }

    private void jButtonDelStreamActionPerformed(ActionEvent evt) {
        this.streamModel.removeRow(this.jTableStreams.getSelectedRow());
    }

    private void jButtonDelMeasureActionPerformed(ActionEvent evt) {
        this.measureModel.removeRow(this.jTableMeasures.getSelectedRow());
    }

    private void jButtonAddMeasureActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.measureModel.getRowCount(); ++i) {
            if (this.jComboBoxMeasure.getSelectedItem().equals(this.measureModel.getValueAt(i, 0))) {
                JOptionPane.showMessageDialog(this, "The value exist", "Error", 0);
                return;
            }
            if (!this.jComboBoxMeasure.getSelectedItem().equals("--Slect--")) continue;
            JOptionPane.showMessageDialog(this, "There are not values", "Error", 0);
            return;
        }
        this.measureModel.addRow(new Object[]{this.jComboBoxMeasure.getSelectedItem(), this.jComboBoxMeasure.getSelectedItem(), "Mean"});
    }

    private void jButtonShowSummaryActionPerformed(ActionEvent evt) {
        if (this.jTextFieldResultsPath.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Directory not found", "Error", 0);
            return;
        }
        ArrayList<Measure> algmeasures = new ArrayList<Measure>();
        ArrayList<Stream> streams = new ArrayList<Stream>();
        ArrayList<String> algPath = new ArrayList<String>();
        ArrayList<String> algShortNames = new ArrayList<String>();
        int count = 0;
        for (int i = 0; i < this.measureModel.getRowCount(); ++i) {
            for (int j = 0; j < this.jComboBoxMeasure.getItemCount(); ++j) {
                if (this.measureModel.getValueAt(i, 0).equals(this.jComboBoxMeasure.getItemAt(j))) {
                    ++count;
                }
                if (!this.measureModel.getValueAt(i, 0).equals("") && !this.measureModel.getValueAt(i, 1).equals("") && this.measureModel.getValueAt(i, 2) != null) continue;
                JOptionPane.showMessageDialog(this, "There are fields incompleted in Table", "Error", 0);
                return;
            }
        }
        boolean type = true;
        for (int k = 0; k < this.measureModel.getRowCount(); ++k) {
            type = this.measureModel.getValueAt(k, 2).equals("Mean");
            Measure m = new Measure(this.measureModel.getValueAt(k, 1).toString(), this.measureModel.getValueAt(k, 0).toString(), type, 0);
            algmeasures.add(m);
        }
        String path = this.jTextFieldResultsPath.getText();
        for (int i = 0; i < this.streamModel.getRowCount(); ++i) {
            algPath.clear();
            for (int j = 0; j < this.algoritmModel.getRowCount(); ++j) {
                File inputFile = new File(FilenameUtils.separatorsToSystem((String)(path + "\\" + this.streamModel.getValueAt(i, 0) + "\\" + this.algoritmModel.getValueAt(j, 0))));
                File streamFile = new File(FilenameUtils.separatorsToSystem((String)(path + "\\" + this.streamModel.getValueAt(i, 0))));
                if (!inputFile.exists()) {
                    JOptionPane.showMessageDialog(this, "File not found: " + inputFile.getAbsolutePath(), "Error", 0);
                    return;
                }
                String algorithmPath = FilenameUtils.separatorsToSystem((String)(path + "\\" + this.streamModel.getValueAt(i, 0).toString() + "\\" + this.algoritmModel.getValueAt(j, 0).toString()));
                algPath.add(algorithmPath);
                if (i != 0) continue;
                algShortNames.add(this.algoritmModel.getValueAt(j, 1).toString());
            }
            Stream s = new Stream(this.streamModel.getValueAt(i, 1).toString(), algPath, algShortNames, algmeasures);
            streams.add(s);
        }
        try {
            this.summary = new Summary(streams, FilenameUtils.separatorsToSystem((String)(path + "\\")));
            this.jButtonSummarize.setEnabled(true);
            SummaryTable[] table = this.summary.showSummary();
            SummaryViewer summaryViewer = new SummaryViewer(table, this.summary, this.jTextFieldResultsPath.getText());
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(this, "Problems generating summaries", "Error", 0);
        }
    }

    private void jButtonSummaryActionPerformed(ActionEvent evt) {
    }

    private void jButtonResultsActionPerformed(ActionEvent evt) {
        BaseDirectoryChooser resultsDir = new BaseDirectoryChooser();
        resultsDir.setFileSelectionMode(1);
        int selection = -1;
        String path = "";
        selection = resultsDir.showOpenDialog((Component)this);
        if (selection == 0) {
            try {
                path = resultsDir.getSelectedFile().getAbsolutePath();
                this.readData(path);
            }
            catch (Exception exp) {
                JOptionPane.showMessageDialog(this, "Problem with path", "Error", 0);
            }
        }
    }

    public void summaryCMD(String[] measures, String[] types) {
        ArrayList<Measure> algmeasures = new ArrayList<Measure>();
        ArrayList<Stream> streams = new ArrayList<Stream>();
        ArrayList<String> algPath = new ArrayList<String>();
        ArrayList<String> algShortNames = new ArrayList<String>();
        boolean type = true;
        for (int k = 0; k < measures.length; ++k) {
            type = types[k].equals("Mean");
            Measure m = new Measure(measures[k], measures[k], type, 0);
            algmeasures.add(m);
        }
        String path = this.jTextFieldResultsPath.getText();
        for (int i = 0; i < this.streamModel.getRowCount(); ++i) {
            algPath.clear();
            for (int j = 0; j < this.algoritmModel.getRowCount(); ++j) {
                File inputFile = new File(FilenameUtils.separatorsToSystem((String)(path + "\\" + this.streamModel.getValueAt(i, 0) + "\\" + this.algoritmModel.getValueAt(j, 0))));
                File streamFile = new File(FilenameUtils.separatorsToSystem((String)(path + "\\" + this.streamModel.getValueAt(i, 0))));
                if (!inputFile.exists()) {
                    System.out.println("File not found: " + inputFile.getAbsolutePath());
                    return;
                }
                String algorithmPath = FilenameUtils.separatorsToSystem((String)(path + "\\" + this.streamModel.getValueAt(i, 0).toString() + "\\" + this.algoritmModel.getValueAt(j, 0).toString()));
                algPath.add(algorithmPath);
                if (i != 0) continue;
                algShortNames.add(this.algoritmModel.getValueAt(j, 1).toString());
            }
            Stream s = new Stream(this.streamModel.getValueAt(i, 1).toString(), algPath, algShortNames, algmeasures);
            streams.add(s);
        }
        try {
            this.summary = new Summary(streams, FilenameUtils.separatorsToSystem((String)(path + File.separator)));
            this.jButtonSummarize.setEnabled(true);
            String summaryPath = this.jTextFieldResultsPath.getText() + File.separator;
            this.summary.invertedSumariesPerMeasure(summaryPath);
            this.summary.computeWinsTiesLossesHTML(summaryPath);
            this.summary.computeWinsTiesLossesLatex(summaryPath);
            this.summary.generateHTML(summaryPath);
            this.summary.generateLatex(summaryPath);
            System.out.println("Summaries created at: " + summaryPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void readData(String path) {
        this.jTextFieldResultsPath.setText(path);
        this.cleanTables();
        this.rf = new ReadFile(path);
        String str = this.rf.processFiles();
        if (str.equals("")) {
            this.algotithmID = this.rf.getAlgShortNames();
            this.algorithmNames = this.rf.getAlgNames();
            this.streamNames = this.rf.getStream();
            this.measures = this.rf.getMeasures();
            for (int i = 0; i < this.algotithmID.size(); ++i) {
                this.algoritmModel.addRow(new Object[]{this.algorithmNames.get(i), this.algotithmID.get(i)});
            }
            this.streamNames.stream().forEach(streamName -> this.streamModel.addRow(new Object[]{streamName, streamName}));
            String[] measuresNames = this.measures.getFirst().split(",");
            this.jComboBoxMeasure.removeAllItems();
            for (String measuresName : measuresNames) {
                this.jComboBoxMeasure.addItem(measuresName);
            }
        } else {
            JOptionPane.showMessageDialog(this, str, "Error", 0);
        }
    }

    public void cleanTables() {
        try {
            int i;
            DefaultTableModel algModel = (DefaultTableModel)this.jTableAlgoritms.getModel();
            DefaultTableModel strModel = (DefaultTableModel)this.jTableStreams.getModel();
            DefaultTableModel measureModel = (DefaultTableModel)this.jTableMeasures.getModel();
            int rows = this.jTableAlgoritms.getRowCount();
            int srow = this.jTableStreams.getRowCount();
            int trow = this.jTableMeasures.getRowCount();
            for (i = 0; i < rows; ++i) {
                algModel.removeRow(0);
            }
            for (i = 0; i < srow; ++i) {
                strModel.removeRow(0);
            }
            for (i = 0; i < trow; ++i) {
                this.measureModel.removeRow(0);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error cleaning the table.");
        }
        this.jButtonSummarize.setEnabled(false);
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Test");
        frame.setDefaultCloseOperation(3);
        SummaryTab panel = new SummaryTab();
        panel.setOpaque(true);
        frame.setContentPane(panel);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            LookAndFeel.install();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SummaryTab.createAndShowGUI();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

