/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.experimentertab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import moa.classifiers.Classifier;
import moa.classifiers.bayes.NaiveBayes;
import moa.core.Globals;
import moa.core.StringUtils;
import moa.gui.ClassOptionSelectionPanel;
import moa.gui.LookAndFeel;
import moa.gui.experimentertab.AnalyzeTab;
import moa.gui.experimentertab.Buffer;
import moa.gui.experimentertab.ExpPreviewPanel;
import moa.gui.experimentertab.ExpTaskThread;
import moa.gui.experimentertab.ExperimeterCLI;
import moa.gui.experimentertab.PlotTab;
import moa.gui.experimentertab.PreviewExperiments;
import moa.gui.experimentertab.ReadFile;
import moa.gui.experimentertab.SummaryTab;
import moa.gui.experimentertab.tasks.ExperimenterTask;
import moa.learners.ChangeDetectorLearner;
import moa.learners.Learner;
import moa.options.AbstractOptionHandler;
import moa.options.ClassOption;
import moa.options.OptionHandler;
import moa.streams.ArffFileStream;
import moa.streams.InstanceStream;
import moa.streams.generators.AgrawalGenerator;
import moa.streams.generators.cd.ConceptDriftGenerator;
import moa.streams.generators.cd.GradualChangeGenerator;
import moa.tasks.EvaluateConceptDrift;
import moa.tasks.EvaluatePrequential;
import moa.tasks.MainTask;
import nz.ac.waikato.cms.gui.core.BaseDirectoryChooser;
import nz.ac.waikato.cms.gui.core.BaseFileChooser;
import org.apache.commons.io.FilenameUtils;

public class TaskManagerTabPanel
extends JPanel {
    protected MainTask currentTask = new EvaluatePrequential();
    protected Classifier learner = new NaiveBayes();
    protected AbstractOptionHandler stream = new AgrawalGenerator();
    protected DefaultTableModel algoritmModel;
    protected DefaultTableModel streamModel;
    protected List<ExpTaskThread> taskList = new ArrayList<ExpTaskThread>();
    protected TaskTableModel taskTableModel;
    protected JTable taskTable = new JTable();
    protected String initialString = "initial";
    protected ChangeDetectorLearner detector = new ChangeDetectorLearner();
    protected ConceptDriftGenerator detectorStream = new GradualChangeGenerator();
    protected ExpPreviewPanel previewPanel = new ExpPreviewPanel();
    private PreviewExperiments preview = new PreviewExperiments(this.previewPanel);
    DefaultListModel listModelMonitor = new DefaultListModel();
    public static final int MILLISECS_BETWEEN_REFRESH = 600;
    public static final char[] progressAnimSequence = new char[]{'-', '\\', '|', '/'};
    public static final int MAX_STATUS_STRING_LENGTH = 79;
    public SummaryTab summary = new SummaryTab();
    public PlotTab plot = new PlotTab();
    public AnalyzeTab analizeTab = new AnalyzeTab();
    protected String resultsPath = "";
    private JButton jButtonTask;
    private JButton jButtonAlgorithm;
    private JButton jButtonCancel;
    private JButton jButtonDelAlgoritm;
    private JButton jButtonDelStream;
    private JButton jButtonDelete;
    private JButton jButtonPause;
    private JButton jButtonResume;
    private JButton jButtonRun;
    private JButton jButtonStream;
    private JButton jButtonSaveConfig;
    private JButton jButtonOpenConfig;
    private JButton jButtonReset;
    private JButton jButtonDir;
    private JButton jButtonPreview;
    private JPanel jPanelConfig;
    private JScrollPane jScrollPaneAlgorithms;
    private JScrollPane jScrollPaneStreams;
    private JScrollPane jScrollPaneTaskTable;
    private JTable jTableAlgorithms;
    private JTable jTableStreams;
    private JTextField jTextFieldProcess;
    private JTextField jTextFieldTask;
    private JTextField jTextFieldDir;

    public TaskManagerTabPanel() {
        this.initComponents();
        this.algoritmModel = (DefaultTableModel)this.jTableAlgorithms.getModel();
        this.streamModel = (DefaultTableModel)this.jTableStreams.getModel();
        this.taskTableModel = new TaskTableModel();
        this.taskTable.setModel(this.taskTableModel);
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        this.taskTable.getColumnModel().getColumn(1).setCellRenderer(centerRenderer);
        this.taskTable.getColumnModel().getColumn(2).setCellRenderer(centerRenderer);
        this.taskTable.getColumnModel().getColumn(4).setCellRenderer(new ProgressCellRenderer());
        this.taskTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                TaskManagerTabPanel.this.taskSelectionChanged();
            }
        });
        Timer updateListTimer = new Timer(600, e -> this.taskTable.repaint());
        updateListTimer.start();
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Test");
        frame.setDefaultCloseOperation(3);
        TaskManagerTabPanel panel = new TaskManagerTabPanel();
        panel.setOpaque(true);
        frame.setContentPane(panel);
        frame.pack();
        frame.setVisible(true);
    }

    private void initComponents() {
        this.jPanelConfig = new JPanel();
        this.jScrollPaneAlgorithms = new JScrollPane();
        this.jTableAlgorithms = new JTable();
        this.jScrollPaneStreams = new JScrollPane();
        this.jTableStreams = new JTable();
        this.jTextFieldTask = new JTextField();
        this.jButtonTask = new JButton();
        this.jButtonAlgorithm = new JButton();
        this.jButtonStream = new JButton();
        this.jButtonRun = new JButton();
        this.jScrollPaneTaskTable = new JScrollPane();
        this.taskTable = new JTable();
        this.jTextFieldProcess = new JTextField();
        this.jTextFieldDir = new JTextField();
        this.jButtonDelAlgoritm = new JButton();
        this.jButtonDelStream = new JButton();
        this.jButtonPause = new JButton();
        this.jButtonResume = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonSaveConfig = new JButton();
        this.jButtonOpenConfig = new JButton();
        this.jButtonReset = new JButton();
        this.jButtonDir = new JButton();
        this.jButtonPreview = new JButton();
        this.jPanelConfig.setBorder(BorderFactory.createTitledBorder(null, "Configure", 0, 0, new Font("Tahoma", 0, 12)));
        this.jScrollPaneAlgorithms.setBorder(BorderFactory.createTitledBorder("Algorithms"));
        this.jTableAlgorithms.setModel(new DefaultTableModel(new Object[0][], new String[]{"Algorithm", "Algorithm ID"}));
        this.jTableAlgorithms.setEditingColumn(1);
        this.jScrollPaneAlgorithms.setViewportView(this.jTableAlgorithms);
        this.jScrollPaneStreams.setBorder(BorderFactory.createTitledBorder("Streams"));
        this.jTableStreams.setModel(new DefaultTableModel(new Object[0][], new String[]{"Stream", "Stream ID"}));
        this.jScrollPaneStreams.setViewportView(this.jTableStreams);
        this.jTextFieldTask.setEditable(false);
        this.jButtonTask.setText("Add Task");
        this.jButtonTask.addActionListener(this::jButtonTaskActionPerformed);
        this.jButtonDir.setText("Browse");
        this.jButtonDir.addActionListener(this::jButtonDirActionPerformed);
        this.jButtonPreview.setText("Preview");
        this.jButtonPreview.addActionListener(this::jButtonPreviewActionPerformed);
        this.jButtonAlgorithm.setText("Add Algorithm");
        this.jButtonAlgorithm.addActionListener(this::jButtonAlgorithmActionPerformed);
        this.jButtonStream.setText("Add Stream");
        this.jButtonStream.addActionListener(this::jButtonStreamActionPerformed);
        this.jButtonRun.setText("Run Experiment");
        this.jButtonRun.setToolTipText("Run task");
        this.jButtonRun.addActionListener(this::jButtonRunActionPerformed);
        this.jButtonOpenConfig.setText("Open Experiment");
        this.jButtonOpenConfig.setToolTipText("Open saved configuration file");
        this.jButtonOpenConfig.addActionListener(this::jButtonOpenConfigActionPerformed);
        this.jButtonSaveConfig.setText("Save Experiment");
        this.jButtonSaveConfig.setToolTipText("Save Configuration to file");
        this.jButtonSaveConfig.addActionListener(this::jButtonSaveConfigActionPerformed);
        this.jButtonReset.setText("Reset to Default");
        this.jButtonReset.setToolTipText("Reset all");
        this.jButtonReset.addActionListener(this::jButtonResetActionPerformed);
        this.taskTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPaneTaskTable.setViewportView(this.taskTable);
        this.jTextFieldProcess.setText("1");
        this.jTextFieldProcess.setBorder(BorderFactory.createTitledBorder("Threads"));
        this.jTextFieldDir.setText("");
        this.jButtonDelAlgoritm.setText("Delete Algorithm");
        this.jButtonDelAlgoritm.addActionListener(this::jButtonDelAlgoritmActionPerformed);
        this.jButtonDelStream.setText("Delete Stream");
        this.jButtonDelStream.addActionListener(this::jButtonDelStreamActionPerformed);
        this.jButtonPause.setText("Pause");
        this.jButtonPause.addActionListener(this::jButtonPauseActionPerformed);
        this.jButtonResume.setText("Resume");
        this.jButtonResume.addActionListener(this::jButtonResumeActionPerformed);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(this::jButtonCancelActionPerformed);
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(this::jButtonDeleteActionPerformed);
        JPanel jPanel1 = new JPanel();
        jPanel1.setBorder(BorderFactory.createTitledBorder("Configuration"));
        JLabel jLabelDirectory = new JLabel("Result folder");
        JLabel jLabel1 = new JLabel("Task");
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneAlgorithms, -2, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jButtonAlgorithm).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelAlgoritm).addGap(0, 111, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneStreams, -1, 311, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonStream).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonDelStream)))).addGroup(jPanel1Layout.createSequentialGroup().addGap(14, 14, 14).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel1).addComponent(jLabelDirectory)).addGap(14, 14, 14).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldDir).addComponent(this.jTextFieldTask)).addGap(14, 14, 14).addComponent(this.jButtonDir))).addGap(16, 16, 16)).addGroup(jPanel1Layout.createSequentialGroup().addGap(113, 113, 113).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonOpenConfig).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSaveConfig).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonTask))).addGap(14, 14, 14)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOpenConfig).addComponent(this.jButtonSaveConfig)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldTask, -2, 23, -2).addComponent(this.jButtonTask).addComponent(jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldDir, -2, 23, -2).addComponent(jLabelDirectory).addComponent(this.jButtonDir)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneAlgorithms, -1, 288, Short.MAX_VALUE).addComponent(this.jScrollPaneStreams, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonDelStream).addComponent(this.jButtonDelAlgoritm).addComponent(this.jButtonAlgorithm).addComponent(this.jButtonStream))));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap())));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 393, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE))));
        JPanel panelSRB = new JPanel();
        this.jTextFieldProcess.setPreferredSize(new Dimension(80, 40));
        panelSRB.add(this.jTextFieldProcess);
        panelSRB.add(this.jButtonRun);
        this.jScrollPaneAlgorithms.setPreferredSize(new Dimension(461, 260));
        this.jScrollPaneStreams.setPreferredSize(new Dimension(461, 260));
        this.jScrollPaneTaskTable.setPreferredSize(new Dimension(350, 180));
        JPanel panelTaskTable = new JPanel();
        JPanel panelTaskTableBtn = new JPanel();
        panelTaskTableBtn.add(this.jButtonPreview);
        panelTaskTableBtn.add(this.jButtonPause);
        panelTaskTableBtn.add(this.jButtonResume);
        panelTaskTableBtn.add(this.jButtonCancel);
        panelTaskTableBtn.add(this.jButtonDelete);
        panelTaskTableBtn.add(this.jButtonReset);
        panelTaskTable.setLayout(new BorderLayout());
        panelTaskTable.add((Component)panelSRB, "North");
        panelTaskTable.add((Component)this.jScrollPaneTaskTable, "Center");
        panelTaskTable.add((Component)panelTaskTableBtn, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel1, "Center");
        this.add((Component)panelTaskTable, "South");
    }

    private void jButtonSaveConfigActionPerformed(ActionEvent evt) {
        String path = "";
        BaseFileChooser propDir = new BaseFileChooser();
        int selection = propDir.showSaveDialog((Component)this);
        if (selection == 0) {
            path = propDir.getSelectedFile().getAbsolutePath();
            this.SaveConfig(path);
        }
    }

    private void jButtonOpenConfigActionPerformed(ActionEvent evt) {
        String path = "";
        BaseFileChooser fileChooser = new BaseFileChooser();
        int option = fileChooser.showOpenDialog(null);
        if (option == 0) {
            path = fileChooser.getSelectedFile().getAbsolutePath();
            this.openConfig(path);
        }
    }

    private String openDirectory() {
        String path = "";
        BaseDirectoryChooser propDir = new BaseDirectoryChooser();
        int selection = propDir.showOpenDialog((Component)this);
        if (selection == 0) {
            path = propDir.getSelectedFile().getAbsolutePath();
            return path;
        }
        return "";
    }

    private void jButtonResetActionPerformed(ActionEvent evt) {
        this.jTextFieldTask.setText("");
        this.jTextFieldDir.setText("");
        this.jTextFieldProcess.setText("1");
        this.jButtonRun.setEnabled(true);
        this.cleanTables();
    }

    private void jButtonDirActionPerformed(ActionEvent evt) {
        String path = this.openDirectory();
        if (!path.equals("")) {
            this.jTextFieldDir.setText(path);
            this.resultsPath = this.jTextFieldDir.getText() + File.separator + "Results";
        }
    }

    private void jButtonPreviewActionPerformed(ActionEvent evt) {
        this.preview.setVisible(true);
    }

    private void jButtonTaskActionPerformed(ActionEvent evt) {
        String initial = this.currentTask.getCLICreationString(MainTask.class);
        if (initial.split(" ") != null) {
            String[] split = initial.split(" ");
            String temp = initial.split(" ")[0];
            if (split.length >= 3 && split[1].equals("-l")) {
                for (int i = 3; i < split.length; ++i) {
                    temp = temp + " " + split[i];
                }
                initial = temp;
            }
        }
        String newTaskString = ClassOptionSelectionPanel.showSelectClassDialog(this, "Configure task", ExperimenterTask.class, initial, null);
        try {
            this.currentTask = (MainTask)ClassOption.cliStringToObject(newTaskString, MainTask.class, null);
        }
        catch (Exception ex) {
            Logger.getLogger(TaskManagerTabPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.jTextFieldTask.setText(newTaskString);
    }

    private void jButtonAlgorithmActionPerformed(ActionEvent evt) {
        String newTaskString;
        if (this.currentTask instanceof EvaluateConceptDrift) {
            newTaskString = ClassOptionSelectionPanel.showSelectClassDialog(this, "Configure learner", ChangeDetectorLearner.class, this.initialString, null);
            if (newTaskString.equals(this.initialString)) {
                return;
            }
            this.initialString = newTaskString;
            try {
                this.detector = (ChangeDetectorLearner)ClassOption.cliStringToObject(newTaskString, ChangeDetectorLearner.class, null);
            }
            catch (Exception ex) {
                Logger.getLogger(TaskManagerTabPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            newTaskString = ClassOptionSelectionPanel.showSelectClassDialog(this, "Configure learner", Learner.class, this.initialString, null);
            if (newTaskString.equals(this.initialString)) {
                return;
            }
            this.initialString = newTaskString;
            try {
                this.learner = (Classifier)ClassOption.cliStringToObject(newTaskString, Learner.class, null);
            }
            catch (Exception ex) {
                Logger.getLogger(TaskManagerTabPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        for (int i = 0; i < this.algoritmModel.getRowCount(); ++i) {
            if (!this.algoritmModel.getValueAt(i, 0).equals(newTaskString)) continue;
            JOptionPane.showMessageDialog(this, "The value exist", "Error", 0);
            return;
        }
        this.algoritmModel.addRow(new Object[]{newTaskString, newTaskString});
    }

    private void jButtonStreamActionPerformed(ActionEvent evt) {
        boolean arff = false;
        String newTaskString = "";
        String streamOption = "";
        if (this.currentTask instanceof EvaluateConceptDrift) {
            newTaskString = ClassOptionSelectionPanel.showSelectClassDialog(this, "Configure stream", ConceptDriftGenerator.class, this.initialString, null);
            if (newTaskString.equals(this.initialString)) {
                return;
            }
            this.initialString = newTaskString;
            try {
                this.detectorStream = (ConceptDriftGenerator)ClassOption.cliStringToObject(newTaskString, ConceptDriftGenerator.class, null);
            }
            catch (Exception ex) {
                Logger.getLogger(TaskManagerTabPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            newTaskString = ClassOptionSelectionPanel.showSelectClassDialog(this, "Configure stream", InstanceStream.class, this.initialString, null);
            if (newTaskString.equals(this.initialString)) {
                return;
            }
            this.initialString = newTaskString;
            try {
                this.stream = (AbstractOptionHandler)ClassOption.cliStringToObject(newTaskString, InstanceStream.class, null);
            }
            catch (Exception ex) {
                Logger.getLogger(TaskManagerTabPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (this.stream instanceof ArffFileStream) {
                streamOption = FilenameUtils.getBaseName((String)((ArffFileStream)this.stream).arffFileOption.getFile().getName());
                arff = true;
            }
        }
        for (int i = 0; i < this.streamModel.getRowCount(); ++i) {
            if (!this.streamModel.getValueAt(i, 0).equals(newTaskString)) continue;
            JOptionPane.showMessageDialog(this, "The value exist", "Error", 0);
            return;
        }
        if (arff) {
            this.streamModel.addRow(new Object[]{newTaskString, streamOption});
        } else {
            this.streamModel.addRow(new Object[]{newTaskString, newTaskString});
        }
    }

    private void jButtonRunActionPerformed(ActionEvent evt) {
        if (this.jTextFieldTask.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "The task is not specified", "Error", 0);
        } else if (this.jTextFieldDir.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "The result directory is not specified", "Error", 0);
        } else if (this.jTableAlgorithms.getRowCount() != 0) {
            if (this.jTableStreams.getRowCount() != 0) {
                ArrayList<String> stream = new ArrayList<String>();
                for (int i = 0; i < this.streamModel.getRowCount(); ++i) {
                    if (this.streamModel.getValueAt(i, 0).equals("") || this.streamModel.getValueAt(i, 1).equals("")) {
                        JOptionPane.showMessageDialog(this, "Fields incompleted in Table Stream", "Error", 0);
                        return;
                    }
                    if (i == 0) {
                        stream.add(this.streamModel.getValueAt(i, 1).toString());
                        continue;
                    }
                    if (stream.remove(this.streamModel.getValueAt(i, 1).toString())) {
                        stream.add(this.streamModel.getValueAt(i, 1).toString());
                        JOptionPane.showMessageDialog(this, "There are reapeted values in Table Stream", "Error", 0);
                        return;
                    }
                    stream.add(this.streamModel.getValueAt(i, 1).toString());
                }
                ArrayList<String> algorithm = new ArrayList<String>();
                for (int i = 0; i < this.algoritmModel.getRowCount(); ++i) {
                    if (this.algoritmModel.getValueAt(i, 0).equals("") || this.algoritmModel.getValueAt(i, 1).equals("")) {
                        JOptionPane.showMessageDialog(this, "Fields incompleted in Table Algorithm", "Error", 0);
                        return;
                    }
                    if (i == 0) {
                        algorithm.add(this.algoritmModel.getValueAt(i, 1).toString());
                        continue;
                    }
                    if (algorithm.remove(this.algoritmModel.getValueAt(i, 1).toString())) {
                        algorithm.add(this.algoritmModel.getValueAt(i, 1).toString());
                        JOptionPane.showMessageDialog(this, "There are reapeted values in Table Algorithm", "Error", 0);
                        return;
                    }
                    algorithm.add(this.algoritmModel.getValueAt(i, 1).toString());
                }
                this.runTask();
            } else {
                JOptionPane.showMessageDialog(this, "You must select at least one dataset", "Error", 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, "You must select at least one algorithm", "Error", 0);
        }
    }

    private void jButtonDelAlgoritmActionPerformed(ActionEvent evt) {
        this.algoritmModel.removeRow(this.jTableAlgorithms.getSelectedRow());
    }

    private void jButtonDelStreamActionPerformed(ActionEvent evt) {
        this.streamModel.removeRow(this.jTableStreams.getSelectedRow());
    }

    private void jButtonPauseActionPerformed(ActionEvent evt) {
        this.pauseSelectedTasks();
    }

    private void jButtonResumeActionPerformed(ActionEvent evt) {
        this.resumeSelectedTasks();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.cancelSelectedTasks();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.deleteSelectedTasks();
    }

    public void runTask() {
        MainTask[] tasks = new MainTask[this.jTableAlgorithms.getModel().getRowCount() * this.jTableStreams.getModel().getRowCount()];
        int taskCount = 0;
        String dir = "";
        try {
            this.currentTask = (MainTask)ClassOption.cliStringToObject(this.jTextFieldTask.getText(), MainTask.class, null);
        }
        catch (Exception ex) {
            Logger.getLogger(TaskManagerTabPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        MainTask auxTask = (MainTask)this.currentTask.copy();
        dir = dir + this.resultsPath;
        File f = new File(dir);
        if (f.exists()) {
            Object[] options = new Object[]{"Yes", "No"};
            String cancel = "NO";
            int resp = JOptionPane.showOptionDialog(this, "The selected folder is not empty. This action may overwrite previous experiment results. Do you want to continue?", "Warning", 2, 3, null, options, cancel);
            if (resp == 0) {
                ReadFile.deleteDrectory(f);
            } else {
                JOptionPane.showMessageDialog(this, "Please specify another directory", "Message", 1);
                return;
            }
        }
        f.mkdir();
        String algNames = "";
        String streamNames = "";
        for (int i = 0; i < this.jTableAlgorithms.getModel().getRowCount(); ++i) {
            String alg = this.jTableAlgorithms.getModel().getValueAt(i, 0).toString();
            String algFile = this.jTableAlgorithms.getModel().getValueAt(i, 1).toString();
            algNames = algNames + algFile;
            if (i != this.jTableAlgorithms.getModel().getRowCount() - 1) {
                algNames = algNames + ",";
            }
            for (int j = 0; j < this.jTableStreams.getModel().getRowCount(); ++j) {
                String stream = this.jTableStreams.getModel().getValueAt(j, 0).toString();
                String streamFile = this.jTableStreams.getModel().getValueAt(j, 1).toString();
                streamNames = streamNames + streamFile.split(" ")[0];
                if (j != this.jTableStreams.getModel().getRowCount() - 1) {
                    streamNames = streamNames + ",";
                }
                if (i == 0) {
                    String sfile = FilenameUtils.separatorsToSystem((String)(dir + "\\\\" + streamFile));
                    f = new File(sfile);
                    f.mkdir();
                }
                String task = " -l ";
                task = alg.split(" ") != null ? task + "(" + alg + ") -s (" + stream + ") -d (" + dir + File.separator + streamFile.split(" ")[0] + File.separator + algFile + ".txt)" : task + alg + " -s (" + stream + ") -d (" + dir + File.separator + streamFile.split(" ")[0] + File.separator + algFile + ".txt)";
                auxTask.getOptions().setViaCLIString(task);
                try {
                    tasks[taskCount] = (MainTask)auxTask.copy();
                }
                catch (Exception ex) {
                    Logger.getLogger(TaskManagerTabPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                ++taskCount;
            }
        }
        this.jButtonRun.setEnabled(false);
        Buffer buffer = new Buffer(tasks);
        int proc = 1;
        if (!this.jTextFieldProcess.getText().equals("")) {
            proc = Integer.parseInt(this.jTextFieldProcess.getText());
        }
        if (proc > tasks.length) {
            proc = tasks.length;
        }
        for (int i = 0; i < proc; ++i) {
            ExpTaskThread thread = new ExpTaskThread(buffer);
            thread.start();
            this.taskList.add(0, thread);
            this.taskTableModel.fireTableDataChanged();
            this.taskTable.setRowSelectionInterval(0, 0);
        }
        Thread obs = new Thread(){

            @Override
            public void run() {
                int count;
                do {
                    count = 0;
                    for (ExpTaskThread thread : TaskManagerTabPanel.this.taskList) {
                        if (!thread.isCompleted) continue;
                        ++count;
                    }
                } while (count != TaskManagerTabPanel.this.taskList.size());
                TaskManagerTabPanel.this.summary.readData(TaskManagerTabPanel.this.resultsPath);
                TaskManagerTabPanel.this.plot.readData(TaskManagerTabPanel.this.resultsPath);
                TaskManagerTabPanel.this.analizeTab.readData(TaskManagerTabPanel.this.resultsPath);
                TaskManagerTabPanel.this.jButtonRun.setEnabled(true);
            }
        };
        obs.start();
    }

    public void runTaskCLI(String[] args) {
        ExperimeterCLI expCLI = new ExperimeterCLI(args);
        boolean Ok = expCLI.proccesCMD();
        if (Ok) {
            int count;
            MainTask[] tasks = new MainTask[expCLI.getAlgorithms().length * expCLI.getStreams().length];
            int taskCount = 0;
            String dir = "";
            try {
                this.currentTask = (MainTask)ClassOption.cliStringToObject(expCLI.getTask(), MainTask.class, null);
            }
            catch (Exception ex) {
                Logger.getLogger(TaskManagerTabPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            MainTask auxTask = (MainTask)this.currentTask.copy();
            this.resultsPath = expCLI.getResultsFolder() + File.separator + "Results";
            dir = dir + this.resultsPath;
            File f = new File(dir);
            if (f.exists()) {
                ReadFile.deleteDrectory(f);
            }
            f.mkdir();
            String algNames = "";
            String streamNames = "";
            for (int i = 0; i < expCLI.getAlgorithms().length; ++i) {
                String alg = expCLI.getAlgorithms()[i];
                String algFile = expCLI.getAlgorithmsID()[i];
                algNames = algNames + algFile;
                if (i != expCLI.getAlgorithms().length - 1) {
                    algNames = algNames + ",";
                }
                for (int j = 0; j < expCLI.getStreams().length; ++j) {
                    String stream = expCLI.getStreams()[j];
                    String streamFile = expCLI.getStreamsID()[j];
                    streamNames = streamNames + streamFile.split(" ")[0];
                    if (j != expCLI.getStreams().length - 1) {
                        streamNames = streamNames + ",";
                    }
                    if (i == 0) {
                        String sfile = FilenameUtils.separatorsToSystem((String)(dir + "\\\\" + (String)streamFile));
                        f = new File(sfile);
                        f.mkdir();
                    }
                    String task = " -l ";
                    task = alg.split(" ") != null ? task + "(" + alg + ") -s (" + stream + ") -d (" + dir + File.separator + streamFile.split(" ")[0] + File.separator + algFile + ".txt)" : task + alg + " -s (" + stream + ") -d (" + dir + File.separator + streamFile.split(" ")[0] + File.separator + algFile + ".txt)";
                    auxTask.getOptions().setViaCLIString(task);
                    try {
                        tasks[taskCount] = (MainTask)auxTask.copy();
                    }
                    catch (Exception ex) {
                        Logger.getLogger(TaskManagerTabPanel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    ++taskCount;
                }
            }
            Buffer buffer = new Buffer(tasks);
            int proc = expCLI.getThreads();
            if (proc > tasks.length) {
                proc = tasks.length;
            }
            for (int i = 0; i < proc; ++i) {
                ExpTaskThread thread = new ExpTaskThread(buffer);
                thread.start();
                this.taskList.add(0, thread);
                this.taskTableModel.fireTableDataChanged();
                this.taskTable.setRowSelectionInterval(0, 0);
            }
            System.err.println(Globals.getWorkbenchInfoString());
            do {
                count = 0;
                boolean progressAnimIndex = false;
                StringBuilder progressLine = new StringBuilder();
                progressLine.append('\r');
                for (ExpTaskThread thread : this.taskList) {
                    if (thread.isCompleted) {
                        ++count;
                    }
                    progressLine.append(StringUtils.secondsToDHMSString(thread.getCPUSecondsElapsed()));
                    progressLine.append(" [");
                    progressLine.append(thread.getCurrentStatusString());
                    progressLine.append("] ");
                    double fracComplete = thread.getCurrentActivityFracComplete();
                    if (!(fracComplete >= 0.0)) continue;
                    progressLine.append(StringUtils.doubleToString(fracComplete * 100.0, 2, 2));
                    progressLine.append("% ");
                }
                System.out.print(progressLine);
                System.out.print('\r');
                System.out.flush();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException streamFile) {
                    // empty catch block
                }
            } while (count != this.taskList.size());
            this.summary.readData(this.resultsPath);
            System.out.println();
            System.out.println("To perform summaries type summary or exit to finish");
            Scanner sc = new Scanner(System.in);
            String option = sc.nextLine();
            while (!option.equals("exit")) {
                block6 : switch (option) {
                    case "summary": {
                        System.out.println("Measures:");
                        for (int i = 0; i < this.summary.measures.get(0).split(",").length; ++i) {
                            System.out.println("[" + i + "] " + this.summary.measures.get(0).split(",")[i]);
                        }
                        System.out.println("Select Measeures: type -h for help");
                        while (true) {
                            String[] arg;
                            boolean out;
                            if (!(out = expCLI.summary1CMD(arg = sc.nextLine().split(" "))) || expCLI.measures == null) {
                                continue;
                            }
                            String[] measures = new String[expCLI.measures.length];
                            if (measures.length == expCLI.types.length) {
                                for (int i = 0; i < measures.length; ++i) {
                                    measures[i] = this.summary.measures.get(0).split(",")[expCLI.measures[i]];
                                }
                                this.summary.summaryCMD(measures, expCLI.types);
                                break block6;
                            }
                            System.out.println("There must be the same number of measures and types, please enter the commands again");
                        }
                    }
                }
                System.out.println("To perform summaries type summary or exit to finish");
                option = sc.nextLine();
            }
        }
    }

    public void taskSelectionChanged() {
        ExpTaskThread[] selectedTasks = this.getSelectedTasks();
        if (selectedTasks.length == 1) {
            if (this.previewPanel != null) {
                this.previewPanel.setTaskThreadToPreview(selectedTasks[0]);
            }
        } else {
            this.previewPanel.setTaskThreadToPreview(null);
        }
    }

    public ExpTaskThread[] getSelectedTasks() {
        int[] selectedRows = this.taskTable.getSelectedRows();
        ExpTaskThread[] selectedTasks = new ExpTaskThread[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            selectedTasks[i] = this.taskList.get(selectedRows[i]);
        }
        return selectedTasks;
    }

    public void pauseSelectedTasks() {
        ExpTaskThread[] selectedTasks;
        for (ExpTaskThread thread : selectedTasks = this.getSelectedTasks()) {
            thread.pauseTask();
        }
    }

    public void resumeSelectedTasks() {
        ExpTaskThread[] selectedTasks;
        for (ExpTaskThread thread : selectedTasks = this.getSelectedTasks()) {
            thread.resumeTask();
        }
    }

    public void cancelSelectedTasks() {
        ExpTaskThread[] selectedTasks;
        for (ExpTaskThread thread : selectedTasks = this.getSelectedTasks()) {
            thread.cancelTask();
        }
    }

    public void deleteSelectedTasks() {
        ExpTaskThread[] selectedTasks;
        for (ExpTaskThread thread : selectedTasks = this.getSelectedTasks()) {
            thread.cancelTask();
            this.taskList.remove(thread);
        }
        this.taskTableModel.fireTableDataChanged();
    }

    private void SaveConfig(String path) {
        Properties prop = new Properties();
        String algShortNames = "";
        String algCommand = "";
        String streamShortNames = "";
        String streamCommand = "";
        String expCLI = "";
        if (this.jTableAlgorithms.getRowCount() != 0) {
            algCommand = algCommand + this.jTableAlgorithms.getModel().getValueAt(0, 0);
            algShortNames = algShortNames + this.jTableAlgorithms.getModel().getValueAt(0, 1);
        }
        if (this.jTableStreams.getRowCount() != 0) {
            streamCommand = streamCommand + this.jTableStreams.getModel().getValueAt(0, 0);
            streamShortNames = streamShortNames + this.jTableStreams.getModel().getValueAt(0, 1);
        }
        for (int i = 1; i < this.jTableAlgorithms.getRowCount(); ++i) {
            algCommand = algCommand + "," + this.jTableAlgorithms.getModel().getValueAt(i, 0);
            algShortNames = algShortNames + "," + this.jTableAlgorithms.getModel().getValueAt(i, 1);
        }
        for (int j = 1; j < this.jTableStreams.getRowCount(); ++j) {
            streamCommand = streamCommand + "," + this.jTableStreams.getModel().getValueAt(j, 0);
            streamShortNames = streamShortNames + "," + this.jTableStreams.getModel().getValueAt(j, 1);
        }
        expCLI = expCLI + "-ts \"" + this.jTextFieldTask.getText() + "\" ";
        expCLI = expCLI + "-ls \"" + algCommand + "\" ";
        expCLI = expCLI + "-lss \"" + algShortNames + "\" ";
        expCLI = expCLI + "-ds \"" + streamCommand + "\" ";
        expCLI = expCLI + "-dss \"" + streamShortNames + "\" ";
        expCLI = expCLI + "-th " + this.jTextFieldProcess.getText() + " ";
        expCLI = expCLI + "-rf \"" + FilenameUtils.separatorsToSystem((String)this.jTextFieldDir.getText()) + "\" ";
        prop.setProperty("expCLI", expCLI);
        prop.setProperty("task", this.jTextFieldTask.getText());
        prop.setProperty("processors", this.jTextFieldProcess.getText());
        prop.setProperty("algorithmCommand", algCommand);
        prop.setProperty("algorithmShortNames", algShortNames);
        prop.setProperty("streamCommand", streamCommand);
        prop.setProperty("streamShortNames", streamShortNames);
        prop.setProperty("ResultsDir", this.resultsPath);
        path = path + ".properties";
        FileOutputStream propertiesFile = null;
        File f = new File(path);
        if (!f.exists()) {
            f.delete();
        }
        try {
            propertiesFile = new FileOutputStream(path);
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, "Problems creating properties file", "Error", 0);
        }
        try {
            prop.store(propertiesFile, "file");
            JOptionPane.showMessageDialog(this, "Experiments saved at " + path, "", 1);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Problems creating properties file", "Error", 0);
        }
    }

    public void openConfig(String path) {
        int i;
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(path));
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Problems reading the properties file", "Error", 0);
        }
        this.jTextFieldProcess.setText(properties.getProperty("processors"));
        this.jTextFieldTask.setText(properties.getProperty("task"));
        try {
            this.currentTask = (MainTask)ClassOption.cliStringToObject(this.jTextFieldTask.getText(), MainTask.class, null);
        }
        catch (Exception ex) {
            Logger.getLogger(TaskManagerTabPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.jTextFieldDir.setText(properties.getProperty("ResultsDir"));
        this.resultsPath = this.jTextFieldDir.getText();
        String[] streamShortNames = properties.getProperty("streamShortNames").split(",");
        String[] streamCommand = properties.getProperty("streamCommand").split(",");
        String[] algShortNames = properties.getProperty("algorithmShortNames").split(",");
        String[] algorithmCommand = properties.getProperty("algorithmCommand").split(",");
        this.cleanTables();
        for (i = 0; i < streamShortNames.length; ++i) {
            this.streamModel.addRow(new Object[]{streamCommand[i], streamShortNames[i]});
        }
        for (i = 0; i < algShortNames.length; ++i) {
            this.algoritmModel.addRow(new Object[]{algorithmCommand[i], algShortNames[i]});
        }
    }

    public void cleanTables() {
        try {
            int i;
            DefaultTableModel algModel = (DefaultTableModel)this.jTableAlgorithms.getModel();
            DefaultTableModel strModel = (DefaultTableModel)this.jTableStreams.getModel();
            int rows = this.jTableAlgorithms.getRowCount();
            int srow = this.jTableStreams.getRowCount();
            int trow = this.taskList.size();
            for (i = 0; i < rows; ++i) {
                algModel.removeRow(0);
            }
            for (i = 0; i < srow; ++i) {
                strModel.removeRow(0);
            }
            for (i = 0; i < trow; ++i) {
                this.taskList.remove(0);
            }
            this.taskTableModel.fireTableDataChanged();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error al limpiar la tabla.");
        }
    }

    public static void main(final String[] args) {
        try {
            LookAndFeel.install();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (args.length != 0) {
                        TaskManagerTabPanel panel = new TaskManagerTabPanel();
                        panel.runTaskCLI(args);
                        System.exit(0);
                    } else {
                        TaskManagerTabPanel.createAndShowGUI();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected class TaskTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        protected TaskTableModel() {
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "command";
                }
                case 1: {
                    return "status";
                }
                case 2: {
                    return "time elapsed";
                }
                case 3: {
                    return "current activity";
                }
                case 4: {
                    return "% complete";
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return TaskManagerTabPanel.this.taskList.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ExpTaskThread thread = TaskManagerTabPanel.this.taskList.get(row);
            switch (col) {
                case 0: {
                    try {
                        return ((OptionHandler)((Object)thread.getTask())).getCLICreationString(MainTask.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                case 1: {
                    return thread.getCurrentStatusString();
                }
                case 2: {
                    return StringUtils.secondsToDHMSString(thread.getCPUSecondsElapsed());
                }
                case 3: {
                    return thread.getCurrentActivityString();
                }
                case 4: {
                    return thread.getCurrentActivityFracComplete();
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    public class ProgressCellRenderer
    extends JProgressBar
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public ProgressCellRenderer() {
            super(0, 0, 10000);
            this.setBorderPainted(false);
            this.setStringPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            double frac = -1.0;
            if (value instanceof Double) {
                frac = (Double)value;
            }
            if (frac >= 0.0) {
                this.setIndeterminate(false);
                this.setValue((int)(frac * 10000.0));
                this.setString(StringUtils.doubleToString(frac * 100.0, 2, 2));
            } else {
                this.setValue(0);
            }
            return this;
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }
}

