/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.featureanalysis;

import com.yahoo.labs.samoa.instances.WekaToSamoaInstanceConverter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import weka.core.Instances;
import weka.gui.JTableHelper;

public class FeatureImportanceDataModelPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected JButton m_IncludeAll = new JButton("All");
    protected JButton m_RemoveAll = new JButton("None");
    protected JButton m_Invert = new JButton("Invert");
    protected JButton m_Pattern = new JButton("Pattern");
    protected JTable m_Table = new JTable();
    protected FeatureImportanceDataModel m_Model;
    protected String m_PatternRegEx = "";
    protected com.yahoo.labs.samoa.instances.Instances m_Instances;

    public FeatureImportanceDataModelPanel() {
        this(false, false, false, false);
    }

    public FeatureImportanceDataModelPanel(boolean include, boolean remove, boolean invert, boolean pattern) {
        this.m_IncludeAll.setToolTipText("Selects all attributes");
        this.m_IncludeAll.setEnabled(false);
        this.m_IncludeAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureImportanceDataModelPanel.this.m_Model.includeAll();
            }
        });
        this.m_RemoveAll.setToolTipText("Unselects all attributes");
        this.m_RemoveAll.setEnabled(false);
        this.m_RemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureImportanceDataModelPanel.this.m_Model.removeAll();
            }
        });
        this.m_Invert.setToolTipText("Inverts the current attribute selection");
        this.m_Invert.setEnabled(false);
        this.m_Invert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureImportanceDataModelPanel.this.m_Model.invert();
            }
        });
        this.m_Pattern.setToolTipText("Selects all attributes that match a reg. expression");
        this.m_Pattern.setEnabled(false);
        this.m_Pattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String pattern = JOptionPane.showInputDialog(FeatureImportanceDataModelPanel.this.m_Pattern.getParent(), "Enter a Perl regular expression", FeatureImportanceDataModelPanel.this.m_PatternRegEx);
                if (pattern != null) {
                    try {
                        Pattern.compile(pattern);
                        FeatureImportanceDataModelPanel.this.m_PatternRegEx = pattern;
                        FeatureImportanceDataModelPanel.this.m_Model.pattern(pattern);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(FeatureImportanceDataModelPanel.this.m_Pattern.getParent(), "'" + pattern + "' is not a valid Perl regular expression!\nError: " + ex, "Error in Pattern...", 0);
                    }
                }
            }
        });
        DefaultTableCellRenderer r = new DefaultTableCellRenderer();
        r.setHorizontalAlignment(0);
        this.m_Table.setDefaultRenderer(Object.class, r);
        this.m_Table.setSelectionMode(0);
        this.m_Table.setColumnSelectionAllowed(false);
        this.m_Table.setPreferredScrollableViewportSize(new Dimension(super.getWidth(), super.getHeight()));
        this.m_Table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if ((e.getModifiers() & 0x10) != 16 || e.isAltDown()) {
                    FeatureImportanceDataModelPanel.this.popupCopyRangeMenu(e.getX(), e.getY());
                }
            }
        });
        JPanel p1 = new JPanel();
        p1.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        p1.setLayout(new GridLayout(1, 4, 5, 5));
        if (include) {
            p1.add(this.m_IncludeAll);
        }
        if (remove) {
            p1.add(this.m_RemoveAll);
        }
        if (invert) {
            p1.add(this.m_Invert);
        }
        if (pattern) {
            p1.add(this.m_Pattern);
        }
        this.setLayout(new BorderLayout());
        if (include || remove || invert || pattern) {
            this.add((Component)p1, "North");
        }
        this.add((Component)new JScrollPane(this.m_Table, 20, 30), "Center");
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.m_Table.getPreferredScrollableViewportSize();
    }

    public void setPreferredScrollableViewportSize(Dimension d) {
        this.m_Table.setPreferredScrollableViewportSize(d);
    }

    protected void popupCopyRangeMenu(int x, int y) {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem copyRangeItem = new JMenuItem("Copy checked items to range in clipboard");
        popupMenu.add(copyRangeItem);
        if (this.getSelectedAttributes().length == 0) {
            copyRangeItem.setEnabled(false);
        }
        copyRangeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = FeatureImportanceDataModelPanel.this.getSelectedAttributes();
                StringBuilder b = new StringBuilder();
                int prev = -1;
                int lastInString = -1;
                for (int v : selected) {
                    if (v == 0) {
                        b.append("first-");
                        prev = v;
                        lastInString = v;
                        continue;
                    }
                    if (prev < 0) {
                        prev = v;
                        lastInString = v;
                        b.append(v + 1).append("-");
                        continue;
                    }
                    if (v - prev == 1) {
                        prev = v;
                        continue;
                    }
                    if (b.charAt(b.length() - 1) == '-') {
                        if (prev == lastInString) {
                            b.setCharAt(b.length() - 1, ',');
                        } else {
                            b.append(prev + 1).append(",");
                        }
                    }
                    if (v == FeatureImportanceDataModelPanel.this.m_Model.getRowCount() - 1) {
                        b.append("last");
                    } else {
                        b.append(v + 1).append("-");
                    }
                    prev = v;
                    lastInString = v;
                }
                if (b.charAt(b.length() - 1) == '-') {
                    if (selected.length > 1 && lastInString != selected[selected.length - 1]) {
                        if (selected[selected.length - 1] == FeatureImportanceDataModelPanel.this.m_Model.getRowCount() - 1) {
                            b.append("last");
                        } else {
                            b.append(selected[selected.length - 1] + 1);
                        }
                    } else {
                        b.setLength(b.length() - 1);
                    }
                }
                StringSelection selection = new StringSelection(b.toString());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(selection, selection);
            }
        });
        popupMenu.show(this.m_Table, x, y);
    }

    public void setInstances(com.yahoo.labs.samoa.instances.Instances newInstances) {
        this.m_Instances = newInstances;
    }

    public void setFeatureImportanceScores(double[][] scores) {
        if (this.m_Model == null) {
            this.m_Model = new FeatureImportanceDataModel(this.m_Instances);
            this.m_Model.setFeatureImportance(scores);
            this.m_Table.setModel(this.m_Model);
            TableColumnModel tcm = this.m_Table.getColumnModel();
            tcm.getColumn(0).setPreferredWidth(30);
            tcm.getColumn(1).setPreferredWidth(50);
            tcm.getColumn(2).setPreferredWidth(90);
        } else {
            this.m_Table.removeAll();
            this.m_Model = new FeatureImportanceDataModel(this.m_Instances);
            this.m_Model.setFeatureImportance(scores);
            this.m_Table.setModel(this.m_Model);
            this.m_Table.validate();
        }
        this.m_IncludeAll.setEnabled(true);
        this.m_RemoveAll.setEnabled(true);
        this.m_Invert.setEnabled(true);
        this.m_Pattern.setEnabled(true);
        this.m_Table.setAutoResizeMode(0);
        JTableHelper.setOptimalColumnWidth((JTable)this.m_Table);
        this.m_Table.revalidate();
        this.m_Table.repaint();
    }

    public int[] getSelectedAttributes() {
        return this.m_Model == null ? null : this.m_Model.getSelectedAttributes();
    }

    public void setSelectedAttributes(boolean[] selected) throws Exception {
        if (this.m_Model != null) {
            this.m_Model.setSelectedAttributes(selected);
        }
    }

    public TableModel getTableModel() {
        return this.m_Model;
    }

    public ListSelectionModel getSelectionModel() {
        return this.m_Table.getSelectionModel();
    }

    public static void main(String[] args) {
        WekaToSamoaInstanceConverter m_wekaToSamoaInstanceConverter = new WekaToSamoaInstanceConverter();
        try {
            if (args.length == 0) {
                throw new Exception("supply the name of an arff file");
            }
            Instances i = new Instances((Reader)new BufferedReader(new FileReader(args[0])));
            FeatureImportanceDataModelPanel fidmp = new FeatureImportanceDataModelPanel();
            final JFrame jf = new JFrame("Feature importance data model panel");
            jf.setLayout(new BorderLayout());
            jf.add((Component)fidmp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.setSize(800, 400);
            jf.setVisible(true);
            fidmp.setInstances(m_wekaToSamoaInstanceConverter.samoaInstances(i));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    class FeatureImportanceDataModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        protected com.yahoo.labs.samoa.instances.Instances m_Instances;
        protected boolean[] m_Selected;
        protected double[][] m_featureImportance;

        public double[][] getFeatureImportance() {
            return this.m_featureImportance;
        }

        public void setFeatureImportance(double[][] featureImportance) {
            if (this.m_Instances != null) {
                this.m_featureImportance = featureImportance;
            }
        }

        public FeatureImportanceDataModel(com.yahoo.labs.samoa.instances.Instances instances) {
            this.setInstances(instances);
        }

        public void setInstances(com.yahoo.labs.samoa.instances.Instances instances) {
            this.m_Instances = instances;
            this.m_Selected = new boolean[this.m_Instances.numAttributes() - 1];
        }

        @Override
        public int getRowCount() {
            return this.m_Selected.length;
        }

        @Override
        public int getColumnCount() {
            return 3 + this.getFeatureImportance().length;
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return new Integer(row + 1);
                }
                case 1: {
                    return new Boolean(this.m_Selected[row]);
                }
                case 2: {
                    return this.m_Instances.attribute(row).name();
                }
            }
            if (Double.isNaN(this.getFeatureImportance()[column - 3][row])) {
                return "<html><strong color='red'>NaN</strong></html>";
            }
            if (this.getFeatureImportance()[column - 3][row] >= 1.0) {
                return "<html><strong color='red'>" + Double.toString(this.getFeatureImportance()[column - 3][row]) + "</strong></html>";
            }
            return Double.toString(this.getFeatureImportance()[column - 3][row]);
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return new String("No.");
                }
                case 1: {
                    return new String("choices");
                }
                case 2: {
                    return new String("Attribute name");
                }
            }
            return new String("WinIndex_" + (column - 3));
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 1) {
                this.m_Selected[row] = (Boolean)value;
            }
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        public int[] getSelectedAttributes() {
            int[] r1 = new int[this.getRowCount()];
            int selCount = 0;
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!this.m_Selected[i]) continue;
                r1[selCount++] = i;
            }
            int[] result = new int[selCount];
            System.arraycopy(r1, 0, result, 0, selCount);
            return result;
        }

        public void includeAll() {
            for (int i = 0; i < this.m_Selected.length; ++i) {
                this.m_Selected[i] = true;
            }
            this.fireTableRowsUpdated(0, this.m_Selected.length);
        }

        public void removeAll() {
            for (int i = 0; i < this.m_Selected.length; ++i) {
                this.m_Selected[i] = false;
            }
            this.fireTableRowsUpdated(0, this.m_Selected.length);
        }

        public void invert() {
            for (int i = 0; i < this.m_Selected.length; ++i) {
                this.m_Selected[i] = !this.m_Selected[i];
            }
            this.fireTableRowsUpdated(0, this.m_Selected.length);
        }

        public void pattern(String pattern) {
            for (int i = 0; i < this.m_Selected.length; ++i) {
                this.m_Selected[i] = Pattern.matches(pattern, this.m_Instances.attribute(i).name());
            }
            this.fireTableRowsUpdated(0, this.m_Selected.length);
        }

        public void setSelectedAttributes(boolean[] selected) throws Exception {
            if (selected.length != this.m_Selected.length) {
                throw new Exception("Supplied array does not have the same number of elements as there are attributes!");
            }
            for (int i = 0; i < selected.length; ++i) {
                this.m_Selected[i] = selected[i];
            }
            this.fireTableRowsUpdated(0, this.m_Selected.length);
        }
    }
}

