/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.featureanalysis;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Arrays;
import javax.swing.JPanel;
import org.math.plot.Plot2DPanel;

public class FeatureImportanceGraph
extends JPanel {
    protected double[][] m_featureImportance;
    protected int[] m_selectedAttributeIndices;
    protected Plot2DPanel plot = new Plot2DPanel();
    protected String[] m_attributeNames;

    public void setAttributeNames(String[] attribNames) {
        this.m_attributeNames = attribNames;
    }

    public void setFeatureImportance(double[][] featureImportance) {
        this.m_featureImportance = featureImportance;
        this.remove((Component)this.plot);
        this.plot = new Plot2DPanel();
        this.repaint();
    }

    public void setSelectedAttributeIndices(int[] selectedAttributeIndices) {
        this.m_selectedAttributeIndices = selectedAttributeIndices;
        this.remove((Component)this.plot);
        this.plot = new Plot2DPanel();
        this.repaint();
    }

    public FeatureImportanceGraph() {
        this.plot.setSize(super.getWidth(), super.getHeight());
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.setLayout(new BorderLayout());
        this.plot.addLegend("SOUTH");
        this.plot.setAxisLabel(0, "Win index");
        this.plot.setAxisLabel(1, "Feature importance");
        this.plot.setFont(new Font("Courier", 1, 12));
        this.plot.setVisible(true);
        if (this.m_featureImportance != null) {
            int rows = this.m_featureImportance.length;
            double[] featureImportance = new double[rows];
            if (this.m_selectedAttributeIndices == null || Arrays.toString(this.m_selectedAttributeIndices).equalsIgnoreCase("[]")) {
                int selectedAttributeIndex = 0;
                for (int i = 0; i < rows; ++i) {
                    featureImportance[i] = this.m_featureImportance[i][selectedAttributeIndex];
                }
                this.plot.addLinePlot(this.m_attributeNames[selectedAttributeIndex], featureImportance);
                this.add((Component)this.plot, "Center");
                super.revalidate();
            } else {
                for (int selectedAttributeIndex : this.m_selectedAttributeIndices) {
                    for (int i = 0; i < rows; ++i) {
                        featureImportance[i] = this.m_featureImportance[i][selectedAttributeIndex];
                    }
                    this.plot.addLinePlot(this.m_attributeNames[selectedAttributeIndex], featureImportance);
                    this.add((Component)this.plot, "Center");
                    super.revalidate();
                }
            }
        }
    }
}

