/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.featureanalysis;

import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.WekaToSamoaInstanceConverter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import moa.gui.ClassOptionSelectionPanel;
import moa.gui.GUIUtils;
import moa.gui.featureanalysis.FeatureImportanceDataModelPanel;
import moa.gui.featureanalysis.FeatureImportanceGraph;
import moa.options.ClassOption;
import moa.tasks.ClassificationMainTask;
import moa.tasks.FeatureImportanceConfig;
import moa.tasks.MainTask;
import moa.tasks.Task;
import moa.tasks.TaskCompletionListener;
import moa.tasks.TaskThread;
import org.math.plot.Plot2DPanel;
import weka.gui.AbstractPerspective;

public class FeatureImportancePanel
extends AbstractPerspective {
    protected Instances m_Instances;
    protected MainTask currentTask = new FeatureImportanceConfig();
    protected List<TaskThread> taskList = new ArrayList<TaskThread>();
    private Preferences prefs;
    private final String PREF_NAME = "currentTask";
    protected JButton configureTaskButton = new JButton("Configure");
    protected JTextField taskDescField = new JTextField();
    protected JButton runTaskButton = new JButton("Run");
    protected JProgressBar progressBar = new JProgressBar();
    protected JLabel progressLabel = new JLabel("Running progress:");
    protected FeatureImportanceDataModelPanel featureImportanceDataModelPanel = new FeatureImportanceDataModelPanel();
    private static FeatureImportancePanel fip = null;
    protected Plot2DPanel plot;
    protected double[][] scores;
    protected int[] m_selectedAttributeIndices;
    protected FeatureImportanceGraph featureImportanceGraph = new FeatureImportanceGraph();
    protected int m_windowSize = 500;

    public int getWindowSize() {
        return this.m_windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.m_windowSize = windowSize;
    }

    public static synchronized FeatureImportancePanel getInstance() {
        if (fip == null) {
            fip = new FeatureImportancePanel();
        }
        return fip;
    }

    private FeatureImportancePanel() {
        this.prefs = Preferences.userRoot().node(((Object)((Object)this)).getClass().getName());
        String taskText = this.currentTask.getCLICreationString(MainTask.class);
        String propertyValue = this.prefs.get("currentTask", taskText);
        if (propertyValue != null) {
            this.setParameters(propertyValue);
        }
        this.setTaskString(propertyValue, false);
        this.taskDescField.setEditable(false);
        final JTextField comp = this.taskDescField;
        this.taskDescField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 1 && (evt.getButton() == 3 || evt.getButton() == 1 && evt.isAltDown() && evt.isShiftDown())) {
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem item = new JMenuItem("Copy configuration to clipboard");
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            FeatureImportancePanel.this.copyClipBoardConfiguration();
                        }
                    });
                    menu.add(item);
                    item = new JMenuItem("Enter configuration...");
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            String newTaskString = JOptionPane.showInputDialog("Insert command line");
                            if (newTaskString != null) {
                                FeatureImportancePanel.this.setTaskString(newTaskString);
                            }
                        }
                    });
                    menu.add(item);
                    menu.show(comp, evt.getX(), evt.getY());
                }
            }
        });
        this.setLayout(new BorderLayout());
        JPanel configPanel = new JPanel();
        configPanel.setBorder(BorderFactory.createTitledBorder("Feature importance algorithm parameters config:"));
        configPanel.setLayout(new BorderLayout());
        configPanel.add((Component)this.configureTaskButton, "West");
        configPanel.add((Component)this.taskDescField, "Center");
        JPanel runViewPanel = new JPanel();
        runViewPanel.setLayout(new BorderLayout());
        runViewPanel.add((Component)this.runTaskButton, "West");
        configPanel.add((Component)runViewPanel, "East");
        JPanel barPanel = new JPanel();
        barPanel.setBorder(BorderFactory.createEmptyBorder(10, 2, 5, 2));
        barPanel.setLayout(new BorderLayout());
        barPanel.setSize(super.getWidth(), super.getHeight());
        barPanel.add((Component)this.progressLabel, "West");
        barPanel.add((Component)this.progressBar, "Center");
        configPanel.add((Component)barPanel, "South");
        this.add(configPanel, "North");
        this.configureTaskButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String newTaskString = ClassOptionSelectionPanel.showSelectClassDialog((Component)((Object)FeatureImportancePanel.this), "Configure task", ClassificationMainTask.class, FeatureImportancePanel.this.currentTask.getCLICreationString(ClassificationMainTask.class), null);
                if (newTaskString != null) {
                    FeatureImportancePanel.this.setParameters(newTaskString);
                }
                FeatureImportancePanel.this.setTaskString(newTaskString);
                ClassOptionSelectionPanel.setRequiredCapabilities(null);
            }
        });
        this.runTaskButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (FeatureImportancePanel.this.m_Instances != null) {
                    int windowSize;
                    int numInstances = FeatureImportancePanel.this.m_Instances.numInstances();
                    if (numInstances <= (windowSize = FeatureImportancePanel.this.getWindowSize())) {
                        Toolkit.getDefaultToolkit().beep();
                        JOptionPane.showMessageDialog(FeatureImportancePanel.this.runTaskButton.getParent(), "Parameter windowSize of feature importance algorithm must be smaller than numInstances.\nThe current set: windowSize is \"" + windowSize + "\" and numInstances is \"" + numInstances + "\".", "Feature importance configuration", 0);
                    } else {
                        int numAttributes = FeatureImportancePanel.this.m_Instances.numAttributes();
                        final String[] attributeNames = new String[numAttributes - 1];
                        for (int i = 0; i < numAttributes - 1; ++i) {
                            attributeNames[i] = FeatureImportancePanel.this.m_Instances.attribute(i).name();
                        }
                        ((FeatureImportanceConfig)FeatureImportancePanel.this.currentTask).setInstances(FeatureImportancePanel.this.m_Instances);
                        FeatureImportancePanel.this.runTask(FeatureImportancePanel.this.currentTask);
                        final TaskThread thread = FeatureImportancePanel.this.taskList.get(0);
                        thread.addTaskCompletionListener(new TaskCompletionListener(){

                            @Override
                            public void taskCompleted(TaskThread task) {
                                FeatureImportancePanel.this.scores = (double[][])thread.getFinalResult();
                                for (int row = 0; row < FeatureImportancePanel.this.scores.length; ++row) {
                                    for (int col = 0; col < FeatureImportancePanel.this.scores[row].length; ++col) {
                                        if (Double.isNaN(FeatureImportancePanel.this.scores[row][col]) || Double.toString(FeatureImportancePanel.this.scores[row][col]).length() < 6) continue;
                                        FeatureImportancePanel.this.scores[row][col] = new BigDecimal(FeatureImportancePanel.this.scores[row][col]).setScale(4, 4).doubleValue();
                                    }
                                }
                                double[][] scoresCopyForDataModel = (double[][])FeatureImportancePanel.this.scores.clone();
                                FeatureImportancePanel.this.featureImportanceDataModelPanel.setFeatureImportanceScores(scoresCopyForDataModel);
                                FeatureImportancePanel.this.featureImportanceGraph.setAttributeNames(attributeNames);
                                int rows = FeatureImportancePanel.this.scores.length;
                                int columns = FeatureImportancePanel.this.scores[0].length;
                                double[][] scoresCopyForGraph = new double[rows][columns];
                                for (int k = 0; k < FeatureImportancePanel.this.scores.length; ++k) {
                                    scoresCopyForGraph[k] = (double[])FeatureImportancePanel.this.scores[k].clone();
                                }
                                double naNSubstitute = ((FeatureImportanceConfig)FeatureImportancePanel.this.currentTask).getNaNSubstitute();
                                for (int i = 0; i < rows; ++i) {
                                    for (int j = 0; j < columns; ++j) {
                                        if (!Double.isNaN(scoresCopyForGraph[i][j])) continue;
                                        scoresCopyForGraph[i][j] = naNSubstitute;
                                    }
                                }
                                FeatureImportancePanel.this.featureImportanceGraph.setFeatureImportance(scoresCopyForGraph);
                            }
                        });
                        JProgressBar sourceProgressBar = ((FeatureImportanceConfig)FeatureImportancePanel.this.currentTask).getProgressBar();
                        sourceProgressBar.addChangeListener(new ChangeListener(){

                            @Override
                            public void stateChanged(ChangeEvent evt) {
                                JProgressBar comp = (JProgressBar)evt.getSource();
                                int value = comp.getValue();
                                int max = comp.getMaximum();
                                FeatureImportancePanel.this.progressBar.setMinimum(0);
                                FeatureImportancePanel.this.progressBar.setMaximum(max);
                                FeatureImportancePanel.this.progressBar.setValue(value);
                            }
                        });
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(FeatureImportancePanel.this.runTaskButton.getParent(), "Please open data stream file from \nVisualizerFeatures tab first!", "Not open file error prompt!", 2);
                }
            }
        });
        JPanel tabAndGraphHolder = new JPanel();
        tabAndGraphHolder.setLayout(new GridLayout(2, 1));
        JPanel featureImportanceTablePanel = new JPanel();
        featureImportanceTablePanel.setBorder(BorderFactory.createTitledBorder("Feature importance table"));
        featureImportanceTablePanel.setLayout(new BorderLayout());
        featureImportanceTablePanel.add((Component)this.featureImportanceDataModelPanel, "Center");
        tabAndGraphHolder.add(featureImportanceTablePanel);
        this.featureImportanceDataModelPanel.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    FeatureImportancePanel.this.m_selectedAttributeIndices = FeatureImportancePanel.this.featureImportanceDataModelPanel.m_Model.getSelectedAttributes();
                    FeatureImportancePanel.this.featureImportanceGraph.setSelectedAttributeIndices(FeatureImportancePanel.this.m_selectedAttributeIndices);
                }
            }
        });
        JPanel featureImportanceLineGraphPanel = new JPanel();
        featureImportanceLineGraphPanel.setLayout(new BorderLayout());
        featureImportanceLineGraphPanel.setBorder(BorderFactory.createTitledBorder("Feature importance line graph"));
        featureImportanceLineGraphPanel.add((Component)this.featureImportanceGraph, "Center");
        tabAndGraphHolder.add(featureImportanceLineGraphPanel);
        this.add(tabAndGraphHolder, "Center");
    }

    public void setParameters(String commandLineText) {
        String[] cli = commandLineText.split(" ");
        for (int i = 0; i < cli.length; ++i) {
            if (!cli[i].trim().equalsIgnoreCase("-w")) continue;
            try {
                this.setWindowSize(Integer.parseInt(cli[i + 1].trim()));
                continue;
            }
            catch (NumberFormatException e) {
                String subString = cli[i + 1].trim();
                int subStringLength = subString.length();
                this.setWindowSize(Integer.parseInt(subString.substring(0, subStringLength - 1)));
            }
        }
    }

    public void setTaskString(String cliString) {
        this.setTaskString(cliString, true);
    }

    public void setTaskString(String cliString, boolean storePreference) {
        try {
            this.currentTask = (MainTask)ClassOption.cliStringToObject(cliString, MainTask.class, null);
            String taskText = this.currentTask.getCLICreationString(MainTask.class);
            this.taskDescField.setText(taskText);
            if (storePreference) {
                this.prefs.put("currentTask", taskText);
            }
        }
        catch (Exception ex) {
            GUIUtils.showExceptionDialog((Component)((Object)this), "Problem with task", ex);
        }
    }

    public void copyClipBoardConfiguration() {
        StringSelection selection = new StringSelection(this.taskDescField.getText().trim());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, selection);
    }

    public void setInstances(Instances inst) {
        this.m_Instances = inst;
        this.featureImportanceDataModelPanel.setInstances(inst);
    }

    public boolean acceptsInstances() {
        return true;
    }

    public static void main(String[] args) {
        WekaToSamoaInstanceConverter m_wekaToSamoaInstanceConverter = new WekaToSamoaInstanceConverter();
        try {
            if (args.length == 0) {
                throw new Exception("supply the name of an arff file");
            }
            weka.core.Instances i = new weka.core.Instances((Reader)new BufferedReader(new FileReader(args[0])));
            FeatureImportancePanel fip = new FeatureImportancePanel();
            final JFrame jf = new JFrame("Feature importance data model panel");
            jf.setLayout(new BorderLayout());
            jf.add((Component)((Object)fip), "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.setSize(800, 400);
            jf.setVisible(true);
            fip.setInstances(m_wekaToSamoaInstanceConverter.samoaInstances(i));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    public void runTask(Task task) {
        TaskThread thread = new TaskThread(task);
        this.taskList.add(0, thread);
        thread.start();
    }
}

