/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.featureanalysis;

import com.yahoo.labs.samoa.instances.Instances;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.math.plot.Plot2DPanel;
import org.math.plot.plotObjects.BaseLabel;
import org.math.plot.plotObjects.Plotable;

public class LineAndScatterPanel
extends JPanel {
    protected Instances m_data;
    protected int m_attributeIndex;
    protected String m_attributeName;
    protected int m_selectedPlotTyeIndex;
    protected String m_selectedPlotTyeItem;
    protected int m_intStartIndex;
    protected int m_intEndIndex;
    protected List<double[]> featureVectorList;
    protected Plot2DPanel plot = new Plot2DPanel();
    protected int m_featureRangeStartIndex;
    protected int m_featureRangeEndIndex;
    protected String m_featureRange;

    public int getSelectedPlotTyeIndex() {
        return this.m_selectedPlotTyeIndex;
    }

    public String getSelectedPlotItem() {
        return this.m_selectedPlotTyeItem;
    }

    public void setSelectedPlotItem(String SelectedPlotItem) {
        this.m_selectedPlotTyeItem = SelectedPlotItem;
    }

    public String getAttributeName() {
        return this.m_attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.m_attributeName = attributeName;
    }

    public int getIntStartIndex() {
        return this.m_intStartIndex;
    }

    public void setIntStartIndex(int intStartIndex) {
        this.m_intStartIndex = intStartIndex;
    }

    public int getIntEndIndex() {
        return this.m_intEndIndex;
    }

    public void setIntEndIndex(int intEndIndex) {
        this.m_intEndIndex = intEndIndex;
    }

    public int getFeatureRangeStartIndex() {
        return this.m_featureRangeStartIndex;
    }

    public void setFeatureRangeStartIndex(int featureRangeStartIndex) {
        this.m_featureRangeStartIndex = featureRangeStartIndex;
    }

    public int getFeatureRangeEndIndex() {
        return this.m_featureRangeEndIndex;
    }

    public void setFeatureRangeEndIndex(int featureRangeEndIndex) {
        this.m_featureRangeEndIndex = featureRangeEndIndex;
    }

    public void setFeatureRange(String featureRange) {
        this.m_featureRange = featureRange;
        String rangeStart = "";
        String rangeEnd = "";
        String[] split = featureRange.split("[ ]");
        if (split.length == 5) {
            rangeStart = split[2].trim();
            rangeEnd = split[4].trim();
        } else if (split.length == 3) {
            rangeStart = split[2].trim();
            rangeEnd = split[2].trim();
        }
        this.setFeatureRangeStartIndex(Integer.parseInt(rangeStart) - 1);
        this.setFeatureRangeEndIndex(Integer.parseInt(rangeEnd) - 1);
    }

    public void setInstances(Instances inst) {
        this.m_data = inst;
        if (this.m_data != null) {
            int numInst = this.m_data.size();
            int numAttributes = this.m_data.numAttributes();
            this.featureVectorList = new ArrayList<double[]>();
            double[] featureVector = new double[numInst];
            Future[] futures = new Future[numAttributes];
            ExecutorService service = Executors.newFixedThreadPool(numAttributes);
            for (int i = 0; i < numAttributes; ++i) {
                futures[i] = service.submit(new ExtractFeatureVectorCallable(i));
            }
            for (int j = 0; j < numAttributes; ++j) {
                try {
                    featureVector = (double[])futures[j].get();
                    this.featureVectorList.add(featureVector);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            service.shutdown();
            while (!service.isTerminated()) {
            }
        }
    }

    public void setAttributeIndex(int attributeIndex) {
        this.m_attributeIndex = attributeIndex;
    }

    public int getAttributeIndex() {
        return this.m_attributeIndex;
    }

    public LineAndScatterPanel() {
        this.plot.setSize(super.getWidth(), super.getHeight());
        this.setAttributeIndex(0);
    }

    public void setSelectedPlotInfo(int selectedPlotTyeIndex, String selectedPlotItem, int attributeIndex, String attributeName) {
        this.m_selectedPlotTyeIndex = selectedPlotTyeIndex;
        this.setAttributeIndex(attributeIndex);
        this.setAttributeName(attributeName);
        this.setSelectedPlotItem(selectedPlotItem);
        this.remove((Component)this.plot);
        this.plot = new Plot2DPanel();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.setLayout(new BorderLayout());
        String attributeName = this.getAttributeName();
        if (this.m_data != null) {
            double[] y_axis = this.featureVectorList.get(this.getAttributeIndex());
            this.m_intStartIndex = this.getIntStartIndex();
            this.m_intEndIndex = this.getIntEndIndex();
            double[] y_axis_segment = Arrays.copyOfRange(y_axis, this.m_intStartIndex - 1, this.m_intEndIndex);
            double[] x_axis_segment = this.setXAxisCoordinate();
            if (this.getSelectedPlotItem().equalsIgnoreCase("plot type: Line graph")) {
                this.plot.addLegend("SOUTH");
                this.plot.addLinePlot(attributeName, Color.BLUE, x_axis_segment, y_axis_segment);
                this.plot.removePlotToolBar();
                this.plot.setVisible(true);
                this.add((Component)this.plot, "Center");
                super.revalidate();
            } else if (this.getSelectedPlotItem().equalsIgnoreCase("plot type: Scatter diagram")) {
                this.plot = new Plot2DPanel();
                this.plot.addLegend("SOUTH");
                this.plot.addScatterPlot(attributeName, Color.BLUE, x_axis_segment, y_axis_segment);
                this.plot.removePlotToolBar();
                this.plot.setVisible(true);
                this.add((Component)this.plot, "Center");
                super.revalidate();
            } else if (this.getSelectedPlotItem().equalsIgnoreCase("No plot type")) {
                super.revalidate();
            }
        }
    }

    public void paintAmplifiedPlot() {
        Plot2DPanel amplifyPlot = new Plot2DPanel();
        String attrName = this.getAttributeName();
        if (this.m_data != null) {
            double[] y_axis = this.featureVectorList.get(this.getAttributeIndex());
            this.m_intStartIndex = this.getIntStartIndex();
            this.m_intEndIndex = this.getIntEndIndex();
            double[] y_axis_segment = Arrays.copyOfRange(y_axis, this.m_intStartIndex - 1, this.m_intEndIndex);
            double[] x_axis_segment = this.setXAxisCoordinate();
            JFrame jf = new JFrame("Amplification of Line graph or scatter diagram");
            jf.setDefaultCloseOperation(2);
            Dimension d = this.getScreenSize();
            jf.setSize(d);
            jf.setLayout(new BorderLayout());
            jf.add((Component)amplifyPlot, "Center");
            amplifyPlot.addLegend("SOUTH");
            amplifyPlot.setAxisLabel(0, "Instance index");
            amplifyPlot.setAxisLabel(1, "Instance attribute value");
            amplifyPlot.setFont(new Font("Courier", 1, 12));
            amplifyPlot.setVisible(true);
            jf.setVisible(true);
            if (this.getSelectedPlotItem().equalsIgnoreCase("plot type: Line graph")) {
                amplifyPlot.addLinePlot(attrName, Color.BLUE, x_axis_segment, y_axis_segment);
            } else if (this.getSelectedPlotItem().equalsIgnoreCase("plot type: Scatter diagram")) {
                BaseLabel title = new BaseLabel("Feature: " + attrName, Color.BLACK, new double[]{0.5, 1.1});
                title.setFont(new Font("Courier", 1, 20));
                amplifyPlot.addPlotable((Plotable)title);
                int attIndex = this.getAttributeIndex();
                int numValues = this.m_data.attribute(attIndex).numValues();
                Object[] attributeValues = new Object[numValues];
                if (this.m_data.attribute(attIndex).isNominal()) {
                    attributeValues = this.m_data.attribute(attIndex).getAttributeValues().toArray();
                }
                if (attrName.endsWith("(nominal)")) {
                    int len = y_axis_segment.length;
                    HashMap<Double, Integer> hm = new HashMap<Double, Integer>();
                    for (int h = 0; h < len; ++h) {
                        if (hm.containsKey(y_axis_segment[h])) {
                            int count = (Integer)hm.get(y_axis_segment[h]);
                            hm.put(y_axis_segment[h], count + 1);
                            continue;
                        }
                        hm.put(y_axis_segment[h], 1);
                    }
                    for (Object key : hm.keySet()) {
                        double y_value = (Double)key;
                        int value_count = (Integer)hm.get(key);
                        double[] y_axis_sub = new double[value_count];
                        double[] x_axis_sub = new double[value_count];
                        ArrayList<Double> al = new ArrayList<Double>();
                        if (value_count == 2) {
                            y_axis_sub[1] = y_value;
                            int count = 0;
                            for (int s = 0; s < len; ++s) {
                                if (y_axis_segment[s] != y_value) continue;
                                if (++count == 1) {
                                    al.add(x_axis_segment[s]);
                                    continue;
                                }
                                if (count != 2) continue;
                                y_axis_sub[0] = x_axis_segment[s];
                                al.add(y_value);
                            }
                        } else {
                            if (value_count > 2) {
                                for (int f = 0; f < value_count; ++f) {
                                    y_axis_sub[f] = y_value;
                                }
                            } else if (value_count == 1) {
                                y_axis_sub[0] = y_value;
                            }
                            for (int s = 0; s < len; ++s) {
                                if (y_axis_segment[s] != y_value) continue;
                                al.add(x_axis_segment[s]);
                            }
                        }
                        for (int t = 0; t < al.size(); ++t) {
                            x_axis_sub[t] = (Double)al.get(t);
                        }
                        String attributeValue = (String)attributeValues[(int)y_value];
                        amplifyPlot.addScatterPlot(attributeValue, x_axis_sub, y_axis_sub);
                    }
                } else {
                    amplifyPlot.addScatterPlot(attrName, Color.BLUE, x_axis_segment, y_axis_segment);
                }
            }
        }
    }

    public void visualizeAll() {
        if (this.m_data != null) {
            this.m_intStartIndex = this.getIntStartIndex();
            this.m_intEndIndex = this.getIntEndIndex();
            this.m_selectedPlotTyeItem = this.getSelectedPlotItem();
            JFrame jf = new JFrame("Visualize all features as line graphs or scatter diagrams");
            jf.setSize(830, 700);
            jf.setDefaultCloseOperation(2);
            jf.setVisible(true);
            JPanel contentPane = new JPanel();
            contentPane.setVisible(true);
            contentPane.setLayout(new GridLayout(4, 3));
            JScrollPane scroller = new JScrollPane(contentPane);
            jf.add(scroller);
            this.m_featureRangeStartIndex = this.getFeatureRangeStartIndex();
            this.m_featureRangeEndIndex = this.getFeatureRangeEndIndex();
            for (int p = this.m_featureRangeStartIndex; p <= this.m_featureRangeEndIndex; ++p) {
                double[] y_axis_visualizeAll = this.featureVectorList.get(p);
                double[] y_axis_visualizeAll_segment = Arrays.copyOfRange(y_axis_visualizeAll, this.m_intStartIndex - 1, this.m_intEndIndex);
                double[] x_axis_visualizeAll_segment = this.setXAxisCoordinate();
                boolean isNominal = this.m_data.attribute(p).isNominal();
                Plot2DPanel plot2d = new Plot2DPanel();
                JPanel jp = new JPanel();
                jp.setLayout(new BorderLayout());
                jp.setVisible(true);
                String name = this.m_data.attribute(p).name();
                jp.setBorder(BorderFactory.createTitledBorder(name));
                jp.setPreferredSize(new Dimension(200, 200));
                if (isNominal) {
                    plot2d.addScatterPlot(name, Color.BLUE, x_axis_visualizeAll_segment, y_axis_visualizeAll_segment);
                } else if (this.getSelectedPlotItem().equalsIgnoreCase("plot type: Line graph")) {
                    plot2d.addLinePlot(name, Color.BLUE, x_axis_visualizeAll_segment, y_axis_visualizeAll_segment);
                } else if (this.getSelectedPlotItem().equalsIgnoreCase("plot type: Scatter diagram")) {
                    plot2d.addScatterPlot(name, Color.BLUE, x_axis_visualizeAll_segment, y_axis_visualizeAll_segment);
                }
                plot2d.setVisible(true);
                plot2d.removePlotToolBar();
                jp.add((Component)plot2d, "Center");
                contentPane.add(jp);
            }
        }
    }

    private double[] setXAxisCoordinate() {
        int length = this.m_intEndIndex - this.m_intStartIndex + 1;
        double[] x_axis_visualizeAll_segment = new double[length];
        for (int k = 0; k < length; ++k) {
            x_axis_visualizeAll_segment[k] = this.m_intStartIndex - 1 + k;
        }
        return x_axis_visualizeAll_segment;
    }

    public Dimension getScreenSize() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int w = screenSize.width;
        int h = screenSize.height;
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        return new Dimension(w -= screenInsets.left + screenInsets.right, h -= screenInsets.top + screenInsets.bottom);
    }

    class ExtractFeatureVectorCallable
    implements Callable<double[]> {
        private int m_attributeIndex;

        public ExtractFeatureVectorCallable(Integer attribIndex) {
            this.m_attributeIndex = attribIndex;
        }

        @Override
        public double[] call() throws Exception {
            int numInst = LineAndScatterPanel.this.m_data.numInstances();
            double[] featureVector = new double[numInst];
            for (int i = 0; i < numInst; ++i) {
                featureVector[i] = LineAndScatterPanel.this.m_data.get(i).value(this.m_attributeIndex);
            }
            return featureVector;
        }
    }
}

