/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.featureanalysis;

import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.SamoaToWekaInstanceConverter;
import com.yahoo.labs.samoa.instances.WekaToSamoaInstanceConverter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import moa.gui.featureanalysis.AttributeSelectionPanel;
import moa.gui.featureanalysis.AttributeSummaryPanel;
import moa.gui.featureanalysis.AttributeVisualizationPanel;
import moa.gui.featureanalysis.FeatureImportancePanel;
import moa.gui.featureanalysis.InstancesSummaryPanel;
import moa.gui.featureanalysis.LineAndScatterPanel;
import moa.streams.ArffFileStream;
import weka.core.Defaults;
import weka.core.Environment;
import weka.core.OptionHandler;
import weka.core.Settings;
import weka.core.Utils;
import weka.core.converters.AbstractFileSaver;
import weka.filters.AllFilter;
import weka.filters.Filter;
import weka.filters.SupervisedFilter;
import weka.filters.unsupervised.attribute.Remove;
import weka.gui.AbstractPerspective;
import weka.gui.ConverterFileChooser;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.Perspective;
import weka.gui.SysErrLog;
import weka.gui.TaskLogger;
import weka.gui.beans.AttributeSummarizer;
import weka.gui.explorer.PreprocessPanel;

public class VisualizeFeaturesPanel
extends AbstractPerspective {
    private static final long serialVersionUID = 1L;
    protected InstancesSummaryPanel m_InstSummaryPanel = new InstancesSummaryPanel();
    protected JButton m_OpenFileBut = new JButton("Open file...");
    protected AttributeSelectionPanel m_AttPanel = new AttributeSelectionPanel();
    protected JButton m_RemoveButton = new JButton("Remove");
    protected JButton m_SaveBut = new JButton("Save...");
    protected JButton m_plotAmplify = new JButton("plotAmplify");
    protected JLabel m_startIndex = new JLabel("startIndex:");
    protected JLabel m_endIndex = new JLabel("endIndex:");
    protected int m_intStartIndex;
    protected int m_intEndIndex;
    protected JButton m_visAllGraphBut = new JButton("Visualize All");
    protected JFormattedTextField m_startInstanceInput = new JFormattedTextField(NumberFormat.getIntegerInstance());
    protected JFormattedTextField m_endInstanceInput = new JFormattedTextField(NumberFormat.getIntegerInstance());
    protected AttributeSummaryPanel m_AttSummaryPanel = new AttributeSummaryPanel();
    protected ConverterFileChooser m_FileChooser;
    protected Instances m_Instances;
    protected AttributeVisualizationPanel m_AttVisualizePanel = new AttributeVisualizationPanel();
    protected PropertyChangeSupport m_Support = new PropertyChangeSupport((Object)this);
    protected Thread m_IOThread;
    protected Logger m_Log = new SysErrLog();
    protected SamoaToWekaInstanceConverter m_samoaToWekaInstanceConverter;
    protected WekaToSamoaInstanceConverter m_wekaToSamoaInstanceConverter;
    protected JComboBox m_plotTypeBox;
    protected int m_selectedPlotTypeIndex;
    protected JComboBox m_featureRangeBox;
    private static final int m_defaultMaxInstanceIndex = 500;
    protected LineAndScatterPanel m_graphPanel = new LineAndScatterPanel();
    protected FeatureImportancePanel fip = FeatureImportancePanel.getInstance();
    protected JMenu m_sendToPerspective;

    public VisualizeFeaturesPanel() {
        this.m_samoaToWekaInstanceConverter = new SamoaToWekaInstanceConverter();
        this.m_wekaToSamoaInstanceConverter = new WekaToSamoaInstanceConverter();
        this.m_FileChooser = new ConverterFileChooser();
        this.m_FileChooser.setFileSelectionMode(2);
        this.m_OpenFileBut.setToolTipText("Open a set of instances from a file");
        this.m_OpenFileBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualizeFeaturesPanel.this.setInstancesFromFileQ();
            }
        });
        this.m_SaveBut.setToolTipText("Save the working relation to a file");
        this.m_SaveBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualizeFeaturesPanel.this.saveWorkingInstancesToFileQ();
            }
        });
        this.m_AttPanel.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ListSelectionModel lm = (ListSelectionModel)e.getSource();
                    for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                        if (!lm.isSelectedIndex(i)) continue;
                        VisualizeFeaturesPanel.this.m_AttSummaryPanel.setAttribute(i);
                        VisualizeFeaturesPanel.this.m_AttVisualizePanel.setAttribute(i);
                        break;
                    }
                }
            }
        });
        this.m_InstSummaryPanel.setBorder(BorderFactory.createTitledBorder("Current relation"));
        JPanel attStuffHolderPanel = new JPanel();
        attStuffHolderPanel.setBorder(BorderFactory.createTitledBorder("Attributes"));
        attStuffHolderPanel.setLayout(new BorderLayout());
        attStuffHolderPanel.add((Component)this.m_AttPanel, "Center");
        this.m_RemoveButton.setEnabled(false);
        this.m_RemoveButton.setToolTipText("Remove selected attributes.");
        this.m_RemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Remove r = new Remove();
                    int[] selected = VisualizeFeaturesPanel.this.m_AttPanel.getSelectedAttributes();
                    if (selected.length == 0) {
                        return;
                    }
                    for (int i = 0; i < selected.length; ++i) {
                        if (selected[i] != VisualizeFeaturesPanel.this.m_Instances.classIndex()) continue;
                        JOptionPane.showMessageDialog((Component)((Object)VisualizeFeaturesPanel.this), "Can't remove the class attribute from dataset!\n", "Remove Attributes", 0);
                        return;
                    }
                    if (selected.length == VisualizeFeaturesPanel.this.m_Instances.numAttributes()) {
                        JOptionPane.showMessageDialog((Component)((Object)VisualizeFeaturesPanel.this), "Can't remove all attributes from data!\n", "Remove Attributes", 0);
                        VisualizeFeaturesPanel.this.m_Log.logMessage("Can't remove all attributes from data!");
                        VisualizeFeaturesPanel.this.m_Log.statusMessage("Problem removing attributes");
                        return;
                    }
                    r.setAttributeIndicesArray(selected);
                    VisualizeFeaturesPanel.this.applyFilter((Filter)r);
                    VisualizeFeaturesPanel.this.m_RemoveButton.setEnabled(false);
                }
                catch (Exception ex) {
                    if (VisualizeFeaturesPanel.this.m_Log instanceof TaskLogger) {
                        ((TaskLogger)VisualizeFeaturesPanel.this.m_Log).taskFinished();
                    }
                    JOptionPane.showMessageDialog((Component)((Object)VisualizeFeaturesPanel.this), "Problem filtering instances:\n" + ex.getMessage(), "Remove Attributes", 0);
                    VisualizeFeaturesPanel.this.m_Log.logMessage("Problem removing attributes: " + ex.getMessage());
                    VisualizeFeaturesPanel.this.m_Log.statusMessage("Problem removing attributes");
                    ex.printStackTrace();
                }
            }
        });
        JPanel p1 = new JPanel();
        p1.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        p1.setLayout(new BorderLayout());
        p1.add((Component)this.m_RemoveButton, "Center");
        attStuffHolderPanel.add((Component)p1, "South");
        this.m_AttSummaryPanel.setBorder(BorderFactory.createTitledBorder("Selected attribute"));
        this.m_SaveBut.setEnabled(false);
        JPanel buttons = new JPanel();
        buttons.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        buttons.setLayout(new GridLayout(1, 6, 5, 5));
        buttons.add(this.m_OpenFileBut);
        buttons.add(this.m_SaveBut);
        JPanel attInfo = new JPanel();
        attInfo.setLayout(new BorderLayout());
        attInfo.add((Component)attStuffHolderPanel, "Center");
        JPanel attVis = new JPanel();
        attVis.setLayout(new GridLayout(3, 1));
        attVis.add(this.m_AttSummaryPanel);
        this.m_plotTypeBox = new JComboBox();
        final JComboBox colorBox = this.m_AttVisualizePanel.getColorBox();
        colorBox.setToolTipText("The chosen attribute will also be used as the class attribute when a filter is applied.");
        colorBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    String item = colorBox.getSelectedItem().toString();
                    if (item.equalsIgnoreCase("No class")) {
                        VisualizeFeaturesPanel.this.m_plotAmplify.setEnabled(false);
                    } else {
                        VisualizeFeaturesPanel.this.m_plotAmplify.setEnabled(true);
                    }
                    if (item.endsWith("(numeric)")) {
                        VisualizeFeaturesPanel.this.m_plotTypeBox.removeAllItems();
                        VisualizeFeaturesPanel.this.m_plotTypeBox.addItem("plot type: Line graph");
                        VisualizeFeaturesPanel.this.m_plotTypeBox.addItem("plot type: Scatter diagram");
                    } else if (item.endsWith("(nominal)")) {
                        VisualizeFeaturesPanel.this.m_plotTypeBox.removeAllItems();
                        VisualizeFeaturesPanel.this.m_plotTypeBox.addItem("plot type: Scatter diagram");
                        VisualizeFeaturesPanel.this.m_plotTypeBox.addItem("No plot type");
                    } else {
                        VisualizeFeaturesPanel.this.m_plotTypeBox.removeAllItems();
                    }
                }
            }
        });
        this.m_startInstanceInput.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                try {
                    VisualizeFeaturesPanel.this.m_startInstanceInput.commitEdit();
                    Object o = VisualizeFeaturesPanel.this.m_startInstanceInput.getValue();
                    if (o == null) {
                        VisualizeFeaturesPanel.this.m_startInstanceInput.setValue(1);
                    } else {
                        int i = Integer.parseInt(o.toString());
                        if (i < 1 || i >= VisualizeFeaturesPanel.this.m_Instances.numInstances()) {
                            VisualizeFeaturesPanel.this.m_startInstanceInput.setValue(1);
                            Toolkit.getDefaultToolkit().beep();
                            JOptionPane.showMessageDialog(VisualizeFeaturesPanel.this.m_startInstanceInput.getParent(), "The instance start index must be positive integer, \nmore than 0 and less than total instance number!", "Instance startIndex input error prompt!", 2);
                        }
                    }
                }
                catch (ParseException parseException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(VisualizeFeaturesPanel.this.m_startInstanceInput.getParent(), "The instance start index must be positive integer, \nmore than 0 and less than total instance number!", "Instance startIndex input error prompt!", 2);
                }
            }
        });
        this.m_endInstanceInput.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                if (VisualizeFeaturesPanel.this.m_Instances != null) {
                    int numInst = VisualizeFeaturesPanel.this.m_Instances.numInstances();
                    try {
                        VisualizeFeaturesPanel.this.m_endInstanceInput.commitEdit();
                        Object o = VisualizeFeaturesPanel.this.m_endInstanceInput.getValue();
                        if (o == null) {
                            VisualizeFeaturesPanel.this.m_endInstanceInput.setValue(numInst);
                        } else {
                            int inputInt = Integer.parseInt(o.toString());
                            if (inputInt < 2 || inputInt > numInst) {
                                if (numInst <= 500) {
                                    if (numInst <= 500) {
                                        VisualizeFeaturesPanel.this.m_endInstanceInput.setValue(numInst);
                                    } else if (numInst > 500) {
                                        VisualizeFeaturesPanel.this.m_endInstanceInput.setValue(500);
                                    }
                                }
                                Toolkit.getDefaultToolkit().beep();
                                JOptionPane.showMessageDialog(VisualizeFeaturesPanel.this.m_endInstanceInput.getParent(), "The instance end index must be positive integer, \nmore than 1 and not more than total instance number \"" + numInst + "\"!", "Instance startIndex input error prompt!", 2);
                            }
                        }
                    }
                    catch (ParseException parseException) {
                        Toolkit.getDefaultToolkit().beep();
                        JOptionPane.showMessageDialog(VisualizeFeaturesPanel.this.m_endInstanceInput.getParent(), "The instance end index must be positive integer, \nmore than 1 and not more than total instance number \"" + numInst + "\"!", "Instance startIndex input error prompt!", 2);
                    }
                }
            }
        });
        this.m_startInstanceInput.setToolTipText("Start index must be positive integer, bigger than 0 and less than instance number!");
        this.m_endInstanceInput.setToolTipText("End index must be positive integer, bigger than 1 and no than instance number!");
        this.m_plotTypeBox.setEditable(false);
        this.m_plotTypeBox.setToolTipText("The chosen item will determine the feature plot type.");
        this.m_plotTypeBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && colorBox.getSelectedItem() != null && VisualizeFeaturesPanel.this.m_Instances != null) {
                    Object objectStartInstanceInput = VisualizeFeaturesPanel.this.m_startInstanceInput.getValue();
                    Object objectEndInstanceInput = VisualizeFeaturesPanel.this.m_endInstanceInput.getValue();
                    VisualizeFeaturesPanel.this.m_intStartIndex = Integer.parseInt(objectStartInstanceInput.toString());
                    VisualizeFeaturesPanel.this.m_intEndIndex = Integer.parseInt(objectEndInstanceInput.toString());
                    if (VisualizeFeaturesPanel.this.m_intEndIndex > VisualizeFeaturesPanel.this.m_intStartIndex) {
                        VisualizeFeaturesPanel.this.m_graphPanel.setIntStartIndex(VisualizeFeaturesPanel.this.m_intStartIndex);
                        VisualizeFeaturesPanel.this.m_graphPanel.setIntEndIndex(VisualizeFeaturesPanel.this.m_intEndIndex);
                        VisualizeFeaturesPanel.this.m_selectedPlotTypeIndex = VisualizeFeaturesPanel.this.m_plotTypeBox.getSelectedIndex();
                        String selectedPlotItem = VisualizeFeaturesPanel.this.m_plotTypeBox.getSelectedItem().toString();
                        if (selectedPlotItem.equalsIgnoreCase("No plot type")) {
                            VisualizeFeaturesPanel.this.m_plotAmplify.setEnabled(false);
                            VisualizeFeaturesPanel.this.m_visAllGraphBut.setEnabled(false);
                        } else {
                            VisualizeFeaturesPanel.this.m_plotAmplify.setEnabled(true);
                            VisualizeFeaturesPanel.this.m_visAllGraphBut.setEnabled(true);
                        }
                        String attributeName = colorBox.getSelectedItem().toString();
                        int attributeIndex = colorBox.getSelectedIndex();
                        if (attributeIndex == 0) {
                            VisualizeFeaturesPanel.this.m_graphPanel.setSelectedPlotInfo(VisualizeFeaturesPanel.this.m_selectedPlotTypeIndex, selectedPlotItem, 0, colorBox.getItemAt(1).toString());
                        } else {
                            VisualizeFeaturesPanel.this.m_graphPanel.setSelectedPlotInfo(VisualizeFeaturesPanel.this.m_selectedPlotTypeIndex, selectedPlotItem, attributeIndex - 1, attributeName);
                        }
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                        JOptionPane.showMessageDialog(VisualizeFeaturesPanel.this.m_plotTypeBox.getParent(), "EndIndex must be bigger than StartIndex", "Instance index range error prompt!", 2);
                    }
                }
            }
        });
        final JButton visAllBut = new JButton("Visualize All");
        visAllBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (VisualizeFeaturesPanel.this.m_Instances != null) {
                    try {
                        AttributeSummarizer as = new AttributeSummarizer();
                        as.setColoringIndex(VisualizeFeaturesPanel.this.m_AttVisualizePanel.getColoringIndex());
                        as.setInstances(VisualizeFeaturesPanel.this.m_samoaToWekaInstanceConverter.wekaInstances(VisualizeFeaturesPanel.this.m_Instances));
                        final JFrame jf = Utils.getWekaJFrame((String)"All attributes", (Component)((Object)VisualizeFeaturesPanel.this));
                        jf.getContentPane().setLayout(new BorderLayout());
                        jf.getContentPane().add((Component)as, "Center");
                        jf.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                visAllBut.setEnabled(true);
                                jf.dispose();
                            }
                        });
                        jf.pack();
                        jf.setSize(1000, 600);
                        jf.setLocationRelativeTo(SwingUtilities.getWindowAncestor((Component)((Object)VisualizeFeaturesPanel.this)));
                        jf.setVisible(true);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.m_plotAmplify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VisualizeFeaturesPanel.this.m_Instances != null) {
                    int numIns = VisualizeFeaturesPanel.this.m_Instances.numInstances();
                    Object objectStartInstanceInput = VisualizeFeaturesPanel.this.m_startInstanceInput.getValue();
                    Object objectEndInstanceInput = VisualizeFeaturesPanel.this.m_endInstanceInput.getValue();
                    VisualizeFeaturesPanel.this.m_intStartIndex = Integer.parseInt(objectStartInstanceInput.toString());
                    VisualizeFeaturesPanel.this.m_intEndIndex = Integer.parseInt(objectEndInstanceInput.toString());
                    if (VisualizeFeaturesPanel.this.m_intEndIndex > VisualizeFeaturesPanel.this.m_intStartIndex) {
                        VisualizeFeaturesPanel.this.m_graphPanel.setIntStartIndex(VisualizeFeaturesPanel.this.m_intStartIndex);
                        VisualizeFeaturesPanel.this.m_graphPanel.setIntEndIndex(VisualizeFeaturesPanel.this.m_intEndIndex);
                        VisualizeFeaturesPanel.this.m_graphPanel.paintAmplifiedPlot();
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                        JOptionPane.showMessageDialog(VisualizeFeaturesPanel.this.m_plotAmplify.getParent(), "EndIndex must be bigger than StartIndex", "Instance index range error prompt!", 2);
                    }
                }
            }
        });
        this.m_visAllGraphBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VisualizeFeaturesPanel.this.m_Instances != null) {
                    Object objectStartInstanceInput = VisualizeFeaturesPanel.this.m_startInstanceInput.getValue();
                    Object objectEndInstanceInput = VisualizeFeaturesPanel.this.m_endInstanceInput.getValue();
                    VisualizeFeaturesPanel.this.m_intStartIndex = Integer.parseInt(objectStartInstanceInput.toString());
                    VisualizeFeaturesPanel.this.m_intEndIndex = Integer.parseInt(objectEndInstanceInput.toString());
                    if (VisualizeFeaturesPanel.this.m_intEndIndex > VisualizeFeaturesPanel.this.m_intStartIndex) {
                        VisualizeFeaturesPanel.this.m_graphPanel.visualizeAll();
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                        JOptionPane.showMessageDialog(VisualizeFeaturesPanel.this.m_visAllGraphBut.getParent(), "EndIndex must be bigger than StartIndex", "Instance index range error prompt!", 2);
                    }
                }
            }
        });
        JPanel histoHolder = new JPanel();
        JPanel histoControls = new JPanel();
        histoControls.setLayout(new BorderLayout());
        histoControls.add((Component)colorBox, "Center");
        histoControls.add((Component)visAllBut, "East");
        histoHolder.setLayout(new BorderLayout());
        histoHolder.add((Component)histoControls, "North");
        histoHolder.add((Component)((Object)this.m_AttVisualizePanel), "Center");
        attVis.add(histoHolder);
        JPanel lineScatterController = new JPanel();
        lineScatterController.setLayout(new BoxLayout(lineScatterController, 0));
        lineScatterController.add(this.m_startIndex);
        this.m_startInstanceInput.setPreferredSize(new Dimension(80, 18));
        lineScatterController.add(this.m_startInstanceInput);
        lineScatterController.add(this.m_endIndex);
        this.m_endInstanceInput.setPreferredSize(new Dimension(80, 18));
        lineScatterController.add(this.m_endInstanceInput);
        lineScatterController.add(this.m_plotTypeBox);
        JPanel lineScatterHolder = new JPanel();
        lineScatterHolder.setLayout(new BorderLayout());
        lineScatterHolder.add((Component)lineScatterController, "North");
        lineScatterHolder.add((Component)this.m_graphPanel, "Center");
        JPanel graphButtonPanel = new JPanel();
        graphButtonPanel.setLayout(new FlowLayout());
        graphButtonPanel.add(this.m_plotAmplify);
        this.m_featureRangeBox = new JComboBox();
        graphButtonPanel.add(this.m_featureRangeBox);
        this.m_featureRangeBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    VisualizeFeaturesPanel.this.m_graphPanel.setFeatureRange(e.getItem().toString());
                }
            }
        });
        graphButtonPanel.add(this.m_visAllGraphBut);
        lineScatterHolder.add((Component)graphButtonPanel, "South");
        attVis.add(lineScatterHolder);
        JPanel lhs = new JPanel();
        lhs.setLayout(new BorderLayout());
        lhs.add((Component)this.m_InstSummaryPanel, "North");
        lhs.add((Component)attInfo, "Center");
        JPanel rhs = new JPanel();
        rhs.setLayout(new BorderLayout());
        rhs.add((Component)attVis, "Center");
        JPanel relation = new JPanel();
        relation.setLayout(new GridLayout(1, 2));
        relation.add(lhs);
        relation.add(rhs);
        JPanel middle = new JPanel();
        middle.setLayout(new BorderLayout());
        middle.add((Component)relation, "Center");
        LogPanel lp = new LogPanel();
        this.setLog((Logger)lp);
        this.setLayout(new BorderLayout());
        this.add(buttons, "North");
        this.add(middle, "Center");
    }

    public boolean startIndexValidation(int startIndex) {
        if (startIndex >= 1) {
            return true;
        }
        JOptionPane.showMessageDialog((Component)((Object)this), "The instance start index must be integer and not less than 1:\n", "Instance Index", 0);
        return false;
    }

    public boolean endIndexValidation(int endIndex) {
        if (endIndex <= this.m_Instances.numInstances()) {
            return true;
        }
        JOptionPane.showMessageDialog((Component)((Object)this), "The instance end index must be integer and not bigger than \"" + this.m_Instances.numInstances() + "\"", "Instance Index", 0);
        return false;
    }

    public void setLog(Logger newLog) {
        this.m_Log = newLog;
    }

    public void setInstances(Instances inst) {
        this.m_Instances = inst;
        try {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    boolean first = VisualizeFeaturesPanel.this.m_AttPanel.getTableModel() == null;
                    VisualizeFeaturesPanel.this.m_graphPanel.setInstances(VisualizeFeaturesPanel.this.m_Instances);
                    if (VisualizeFeaturesPanel.this.m_Instances != null) {
                        VisualizeFeaturesPanel.this.m_startInstanceInput.setValue(1);
                        int numInstances = VisualizeFeaturesPanel.this.m_Instances.numInstances();
                        if (numInstances <= 500) {
                            VisualizeFeaturesPanel.this.m_endInstanceInput.setValue(numInstances);
                            VisualizeFeaturesPanel.this.m_graphPanel.setIntEndIndex(numInstances);
                        } else {
                            VisualizeFeaturesPanel.this.m_endInstanceInput.setValue(500);
                            VisualizeFeaturesPanel.this.m_graphPanel.setIntEndIndex(500);
                        }
                    }
                    int maxPlotsNumberInOneScreen = 9;
                    if (VisualizeFeaturesPanel.this.m_Instances != null && VisualizeFeaturesPanel.this.m_Instances.numAttributes() > 0) {
                        VisualizeFeaturesPanel.this.m_featureRangeBox.removeAllItems();
                        VisualizeFeaturesPanel.this.featureRangeBoxSet(VisualizeFeaturesPanel.this.m_Instances.numAttributes(), maxPlotsNumberInOneScreen);
                    }
                    VisualizeFeaturesPanel.this.m_InstSummaryPanel.setInstances(VisualizeFeaturesPanel.this.m_Instances);
                    VisualizeFeaturesPanel.this.m_AttPanel.setInstances(VisualizeFeaturesPanel.this.m_Instances);
                    if (first) {
                        TableModel model = VisualizeFeaturesPanel.this.m_AttPanel.getTableModel();
                        model.addTableModelListener(new TableModelListener(){

                            @Override
                            public void tableChanged(TableModelEvent e) {
                                if (VisualizeFeaturesPanel.this.m_AttPanel.getSelectedAttributes() != null && VisualizeFeaturesPanel.this.m_AttPanel.getSelectedAttributes().length > 0) {
                                    VisualizeFeaturesPanel.this.m_RemoveButton.setEnabled(true);
                                } else {
                                    VisualizeFeaturesPanel.this.m_RemoveButton.setEnabled(false);
                                }
                            }
                        });
                    }
                    VisualizeFeaturesPanel.this.m_AttSummaryPanel.setInstances(VisualizeFeaturesPanel.this.m_Instances);
                    VisualizeFeaturesPanel.this.m_AttVisualizePanel.setInstances(VisualizeFeaturesPanel.this.m_samoaToWekaInstanceConverter.wekaInstances(VisualizeFeaturesPanel.this.m_Instances));
                    VisualizeFeaturesPanel.this.m_AttPanel.getSelectionModel().setSelectionInterval(0, 0);
                    VisualizeFeaturesPanel.this.m_AttSummaryPanel.setAttribute(0);
                    VisualizeFeaturesPanel.this.m_AttVisualizePanel.setAttribute(0);
                    VisualizeFeaturesPanel.this.m_graphPanel.setAttributeIndex(VisualizeFeaturesPanel.this.m_Instances.classIndex());
                    VisualizeFeaturesPanel.this.m_Log.logMessage("Base relation is now " + VisualizeFeaturesPanel.this.m_Instances.getRelationName() + " (" + VisualizeFeaturesPanel.this.m_Instances.numInstances() + " instances)");
                    VisualizeFeaturesPanel.this.m_SaveBut.setEnabled(true);
                    VisualizeFeaturesPanel.this.m_Log.statusMessage("OK");
                    VisualizeFeaturesPanel.this.m_Support.firePropertyChange("", null, null);
                    VisualizeFeaturesPanel.this.fip.setInstances(VisualizeFeaturesPanel.this.m_Instances);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeAndWait(r);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog((Component)((Object)this), "Problem setting base instances:\n" + ex, "Instances", 0);
        }
    }

    public void featureRangeBoxSet(int numAttributes, int maxFeaturesInOneScreen) {
        if (numAttributes >= maxFeaturesInOneScreen) {
            int itemNum = (int)Math.ceil(numAttributes / maxFeaturesInOneScreen);
            int remainder = numAttributes % maxFeaturesInOneScreen;
            for (int i = 0; i < itemNum; ++i) {
                this.m_featureRangeBox.addItem("feature range: " + (i * maxFeaturesInOneScreen + 1) + " -- " + (i + 1) * maxFeaturesInOneScreen);
            }
            if (remainder > 0 && remainder == 1) {
                this.m_featureRangeBox.addItem("feature range: " + (itemNum * maxFeaturesInOneScreen + 1));
            } else if (remainder > 1) {
                this.m_featureRangeBox.addItem("feature range: " + (itemNum * maxFeaturesInOneScreen + 1) + " -- " + (itemNum * maxFeaturesInOneScreen + remainder));
            }
        } else if (numAttributes < maxFeaturesInOneScreen && numAttributes > 1) {
            this.m_featureRangeBox.addItem("feature range: 1 -- " + numAttributes);
        } else if (numAttributes == 1) {
            this.m_featureRangeBox.addItem("feature range: 1");
        }
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.m_Support != null && l != null) {
            this.m_Support.addPropertyChangeListener(l);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.m_Support != null && l != null) {
            this.m_Support.removePropertyChangeListener(l);
        }
    }

    protected void applyFilter(final Filter filter) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                @Override
                public void run() {
                    try {
                        if (filter != null) {
                            if (VisualizeFeaturesPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)VisualizeFeaturesPanel.this.m_Log).taskStarted();
                            }
                            VisualizeFeaturesPanel.this.m_Log.statusMessage("Passing dataset through filter " + filter.getClass().getName());
                            String cmd = filter.getClass().getName();
                            if (filter instanceof OptionHandler) {
                                cmd = cmd + " " + Utils.joinOptions((String[])filter.getOptions());
                            }
                            VisualizeFeaturesPanel.this.m_Log.logMessage("Command: " + cmd);
                            int classIndex = VisualizeFeaturesPanel.this.m_AttVisualizePanel.getColoringIndex();
                            if (classIndex < 0 && filter instanceof SupervisedFilter) {
                                throw new IllegalArgumentException("Class (colour) needs to be set for supervised filter.");
                            }
                            Instances copy = new Instances(VisualizeFeaturesPanel.this.m_Instances);
                            copy.setClassIndex(classIndex);
                            Filter filterCopy = Filter.makeCopy((Filter)filter);
                            weka.core.Instances copyToWeka = VisualizeFeaturesPanel.this.m_samoaToWekaInstanceConverter.wekaInstances(copy);
                            filterCopy.setInputFormat(copyToWeka);
                            weka.core.Instances newInstances = Filter.useFilter((weka.core.Instances)copyToWeka, (Filter)filterCopy);
                            if (newInstances == null || newInstances.numAttributes() < 1) {
                                throw new Exception("Dataset is empty.");
                            }
                            VisualizeFeaturesPanel.this.m_Log.statusMessage("Saving undo information");
                            int debugClassIndex = copy.classIndex();
                            int debugClassIndex2 = copyToWeka.classIndex();
                            VisualizeFeaturesPanel.this.m_AttVisualizePanel.setColoringIndex(copy.classIndex());
                            VisualizeFeaturesPanel.this.m_Instances = VisualizeFeaturesPanel.this.m_wekaToSamoaInstanceConverter.samoaInstances(newInstances);
                            VisualizeFeaturesPanel.this.setInstances(VisualizeFeaturesPanel.this.m_Instances);
                            if (VisualizeFeaturesPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)VisualizeFeaturesPanel.this.m_Log).taskFinished();
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (VisualizeFeaturesPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)VisualizeFeaturesPanel.this.m_Log).taskFinished();
                        }
                        JOptionPane.showMessageDialog((Component)((Object)VisualizeFeaturesPanel.this), "Problem filtering instances:\n" + ex.getMessage(), "Apply Filter", 0);
                        VisualizeFeaturesPanel.this.m_Log.logMessage("Problem filtering instances: " + ex.getMessage());
                        VisualizeFeaturesPanel.this.m_Log.statusMessage("Problem filtering instances");
                        ex.printStackTrace();
                    }
                    VisualizeFeaturesPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "Can't apply filter at this time,\ncurrently busy with other IO", "Apply Filter", 2);
        }
    }

    public void setInstancesFromFileQ() {
        if (this.m_IOThread == null) {
            int returnVal = this.m_FileChooser.showOpenDialog((Component)((Object)this));
            if (returnVal == 0) {
                if (this.m_FileChooser.getLoader() == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Cannot determine file loader automatically, please choose one.", "Load Instances", 0);
                } else {
                    this.setInstancesFromFile2(this.m_FileChooser.getSelectedFile().toString());
                }
            }
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    public void setInstancesFromFile2(final String selectedFile) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                @Override
                public void run() {
                    try {
                        VisualizeFeaturesPanel.this.m_Log.statusMessage("Reading from file...");
                        ArffFileStream afs = new ArffFileStream(selectedFile, -1);
                        Instance instance = null;
                        BufferedReader reader = new BufferedReader(new FileReader(selectedFile));
                        Instances insts = new Instances(reader, 1, -1);
                        while (afs.hasMoreInstances()) {
                            instance = afs.nextInstance().getData();
                            insts.add(instance);
                        }
                        VisualizeFeaturesPanel.this.setInstances(insts);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    VisualizeFeaturesPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    public void saveWorkingInstancesToFileQ() {
        if (this.m_IOThread == null) {
            this.m_FileChooser.setAcceptAllFileFilterUsed(false);
            int returnVal = this.m_FileChooser.showSaveDialog((Component)((Object)this));
            if (returnVal == 0) {
                weka.core.Instances inst = this.m_samoaToWekaInstanceConverter.wekaInstances(this.m_Instances);
                inst.setClassIndex(this.m_AttVisualizePanel.getColoringIndex());
                this.saveInstancesToFile(this.m_FileChooser.getSaver(), inst);
            }
            FileFilter temp = this.m_FileChooser.getFileFilter();
            this.m_FileChooser.setAcceptAllFileFilterUsed(true);
            this.m_FileChooser.setFileFilter(temp);
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "Can't save at this time,\ncurrently busy with other IO", "Save Instances", 2);
        }
    }

    public void saveInstancesToFile(final AbstractFileSaver saver, final weka.core.Instances inst) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                @Override
                public void run() {
                    try {
                        VisualizeFeaturesPanel.this.m_Log.statusMessage("Saving to file...");
                        saver.setInstances(inst);
                        saver.writeBatch();
                        VisualizeFeaturesPanel.this.m_Log.statusMessage("OK");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        VisualizeFeaturesPanel.this.m_Log.logMessage(ex.getMessage());
                    }
                    VisualizeFeaturesPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "Can't save at this time,\ncurrently busy with other IO", "Saving instances", 2);
        }
    }

    public void instantiationComplete() {
        boolean sendToAll = (Boolean)this.getMainApplication().getApplicationSettings().getSetting(this.getPerspectiveID(), PreprocessPanel.PreprocessDefaults.ALWAYS_SEND_INSTANCES_TO_ALL_KEY, (Object)PreprocessPanel.PreprocessDefaults.ALWAYS_SEND_INSTANCES_TO_ALL, Environment.getSystemWide());
        final ArrayList<Perspective> perspectivesThatAcceptInstances = new ArrayList<Perspective>();
        List visiblePerspectives = this.getMainApplication().getPerspectiveManager().getVisiblePerspectives();
        for (Perspective p : visiblePerspectives) {
            if (!p.acceptsInstances() || p.getPerspectiveID().equals(this.getPerspectiveID())) continue;
            perspectivesThatAcceptInstances.add(p);
        }
        if (perspectivesThatAcceptInstances.size() > 0) {
            this.m_sendToPerspective = new JMenu();
            this.m_sendToPerspective.setText("Send to perspective");
            if (!sendToAll) {
                this.m_sendToPerspective.setEnabled(false);
            }
            JMenuItem sendToAllItem = new JMenuItem("All perspectives");
            sendToAllItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (Perspective p : perspectivesThatAcceptInstances) {
                        if (VisualizeFeaturesPanel.this.getInstances() == null || !p.acceptsInstances()) continue;
                        p.setInstances(VisualizeFeaturesPanel.this.m_samoaToWekaInstanceConverter.wekaInstances(VisualizeFeaturesPanel.this.getInstances()));
                        VisualizeFeaturesPanel.this.getMainApplication().getPerspectiveManager().setEnablePerspectiveTab(p.getPerspectiveID(), true);
                    }
                }
            });
            this.m_sendToPerspective.add(sendToAllItem);
            for (final Perspective p : perspectivesThatAcceptInstances) {
                JMenuItem item = new JMenuItem(p.getPerspectiveTitle());
                this.m_sendToPerspective.add(item);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (VisualizeFeaturesPanel.this.getInstances() != null) {
                            p.setInstances(VisualizeFeaturesPanel.this.m_samoaToWekaInstanceConverter.wekaInstances(VisualizeFeaturesPanel.this.getInstances()));
                            VisualizeFeaturesPanel.this.getMainApplication().getPerspectiveManager().setEnablePerspectiveTab(p.getPerspectiveID(), true);
                            VisualizeFeaturesPanel.this.getMainApplication().getPerspectiveManager().setActivePerspective(p.getPerspectiveID());
                        }
                    }
                });
            }
        }
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("MOA: Data Analysis");
            jf.getContentPane().setLayout(new BorderLayout());
            VisualizeFeaturesPanel sp = new VisualizeFeaturesPanel();
            jf.getContentPane().add((Component)((Object)sp), "Center");
            LogPanel lp = new LogPanel();
            sp.setLog((Logger)lp);
            jf.getContentPane().add((Component)lp, "South");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setSize(800, 600);
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    public static class PreprocessDefaults
    extends Defaults {
        public static final String ID = "weka.gui.explorer.preprocesspanel";
        public static final Settings.SettingKey INITIAL_DIR_KEY = new Settings.SettingKey("weka.gui.explorer.preprocesspanel.initialDir", "Initial directory for opening datasets", "");
        public static final File INITIAL_DIR = new File("${user.dir}");
        public static final Settings.SettingKey UNDO_DIR_KEY = new Settings.SettingKey("weka.gui.explorer.preprocesspanel.undoDir", "Directory for storing undo files", "");
        public static final File UNDO_DIR = new File("${java.io.tmpdir}");
        public static final Settings.SettingKey FILTER_KEY = new Settings.SettingKey("weka.gui.explorer.preprocesspanel.initialFilter", "Initial filter", "");
        public static final Filter FILTER = new AllFilter();
        public static final Settings.SettingKey ENABLE_UNDO_KEY = new Settings.SettingKey("weka.gui.explorer.preprocesspanel.enableUndo", "Enable undo", "");
        public static final Boolean ENABLE_UNDO = true;
        public static final Settings.SettingKey ALWAYS_SEND_INSTANCES_TO_ALL_KEY = new Settings.SettingKey("weka.gui.explorer.preprocesspanel.alwaysSendInstancesToAllPerspectives", "Always send instances to all perspectives", "");
        public static boolean ALWAYS_SEND_INSTANCES_TO_ALL = true;

        public PreprocessDefaults() {
            super(ID);
            INITIAL_DIR_KEY.setMetadataElement("java.io.File.fileSelectionMode", "1");
            INITIAL_DIR_KEY.setMetadataElement("java.io.File.dialogType", "0");
            UNDO_DIR_KEY.setMetadataElement("java.io.File.fileSelectionMode", "1");
            UNDO_DIR_KEY.setMetadataElement("java.io.File.dialogType", "1");
            this.m_defaults.put(INITIAL_DIR_KEY, INITIAL_DIR);
            this.m_defaults.put(UNDO_DIR_KEY, UNDO_DIR);
            this.m_defaults.put(FILTER_KEY, FILTER);
            this.m_defaults.put(ENABLE_UNDO_KEY, ENABLE_UNDO);
            this.m_defaults.put(ALWAYS_SEND_INSTANCES_TO_ALL_KEY, ALWAYS_SEND_INSTANCES_TO_ALL);
        }
    }
}

