/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.visualization;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.text.DecimalFormat;
import javax.swing.GroupLayout;
import javax.swing.JPanel;

public class GraphAxes
extends JPanel {
    private final int x_offset_left = 35;
    private final int x_offset_right = 5;
    private final int y_offset_bottom = 20;
    private final int y_offset_top = 20;
    private int height;
    private int width;
    private double x_resolution;
    private int processFrequency;
    private double min_value = 0.0;
    private double max_value = 1.0;
    private int max_x_value;

    public GraphAxes() {
        this.initComponents();
    }

    public void setXMaxValue(int max) {
        this.max_x_value = max;
    }

    public void setXResolution(double resolution) {
        this.x_resolution = resolution;
    }

    public void setProcessFrequency(int frequency) {
        this.processFrequency = frequency;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.processFrequency == 0) {
            return;
        }
        this.height = this.getHeight() - 20 - 20;
        this.width = this.getWidth() - 35 - 5;
        g.setColor(new Color(236, 233, 216));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.WHITE);
        g.fillRect(35, 20, this.width, this.height);
        g.setFont(new Font("Tahoma", 0, 11));
        this.xAxis(g);
        this.yAxis(g);
    }

    private void xAxis(Graphics g) {
        g.setColor(Color.BLACK);
        g.drawLine(35, this.calcY(0.0), this.width + 35, this.calcY(0.0));
        int w = 100;
        int i = 0;
        while (w * i < this.width - 5) {
            g.drawLine(w * i + 35, this.height + 20, w * i + 35, this.height + 20 + 5);
            String label = Integer.toString((int)((double)(w * i * this.processFrequency) * this.x_resolution));
            int str_length = g.getFontMetrics().stringWidth(label);
            g.drawString(label, w * i + 35 - str_length / 2, this.height + 20 + 18);
            ++i;
        }
    }

    private void yAxis(Graphics g) {
        g.setColor(Color.BLACK);
        g.drawLine(35, this.calcY(0.0), 35, 20);
        g.setColor(new Color(220, 220, 220));
        g.drawLine(35, this.height / 2 + 20, this.getWidth(), this.height / 2 + 20);
        g.setColor(Color.BLACK);
        DecimalFormat d = new DecimalFormat("0.00");
        int digits_y = (int)Math.log10(this.max_value) - 1;
        double upper = Math.ceil(this.max_value / Math.pow(10.0, digits_y));
        if (digits_y < 0) {
            upper *= Math.pow(10.0, digits_y);
        }
        if (Double.isNaN(upper)) {
            upper = 1.0;
        }
        g.drawString(d.format(0.0), 3, this.height + 20 + 5);
        g.drawString(d.format(upper / 2.0), 3, this.height / 2 + 20 + 5);
        g.drawString(d.format(upper), 3, 25);
        g.drawLine(30, this.height + 20, 35, this.height + 20);
        g.drawLine(30, this.height / 2 + 20, 35, this.height / 2 + 20);
        g.drawLine(30, 20, 35, 20);
    }

    public void setYMinMaxValues(double min, double max) {
        this.min_value = min;
        this.max_value = max;
    }

    public void setMaxXValue(int max) {
        this.max_x_value = max;
    }

    private int calcY(double value) {
        return (int)((double)this.height - value / this.max_value * (double)this.height) + 20;
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }
}

