/*
 * Decompiled with CFR 0.152.
 */
package moa.learners.featureanalysis;

import com.yahoo.labs.samoa.instances.Instance;
import moa.capabilities.CapabilitiesHandler;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.Classifier;
import moa.classifiers.MultiClassClassifier;
import moa.classifiers.trees.HoeffdingTree;
import moa.core.Measurement;
import moa.core.Utils;
import moa.learners.featureanalysis.FeatureImportanceClassifier;
import moa.learners.featureanalysis.FeatureImportanceHoeffdingTree;
import moa.options.ClassOption;

public class FeatureImportanceHoeffdingTreeEnsemble
extends AbstractClassifier
implements MultiClassClassifier,
CapabilitiesHandler,
FeatureImportanceClassifier {
    public ClassOption ensembleLearnerOption = new ClassOption("ensembleLearner", 'l', "Ensemble learner to train and analyze.", Classifier.class, "moa.classifiers.meta.AdaptiveRandomForest");
    public ClassOption hoeffdingTreeFeatureImportanceOption = new ClassOption("hoeffdingTreeFeatureImportance", 't', "Hoeffding Tree object to use. Its learner option is overridden by the ensemble base tree model.", FeatureImportanceHoeffdingTree.class, "FeatureImportanceHoeffdingTree");
    protected Classifier ensemble;
    protected FeatureImportanceHoeffdingTree htFeatureImportanceBase;
    protected double[] featureImportances;

    @Override
    public double[] getFeatureImportances(boolean normalize) {
        Classifier[] subClassifiers = (Classifier[])this.ensemble.getSublearners();
        if (subClassifiers != null) {
            int i;
            FeatureImportanceHoeffdingTree[] subFeatureImportanceWrapper = new FeatureImportanceHoeffdingTree[subClassifiers.length];
            for (i = 0; i < subClassifiers.length; ++i) {
                subFeatureImportanceWrapper[i] = (FeatureImportanceHoeffdingTree)this.htFeatureImportanceBase.copy();
                subFeatureImportanceWrapper[i].treeLearner = (HoeffdingTree)subClassifiers[i];
                if (subFeatureImportanceWrapper[i].featureImportances != null) continue;
                if (this.featureImportances != null) {
                    subFeatureImportanceWrapper[i].featureImportances = new double[this.featureImportances.length];
                    continue;
                }
                System.err.println("Unable to infer the number of features. trainOnInstance() must be invoked prior to getFeatureImportances()");
            }
            if (this.featureImportances != null) {
                this.featureImportances = new double[this.featureImportances.length];
            }
            for (i = 0; i < subClassifiers.length; ++i) {
                double[] treeFeatureImportances = subFeatureImportanceWrapper[i].getFeatureImportances(normalize);
                for (int j = 0; j < this.featureImportances.length; ++j) {
                    int n = j;
                    this.featureImportances[n] = this.featureImportances[n] + (Double.isNaN(treeFeatureImportances[j]) ? 0.0 : treeFeatureImportances[j]);
                }
            }
            if (normalize) {
                double sumFeatureImportances = Utils.sum(this.featureImportances);
                int i2 = 0;
                while (i2 < this.featureImportances.length) {
                    int n = i2++;
                    this.featureImportances[n] = this.featureImportances[n] / sumFeatureImportances;
                }
            }
        }
        return this.featureImportances;
    }

    @Override
    public int[] getTopKFeatures(int k, boolean normalize) {
        int i;
        if (this.getFeatureImportances(normalize) == null) {
            return null;
        }
        if (k > this.getFeatureImportances(normalize).length) {
            k = this.getFeatureImportances(normalize).length;
        }
        int[] topK = new int[k];
        double[] currentFeatureImportances = new double[this.getFeatureImportances(normalize).length];
        for (i = 0; i < currentFeatureImportances.length; ++i) {
            currentFeatureImportances[i] = this.getFeatureImportances(normalize)[i];
        }
        for (i = 0; i < k; ++i) {
            int currentTop;
            topK[i] = currentTop = Utils.maxIndex(currentFeatureImportances);
            currentFeatureImportances[currentTop] = -1.0;
        }
        return topK;
    }

    @Override
    public void resetLearningImpl() {
        this.ensemble = (Classifier)this.getPreparedClassOption(this.ensembleLearnerOption);
        this.ensemble.resetLearning();
        this.htFeatureImportanceBase = (FeatureImportanceHoeffdingTree)this.getPreparedClassOption(this.hoeffdingTreeFeatureImportanceOption);
        if (this.ensemble.getSubClassifiers() == null) {
            System.err.println("The classifier is not an ensemble or does not implement the getSubClassifiers() method. ");
        }
    }

    @Override
    public void trainOnInstanceImpl(Instance instance) {
        if (this.featureImportances == null) {
            this.featureImportances = new double[instance.numAttributes() - 1];
        }
        this.ensemble.trainOnInstance(instance);
    }

    @Override
    public double[] getVotesForInstance(Instance instance) {
        return this.ensemble.getVotesForInstance(instance);
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return this.ensemble.getModelMeasurements();
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }
}

